/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a tool. Tools are used in a simulation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tool implements SdkPojo, Serializable, ToCopyableBuilder<Tool.Builder, Tool> {
    private static final SdkField<Boolean> STREAM_UI_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("streamUI").getter(getter(Tool::streamUI)).setter(setter(Builder::streamUI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamUI").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Tool::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> COMMAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("command")
            .getter(getter(Tool::command)).setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build()).build();

    private static final SdkField<Boolean> STREAM_OUTPUT_TO_CLOUD_WATCH_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("streamOutputToCloudWatch")
            .getter(getter(Tool::streamOutputToCloudWatch)).setter(setter(Builder::streamOutputToCloudWatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamOutputToCloudWatch").build())
            .build();

    private static final SdkField<String> EXIT_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exitBehavior").getter(getter(Tool::exitBehaviorAsString)).setter(setter(Builder::exitBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exitBehavior").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_UI_FIELD, NAME_FIELD,
            COMMAND_FIELD, STREAM_OUTPUT_TO_CLOUD_WATCH_FIELD, EXIT_BEHAVIOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean streamUI;

    private final String name;

    private final String command;

    private final Boolean streamOutputToCloudWatch;

    private final String exitBehavior;

    private Tool(BuilderImpl builder) {
        this.streamUI = builder.streamUI;
        this.name = builder.name;
        this.command = builder.command;
        this.streamOutputToCloudWatch = builder.streamOutputToCloudWatch;
        this.exitBehavior = builder.exitBehavior;
    }

    /**
     * <p>
     * Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS
     * RoboMaker will configure a connection so you can interact with the tool as it is running in the simulation. It
     * must have a graphical user interface. The default is <code>False</code>.
     * </p>
     * 
     * @return Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS
     *         RoboMaker will configure a connection so you can interact with the tool as it is running in the
     *         simulation. It must have a graphical user interface. The default is <code>False</code>.
     */
    public final Boolean streamUI() {
        return streamUI;
    }

    /**
     * <p>
     * The name of the tool.
     * </p>
     * 
     * @return The name of the tool.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Command-line arguments for the tool. It must include the tool executable name.
     * </p>
     * 
     * @return Command-line arguments for the tool. It must include the tool executable name.
     */
    public final String command() {
        return command;
    }

    /**
     * <p>
     * Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is <code>False</code>.
     * </p>
     * 
     * @return Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is
     *         <code>False</code>.
     */
    public final Boolean streamOutputToCloudWatch() {
        return streamOutputToCloudWatch;
    }

    /**
     * <p>
     * Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool to
     * be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exitBehavior} will
     * return {@link ExitBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exitBehaviorAsString}.
     * </p>
     * 
     * @return Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your
     *         tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>.
     * @see ExitBehavior
     */
    public final ExitBehavior exitBehavior() {
        return ExitBehavior.fromValue(exitBehavior);
    }

    /**
     * <p>
     * Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool to
     * be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exitBehavior} will
     * return {@link ExitBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #exitBehaviorAsString}.
     * </p>
     * 
     * @return Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your
     *         tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>.
     * @see ExitBehavior
     */
    public final String exitBehaviorAsString() {
        return exitBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamUI());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(streamOutputToCloudWatch());
        hashCode = 31 * hashCode + Objects.hashCode(exitBehaviorAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool other = (Tool) obj;
        return Objects.equals(streamUI(), other.streamUI()) && Objects.equals(name(), other.name())
                && Objects.equals(command(), other.command())
                && Objects.equals(streamOutputToCloudWatch(), other.streamOutputToCloudWatch())
                && Objects.equals(exitBehaviorAsString(), other.exitBehaviorAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tool").add("StreamUI", streamUI()).add("Name", name()).add("Command", command())
                .add("StreamOutputToCloudWatch", streamOutputToCloudWatch()).add("ExitBehavior", exitBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamUI":
            return Optional.ofNullable(clazz.cast(streamUI()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "command":
            return Optional.ofNullable(clazz.cast(command()));
        case "streamOutputToCloudWatch":
            return Optional.ofNullable(clazz.cast(streamOutputToCloudWatch()));
        case "exitBehavior":
            return Optional.ofNullable(clazz.cast(exitBehaviorAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tool, T> g) {
        return obj -> g.apply((Tool) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tool> {
        /**
         * <p>
         * Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>, AWS
         * RoboMaker will configure a connection so you can interact with the tool as it is running in the simulation.
         * It must have a graphical user interface. The default is <code>False</code>.
         * </p>
         * 
         * @param streamUI
         *        Boolean indicating whether a streaming session will be configured for the tool. If <code>True</code>,
         *        AWS RoboMaker will configure a connection so you can interact with the tool as it is running in the
         *        simulation. It must have a graphical user interface. The default is <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamUI(Boolean streamUI);

        /**
         * <p>
         * The name of the tool.
         * </p>
         * 
         * @param name
         *        The name of the tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Command-line arguments for the tool. It must include the tool executable name.
         * </p>
         * 
         * @param command
         *        Command-line arguments for the tool. It must include the tool executable name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String command);

        /**
         * <p>
         * Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is
         * <code>False</code>.
         * </p>
         * 
         * @param streamOutputToCloudWatch
         *        Boolean indicating whether logs will be recorded in CloudWatch for the tool. The default is
         *        <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamOutputToCloudWatch(Boolean streamOutputToCloudWatch);

        /**
         * <p>
         * Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool
         * to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>.
         * </p>
         * 
         * @param exitBehavior
         *        Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause
         *        your tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is
         *        <code>RESTART</code>.
         * @see ExitBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExitBehavior
         */
        Builder exitBehavior(String exitBehavior);

        /**
         * <p>
         * Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause your tool
         * to be restarted. <code>FAIL</code> will cause your job to exit. The default is <code>RESTART</code>.
         * </p>
         * 
         * @param exitBehavior
         *        Exit behavior determines what happens when your tool quits running. <code>RESTART</code> will cause
         *        your tool to be restarted. <code>FAIL</code> will cause your job to exit. The default is
         *        <code>RESTART</code>.
         * @see ExitBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExitBehavior
         */
        Builder exitBehavior(ExitBehavior exitBehavior);
    }

    static final class BuilderImpl implements Builder {
        private Boolean streamUI;

        private String name;

        private String command;

        private Boolean streamOutputToCloudWatch;

        private String exitBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(Tool model) {
            streamUI(model.streamUI);
            name(model.name);
            command(model.command);
            streamOutputToCloudWatch(model.streamOutputToCloudWatch);
            exitBehavior(model.exitBehavior);
        }

        public final Boolean getStreamUI() {
            return streamUI;
        }

        public final void setStreamUI(Boolean streamUI) {
            this.streamUI = streamUI;
        }

        @Override
        public final Builder streamUI(Boolean streamUI) {
            this.streamUI = streamUI;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCommand() {
            return command;
        }

        public final void setCommand(String command) {
            this.command = command;
        }

        @Override
        public final Builder command(String command) {
            this.command = command;
            return this;
        }

        public final Boolean getStreamOutputToCloudWatch() {
            return streamOutputToCloudWatch;
        }

        public final void setStreamOutputToCloudWatch(Boolean streamOutputToCloudWatch) {
            this.streamOutputToCloudWatch = streamOutputToCloudWatch;
        }

        @Override
        public final Builder streamOutputToCloudWatch(Boolean streamOutputToCloudWatch) {
            this.streamOutputToCloudWatch = streamOutputToCloudWatch;
            return this;
        }

        public final String getExitBehavior() {
            return exitBehavior;
        }

        public final void setExitBehavior(String exitBehavior) {
            this.exitBehavior = exitBehavior;
        }

        @Override
        public final Builder exitBehavior(String exitBehavior) {
            this.exitBehavior = exitBehavior;
            return this;
        }

        @Override
        public final Builder exitBehavior(ExitBehavior exitBehavior) {
            this.exitBehavior(exitBehavior == null ? null : exitBehavior.toString());
            return this;
        }

        @Override
        public Tool build() {
            return new Tool(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
