/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Source implements SdkPojo, Serializable, ToCopyableBuilder<Source.Builder, Source> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(Source::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Key")
            .getter(getter(Source::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()).build();

    private static final SdkField<String> ETAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("etag")
            .getter(getter(Source::etag)).setter(setter(Builder::etag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etag").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(Source::architectureAsString)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD,
            ETAG_FIELD, ARCHITECTURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Bucket;

    private final String s3Key;

    private final String etag;

    private final String architecture;

    private Source(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.etag = builder.etag;
        this.architecture = builder.architecture;
    }

    /**
     * <p>
     * The s3 bucket name.
     * </p>
     * 
     * @return The s3 bucket name.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * The s3 object key.
     * </p>
     * 
     * @return The s3 object key.
     */
    public final String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.
     * </p>
     * 
     * @return A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.
     */
    public final String etag() {
        return etag;
    }

    /**
     * <p>
     * The taget processor architecture for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The taget processor architecture for the application.
     * @see Architecture
     */
    public final Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The taget processor architecture for the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The taget processor architecture for the application.
     * @see Architecture
     */
    public final String architectureAsString() {
        return architecture;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(etag());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source) obj;
        return Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3Key(), other.s3Key())
                && Objects.equals(etag(), other.etag()) && Objects.equals(architectureAsString(), other.architectureAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Source").add("S3Bucket", s3Bucket()).add("S3Key", s3Key()).add("Etag", etag())
                .add("Architecture", architectureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "etag":
            return Optional.ofNullable(clazz.cast(etag()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Source> {
        /**
         * <p>
         * The s3 bucket name.
         * </p>
         * 
         * @param s3Bucket
         *        The s3 bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * The s3 object key.
         * </p>
         * 
         * @param s3Key
         *        The s3 object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.
         * </p>
         * 
         * @param etag
         *        A hash of the object specified by <code>s3Bucket</code> and <code>s3Key</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder etag(String etag);

        /**
         * <p>
         * The taget processor architecture for the application.
         * </p>
         * 
         * @param architecture
         *        The taget processor architecture for the application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The taget processor architecture for the application.
         * </p>
         * 
         * @param architecture
         *        The taget processor architecture for the application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);
    }

    static final class BuilderImpl implements Builder {
        private String s3Bucket;

        private String s3Key;

        private String etag;

        private String architecture;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            s3Bucket(model.s3Bucket);
            s3Key(model.s3Key);
            etag(model.etag);
            architecture(model.architecture);
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getEtag() {
            return etag;
        }

        public final void setEtag(String etag) {
            this.etag = etag;
        }

        @Override
        public final Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        @Override
        public Source build() {
            return new Source(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
