/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAppComponentRecommendationsResponse extends ResiliencehubResponse implements
        ToCopyableBuilder<ListAppComponentRecommendationsResponse.Builder, ListAppComponentRecommendationsResponse> {
    private static final SdkField<List<ComponentRecommendation>> COMPONENT_RECOMMENDATIONS_FIELD = SdkField
            .<List<ComponentRecommendation>> builder(MarshallingType.LIST)
            .memberName("componentRecommendations")
            .getter(getter(ListAppComponentRecommendationsResponse::componentRecommendations))
            .setter(setter(Builder::componentRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComponentRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComponentRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAppComponentRecommendationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPONENT_RECOMMENDATIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ComponentRecommendation> componentRecommendations;

    private final String nextToken;

    private ListAppComponentRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.componentRecommendations = builder.componentRecommendations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComponentRecommendations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComponentRecommendations() {
        return componentRecommendations != null && !(componentRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The recommendations for an Resilience Hub Application Component, returned as an object. This object contains the
     * names of the Application Components, configuration recommendations, and recommendation statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComponentRecommendations} method.
     * </p>
     * 
     * @return The recommendations for an Resilience Hub Application Component, returned as an object. This object
     *         contains the names of the Application Components, configuration recommendations, and recommendation
     *         statuses.
     */
    public final List<ComponentRecommendation> componentRecommendations() {
        return componentRecommendations;
    }

    /**
     * <p>
     * Token for the next set of results, or null if there are no more results.
     * </p>
     * 
     * @return Token for the next set of results, or null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComponentRecommendations() ? componentRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppComponentRecommendationsResponse)) {
            return false;
        }
        ListAppComponentRecommendationsResponse other = (ListAppComponentRecommendationsResponse) obj;
        return hasComponentRecommendations() == other.hasComponentRecommendations()
                && Objects.equals(componentRecommendations(), other.componentRecommendations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAppComponentRecommendationsResponse")
                .add("ComponentRecommendations", hasComponentRecommendations() ? componentRecommendations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "componentRecommendations":
            return Optional.ofNullable(clazz.cast(componentRecommendations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAppComponentRecommendationsResponse, T> g) {
        return obj -> g.apply((ListAppComponentRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResiliencehubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAppComponentRecommendationsResponse> {
        /**
         * <p>
         * The recommendations for an Resilience Hub Application Component, returned as an object. This object contains
         * the names of the Application Components, configuration recommendations, and recommendation statuses.
         * </p>
         * 
         * @param componentRecommendations
         *        The recommendations for an Resilience Hub Application Component, returned as an object. This object
         *        contains the names of the Application Components, configuration recommendations, and recommendation
         *        statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRecommendations(Collection<ComponentRecommendation> componentRecommendations);

        /**
         * <p>
         * The recommendations for an Resilience Hub Application Component, returned as an object. This object contains
         * the names of the Application Components, configuration recommendations, and recommendation statuses.
         * </p>
         * 
         * @param componentRecommendations
         *        The recommendations for an Resilience Hub Application Component, returned as an object. This object
         *        contains the names of the Application Components, configuration recommendations, and recommendation
         *        statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRecommendations(ComponentRecommendation... componentRecommendations);

        /**
         * <p>
         * The recommendations for an Resilience Hub Application Component, returned as an object. This object contains
         * the names of the Application Components, configuration recommendations, and recommendation statuses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resiliencehub.model.ComponentRecommendation.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.resiliencehub.model.ComponentRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resiliencehub.model.ComponentRecommendation.Builder#build()} is called
         * immediately and its result is passed to {@link #componentRecommendations(List<ComponentRecommendation>)}.
         * 
         * @param componentRecommendations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resiliencehub.model.ComponentRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #componentRecommendations(java.util.Collection<ComponentRecommendation>)
         */
        Builder componentRecommendations(Consumer<ComponentRecommendation.Builder>... componentRecommendations);

        /**
         * <p>
         * Token for the next set of results, or null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        Token for the next set of results, or null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResiliencehubResponse.BuilderImpl implements Builder {
        private List<ComponentRecommendation> componentRecommendations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppComponentRecommendationsResponse model) {
            super(model);
            componentRecommendations(model.componentRecommendations);
            nextToken(model.nextToken);
        }

        public final List<ComponentRecommendation.Builder> getComponentRecommendations() {
            List<ComponentRecommendation.Builder> result = ComponentRecommendationListCopier
                    .copyToBuilder(this.componentRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentRecommendations(Collection<ComponentRecommendation.BuilderImpl> componentRecommendations) {
            this.componentRecommendations = ComponentRecommendationListCopier.copyFromBuilder(componentRecommendations);
        }

        @Override
        public final Builder componentRecommendations(Collection<ComponentRecommendation> componentRecommendations) {
            this.componentRecommendations = ComponentRecommendationListCopier.copy(componentRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentRecommendations(ComponentRecommendation... componentRecommendations) {
            componentRecommendations(Arrays.asList(componentRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentRecommendations(Consumer<ComponentRecommendation.Builder>... componentRecommendations) {
            componentRecommendations(Stream.of(componentRecommendations)
                    .map(c -> ComponentRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAppComponentRecommendationsResponse build() {
            return new ListAppComponentRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
