/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUsersRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, SearchUsersRequest> {
    private static final SdkField<String> COLLECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CollectionId").getter(SearchUsersRequest.getter(SearchUsersRequest::collectionId)).setter(SearchUsersRequest.setter(Builder::collectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollectionId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(SearchUsersRequest.getter(SearchUsersRequest::userId)).setter(SearchUsersRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> FACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FaceId").getter(SearchUsersRequest.getter(SearchUsersRequest::faceId)).setter(SearchUsersRequest.setter(Builder::faceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaceId").build()}).build();
    private static final SdkField<Float> USER_MATCH_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("UserMatchThreshold").getter(SearchUsersRequest.getter(SearchUsersRequest::userMatchThreshold)).setter(SearchUsersRequest.setter(Builder::userMatchThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMatchThreshold").build()}).build();
    private static final SdkField<Integer> MAX_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxUsers").getter(SearchUsersRequest.getter(SearchUsersRequest::maxUsers)).setter(SearchUsersRequest.setter(Builder::maxUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUsers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_ID_FIELD, USER_ID_FIELD, FACE_ID_FIELD, USER_MATCH_THRESHOLD_FIELD, MAX_USERS_FIELD));
    private final String collectionId;
    private final String userId;
    private final String faceId;
    private final Float userMatchThreshold;
    private final Integer maxUsers;

    private SearchUsersRequest(BuilderImpl builder) {
        super(builder);
        this.collectionId = builder.collectionId;
        this.userId = builder.userId;
        this.faceId = builder.faceId;
        this.userMatchThreshold = builder.userMatchThreshold;
        this.maxUsers = builder.maxUsers;
    }

    public final String collectionId() {
        return this.collectionId;
    }

    public final String userId() {
        return this.userId;
    }

    public final String faceId() {
        return this.faceId;
    }

    public final Float userMatchThreshold() {
        return this.userMatchThreshold;
    }

    public final Integer maxUsers() {
        return this.maxUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userMatchThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUsers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUsersRequest)) {
            return false;
        }
        SearchUsersRequest other = (SearchUsersRequest)((Object)obj);
        return Objects.equals(this.collectionId(), other.collectionId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.faceId(), other.faceId()) && Objects.equals(this.userMatchThreshold(), other.userMatchThreshold()) && Objects.equals(this.maxUsers(), other.maxUsers());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUsersRequest").add("CollectionId", (Object)this.collectionId()).add("UserId", (Object)this.userId()).add("FaceId", (Object)this.faceId()).add("UserMatchThreshold", (Object)this.userMatchThreshold()).add("MaxUsers", (Object)this.maxUsers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CollectionId": {
                return Optional.ofNullable(clazz.cast(this.collectionId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "FaceId": {
                return Optional.ofNullable(clazz.cast(this.faceId()));
            }
            case "UserMatchThreshold": {
                return Optional.ofNullable(clazz.cast(this.userMatchThreshold()));
            }
            case "MaxUsers": {
                return Optional.ofNullable(clazz.cast(this.maxUsers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchUsersRequest, T> g) {
        return obj -> g.apply((SearchUsersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String collectionId;
        private String userId;
        private String faceId;
        private Float userMatchThreshold;
        private Integer maxUsers;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUsersRequest model) {
            super(model);
            this.collectionId(model.collectionId);
            this.userId(model.userId);
            this.faceId(model.faceId);
            this.userMatchThreshold(model.userMatchThreshold);
            this.maxUsers(model.maxUsers);
        }

        public final String getCollectionId() {
            return this.collectionId;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getFaceId() {
            return this.faceId;
        }

        public final void setFaceId(String faceId) {
            this.faceId = faceId;
        }

        @Override
        public final Builder faceId(String faceId) {
            this.faceId = faceId;
            return this;
        }

        public final Float getUserMatchThreshold() {
            return this.userMatchThreshold;
        }

        public final void setUserMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
        }

        @Override
        public final Builder userMatchThreshold(Float userMatchThreshold) {
            this.userMatchThreshold = userMatchThreshold;
            return this;
        }

        public final Integer getMaxUsers() {
            return this.maxUsers;
        }

        public final void setMaxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
        }

        @Override
        public final Builder maxUsers(Integer maxUsers) {
            this.maxUsers = maxUsers;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchUsersRequest build() {
            return new SearchUsersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUsersRequest> {
        public Builder collectionId(String var1);

        public Builder userId(String var1);

        public Builder faceId(String var1);

        public Builder userMatchThreshold(Float var1);

        public Builder maxUsers(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

