/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rekognition.model.OutputConfig;
import software.amazon.awssdk.services.rekognition.model.RekognitionRequest;
import software.amazon.awssdk.services.rekognition.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyProjectVersionRequest
extends RekognitionRequest
implements ToCopyableBuilder<Builder, CopyProjectVersionRequest> {
    private static final SdkField<String> SOURCE_PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceProjectArn").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::sourceProjectArn)).setter(CopyProjectVersionRequest.setter(Builder::sourceProjectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProjectArn").build()}).build();
    private static final SdkField<String> SOURCE_PROJECT_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceProjectVersionArn").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::sourceProjectVersionArn)).setter(CopyProjectVersionRequest.setter(Builder::sourceProjectVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceProjectVersionArn").build()}).build();
    private static final SdkField<String> DESTINATION_PROJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationProjectArn").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::destinationProjectArn)).setter(CopyProjectVersionRequest.setter(Builder::destinationProjectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationProjectArn").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionName").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::versionName)).setter(CopyProjectVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::outputConfig)).setter(CopyProjectVersionRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::tags)).setter(CopyProjectVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CopyProjectVersionRequest.getter(CopyProjectVersionRequest::kmsKeyId)).setter(CopyProjectVersionRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PROJECT_ARN_FIELD, SOURCE_PROJECT_VERSION_ARN_FIELD, DESTINATION_PROJECT_ARN_FIELD, VERSION_NAME_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD));
    private final String sourceProjectArn;
    private final String sourceProjectVersionArn;
    private final String destinationProjectArn;
    private final String versionName;
    private final OutputConfig outputConfig;
    private final Map<String, String> tags;
    private final String kmsKeyId;

    private CopyProjectVersionRequest(BuilderImpl builder) {
        super(builder);
        this.sourceProjectArn = builder.sourceProjectArn;
        this.sourceProjectVersionArn = builder.sourceProjectVersionArn;
        this.destinationProjectArn = builder.destinationProjectArn;
        this.versionName = builder.versionName;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String sourceProjectArn() {
        return this.sourceProjectArn;
    }

    public final String sourceProjectVersionArn() {
        return this.sourceProjectVersionArn;
    }

    public final String destinationProjectArn() {
        return this.destinationProjectArn;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProjectVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationProjectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyProjectVersionRequest)) {
            return false;
        }
        CopyProjectVersionRequest other = (CopyProjectVersionRequest)((Object)obj);
        return Objects.equals(this.sourceProjectArn(), other.sourceProjectArn()) && Objects.equals(this.sourceProjectVersionArn(), other.sourceProjectVersionArn()) && Objects.equals(this.destinationProjectArn(), other.destinationProjectArn()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.outputConfig(), other.outputConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"CopyProjectVersionRequest").add("SourceProjectArn", (Object)this.sourceProjectArn()).add("SourceProjectVersionArn", (Object)this.sourceProjectVersionArn()).add("DestinationProjectArn", (Object)this.destinationProjectArn()).add("VersionName", (Object)this.versionName()).add("OutputConfig", (Object)this.outputConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceProjectArn": {
                return Optional.ofNullable(clazz.cast(this.sourceProjectArn()));
            }
            case "SourceProjectVersionArn": {
                return Optional.ofNullable(clazz.cast(this.sourceProjectVersionArn()));
            }
            case "DestinationProjectArn": {
                return Optional.ofNullable(clazz.cast(this.destinationProjectArn()));
            }
            case "VersionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyProjectVersionRequest, T> g) {
        return obj -> g.apply((CopyProjectVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RekognitionRequest.BuilderImpl
    implements Builder {
        private String sourceProjectArn;
        private String sourceProjectVersionArn;
        private String destinationProjectArn;
        private String versionName;
        private OutputConfig outputConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyProjectVersionRequest model) {
            super(model);
            this.sourceProjectArn(model.sourceProjectArn);
            this.sourceProjectVersionArn(model.sourceProjectVersionArn);
            this.destinationProjectArn(model.destinationProjectArn);
            this.versionName(model.versionName);
            this.outputConfig(model.outputConfig);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getSourceProjectArn() {
            return this.sourceProjectArn;
        }

        public final void setSourceProjectArn(String sourceProjectArn) {
            this.sourceProjectArn = sourceProjectArn;
        }

        @Override
        public final Builder sourceProjectArn(String sourceProjectArn) {
            this.sourceProjectArn = sourceProjectArn;
            return this;
        }

        public final String getSourceProjectVersionArn() {
            return this.sourceProjectVersionArn;
        }

        public final void setSourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
        }

        @Override
        public final Builder sourceProjectVersionArn(String sourceProjectVersionArn) {
            this.sourceProjectVersionArn = sourceProjectVersionArn;
            return this;
        }

        public final String getDestinationProjectArn() {
            return this.destinationProjectArn;
        }

        public final void setDestinationProjectArn(String destinationProjectArn) {
            this.destinationProjectArn = destinationProjectArn;
        }

        @Override
        public final Builder destinationProjectArn(String destinationProjectArn) {
            this.destinationProjectArn = destinationProjectArn;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyProjectVersionRequest build() {
            return new CopyProjectVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RekognitionRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CopyProjectVersionRequest> {
        public Builder sourceProjectArn(String var1);

        public Builder sourceProjectVersionArn(String var1);

        public Builder destinationProjectArn(String var1);

        public Builder versionName(String var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

