/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.internal.UserAgentUtils;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsRequest;
import software.amazon.awssdk.services.rekognition.model.ListCollectionsResponse;

public class ListCollectionsPublisher
implements SdkPublisher<ListCollectionsResponse> {
    private final RekognitionAsyncClient client;
    private final ListCollectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollectionsPublisher(RekognitionAsyncClient client, ListCollectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollectionsPublisher(RekognitionAsyncClient client, ListCollectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> collectionIds() {
        Function<ListCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collectionIds() != null) {
                return response.collectionIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollectionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollectionsResponseFetcher
    implements AsyncPageFetcher<ListCollectionsResponse> {
        private ListCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollectionsResponse> nextPage(ListCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCollectionsPublisher.this.client.listCollections(ListCollectionsPublisher.this.firstRequest);
            }
            return ListCollectionsPublisher.this.client.listCollections((ListCollectionsRequest)((Object)ListCollectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

