/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies when to stop processing the stream. You can specify a maximum amount of time to process the video.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamProcessingStopSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamProcessingStopSelector.Builder, StreamProcessingStopSelector> {
    private static final SdkField<Long> MAX_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxDurationInSeconds").getter(getter(StreamProcessingStopSelector::maxDurationInSeconds))
            .setter(setter(Builder::maxDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDurationInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MAX_DURATION_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long maxDurationInSeconds;

    private StreamProcessingStopSelector(BuilderImpl builder) {
        this.maxDurationInSeconds = builder.maxDurationInSeconds;
    }

    /**
     * <p>
     * Specifies the maximum amount of time in seconds that you want the stream to be processed. The largest amount of
     * time is 2 minutes. The default is 10 seconds.
     * </p>
     * 
     * @return Specifies the maximum amount of time in seconds that you want the stream to be processed. The largest
     *         amount of time is 2 minutes. The default is 10 seconds.
     */
    public final Long maxDurationInSeconds() {
        return maxDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamProcessingStopSelector)) {
            return false;
        }
        StreamProcessingStopSelector other = (StreamProcessingStopSelector) obj;
        return Objects.equals(maxDurationInSeconds(), other.maxDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamProcessingStopSelector").add("MaxDurationInSeconds", maxDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StreamProcessingStopSelector, T> g) {
        return obj -> g.apply((StreamProcessingStopSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamProcessingStopSelector> {
        /**
         * <p>
         * Specifies the maximum amount of time in seconds that you want the stream to be processed. The largest amount
         * of time is 2 minutes. The default is 10 seconds.
         * </p>
         * 
         * @param maxDurationInSeconds
         *        Specifies the maximum amount of time in seconds that you want the stream to be processed. The largest
         *        amount of time is 2 minutes. The default is 10 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDurationInSeconds(Long maxDurationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Long maxDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamProcessingStopSelector model) {
            maxDurationInSeconds(model.maxDurationInSeconds);
        }

        public final Long getMaxDurationInSeconds() {
            return maxDurationInSeconds;
        }

        public final void setMaxDurationInSeconds(Long maxDurationInSeconds) {
            this.maxDurationInSeconds = maxDurationInSeconds;
        }

        @Override
        public final Builder maxDurationInSeconds(Long maxDurationInSeconds) {
            this.maxDurationInSeconds = maxDurationInSeconds;
            return this;
        }

        @Override
        public StreamProcessingStopSelector build() {
            return new StreamProcessingStopSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
