/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.Face;
import software.amazon.awssdk.services.rekognition.model.ListFacesRequest;
import software.amazon.awssdk.services.rekognition.model.ListFacesResponse;

public class ListFacesPublisher
implements SdkPublisher<ListFacesResponse> {
    private final RekognitionAsyncClient client;
    private final ListFacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFacesPublisher(RekognitionAsyncClient client, ListFacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFacesPublisher(RekognitionAsyncClient client, ListFacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Face> faces() {
        Function<ListFacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.faces() != null) {
                return response.faces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFacesResponseFetcher
    implements AsyncPageFetcher<ListFacesResponse> {
        private ListFacesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFacesResponse> nextPage(ListFacesResponse previousPage) {
            if (previousPage == null) {
                return ListFacesPublisher.this.client.listFaces(ListFacesPublisher.this.firstRequest);
            }
            return ListFacesPublisher.this.client.listFaces((ListFacesRequest)((Object)ListFacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

