/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionRequest;
import software.amazon.awssdk.services.rekognition.model.GetFaceDetectionResponse;

public class GetFaceDetectionIterable
implements SdkIterable<GetFaceDetectionResponse> {
    private final RekognitionClient client;
    private final GetFaceDetectionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetFaceDetectionIterable(RekognitionClient client, GetFaceDetectionRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetFaceDetectionResponseFetcher();
    }

    public Iterator<GetFaceDetectionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetFaceDetectionResponseFetcher
    implements SyncPageFetcher<GetFaceDetectionResponse> {
        private GetFaceDetectionResponseFetcher() {
        }

        public boolean hasNextPage(GetFaceDetectionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetFaceDetectionResponse nextPage(GetFaceDetectionResponse previousPage) {
            if (previousPage == null) {
                return GetFaceDetectionIterable.this.client.getFaceDetection(GetFaceDetectionIterable.this.firstRequest);
            }
            return GetFaceDetectionIterable.this.client.getFaceDetection((GetFaceDetectionRequest)((Object)GetFaceDetectionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

