/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rekognition.RekognitionClient;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectsResponse;
import software.amazon.awssdk.services.rekognition.model.ProjectDescription;

public class DescribeProjectsIterable
implements SdkIterable<DescribeProjectsResponse> {
    private final RekognitionClient client;
    private final DescribeProjectsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeProjectsIterable(RekognitionClient client, DescribeProjectsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeProjectsResponseFetcher();
    }

    public Iterator<DescribeProjectsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProjectDescription> projectDescriptions() {
        Function<DescribeProjectsResponse, Iterator> getIterator = response -> {
            if (response != null && response.projectDescriptions() != null) {
                return response.projectDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeProjectsResponseFetcher
    implements SyncPageFetcher<DescribeProjectsResponse> {
        private DescribeProjectsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeProjectsResponse nextPage(DescribeProjectsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProjectsIterable.this.client.describeProjects(DescribeProjectsIterable.this.firstRequest);
            }
            return DescribeProjectsIterable.this.client.describeProjects((DescribeProjectsRequest)((Object)DescribeProjectsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

