/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request parameters represent the input of a request to run a SQL statement against a database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementRequest extends RdsDataRequest implements
        ToCopyableBuilder<ExecuteStatementRequest.Builder, ExecuteStatementRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(ExecuteStatementRequest::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretArn").getter(getter(ExecuteStatementRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretArn").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sql")
            .getter(getter(ExecuteStatementRequest::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sql").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("database").getter(getter(ExecuteStatementRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("schema")
            .getter(getter(ExecuteStatementRequest::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<List<SqlParameter>> PARAMETERS_FIELD = SdkField
            .<List<SqlParameter>> builder(MarshallingType.LIST)
            .memberName("parameters")
            .getter(getter(ExecuteStatementRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionId").getter(getter(ExecuteStatementRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final SdkField<Boolean> INCLUDE_RESULT_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("includeResultMetadata").getter(getter(ExecuteStatementRequest::includeResultMetadata))
            .setter(setter(Builder::includeResultMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeResultMetadata").build())
            .build();

    private static final SdkField<Boolean> CONTINUE_AFTER_TIMEOUT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("continueAfterTimeout").getter(getter(ExecuteStatementRequest::continueAfterTimeout))
            .setter(setter(Builder::continueAfterTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("continueAfterTimeout").build())
            .build();

    private static final SdkField<ResultSetOptions> RESULT_SET_OPTIONS_FIELD = SdkField
            .<ResultSetOptions> builder(MarshallingType.SDK_POJO).memberName("resultSetOptions")
            .getter(getter(ExecuteStatementRequest::resultSetOptions)).setter(setter(Builder::resultSetOptions))
            .constructor(ResultSetOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultSetOptions").build()).build();

    private static final SdkField<String> FORMAT_RECORDS_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("formatRecordsAs").getter(getter(ExecuteStatementRequest::formatRecordsAsAsString))
            .setter(setter(Builder::formatRecordsAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatRecordsAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            SECRET_ARN_FIELD, SQL_FIELD, DATABASE_FIELD, SCHEMA_FIELD, PARAMETERS_FIELD, TRANSACTION_ID_FIELD,
            INCLUDE_RESULT_METADATA_FIELD, CONTINUE_AFTER_TIMEOUT_FIELD, RESULT_SET_OPTIONS_FIELD, FORMAT_RECORDS_AS_FIELD));

    private final String resourceArn;

    private final String secretArn;

    private final String sql;

    private final String database;

    private final String schema;

    private final List<SqlParameter> parameters;

    private final String transactionId;

    private final Boolean includeResultMetadata;

    private final Boolean continueAfterTimeout;

    private final ResultSetOptions resultSetOptions;

    private final String formatRecordsAs;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.secretArn = builder.secretArn;
        this.sql = builder.sql;
        this.database = builder.database;
        this.schema = builder.schema;
        this.parameters = builder.parameters;
        this.transactionId = builder.transactionId;
        this.includeResultMetadata = builder.includeResultMetadata;
        this.continueAfterTimeout = builder.continueAfterTimeout;
        this.resultSetOptions = builder.resultSetOptions;
        this.formatRecordsAs = builder.formatRecordsAs;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The ARN of the secret that enables access to the DB cluster. Enter the database user name and password for the
     * credentials in the secret.
     * </p>
     * <p>
     * For information about creating the secret, see <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create a database
     * secret</a>.
     * </p>
     * 
     * @return The ARN of the secret that enables access to the DB cluster. Enter the database user name and password
     *         for the credentials in the secret.</p>
     *         <p>
     *         For information about creating the secret, see <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create a
     *         database secret</a>.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The SQL statement to run.
     * </p>
     * 
     * @return The SQL statement to run.
     */
    public final String sql() {
        return sql;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The name of the database schema.
     * </p>
     * <note>
     * <p>
     * Currently, the <code>schema</code> parameter isn't supported.
     * </p>
     * </note>
     * 
     * @return The name of the database schema.</p> <note>
     *         <p>
     *         Currently, the <code>schema</code> parameter isn't supported.
     *         </p>
     */
    public final String schema() {
        return schema;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * <note>
     * <p>
     * Array parameters are not supported.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the SQL statement.</p> <note>
     *         <p>
     *         Array parameters are not supported.
     *         </p>
     */
    public final List<SqlParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation. Specify
     * the transaction ID of the transaction that you want to include the SQL statement in.
     * </p>
     * <p>
     * If the SQL statement is not part of a transaction, don't set this parameter.
     * </p>
     * 
     * @return The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation.
     *         Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
     *         <p>
     *         If the SQL statement is not part of a transaction, don't set this parameter.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * A value that indicates whether to include metadata in the results.
     * </p>
     * 
     * @return A value that indicates whether to include metadata in the results.
     */
    public final Boolean includeResultMetadata() {
        return includeResultMetadata;
    }

    /**
     * <p>
     * A value that indicates whether to continue running the statement after the call times out. By default, the
     * statement stops running when the call times out.
     * </p>
     * <note>
     * <p>
     * For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL statement
     * terminates before it is finished running, it can result in errors and possibly corrupted data structures.
     * </p>
     * </note>
     * 
     * @return A value that indicates whether to continue running the statement after the call times out. By default,
     *         the statement stops running when the call times out.</p> <note>
     *         <p>
     *         For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL
     *         statement terminates before it is finished running, it can result in errors and possibly corrupted data
     *         structures.
     *         </p>
     */
    public final Boolean continueAfterTimeout() {
        return continueAfterTimeout;
    }

    /**
     * <p>
     * Options that control how the result set is returned.
     * </p>
     * 
     * @return Options that control how the result set is returned.
     */
    public final ResultSetOptions resultSetOptions() {
        return resultSetOptions;
    }

    /**
     * <p>
     * A value that indicates whether to format the result set as a single JSON string. This parameter only applies to
     * <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are <code>NONE</code>
     * and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in the
     * <code>formattedRecords</code> field.
     * </p>
     * <p>
     * For usage information about the JSON format for result sets, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in the
     * <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatRecordsAs}
     * will return {@link RecordsFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatRecordsAsAsString}.
     * </p>
     * 
     * @return A value that indicates whether to format the result set as a single JSON string. This parameter only
     *         applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values
     *         are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is
     *         returned in the <code>formattedRecords</code> field.</p>
     *         <p>
     *         For usage information about the JSON format for result sets, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a>
     *         in the <i>Amazon Aurora User Guide</i>.
     * @see RecordsFormatType
     */
    public final RecordsFormatType formatRecordsAs() {
        return RecordsFormatType.fromValue(formatRecordsAs);
    }

    /**
     * <p>
     * A value that indicates whether to format the result set as a single JSON string. This parameter only applies to
     * <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are <code>NONE</code>
     * and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in the
     * <code>formattedRecords</code> field.
     * </p>
     * <p>
     * For usage information about the JSON format for result sets, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in the
     * <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #formatRecordsAs}
     * will return {@link RecordsFormatType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatRecordsAsAsString}.
     * </p>
     * 
     * @return A value that indicates whether to format the result set as a single JSON string. This parameter only
     *         applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values
     *         are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is
     *         returned in the <code>formattedRecords</code> field.</p>
     *         <p>
     *         For usage information about the JSON format for result sets, see <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a>
     *         in the <i>Amazon Aurora User Guide</i>.
     * @see RecordsFormatType
     */
    public final String formatRecordsAsAsString() {
        return formatRecordsAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(includeResultMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(continueAfterTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(resultSetOptions());
        hashCode = 31 * hashCode + Objects.hashCode(formatRecordsAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(sql(), other.sql()) && Objects.equals(database(), other.database())
                && Objects.equals(schema(), other.schema()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(includeResultMetadata(), other.includeResultMetadata())
                && Objects.equals(continueAfterTimeout(), other.continueAfterTimeout())
                && Objects.equals(resultSetOptions(), other.resultSetOptions())
                && Objects.equals(formatRecordsAsAsString(), other.formatRecordsAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementRequest").add("ResourceArn", resourceArn()).add("SecretArn", secretArn())
                .add("Sql", sql()).add("Database", database()).add("Schema", schema())
                .add("Parameters", hasParameters() ? parameters() : null).add("TransactionId", transactionId())
                .add("IncludeResultMetadata", includeResultMetadata()).add("ContinueAfterTimeout", continueAfterTimeout())
                .add("ResultSetOptions", resultSetOptions()).add("FormatRecordsAs", formatRecordsAsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "secretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "database":
            return Optional.ofNullable(clazz.cast(database()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "includeResultMetadata":
            return Optional.ofNullable(clazz.cast(includeResultMetadata()));
        case "continueAfterTimeout":
            return Optional.ofNullable(clazz.cast(continueAfterTimeout()));
        case "resultSetOptions":
            return Optional.ofNullable(clazz.cast(resultSetOptions()));
        case "formatRecordsAs":
            return Optional.ofNullable(clazz.cast(formatRecordsAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the Aurora Serverless DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The ARN of the secret that enables access to the DB cluster. Enter the database user name and password for
         * the credentials in the secret.
         * </p>
         * <p>
         * For information about creating the secret, see <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create a
         * database secret</a>.
         * </p>
         * 
         * @param secretArn
         *        The ARN of the secret that enables access to the DB cluster. Enter the database user name and password
         *        for the credentials in the secret.</p>
         *        <p>
         *        For information about creating the secret, see <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/create_database_secret.html">Create
         *        a database secret</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The SQL statement to run.
         * </p>
         * 
         * @param sql
         *        The SQL statement to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param database
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The name of the database schema.
         * </p>
         * <note>
         * <p>
         * Currently, the <code>schema</code> parameter isn't supported.
         * </p>
         * </note>
         * 
         * @param schema
         *        The name of the database schema.</p> <note>
         *        <p>
         *        Currently, the <code>schema</code> parameter isn't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * <note>
         * <p>
         * Array parameters are not supported.
         * </p>
         * </note>
         * 
         * @param parameters
         *        The parameters for the SQL statement.</p> <note>
         *        <p>
         *        Array parameters are not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<SqlParameter> parameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * <note>
         * <p>
         * Array parameters are not supported.
         * </p>
         * </note>
         * 
         * @param parameters
         *        The parameters for the SQL statement.</p> <note>
         *        <p>
         *        Array parameters are not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(SqlParameter... parameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * <note>
         * <p>
         * Array parameters are not supported.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rdsdata.model.SqlParameter.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rdsdata.model.SqlParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rdsdata.model.SqlParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #parameters(List<SqlParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rdsdata.model.SqlParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<SqlParameter>)
         */
        Builder parameters(Consumer<SqlParameter.Builder>... parameters);

        /**
         * <p>
         * The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation.
         * Specify the transaction ID of the transaction that you want to include the SQL statement in.
         * </p>
         * <p>
         * If the SQL statement is not part of a transaction, don't set this parameter.
         * </p>
         * 
         * @param transactionId
         *        The identifier of a transaction that was started by using the <code>BeginTransaction</code> operation.
         *        Specify the transaction ID of the transaction that you want to include the SQL statement in.</p>
         *        <p>
         *        If the SQL statement is not part of a transaction, don't set this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * A value that indicates whether to include metadata in the results.
         * </p>
         * 
         * @param includeResultMetadata
         *        A value that indicates whether to include metadata in the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeResultMetadata(Boolean includeResultMetadata);

        /**
         * <p>
         * A value that indicates whether to continue running the statement after the call times out. By default, the
         * statement stops running when the call times out.
         * </p>
         * <note>
         * <p>
         * For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL
         * statement terminates before it is finished running, it can result in errors and possibly corrupted data
         * structures.
         * </p>
         * </note>
         * 
         * @param continueAfterTimeout
         *        A value that indicates whether to continue running the statement after the call times out. By default,
         *        the statement stops running when the call times out.</p> <note>
         *        <p>
         *        For DDL statements, we recommend continuing to run the statement after the call times out. When a DDL
         *        statement terminates before it is finished running, it can result in errors and possibly corrupted
         *        data structures.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continueAfterTimeout(Boolean continueAfterTimeout);

        /**
         * <p>
         * Options that control how the result set is returned.
         * </p>
         * 
         * @param resultSetOptions
         *        Options that control how the result set is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSetOptions(ResultSetOptions resultSetOptions);

        /**
         * <p>
         * Options that control how the result set is returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResultSetOptions.Builder} avoiding the
         * need to create one manually via {@link ResultSetOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResultSetOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #resultSetOptions(ResultSetOptions)}.
         * 
         * @param resultSetOptions
         *        a consumer that will call methods on {@link ResultSetOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultSetOptions(ResultSetOptions)
         */
        default Builder resultSetOptions(Consumer<ResultSetOptions.Builder> resultSetOptions) {
            return resultSetOptions(ResultSetOptions.builder().applyMutation(resultSetOptions).build());
        }

        /**
         * <p>
         * A value that indicates whether to format the result set as a single JSON string. This parameter only applies
         * to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are
         * <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in
         * the <code>formattedRecords</code> field.
         * </p>
         * <p>
         * For usage information about the JSON format for result sets, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in
         * the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param formatRecordsAs
         *        A value that indicates whether to format the result set as a single JSON string. This parameter only
         *        applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values
         *        are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is
         *        returned in the <code>formattedRecords</code> field.</p>
         *        <p>
         *        For usage information about the JSON format for result sets, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data
         *        API</a> in the <i>Amazon Aurora User Guide</i>.
         * @see RecordsFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordsFormatType
         */
        Builder formatRecordsAs(String formatRecordsAs);

        /**
         * <p>
         * A value that indicates whether to format the result set as a single JSON string. This parameter only applies
         * to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values are
         * <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is returned in
         * the <code>formattedRecords</code> field.
         * </p>
         * <p>
         * For usage information about the JSON format for result sets, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data API</a> in
         * the <i>Amazon Aurora User Guide</i>.
         * </p>
         * 
         * @param formatRecordsAs
         *        A value that indicates whether to format the result set as a single JSON string. This parameter only
         *        applies to <code>SELECT</code> statements and is ignored for other types of statements. Allowed values
         *        are <code>NONE</code> and <code>JSON</code>. The default value is <code>NONE</code>. The result is
         *        returned in the <code>formattedRecords</code> field.</p>
         *        <p>
         *        For usage information about the JSON format for result sets, see <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html">Using the Data
         *        API</a> in the <i>Amazon Aurora User Guide</i>.
         * @see RecordsFormatType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecordsFormatType
         */
        Builder formatRecordsAs(RecordsFormatType formatRecordsAs);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsDataRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String secretArn;

        private String sql;

        private String database;

        private String schema;

        private List<SqlParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String transactionId;

        private Boolean includeResultMetadata;

        private Boolean continueAfterTimeout;

        private ResultSetOptions resultSetOptions;

        private String formatRecordsAs;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            secretArn(model.secretArn);
            sql(model.sql);
            database(model.database);
            schema(model.schema);
            parameters(model.parameters);
            transactionId(model.transactionId);
            includeResultMetadata(model.includeResultMetadata);
            continueAfterTimeout(model.continueAfterTimeout);
            resultSetOptions(model.resultSetOptions);
            formatRecordsAs(model.formatRecordsAs);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSql() {
            return sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final List<SqlParameter.Builder> getParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<SqlParameter.BuilderImpl> parameters) {
            this.parameters = SqlParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<SqlParameter> parameters) {
            this.parameters = SqlParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(SqlParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<SqlParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> SqlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Boolean getIncludeResultMetadata() {
            return includeResultMetadata;
        }

        public final void setIncludeResultMetadata(Boolean includeResultMetadata) {
            this.includeResultMetadata = includeResultMetadata;
        }

        @Override
        public final Builder includeResultMetadata(Boolean includeResultMetadata) {
            this.includeResultMetadata = includeResultMetadata;
            return this;
        }

        public final Boolean getContinueAfterTimeout() {
            return continueAfterTimeout;
        }

        public final void setContinueAfterTimeout(Boolean continueAfterTimeout) {
            this.continueAfterTimeout = continueAfterTimeout;
        }

        @Override
        public final Builder continueAfterTimeout(Boolean continueAfterTimeout) {
            this.continueAfterTimeout = continueAfterTimeout;
            return this;
        }

        public final ResultSetOptions.Builder getResultSetOptions() {
            return resultSetOptions != null ? resultSetOptions.toBuilder() : null;
        }

        public final void setResultSetOptions(ResultSetOptions.BuilderImpl resultSetOptions) {
            this.resultSetOptions = resultSetOptions != null ? resultSetOptions.build() : null;
        }

        @Override
        public final Builder resultSetOptions(ResultSetOptions resultSetOptions) {
            this.resultSetOptions = resultSetOptions;
            return this;
        }

        public final String getFormatRecordsAs() {
            return formatRecordsAs;
        }

        public final void setFormatRecordsAs(String formatRecordsAs) {
            this.formatRecordsAs = formatRecordsAs;
        }

        @Override
        public final Builder formatRecordsAs(String formatRecordsAs) {
            this.formatRecordsAs = formatRecordsAs;
            return this;
        }

        @Override
        public final Builder formatRecordsAs(RecordsFormatType formatRecordsAs) {
            this.formatRecordsAs(formatRecordsAs == null ? null : formatRecordsAs.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
