/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.rds.model.IntegrationError;
import software.amazon.awssdk.services.rds.model.IntegrationErrorListCopier;
import software.amazon.awssdk.services.rds.model.IntegrationStatus;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Integration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Integration> {
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(Integration.getter(Integration::sourceArn)).setter(Integration.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceArn").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(Integration.getter(Integration::targetArn)).setter(Integration.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> INTEGRATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationName").getter(Integration.getter(Integration::integrationName)).setter(Integration.setter(Builder::integrationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationName").build()}).build();
    private static final SdkField<String> INTEGRATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IntegrationArn").getter(Integration.getter(Integration::integrationArn)).setter(Integration.setter(Builder::integrationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationArn").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(Integration.getter(Integration::kmsKeyId)).setter(Integration.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdditionalEncryptionContext").getter(Integration.getter(Integration::additionalEncryptionContext)).setter(Integration.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Integration.getter(Integration::statusAsString)).setter(Integration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Integration.getter(Integration::tags)).setter(Integration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(Integration.getter(Integration::createTime)).setter(Integration.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final SdkField<List<IntegrationError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(Integration.getter(Integration::errors)).setter(Integration.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName("IntegrationError").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IntegrationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationError").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataFilter").getter(Integration.getter(Integration::dataFilter)).setter(Integration.setter(Builder::dataFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataFilter").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Integration.getter(Integration::description)).setter(Integration.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ARN_FIELD, TARGET_ARN_FIELD, INTEGRATION_NAME_FIELD, INTEGRATION_ARN_FIELD, KMS_KEY_ID_FIELD, ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, STATUS_FIELD, TAGS_FIELD, CREATE_TIME_FIELD, ERRORS_FIELD, DATA_FILTER_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SourceArn", SOURCE_ARN_FIELD);
            this.put("TargetArn", TARGET_ARN_FIELD);
            this.put("IntegrationName", INTEGRATION_NAME_FIELD);
            this.put("IntegrationArn", INTEGRATION_ARN_FIELD);
            this.put("KMSKeyId", KMS_KEY_ID_FIELD);
            this.put("AdditionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("CreateTime", CREATE_TIME_FIELD);
            this.put("Errors", ERRORS_FIELD);
            this.put("DataFilter", DATA_FILTER_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String sourceArn;
    private final String targetArn;
    private final String integrationName;
    private final String integrationArn;
    private final String kmsKeyId;
    private final Map<String, String> additionalEncryptionContext;
    private final String status;
    private final List<Tag> tags;
    private final Instant createTime;
    private final List<IntegrationError> errors;
    private final String dataFilter;
    private final String description;

    private Integration(BuilderImpl builder) {
        this.sourceArn = builder.sourceArn;
        this.targetArn = builder.targetArn;
        this.integrationName = builder.integrationName;
        this.integrationArn = builder.integrationArn;
        this.kmsKeyId = builder.kmsKeyId;
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.status = builder.status;
        this.tags = builder.tags;
        this.createTime = builder.createTime;
        this.errors = builder.errors;
        this.dataFilter = builder.dataFilter;
        this.description = builder.description;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String integrationName() {
        return this.integrationName;
    }

    public final String integrationArn() {
        return this.integrationArn;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final IntegrationStatus status() {
        return IntegrationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<IntegrationError> errors() {
        return this.errors;
    }

    public final String dataFilter() {
        return this.dataFilter;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Integration)) {
            return false;
        }
        Integration other = (Integration)obj;
        return Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.integrationName(), other.integrationName()) && Objects.equals(this.integrationArn(), other.integrationArn()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.createTime(), other.createTime()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && Objects.equals(this.dataFilter(), other.dataFilter()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"Integration").add("SourceArn", (Object)this.sourceArn()).add("TargetArn", (Object)this.targetArn()).add("IntegrationName", (Object)this.integrationName()).add("IntegrationArn", (Object)this.integrationArn()).add("KMSKeyId", (Object)this.kmsKeyId()).add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("CreateTime", (Object)this.createTime()).add("Errors", this.hasErrors() ? this.errors() : null).add("DataFilter", (Object)this.dataFilter()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "IntegrationName": {
                return Optional.ofNullable(clazz.cast(this.integrationName()));
            }
            case "IntegrationArn": {
                return Optional.ofNullable(clazz.cast(this.integrationArn()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "AdditionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "DataFilter": {
                return Optional.ofNullable(clazz.cast(this.dataFilter()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Integration, T> g) {
        return obj -> g.apply((Integration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceArn;
        private String targetArn;
        private String integrationName;
        private String integrationArn;
        private String kmsKeyId;
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant createTime;
        private List<IntegrationError> errors = DefaultSdkAutoConstructList.getInstance();
        private String dataFilter;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(Integration model) {
            this.sourceArn(model.sourceArn);
            this.targetArn(model.targetArn);
            this.integrationName(model.integrationName);
            this.integrationArn(model.integrationArn);
            this.kmsKeyId(model.kmsKeyId);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.status(model.status);
            this.tags(model.tags);
            this.createTime(model.createTime);
            this.errors(model.errors);
            this.dataFilter(model.dataFilter);
            this.description(model.description);
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getIntegrationName() {
            return this.integrationName;
        }

        public final void setIntegrationName(String integrationName) {
            this.integrationName = integrationName;
        }

        @Override
        public final Builder integrationName(String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        public final String getIntegrationArn() {
            return this.integrationArn;
        }

        public final void setIntegrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
        }

        @Override
        public final Builder integrationArn(String integrationArn) {
            this.integrationArn = integrationArn;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IntegrationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final List<IntegrationError.Builder> getErrors() {
            List<IntegrationError.Builder> result = IntegrationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<IntegrationError.BuilderImpl> errors) {
            this.errors = IntegrationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<IntegrationError> errors) {
            this.errors = IntegrationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(IntegrationError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<IntegrationError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (IntegrationError)((IntegrationError.Builder)IntegrationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataFilter() {
            return this.dataFilter;
        }

        public final void setDataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
        }

        @Override
        public final Builder dataFilter(String dataFilter) {
            this.dataFilter = dataFilter;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public Integration build() {
            return new Integration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Integration> {
        public Builder sourceArn(String var1);

        public Builder targetArn(String var1);

        public Builder integrationName(String var1);

        public Builder integrationArn(String var1);

        public Builder kmsKeyId(String var1);

        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(IntegrationStatus var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder createTime(Instant var1);

        public Builder errors(Collection<IntegrationError> var1);

        public Builder errors(IntegrationError ... var1);

        public Builder errors(Consumer<IntegrationError.Builder> ... var1);

        public Builder dataFilter(String var1);

        public Builder description(String var1);
    }
}

