/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterResponse;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.rds.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest;
import software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse;
import software.amazon.awssdk.services.rds.model.AuthorizationAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.AuthorizationNotFoundException;
import software.amazon.awssdk.services.rds.model.AuthorizationQuotaExceededException;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest;
import software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.BlueGreenDeploymentNotFoundException;
import software.amazon.awssdk.services.rds.model.CancelExportTaskRequest;
import software.amazon.awssdk.services.rds.model.CancelExportTaskResponse;
import software.amazon.awssdk.services.rds.model.CertificateNotFoundException;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.CreateBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionException;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.CreateCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.CreateDbProxyRequest;
import software.amazon.awssdk.services.rds.model.CreateDbProxyResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZoneNotFoundException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionNotFoundException;
import software.amazon.awssdk.services.rds.model.CustomDbEngineVersionQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterBacktrackNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterEndpointQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterParameterGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.DbClusterRoleQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbClusterSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbClusterSnapshotNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbInstanceAutomatedBackupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceAutomatedBackupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbInstanceNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.DbInstanceRoleQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbLogFileNotFoundException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbParameterGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyEndpointQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetAlreadyRegisteredException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbProxyTargetNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupNotSupportedException;
import software.amazon.awssdk.services.rds.model.DbSecurityGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbSnapshotAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSnapshotNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupDoesNotCoverEnoughAZsException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupNotAllowedException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.DbSubnetGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbSubnetQuotaExceededException;
import software.amazon.awssdk.services.rds.model.DbUpgradeDependencyFailureException;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.DeleteBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.DeleteCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.DeleteOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest;
import software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.DescribeEventsResponse;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest;
import software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest;
import software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse;
import software.amazon.awssdk.services.rds.model.DomainNotFoundException;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse;
import software.amazon.awssdk.services.rds.model.Ec2ImagePropertiesNotSupportedException;
import software.amazon.awssdk.services.rds.model.EventSubscriptionQuotaExceededException;
import software.amazon.awssdk.services.rds.model.ExportTaskAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.ExportTaskNotFoundException;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.GlobalClusterAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.GlobalClusterNotFoundException;
import software.amazon.awssdk.services.rds.model.GlobalClusterQuotaExceededException;
import software.amazon.awssdk.services.rds.model.IamRoleMissingPermissionsException;
import software.amazon.awssdk.services.rds.model.IamRoleNotFoundException;
import software.amazon.awssdk.services.rds.model.InstanceQuotaExceededException;
import software.amazon.awssdk.services.rds.model.InsufficientAvailableIPsInSubnetException;
import software.amazon.awssdk.services.rds.model.InsufficientDbClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InsufficientDbInstanceCapacityException;
import software.amazon.awssdk.services.rds.model.InsufficientStorageClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InvalidBlueGreenDeploymentStateException;
import software.amazon.awssdk.services.rds.model.InvalidCustomDbEngineVersionStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterCapacityException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterEndpointStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterSnapshotStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbClusterStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbInstanceAutomatedBackupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbInstanceStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbParameterGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbProxyEndpointStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbProxyStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSecurityGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSnapshotStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetGroupException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidDbSubnetStateException;
import software.amazon.awssdk.services.rds.model.InvalidEventSubscriptionStateException;
import software.amazon.awssdk.services.rds.model.InvalidExportOnlyException;
import software.amazon.awssdk.services.rds.model.InvalidExportSourceStateException;
import software.amazon.awssdk.services.rds.model.InvalidExportTaskStateException;
import software.amazon.awssdk.services.rds.model.InvalidGlobalClusterStateException;
import software.amazon.awssdk.services.rds.model.InvalidOptionGroupStateException;
import software.amazon.awssdk.services.rds.model.InvalidRestoreException;
import software.amazon.awssdk.services.rds.model.InvalidS3BucketException;
import software.amazon.awssdk.services.rds.model.InvalidSubnetException;
import software.amazon.awssdk.services.rds.model.InvalidVpcNetworkStateException;
import software.amazon.awssdk.services.rds.model.KmsKeyNotAccessibleException;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.ModifyActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest;
import software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionRequest;
import software.amazon.awssdk.services.rds.model.ModifyCustomDbEngineVersionResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse;
import software.amazon.awssdk.services.rds.model.NetworkTypeNotSupportedException;
import software.amazon.awssdk.services.rds.model.OptionGroupAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.OptionGroupNotFoundException;
import software.amazon.awssdk.services.rds.model.OptionGroupQuotaExceededException;
import software.amazon.awssdk.services.rds.model.PointInTimeRestoreNotEnabledException;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse;
import software.amazon.awssdk.services.rds.model.ProvisionedIopsNotAvailableInAzException;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse;
import software.amazon.awssdk.services.rds.model.RdsException;
import software.amazon.awssdk.services.rds.model.RebootDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RebootDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RebootDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest;
import software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterResponse;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceAlreadyExistsException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceNotFoundException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstanceQuotaExceededException;
import software.amazon.awssdk.services.rds.model.ReservedDbInstancesOfferingNotFoundException;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupRequest;
import software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse;
import software.amazon.awssdk.services.rds.model.ResourceNotFoundException;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressRequest;
import software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse;
import software.amazon.awssdk.services.rds.model.SharedSnapshotQuotaExceededException;
import software.amazon.awssdk.services.rds.model.SnapshotQuotaExceededException;
import software.amazon.awssdk.services.rds.model.SnsInvalidTopicException;
import software.amazon.awssdk.services.rds.model.SnsNoAuthorizationException;
import software.amazon.awssdk.services.rds.model.SnsTopicArnNotFoundException;
import software.amazon.awssdk.services.rds.model.SourceClusterNotSupportedException;
import software.amazon.awssdk.services.rds.model.SourceDatabaseNotSupportedException;
import software.amazon.awssdk.services.rds.model.SourceNotFoundException;
import software.amazon.awssdk.services.rds.model.StartActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StartActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StartDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StartDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StartDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StartDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StartExportTaskRequest;
import software.amazon.awssdk.services.rds.model.StartExportTaskResponse;
import software.amazon.awssdk.services.rds.model.StopActivityStreamRequest;
import software.amazon.awssdk.services.rds.model.StopActivityStreamResponse;
import software.amazon.awssdk.services.rds.model.StopDbClusterRequest;
import software.amazon.awssdk.services.rds.model.StopDbClusterResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse;
import software.amazon.awssdk.services.rds.model.StopDbInstanceRequest;
import software.amazon.awssdk.services.rds.model.StopDbInstanceResponse;
import software.amazon.awssdk.services.rds.model.StorageQuotaExceededException;
import software.amazon.awssdk.services.rds.model.StorageTypeNotAvailableException;
import software.amazon.awssdk.services.rds.model.StorageTypeNotSupportedException;
import software.amazon.awssdk.services.rds.model.SubnetAlreadyInUseException;
import software.amazon.awssdk.services.rds.model.SubscriptionAlreadyExistException;
import software.amazon.awssdk.services.rds.model.SubscriptionCategoryNotFoundException;
import software.amazon.awssdk.services.rds.model.SubscriptionNotFoundException;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverBlueGreenDeploymentResponse;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.SwitchoverReadReplicaResponse;
import software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable;
import software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable;
import software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable;
import software.amazon.awssdk.services.rds.waiters.RdsWaiter;

/**
 * Service client for accessing Amazon RDS. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Relational Database Service</fullname>
 * <p/>
 * <p>
 * Amazon Relational Database Service (Amazon RDS) is a web service that makes it easier to set up, operate, and scale a
 * relational database in the cloud. It provides cost-efficient, resizeable capacity for an industry-standard relational
 * database and manages common database administration tasks, freeing up developers to focus on what makes their
 * applications and businesses unique.
 * </p>
 * <p>
 * Amazon RDS gives you access to the capabilities of a MySQL, MariaDB, PostgreSQL, Microsoft SQL Server, Oracle, or
 * Amazon Aurora database server. These capabilities mean that the code, applications, and tools you already use today
 * with your existing databases work with Amazon RDS without modification. Amazon RDS automatically backs up your
 * database and maintains the database software that powers your DB instance. Amazon RDS is flexible: you can scale your
 * DB instance's compute resources and storage capacity to meet your application's demand. As with all Amazon Web
 * Services, there are no up-front investments, and you pay only for the resources you use.
 * </p>
 * <p>
 * This interface reference for Amazon RDS contains documentation for a programming or command line interface you can
 * use to manage Amazon RDS. Amazon RDS is asynchronous, which means that some interfaces might require techniques such
 * as polling or callback functions to determine when a command has been applied. In this reference, the parameter
 * descriptions indicate whether a command is applied immediately, on the next instance reboot, or during the
 * maintenance window. The reference structure is as follows, and we list following some related topics from the user
 * guide.
 * </p>
 * <p>
 * <b>Amazon RDS API Reference</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For the alphabetical list of API actions, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Operations.html">API Actions</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For the alphabetical list of data types, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_Types.html">Data Types</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For a list of common query parameters, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonParameters.html">Common Parameters</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For descriptions of the error codes, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/CommonErrors.html">Common Errors</a>.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Amazon RDS User Guide</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * For a summary of the Amazon RDS interfaces, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Welcome.html#Welcome.Interfaces">Available RDS
 * Interfaces</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * For more information about how to use the Query API, see <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Using_the_Query_API.html">Using the Query API</a>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RdsClient extends AwsClient {
    String SERVICE_NAME = "rds";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "rds";

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     * </p>
     *
     * @param addRoleToDbClusterRequest
     * @return Result of the AddRoleToDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterRoleAlreadyExistsException
     *         The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterRoleQuotaExceededException
     *         You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default AddRoleToDbClusterResponse addRoleToDBCluster(AddRoleToDbClusterRequest addRoleToDbClusterRequest)
            throws DbClusterNotFoundException, DbClusterRoleAlreadyExistsException, InvalidDbClusterStateException,
            DbClusterRoleQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Identity and Access Management (IAM) role with a DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToDbClusterRequest.Builder} avoiding the
     * need to create one manually via {@link AddRoleToDbClusterRequest#builder()}
     * </p>
     *
     * @param addRoleToDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link AddRoleToDBClusterMessage.Builder} to create a
     *        request.
     * @return Result of the AddRoleToDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterRoleAlreadyExistsException
     *         The specified IAM role Amazon Resource Name (ARN) is already associated with the specified DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterRoleQuotaExceededException
     *         You have exceeded the maximum number of IAM roles that can be associated with the specified DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddRoleToDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default AddRoleToDbClusterResponse addRoleToDBCluster(Consumer<AddRoleToDbClusterRequest.Builder> addRoleToDbClusterRequest)
            throws DbClusterNotFoundException, DbClusterRoleAlreadyExistsException, InvalidDbClusterStateException,
            DbClusterRoleQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        return addRoleToDBCluster(AddRoleToDbClusterRequest.builder().applyMutation(addRoleToDbClusterRequest).build());
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     * </p>
     * <note>
     * <p>
     * To add a role to a DB instance, the status of the DB instance must be <code>available</code>.
     * </p>
     * </note>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param addRoleToDbInstanceRequest
     * @return Result of the AddRoleToDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbInstanceRoleAlreadyExistsException
     *         The specified <code>RoleArn</code> or <code>FeatureName</code> value is already associated with the DB
     *         instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceRoleQuotaExceededException
     *         You can't associate any more Amazon Web Services Identity and Access Management (IAM) roles with the DB
     *         instance because the quota has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddRoleToDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default AddRoleToDbInstanceResponse addRoleToDBInstance(AddRoleToDbInstanceRequest addRoleToDbInstanceRequest)
            throws DbInstanceNotFoundException, DbInstanceRoleAlreadyExistsException, InvalidDbInstanceStateException,
            DbInstanceRoleQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB instance.
     * </p>
     * <note>
     * <p>
     * To add a role to a DB instance, the status of the DB instance must be <code>available</code>.
     * </p>
     * </note>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddRoleToDbInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link AddRoleToDbInstanceRequest#builder()}
     * </p>
     *
     * @param addRoleToDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link AddRoleToDBInstanceMessage.Builder} to create a
     *        request.
     * @return Result of the AddRoleToDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbInstanceRoleAlreadyExistsException
     *         The specified <code>RoleArn</code> or <code>FeatureName</code> value is already associated with the DB
     *         instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceRoleQuotaExceededException
     *         You can't associate any more Amazon Web Services Identity and Access Management (IAM) roles with the DB
     *         instance because the quota has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddRoleToDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddRoleToDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default AddRoleToDbInstanceResponse addRoleToDBInstance(
            Consumer<AddRoleToDbInstanceRequest.Builder> addRoleToDbInstanceRequest) throws DbInstanceNotFoundException,
            DbInstanceRoleAlreadyExistsException, InvalidDbInstanceStateException, DbInstanceRoleQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {
        return addRoleToDBInstance(AddRoleToDbInstanceRequest.builder().applyMutation(addRoleToDbInstanceRequest).build());
    }

    /**
     * <p>
     * Adds a source identifier to an existing RDS event notification subscription.
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     * @return Result of the AddSourceIdentifierToSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscription(
            AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest)
            throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a source identifier to an existing RDS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddSourceIdentifierToSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link AddSourceIdentifierToSubscriptionRequest#builder()}
     * </p>
     *
     * @param addSourceIdentifierToSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link AddSourceIdentifierToSubscriptionMessage.Builder} to
     *        create a request.
     * @return Result of the AddSourceIdentifierToSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddSourceIdentifierToSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddSourceIdentifierToSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default AddSourceIdentifierToSubscriptionResponse addSourceIdentifierToSubscription(
            Consumer<AddSourceIdentifierToSubscriptionRequest.Builder> addSourceIdentifierToSubscriptionRequest)
            throws SubscriptionNotFoundException, SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest.builder()
                .applyMutation(addSourceIdentifierToSubscriptionRequest).build());
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track
     * cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * </p>
     * <p>
     * For an overview on tagging Amazon RDS resources, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws DbInstanceNotFoundException, DbClusterNotFoundException, DbSnapshotNotFoundException,
            DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost allocation reporting to track
     * cost associated with Amazon RDS resources, or used in a Condition statement in an IAM policy for Amazon RDS.
     * </p>
     * <p>
     * For an overview on tagging Amazon RDS resources, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceMessage.Builder} to create a request.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws DbInstanceNotFoundException, DbClusterNotFoundException, DbSnapshotNotFoundException,
            DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            ApplyPendingMaintenanceActionRequest applyPendingMaintenanceActionRequest) throws ResourceNotFoundException,
            InvalidDbClusterStateException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Applies a pending maintenance action to a resource (for example, to a DB instance).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ApplyPendingMaintenanceActionRequest.Builder}
     * avoiding the need to create one manually via {@link ApplyPendingMaintenanceActionRequest#builder()}
     * </p>
     *
     * @param applyPendingMaintenanceActionRequest
     *        A {@link Consumer} that will call methods on {@link ApplyPendingMaintenanceActionMessage.Builder} to
     *        create a request.
     * @return Result of the ApplyPendingMaintenanceAction operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ApplyPendingMaintenanceAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ApplyPendingMaintenanceAction"
     *      target="_top">AWS API Documentation</a>
     */
    default ApplyPendingMaintenanceActionResponse applyPendingMaintenanceAction(
            Consumer<ApplyPendingMaintenanceActionRequest.Builder> applyPendingMaintenanceActionRequest)
            throws ResourceNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, RdsException {
        return applyPendingMaintenanceAction(ApplyPendingMaintenanceActionRequest.builder()
                .applyMutation(applyPendingMaintenanceActionRequest).build());
    }

    /**
     * <p>
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups
     * can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances.
     * Second, IP ranges are available if the application accessing your database is running on the internet. Required
     * parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
     * EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     * </p>
     * <p>
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB
     * instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB
     * instance in another.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param authorizeDbSecurityGroupIngressRequest
     * @return Result of the AuthorizeDBSecurityGroupIngress operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR IP range or Amazon EC2 security group is already authorized for the specified DB
     *         security group.
     * @throws AuthorizationQuotaExceededException
     *         The DB security group authorization quota has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AuthorizeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeDbSecurityGroupIngressResponse authorizeDBSecurityGroupIngress(
            AuthorizeDbSecurityGroupIngressRequest authorizeDbSecurityGroupIngressRequest)
            throws DbSecurityGroupNotFoundException, InvalidDbSecurityGroupStateException, AuthorizationAlreadyExistsException,
            AuthorizationQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or VPC security groups
     * can be added to the DBSecurityGroup if the application using the database is running on EC2 or VPC instances.
     * Second, IP ranges are available if the application accessing your database is running on the internet. Required
     * parameters for this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and either
     * EC2SecurityGroupName or EC2SecurityGroupId for non-VPC).
     * </p>
     * <p>
     * You can't authorize ingress from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB
     * instance in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon RDS DB
     * instance in another.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AuthorizeDbSecurityGroupIngressRequest.Builder}
     * avoiding the need to create one manually via {@link AuthorizeDbSecurityGroupIngressRequest#builder()}
     * </p>
     *
     * @param authorizeDbSecurityGroupIngressRequest
     *        A {@link Consumer} that will call methods on {@link AuthorizeDBSecurityGroupIngressMessage.Builder} to
     *        create a request.
     * @return Result of the AuthorizeDBSecurityGroupIngress operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws AuthorizationAlreadyExistsException
     *         The specified CIDR IP range or Amazon EC2 security group is already authorized for the specified DB
     *         security group.
     * @throws AuthorizationQuotaExceededException
     *         The DB security group authorization quota has been reached.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.AuthorizeDBSecurityGroupIngress
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/AuthorizeDBSecurityGroupIngress"
     *      target="_top">AWS API Documentation</a>
     */
    default AuthorizeDbSecurityGroupIngressResponse authorizeDBSecurityGroupIngress(
            Consumer<AuthorizeDbSecurityGroupIngressRequest.Builder> authorizeDbSecurityGroupIngressRequest)
            throws DbSecurityGroupNotFoundException, InvalidDbSecurityGroupStateException, AuthorizationAlreadyExistsException,
            AuthorizationQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        return authorizeDBSecurityGroupIngress(AuthorizeDbSecurityGroupIngressRequest.builder()
                .applyMutation(authorizeDbSecurityGroupIngressRequest).build());
    }

    /**
     * <p>
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * </p>
     * <p>
     * For more information on backtracking, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param backtrackDbClusterRequest
     * @return Result of the BacktrackDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.BacktrackDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default BacktrackDbClusterResponse backtrackDBCluster(BacktrackDbClusterRequest backtrackDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Backtracks a DB cluster to a specific time, without creating a new DB cluster.
     * </p>
     * <p>
     * For more information on backtracking, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Managing.Backtrack.html">
     * Backtracking an Aurora DB Cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora MySQL DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BacktrackDbClusterRequest.Builder} avoiding the
     * need to create one manually via {@link BacktrackDbClusterRequest#builder()}
     * </p>
     *
     * @param backtrackDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link BacktrackDBClusterMessage.Builder} to create a
     *        request.
     * @return Result of the BacktrackDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.BacktrackDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/BacktrackDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default BacktrackDbClusterResponse backtrackDBCluster(Consumer<BacktrackDbClusterRequest.Builder> backtrackDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            RdsException {
        return backtrackDBCluster(BacktrackDbClusterRequest.builder().applyMutation(backtrackDbClusterRequest).build());
    }

    /**
     * <p>
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has
     * already been written to the S3 bucket isn't removed.
     * </p>
     *
     * @param cancelExportTaskRequest
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws InvalidExportTaskStateException
     *         You can't cancel an export task that has completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelExportTaskResponse cancelExportTask(CancelExportTaskRequest cancelExportTaskRequest)
            throws ExportTaskNotFoundException, InvalidExportTaskStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3. Any data that has
     * already been written to the S3 bucket isn't removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelExportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelExportTaskRequest#builder()}
     * </p>
     *
     * @param cancelExportTaskRequest
     *        A {@link Consumer} that will call methods on {@link CancelExportTaskMessage.Builder} to create a request.
     * @return Result of the CancelExportTask operation returned by the service.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws InvalidExportTaskStateException
     *         You can't cancel an export task that has completed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CancelExportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CancelExportTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelExportTaskResponse cancelExportTask(Consumer<CancelExportTaskRequest.Builder> cancelExportTaskRequest)
            throws ExportTaskNotFoundException, InvalidExportTaskStateException, AwsServiceException, SdkClientException,
            RdsException {
        return cancelExportTask(CancelExportTaskRequest.builder().applyMutation(cancelExportTaskRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     * @return Result of the CopyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(
            CopyDbClusterParameterGroupRequest copyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB cluster parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CopyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBClusterParameterGroupMessage.Builder} to create
     *        a request.
     * @return Result of the CopyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CopyDbClusterParameterGroupResponse copyDBClusterParameterGroup(
            Consumer<CopyDbClusterParameterGroupRequest.Builder> copyDbClusterParameterGroupRequest)
            throws DbParameterGroupNotFoundException, DbParameterGroupQuotaExceededException,
            DbParameterGroupAlreadyExistsException, AwsServiceException, SdkClientException, RdsException {
        return copyDBClusterParameterGroup(CopyDbClusterParameterGroupRequest.builder()
                .applyMutation(copyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon
     * Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web
     * Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
     * from another Amazon Web Services Region, you must provide the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
     * for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is
     * the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <p>
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region
     * to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     * @return Result of the CopyDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyDbClusterSnapshotResponse copyDBClusterSnapshot(CopyDbClusterSnapshotRequest copyDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException,
            InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies a snapshot of a DB cluster.
     * </p>
     * <p>
     * To copy a DB cluster snapshot from a shared manual DB cluster snapshot,
     * <code>SourceDBClusterSnapshotIdentifier</code> must be the Amazon Resource Name (ARN) of the shared DB cluster
     * snapshot.
     * </p>
     * <p>
     * You can copy an encrypted DB cluster snapshot from another Amazon Web Services Region. In that case, the Amazon
     * Web Services Region where you call the <code>CopyDBClusterSnapshot</code> operation is the destination Amazon Web
     * Services Region for the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
     * from another Amazon Web Services Region, you must provide the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>KmsKeyId</code> - The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
     * for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TargetDBClusterSnapshotIdentifier</code> - The identifier for the new copy of the DB cluster snapshot in
     * the destination Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SourceDBClusterSnapshotIdentifier</code> - The DB cluster snapshot identifier for the encrypted DB cluster
     * snapshot to be copied. This identifier must be in the ARN format for the source Amazon Web Services Region and is
     * the same value as the <code>SourceDBClusterSnapshotIdentifier</code> in the presigned URL.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To cancel the copy operation once it is in progress, delete the target DB cluster snapshot identified by
     * <code>TargetDBClusterSnapshotIdentifier</code> while that DB cluster snapshot is in "copying" status.
     * </p>
     * <p>
     * For more information on copying encrypted Amazon Aurora DB cluster snapshots from one Amazon Web Services Region
     * to another, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_CopySnapshot.html">
     * Copying a Snapshot</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbClusterSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the CopyDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBClusterSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyDbClusterSnapshotResponse copyDBClusterSnapshot(
            Consumer<CopyDbClusterSnapshotRequest.Builder> copyDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, DbClusterSnapshotNotFoundException, InvalidDbClusterStateException,
            InvalidDbClusterSnapshotStateException, SnapshotQuotaExceededException, KmsKeyNotAccessibleException,
            AwsServiceException, SdkClientException, RdsException {
        return copyDBClusterSnapshot(CopyDbClusterSnapshotRequest.builder().applyMutation(copyDbClusterSnapshotRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     *
     * @param copyDbParameterGroupRequest
     * @return Result of the CopyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyDbParameterGroupResponse copyDBParameterGroup(CopyDbParameterGroupRequest copyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, DbParameterGroupAlreadyExistsException,
            DbParameterGroupQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CopyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param copyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return Result of the CopyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBParameterGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyDbParameterGroupResponse copyDBParameterGroup(
            Consumer<CopyDbParameterGroupRequest.Builder> copyDbParameterGroupRequest) throws DbParameterGroupNotFoundException,
            DbParameterGroupAlreadyExistsException, DbParameterGroupQuotaExceededException, AwsServiceException,
            SdkClientException, RdsException {
        return copyDBParameterGroup(CopyDbParameterGroupRequest.builder().applyMutation(copyDbParameterGroupRequest).build());
    }

    /**
     * <p>
     * Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.
     * </p>
     * <p>
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services
     * Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for
     * the DB snapshot copy.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information about copying snapshots, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying
     * a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param copyDbSnapshotRequest
     * @return Result of the CopyDBSnapshot operation returned by the service.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws CustomAvailabilityZoneNotFoundException
     *         <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyDbSnapshotResponse copyDBSnapshot(CopyDbSnapshotRequest copyDbSnapshotRequest)
            throws DbSnapshotAlreadyExistsException, DbSnapshotNotFoundException, InvalidDbSnapshotStateException,
            SnapshotQuotaExceededException, KmsKeyNotAccessibleException, CustomAvailabilityZoneNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified DB snapshot. The source DB snapshot must be in the <code>available</code> state.
     * </p>
     * <p>
     * You can copy a snapshot from one Amazon Web Services Region to another. In that case, the Amazon Web Services
     * Region where you call the <code>CopyDBSnapshot</code> operation is the destination Amazon Web Services Region for
     * the DB snapshot copy.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <p>
     * For more information about copying snapshots, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CopySnapshot.html#USER_CopyDBSnapshot">Copying
     * a DB Snapshot</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyDbSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CopyDbSnapshotRequest#builder()}
     * </p>
     *
     * @param copyDbSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CopyDBSnapshotMessage.Builder} to create a request.
     * @return Result of the CopyDBSnapshot operation returned by the service.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws CustomAvailabilityZoneNotFoundException
     *         <code>CustomAvailabilityZoneId</code> doesn't refer to an existing custom Availability Zone identifier.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyDbSnapshotResponse copyDBSnapshot(Consumer<CopyDbSnapshotRequest.Builder> copyDbSnapshotRequest)
            throws DbSnapshotAlreadyExistsException, DbSnapshotNotFoundException, InvalidDbSnapshotStateException,
            SnapshotQuotaExceededException, KmsKeyNotAccessibleException, CustomAvailabilityZoneNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return copyDBSnapshot(CopyDbSnapshotRequest.builder().applyMutation(copyDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Copies the specified option group.
     * </p>
     *
     * @param copyOptionGroupRequest
     * @return Result of the CopyOptionGroup operation returned by the service.
     * @throws OptionGroupAlreadyExistsException
     *         The option group you are trying to create already exists.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws OptionGroupQuotaExceededException
     *         The quota of 20 option groups was exceeded for this Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyOptionGroupResponse copyOptionGroup(CopyOptionGroupRequest copyOptionGroupRequest)
            throws OptionGroupAlreadyExistsException, OptionGroupNotFoundException, OptionGroupQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the specified option group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyOptionGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CopyOptionGroupRequest#builder()}
     * </p>
     *
     * @param copyOptionGroupRequest
     *        A {@link Consumer} that will call methods on {@link CopyOptionGroupMessage.Builder} to create a request.
     * @return Result of the CopyOptionGroup operation returned by the service.
     * @throws OptionGroupAlreadyExistsException
     *         The option group you are trying to create already exists.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws OptionGroupQuotaExceededException
     *         The quota of 20 option groups was exceeded for this Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CopyOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CopyOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyOptionGroupResponse copyOptionGroup(Consumer<CopyOptionGroupRequest.Builder> copyOptionGroupRequest)
            throws OptionGroupAlreadyExistsException, OptionGroupNotFoundException, OptionGroupQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {
        return copyOptionGroup(CopyOptionGroupRequest.builder().applyMutation(copyOptionGroupRequest).build());
    }

    /**
     * <p>
     * Creates a blue/green deployment.
     * </p>
     * <p>
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green
     * deployment, the blue environment is the current production environment. The green environment is the staging
     * environment. The staging environment stays in sync with the current production environment using logical
     * replication.
     * </p>
     * <p>
     * You can make changes to the databases in the green environment without affecting production workloads. For
     * example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes
     * in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch
     * over the environments to promote the green environment to be the new production environment. The switchover
     * typically takes under a minute.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createBlueGreenDeploymentRequest
     * @return Result of the CreateBlueGreenDeployment operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SourceDatabaseNotSupportedException
     *         The source DB instance isn't supported for a blue/green deployment.
     * @throws SourceClusterNotSupportedException
     *         The source DB cluster isn't supported for a blue/green deployment.
     * @throws BlueGreenDeploymentAlreadyExistsException
     *         A blue/green deployment with the specified name already exists.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBlueGreenDeploymentResponse createBlueGreenDeployment(
            CreateBlueGreenDeploymentRequest createBlueGreenDeploymentRequest) throws DbInstanceNotFoundException,
            DbClusterNotFoundException, SourceDatabaseNotSupportedException, SourceClusterNotSupportedException,
            BlueGreenDeploymentAlreadyExistsException, DbParameterGroupNotFoundException,
            DbClusterParameterGroupNotFoundException, InstanceQuotaExceededException, DbClusterQuotaExceededException,
            InvalidDbInstanceStateException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a blue/green deployment.
     * </p>
     * <p>
     * A blue/green deployment creates a staging environment that copies the production environment. In a blue/green
     * deployment, the blue environment is the current production environment. The green environment is the staging
     * environment. The staging environment stays in sync with the current production environment using logical
     * replication.
     * </p>
     * <p>
     * You can make changes to the databases in the green environment without affecting production workloads. For
     * example, you can upgrade the major or minor DB engine version, change database parameters, or make schema changes
     * in the staging environment. You can thoroughly test changes in the green environment. When ready, you can switch
     * over the environments to promote the green environment to be the new production environment. The switchover
     * typically takes under a minute.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBlueGreenDeploymentRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBlueGreenDeploymentRequest#builder()}
     * </p>
     *
     * @param createBlueGreenDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link CreateBlueGreenDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the CreateBlueGreenDeployment operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SourceDatabaseNotSupportedException
     *         The source DB instance isn't supported for a blue/green deployment.
     * @throws SourceClusterNotSupportedException
     *         The source DB cluster isn't supported for a blue/green deployment.
     * @throws BlueGreenDeploymentAlreadyExistsException
     *         A blue/green deployment with the specified name already exists.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateBlueGreenDeploymentResponse createBlueGreenDeployment(
            Consumer<CreateBlueGreenDeploymentRequest.Builder> createBlueGreenDeploymentRequest)
            throws DbInstanceNotFoundException, DbClusterNotFoundException, SourceDatabaseNotSupportedException,
            SourceClusterNotSupportedException, BlueGreenDeploymentAlreadyExistsException, DbParameterGroupNotFoundException,
            DbClusterParameterGroupNotFoundException, InstanceQuotaExceededException, DbClusterQuotaExceededException,
            InvalidDbInstanceStateException, InvalidDbClusterStateException, AwsServiceException, SdkClientException,
            RdsException {
        return createBlueGreenDeployment(CreateBlueGreenDeploymentRequest.builder()
                .applyMutation(createBlueGreenDeploymentRequest).build());
    }

    /**
     * <p>
     * Creates a custom DB engine version (CEV).
     * </p>
     *
     * @param createCustomDbEngineVersionRequest
     * @return Result of the CreateCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionAlreadyExistsException
     *         A CEV with the specified name already exists.
     * @throws CustomDbEngineVersionQuotaExceededException
     *         You have exceeded your CEV quota.
     * @throws Ec2ImagePropertiesNotSupportedException
     *         The AMI configuration prerequisite has not been met.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws CreateCustomDbEngineVersionException
     *         An error occurred while trying to create the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomDbEngineVersionResponse createCustomDBEngineVersion(
            CreateCustomDbEngineVersionRequest createCustomDbEngineVersionRequest)
            throws CustomDbEngineVersionAlreadyExistsException, CustomDbEngineVersionQuotaExceededException,
            Ec2ImagePropertiesNotSupportedException, KmsKeyNotAccessibleException, CreateCustomDbEngineVersionException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom DB engine version (CEV).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomDbEngineVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCustomDbEngineVersionRequest#builder()}
     * </p>
     *
     * @param createCustomDbEngineVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCustomDBEngineVersionMessage.Builder} to create
     *        a request.
     * @return Result of the CreateCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionAlreadyExistsException
     *         A CEV with the specified name already exists.
     * @throws CustomDbEngineVersionQuotaExceededException
     *         You have exceeded your CEV quota.
     * @throws Ec2ImagePropertiesNotSupportedException
     *         The AMI configuration prerequisite has not been met.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws CreateCustomDbEngineVersionException
     *         An error occurred while trying to create the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCustomDbEngineVersionResponse createCustomDBEngineVersion(
            Consumer<CreateCustomDbEngineVersionRequest.Builder> createCustomDbEngineVersionRequest)
            throws CustomDbEngineVersionAlreadyExistsException, CustomDbEngineVersionQuotaExceededException,
            Ec2ImagePropertiesNotSupportedException, KmsKeyNotAccessibleException, CreateCustomDbEngineVersionException,
            AwsServiceException, SdkClientException, RdsException {
        return createCustomDBEngineVersion(CreateCustomDbEngineVersionRequest.builder()
                .applyMutation(createCustomDbEngineVersionRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * </p>
     * <p>
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer
     * instance for your DB cluster using the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a>
     * operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you,
     * each in a different Availability Zone.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a
     * read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about
     * Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read
     * replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB
     * clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterRequest
     * @return Result of the CreateDBCluster operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You might be able to resolve this error
     *         by updating your subnet group to use different Availability Zones that have more storage available.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbClusterResponse createDBCluster(CreateDbClusterRequest createDbClusterRequest)
            throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException,
            StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException,
            InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException,
            InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException,
            DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            GlobalClusterNotFoundException, InvalidGlobalClusterStateException, DomainNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster.
     * </p>
     * <p>
     * If you create an Aurora DB cluster, the request creates an empty cluster. You must explicitly create the writer
     * instance for your DB cluster using the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_CreateDBInstance.html">CreateDBInstance</a>
     * operation. If you create a Multi-AZ DB cluster, the request creates a writer and two reader DB instances for you,
     * each in a different Availability Zone.
     * </p>
     * <p>
     * You can use the <code>ReplicationSourceIdentifier</code> parameter to create an Amazon Aurora DB cluster as a
     * read replica of another DB cluster or Amazon RDS for MySQL or PostgreSQL DB instance. For more information about
     * Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html">What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * You can also use the <code>ReplicationSourceIdentifier</code> parameter to create a Multi-AZ DB cluster read
     * replica with an RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ DB
     * clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html">Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbClusterRequest#builder()}
     * </p>
     *
     * @param createDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterMessage.Builder} to create a request.
     * @return Result of the CreateDBCluster operation returned by the service.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws InsufficientStorageClusterCapacityException
     *         There is insufficient storage available for the current action. You might be able to resolve this error
     *         by updating your subnet group to use different Availability Zones that have more storage available.
     * @throws DbClusterQuotaExceededException
     *         The user attempted to create a new DB cluster and the user has already reached the maximum allowed DB
     *         cluster quota.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbClusterResponse createDBCluster(Consumer<CreateDbClusterRequest.Builder> createDbClusterRequest)
            throws DbClusterAlreadyExistsException, InsufficientStorageClusterCapacityException, DbClusterQuotaExceededException,
            StorageQuotaExceededException, DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException,
            InvalidDbClusterStateException, InvalidDbSubnetGroupStateException, InvalidSubnetException,
            InvalidDbInstanceStateException, DbClusterParameterGroupNotFoundException, KmsKeyNotAccessibleException,
            DbClusterNotFoundException, DbInstanceNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            GlobalClusterNotFoundException, InvalidGlobalClusterStateException, DomainNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return createDBCluster(CreateDbClusterRequest.builder().applyMutation(createDbClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createDbClusterEndpointRequest
     * @return Result of the CreateDBClusterEndpoint operation returned by the service.
     * @throws DbClusterEndpointQuotaExceededException
     *         The cluster already has the maximum number of custom endpoints.
     * @throws DbClusterEndpointAlreadyExistsException
     *         The specified custom endpoint can't be created because it already exists.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbClusterEndpointResponse createDBClusterEndpoint(CreateDbClusterEndpointRequest createDbClusterEndpointRequest)
            throws DbClusterEndpointQuotaExceededException, DbClusterEndpointAlreadyExistsException, DbClusterNotFoundException,
            InvalidDbClusterStateException, DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param createDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterEndpointMessage.Builder} to create a
     *        request.
     * @return Result of the CreateDBClusterEndpoint operation returned by the service.
     * @throws DbClusterEndpointQuotaExceededException
     *         The cluster already has the maximum number of custom endpoints.
     * @throws DbClusterEndpointAlreadyExistsException
     *         The specified custom endpoint can't be created because it already exists.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbClusterEndpointResponse createDBClusterEndpoint(
            Consumer<CreateDbClusterEndpointRequest.Builder> createDbClusterEndpointRequest)
            throws DbClusterEndpointQuotaExceededException, DbClusterEndpointAlreadyExistsException, DbClusterNotFoundException,
            InvalidDbClusterStateException, DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException,
            SdkClientException, RdsException {
        return createDBClusterEndpoint(CreateDbClusterEndpointRequest.builder().applyMutation(createDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group,
     * you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
     * the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster
     * without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the DB cluster parameter group is used as the default for a new DB cluster.
     * This is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code>
     * operation to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     * @return Result of the CreateDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(
            CreateDbClusterParameterGroupRequest createDbClusterParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB cluster parameter group.
     * </p>
     * <p>
     * Parameters in a DB cluster parameter group apply to all of the instances in a DB cluster.
     * </p>
     * <p>
     * A DB cluster parameter group is initially created with the default parameters for the database engine used by
     * instances in the DB cluster. To provide custom values for any of the parameters, you must modify the group after
     * creating it using <code>ModifyDBClusterParameterGroup</code>. Once you've created a DB cluster parameter group,
     * you need to associate it with your DB cluster using <code>ModifyDBCluster</code>.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
     * the DB cluster without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <p>
     * When you associate a new DB cluster parameter group with a running Multi-AZ DB cluster, reboot the DB cluster
     * without failover for the new DB cluster parameter group and associated settings to take effect.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the DB cluster parameter group is used as the default for a new DB cluster.
     * This is especially important for parameters that are critical when creating the default database for a DB
     * cluster, such as the character set for the default database defined by the <code>character_set_database</code>
     * parameter. You can use the <i>Parameter Groups</i> option of the <a
     * href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or the <code>DescribeDBClusterParameters</code>
     * operation to verify that your DB cluster parameter group has been created or modified.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterParameterGroupMessage.Builder} to
     *        create a request.
     * @return Result of the CreateDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbClusterParameterGroupResponse createDBClusterParameterGroup(
            Consumer<CreateDbClusterParameterGroupRequest.Builder> createDbClusterParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {
        return createDBClusterParameterGroup(CreateDbClusterParameterGroupRequest.builder()
                .applyMutation(createDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     * @return Result of the CreateDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbClusterSnapshotResponse createDBClusterSnapshot(CreateDbClusterSnapshotRequest createDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the CreateDBClusterSnapshot operation returned by the service.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbClusterSnapshotResponse createDBClusterSnapshot(
            Consumer<CreateDbClusterSnapshotRequest.Builder> createDbClusterSnapshotRequest)
            throws DbClusterSnapshotAlreadyExistsException, InvalidDbClusterStateException, DbClusterNotFoundException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            RdsException {
        return createDBClusterSnapshot(CreateDbClusterSnapshotRequest.builder().applyMutation(createDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <p>
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora
     * DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     * </p>
     * <p>
     * For more information about creating an RDS DB instance, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS
     * DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a DB instance in an Aurora DB cluster, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an
     * Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createDbInstanceRequest
     * @return Result of the CreateDBInstance operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbInstanceResponse createDBInstance(CreateDbInstanceRequest createDbInstanceRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, DbClusterNotFoundException, StorageTypeNotSupportedException,
            AuthorizationNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException,
            NetworkTypeNotSupportedException, CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB instance.
     * </p>
     * <p>
     * The new DB instance can be an RDS DB instance, or it can be a DB instance in an Aurora DB cluster. For an Aurora
     * DB cluster, you can call this operation multiple times to add more than one DB instance to the cluster.
     * </p>
     * <p>
     * For more information about creating an RDS DB instance, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_CreateDBInstance.html"> Creating an Amazon RDS
     * DB instance</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about creating a DB instance in an Aurora DB cluster, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.CreateInstance.html"> Creating an
     * Amazon Aurora DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbInstanceRequest#builder()}
     * </p>
     *
     * @param createDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBInstanceMessage.Builder} to create a request.
     * @return Result of the CreateDBInstance operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbInstanceResponse createDBInstance(Consumer<CreateDbInstanceRequest.Builder> createDbInstanceRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidDbClusterStateException,
            InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, DbClusterNotFoundException, StorageTypeNotSupportedException,
            AuthorizationNotFoundException, KmsKeyNotAccessibleException, DomainNotFoundException,
            NetworkTypeNotSupportedException, CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return createDBInstance(CreateDbInstanceRequest.builder().applyMutation(createDbInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster.
     * You can create a read replica for a DB instance running MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server. You
     * can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a>
     * and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica"
     * >Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User
     * Guide</i>.
     * </p>
     * <p>
     * Amazon Aurora doesn't support this operation. Call the <code>CreateDBInstance</code> operation to create a DB
     * instance for an Aurora DB cluster.
     * </p>
     * <p>
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security
     * groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     * </p>
     * <important>
     * <p>
     * Your source DB instance or cluster must have backup retention enabled.
     * </p>
     * </important>
     *
     * @param createDbInstanceReadReplicaRequest
     * @return Result of the CreateDBInstanceReadReplica operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbSubnetGroupNotAllowedException
     *         The DBSubnetGroup shouldn't be specified while creating read replicas that lie in the same region as the
     *         source instance.
     * @throws InvalidDbSubnetGroupException
     *         The DBSubnetGroup doesn't belong to the same VPC as that of an existing cross-region read replica of the
     *         same source instance.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBInstanceReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbInstanceReadReplicaResponse createDBInstanceReadReplica(
            CreateDbInstanceReadReplicaRequest createDbInstanceReadReplicaRequest) throws DbInstanceAlreadyExistsException,
            InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException, DbSecurityGroupNotFoundException,
            InstanceQuotaExceededException, StorageQuotaExceededException, DbInstanceNotFoundException,
            DbClusterNotFoundException, InvalidDbInstanceStateException, InvalidDbClusterStateException,
            DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException,
            InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException,
            DbSubnetGroupNotAllowedException, InvalidDbSubnetGroupException, StorageTypeNotSupportedException,
            KmsKeyNotAccessibleException, DomainNotFoundException, NetworkTypeNotSupportedException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB instance that acts as a read replica for an existing source DB instance or Multi-AZ DB cluster.
     * You can create a read replica for a DB instance running MySQL, MariaDB, Oracle, PostgreSQL, or SQL Server. You
     * can create a read replica for a Multi-AZ DB cluster running MySQL or PostgreSQL. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReadRepl.html">Working with read replicas</a>
     * and <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html#multi-az-db-clusters-migrating-to-instance-with-read-replica"
     * >Migrating from a Multi-AZ DB cluster to a DB instance using a read replica</a> in the <i>Amazon RDS User
     * Guide</i>.
     * </p>
     * <p>
     * Amazon Aurora doesn't support this operation. Call the <code>CreateDBInstance</code> operation to create a DB
     * instance for an Aurora DB cluster.
     * </p>
     * <p>
     * All read replica DB instances are created with backups disabled. All other attributes (including DB security
     * groups and DB parameter groups) are inherited from the source DB instance or cluster, except as specified.
     * </p>
     * <important>
     * <p>
     * Your source DB instance or cluster must have backup retention enabled.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbInstanceReadReplicaRequest.Builder}
     * avoiding the need to create one manually via {@link CreateDbInstanceReadReplicaRequest#builder()}
     * </p>
     *
     * @param createDbInstanceReadReplicaRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBInstanceReadReplicaMessage.Builder} to create
     *        a request.
     * @return Result of the CreateDBInstanceReadReplica operation returned by the service.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws InstanceQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB instances.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbSubnetGroupNotAllowedException
     *         The DBSubnetGroup shouldn't be specified while creating read replicas that lie in the same region as the
     *         source instance.
     * @throws InvalidDbSubnetGroupException
     *         The DBSubnetGroup doesn't belong to the same VPC as that of an existing cross-region read replica of the
     *         same source instance.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBInstanceReadReplica
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBInstanceReadReplica"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDbInstanceReadReplicaResponse createDBInstanceReadReplica(
            Consumer<CreateDbInstanceReadReplicaRequest.Builder> createDbInstanceReadReplicaRequest)
            throws DbInstanceAlreadyExistsException, InsufficientDbInstanceCapacityException, DbParameterGroupNotFoundException,
            DbSecurityGroupNotFoundException, InstanceQuotaExceededException, StorageQuotaExceededException,
            DbInstanceNotFoundException, DbClusterNotFoundException, InvalidDbInstanceStateException,
            InvalidDbClusterStateException, DbSubnetGroupNotFoundException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidSubnetException, InvalidVpcNetworkStateException, ProvisionedIopsNotAvailableInAzException,
            OptionGroupNotFoundException, DbSubnetGroupNotAllowedException, InvalidDbSubnetGroupException,
            StorageTypeNotSupportedException, KmsKeyNotAccessibleException, DomainNotFoundException,
            NetworkTypeNotSupportedException, AwsServiceException, SdkClientException, RdsException {
        return createDBInstanceReadReplica(CreateDbInstanceReadReplicaRequest.builder()
                .applyMutation(createDbInstanceReadReplicaRequest).build());
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to associate it with your
     * DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB
     * instance, you need to reboot the DB instance without failover for the new DB parameter group and associated
     * settings to take effect.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param createDbParameterGroupRequest
     * @return Result of the CreateDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbParameterGroupResponse createDBParameterGroup(CreateDbParameterGroupRequest createDbParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB parameter group.
     * </p>
     * <p>
     * A DB parameter group is initially created with the default parameters for the database engine used by the DB
     * instance. To provide custom values for any of the parameters, you must modify the group after creating it using
     * <code>ModifyDBParameterGroup</code>. Once you've created a DB parameter group, you need to associate it with your
     * DB instance using <code>ModifyDBInstance</code>. When you associate a new DB parameter group with a running DB
     * instance, you need to reboot the DB instance without failover for the new DB parameter group and associated
     * settings to take effect.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <important>
     * <p>
     * After you create a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * create action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param createDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return Result of the CreateDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB parameter groups.
     * @throws DbParameterGroupAlreadyExistsException
     *         A DB parameter group with the same name exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDbParameterGroupResponse createDBParameterGroup(
            Consumer<CreateDbParameterGroupRequest.Builder> createDbParameterGroupRequest)
            throws DbParameterGroupQuotaExceededException, DbParameterGroupAlreadyExistsException, AwsServiceException,
            SdkClientException, RdsException {
        return createDBParameterGroup(CreateDbParameterGroupRequest.builder().applyMutation(createDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new DB proxy.
     * </p>
     *
     * @param createDbProxyRequest
     * @return Result of the CreateDBProxy operation returned by the service.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbProxyAlreadyExistsException
     *         The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyQuotaExceededException
     *         Your Amazon Web Services account already has the maximum number of proxies in the specified Amazon Web
     *         Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbProxyResponse createDBProxy(CreateDbProxyRequest createDbProxyRequest) throws InvalidSubnetException,
            DbProxyAlreadyExistsException, DbProxyQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbProxyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDbProxyRequest#builder()}
     * </p>
     *
     * @param createDbProxyRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBProxyRequest.Builder} to create a request.
     * @return Result of the CreateDBProxy operation returned by the service.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbProxyAlreadyExistsException
     *         The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyQuotaExceededException
     *         Your Amazon Web Services account already has the maximum number of proxies in the specified Amazon Web
     *         Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbProxyResponse createDBProxy(Consumer<CreateDbProxyRequest.Builder> createDbProxyRequest)
            throws InvalidSubnetException, DbProxyAlreadyExistsException, DbProxyQuotaExceededException, AwsServiceException,
            SdkClientException, RdsException {
        return createDBProxy(CreateDbProxyRequest.builder().applyMutation(createDbProxyRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You
     * can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy
     * endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     * </p>
     *
     * @param createDbProxyEndpointRequest
     * @return Result of the CreateDBProxyEndpoint operation returned by the service.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointAlreadyExistsException
     *         The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyEndpointQuotaExceededException
     *         The DB proxy already has the maximum number of endpoints.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbProxyEndpointResponse createDBProxyEndpoint(CreateDbProxyEndpointRequest createDbProxyEndpointRequest)
            throws InvalidSubnetException, DbProxyNotFoundException, DbProxyEndpointAlreadyExistsException,
            DbProxyEndpointQuotaExceededException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DBProxyEndpoint</code>. Only applies to proxies that are associated with Aurora DB clusters. You
     * can use DB proxy endpoints to specify read/write or read-only access to the DB cluster. You can also use DB proxy
     * endpoints to access a DB proxy through a different VPC than the proxy's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbProxyEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbProxyEndpointRequest#builder()}
     * </p>
     *
     * @param createDbProxyEndpointRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBProxyEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDBProxyEndpoint operation returned by the service.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointAlreadyExistsException
     *         The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyEndpointQuotaExceededException
     *         The DB proxy already has the maximum number of endpoints.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbProxyEndpointResponse createDBProxyEndpoint(
            Consumer<CreateDbProxyEndpointRequest.Builder> createDbProxyEndpointRequest) throws InvalidSubnetException,
            DbProxyNotFoundException, DbProxyEndpointAlreadyExistsException, DbProxyEndpointQuotaExceededException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        return createDBProxyEndpoint(CreateDbProxyEndpointRequest.builder().applyMutation(createDbProxyEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a new DB security group. DB security groups control access to a DB instance.
     * </p>
     * <p>
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param createDbSecurityGroupRequest
     * @return Result of the CreateDBSecurityGroup operation returned by the service.
     * @throws DbSecurityGroupAlreadyExistsException
     *         A DB security group with the name specified in <code>DBSecurityGroupName</code> already exists.
     * @throws DbSecurityGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB security groups.
     * @throws DbSecurityGroupNotSupportedException
     *         A DB security group isn't allowed for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSecurityGroupResponse createDBSecurityGroup(CreateDbSecurityGroupRequest createDbSecurityGroupRequest)
            throws DbSecurityGroupAlreadyExistsException, DbSecurityGroupQuotaExceededException,
            DbSecurityGroupNotSupportedException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB security group. DB security groups control access to a DB instance.
     * </p>
     * <p>
     * A DB security group controls access to EC2-Classic DB instances that are not in a VPC.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSecurityGroupRequest#builder()}
     * </p>
     *
     * @param createDbSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBSecurityGroupMessage.Builder} to create a
     *        request.
     * @return Result of the CreateDBSecurityGroup operation returned by the service.
     * @throws DbSecurityGroupAlreadyExistsException
     *         A DB security group with the name specified in <code>DBSecurityGroupName</code> already exists.
     * @throws DbSecurityGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB security groups.
     * @throws DbSecurityGroupNotSupportedException
     *         A DB security group isn't allowed for this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSecurityGroupResponse createDBSecurityGroup(
            Consumer<CreateDbSecurityGroupRequest.Builder> createDbSecurityGroupRequest)
            throws DbSecurityGroupAlreadyExistsException, DbSecurityGroupQuotaExceededException,
            DbSecurityGroupNotSupportedException, AwsServiceException, SdkClientException, RdsException {
        return createDBSecurityGroup(CreateDbSecurityGroupRequest.builder().applyMutation(createDbSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
     * <code>storage-optimization</code> state.
     * </p>
     *
     * @param createDbSnapshotRequest
     * @return Result of the CreateDBSnapshot operation returned by the service.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSnapshotResponse createDBSnapshot(CreateDbSnapshotRequest createDbSnapshotRequest)
            throws DbSnapshotAlreadyExistsException, InvalidDbInstanceStateException, DbInstanceNotFoundException,
            SnapshotQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of a DB instance. The source DB instance must be in the <code>available</code> or
     * <code>storage-optimization</code> state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDbSnapshotRequest#builder()}
     * </p>
     *
     * @param createDbSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBSnapshotMessage.Builder} to create a request.
     * @return Result of the CreateDBSnapshot operation returned by the service.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSnapshotResponse createDBSnapshot(Consumer<CreateDbSnapshotRequest.Builder> createDbSnapshotRequest)
            throws DbSnapshotAlreadyExistsException, InvalidDbInstanceStateException, DbInstanceNotFoundException,
            SnapshotQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        return createDBSnapshot(CreateDbSnapshotRequest.builder().applyMutation(createDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Web Services Region.
     * </p>
     *
     * @param createDbSubnetGroupRequest
     * @return Result of the CreateDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupAlreadyExistsException
     *         <code>DBSubnetGroupName</code> is already used by an existing DB subnet group.
     * @throws DbSubnetGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB subnet groups.
     * @throws DbSubnetQuotaExceededException
     *         The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSubnetGroupResponse createDBSubnetGroup(CreateDbSubnetGroupRequest createDbSubnetGroupRequest)
            throws DbSubnetGroupAlreadyExistsException, DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in the
     * Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param createDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateDBSubnetGroupMessage.Builder} to create a
     *        request.
     * @return Result of the CreateDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupAlreadyExistsException
     *         <code>DBSubnetGroupName</code> is already used by an existing DB subnet group.
     * @throws DbSubnetGroupQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB subnet groups.
     * @throws DbSubnetQuotaExceededException
     *         The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDbSubnetGroupResponse createDBSubnetGroup(
            Consumer<CreateDbSubnetGroupRequest.Builder> createDbSubnetGroupRequest) throws DbSubnetGroupAlreadyExistsException,
            DbSubnetGroupQuotaExceededException, DbSubnetQuotaExceededException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidSubnetException, AwsServiceException, SdkClientException, RdsException {
        return createDBSubnetGroup(CreateDbSubnetGroupRequest.builder().applyMutation(createDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN)
     * created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a
     * topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list
     * of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories
     * (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify
     * <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>,
     * <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.
     * </p>
     * <p>
     * If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> =
     * <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the
     * <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not
     * specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources.
     * If you don't specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated
     * from all RDS sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about subscribing to an event for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon
     * RDS event notification</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about subscribing to an event for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to
     * Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param createEventSubscriptionRequest
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have reached the maximum number of event subscriptions.
     * @throws SubscriptionAlreadyExistException
     *         The supplied subscription name already exists.
     * @throws SnsInvalidTopicException
     *         SNS has responded that there is a problem with the SNS topic specified.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the SNS topic ARN.
     * @throws SnsTopicArnNotFoundException
     *         The SNS topic ARN does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The supplied category does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an RDS event notification subscription. This operation requires a topic Amazon Resource Name (ARN)
     * created by either the RDS console, the SNS console, or the SNS API. To obtain an ARN with SNS, you must create a
     * topic in Amazon SNS and subscribe to the topic. The ARN is displayed in the SNS console.
     * </p>
     * <p>
     * You can specify the type of source (<code>SourceType</code>) that you want to be notified of and provide a list
     * of RDS sources (<code>SourceIds</code>) that triggers the events. You can also provide a list of event categories
     * (<code>EventCategories</code>) for events that you want to be notified of. For example, you can specify
     * <code>SourceType</code> = <code>db-instance</code>, <code>SourceIds</code> = <code>mydbinstance1</code>,
     * <code>mydbinstance2</code> and <code>EventCategories</code> = <code>Availability</code>, <code>Backup</code>.
     * </p>
     * <p>
     * If you specify both the <code>SourceType</code> and <code>SourceIds</code>, such as <code>SourceType</code> =
     * <code>db-instance</code> and <code>SourceIds</code> = <code>myDBInstance1</code>, you are notified of all the
     * <code>db-instance</code> events for the specified source. If you specify a <code>SourceType</code> but do not
     * specify <code>SourceIds</code>, you receive notice of the events for that source type for all your RDS sources.
     * If you don't specify either the SourceType or the <code>SourceIds</code>, you are notified of events generated
     * from all RDS sources belonging to your customer account.
     * </p>
     * <p>
     * For more information about subscribing to an event for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Subscribing.html"> Subscribing to Amazon
     * RDS event notification</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about subscribing to an event for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Subscribing.html"> Subscribing to
     * Amazon RDS event notification</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param createEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the CreateEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have reached the maximum number of event subscriptions.
     * @throws SubscriptionAlreadyExistException
     *         The supplied subscription name already exists.
     * @throws SnsInvalidTopicException
     *         SNS has responded that there is a problem with the SNS topic specified.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the SNS topic ARN.
     * @throws SnsTopicArnNotFoundException
     *         The SNS topic ARN does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The supplied category does not exist.
     * @throws SourceNotFoundException
     *         The requested source could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEventSubscriptionResponse createEventSubscription(
            Consumer<CreateEventSubscriptionRequest.Builder> createEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionAlreadyExistException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            SourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return createEventSubscription(CreateEventSubscriptionRequest.builder().applyMutation(createEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster
     * to it. Or you can specify an existing Aurora cluster during the create operation, and this cluster becomes the
     * primary cluster of the global database.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param createGlobalClusterRequest
     * @return Result of the CreateGlobalCluster operation returned by the service.
     * @throws GlobalClusterAlreadyExistsException
     *         The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique
     *         name) to create a new global database cluster.
     * @throws GlobalClusterQuotaExceededException
     *         The number of global database clusters for this account is already at the maximum allowed.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGlobalClusterResponse createGlobalCluster(CreateGlobalClusterRequest createGlobalClusterRequest)
            throws GlobalClusterAlreadyExistsException, GlobalClusterQuotaExceededException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Aurora global database spread across multiple Amazon Web Services Regions. The global database
     * contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives
     * data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
     * </p>
     * <p>
     * You can create a global database that is initially empty, and then add a primary cluster and a secondary cluster
     * to it. Or you can specify an existing Aurora cluster during the create operation, and this cluster becomes the
     * primary cluster of the global database.
     * </p>
     * <note>
     * <p>
     * This action applies only to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalClusterRequest#builder()}
     * </p>
     *
     * @param createGlobalClusterRequest
     *        A {@link Consumer} that will call methods on {@link CreateGlobalClusterMessage.Builder} to create a
     *        request.
     * @return Result of the CreateGlobalCluster operation returned by the service.
     * @throws GlobalClusterAlreadyExistsException
     *         The <code>GlobalClusterIdentifier</code> already exists. Choose a new global database identifier (unique
     *         name) to create a new global database cluster.
     * @throws GlobalClusterQuotaExceededException
     *         The number of global database clusters for this account is already at the maximum allowed.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGlobalClusterResponse createGlobalCluster(
            Consumer<CreateGlobalClusterRequest.Builder> createGlobalClusterRequest) throws GlobalClusterAlreadyExistsException,
            GlobalClusterQuotaExceededException, InvalidDbClusterStateException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return createGlobalCluster(CreateGlobalClusterRequest.builder().applyMutation(createGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Creates a new option group. You can create up to 20 option groups.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param createOptionGroupRequest
     * @return Result of the CreateOptionGroup operation returned by the service.
     * @throws OptionGroupAlreadyExistsException
     *         The option group you are trying to create already exists.
     * @throws OptionGroupQuotaExceededException
     *         The quota of 20 option groups was exceeded for this Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOptionGroupResponse createOptionGroup(CreateOptionGroupRequest createOptionGroupRequest)
            throws OptionGroupAlreadyExistsException, OptionGroupQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new option group. You can create up to 20 option groups.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOptionGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOptionGroupRequest#builder()}
     * </p>
     *
     * @param createOptionGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateOptionGroupMessage.Builder} to create a request.
     * @return Result of the CreateOptionGroup operation returned by the service.
     * @throws OptionGroupAlreadyExistsException
     *         The option group you are trying to create already exists.
     * @throws OptionGroupQuotaExceededException
     *         The quota of 20 option groups was exceeded for this Amazon Web Services account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.CreateOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/CreateOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOptionGroupResponse createOptionGroup(Consumer<CreateOptionGroupRequest.Builder> createOptionGroupRequest)
            throws OptionGroupAlreadyExistsException, OptionGroupQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {
        return createOptionGroup(CreateOptionGroupRequest.builder().applyMutation(createOptionGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a blue/green deployment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param deleteBlueGreenDeploymentRequest
     * @return Result of the DeleteBlueGreenDeployment operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws InvalidBlueGreenDeploymentStateException
     *         The blue/green deployment can't be switched over or deleted because there is an invalid configuration in
     *         the green environment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBlueGreenDeploymentResponse deleteBlueGreenDeployment(
            DeleteBlueGreenDeploymentRequest deleteBlueGreenDeploymentRequest) throws BlueGreenDeploymentNotFoundException,
            InvalidBlueGreenDeploymentStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a blue/green deployment.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBlueGreenDeploymentRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteBlueGreenDeploymentRequest#builder()}
     * </p>
     *
     * @param deleteBlueGreenDeploymentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBlueGreenDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteBlueGreenDeployment operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws InvalidBlueGreenDeploymentStateException
     *         The blue/green deployment can't be switched over or deleted because there is an invalid configuration in
     *         the green environment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteBlueGreenDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteBlueGreenDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteBlueGreenDeploymentResponse deleteBlueGreenDeployment(
            Consumer<DeleteBlueGreenDeploymentRequest.Builder> deleteBlueGreenDeploymentRequest)
            throws BlueGreenDeploymentNotFoundException, InvalidBlueGreenDeploymentStateException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteBlueGreenDeployment(DeleteBlueGreenDeploymentRequest.builder()
                .applyMutation(deleteBlueGreenDeploymentRequest).build());
    }

    /**
     * <p>
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup
     * of your RDS Custom instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Typically, deletion takes a few minutes.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>DeleteCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a
     * CEV</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteCustomDbEngineVersionRequest
     * @return Result of the DeleteCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionNotFoundException
     *         The specified CEV was not found.
     * @throws InvalidCustomDbEngineVersionStateException
     *         You can't delete the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomDbEngineVersionResponse deleteCustomDBEngineVersion(
            DeleteCustomDbEngineVersionRequest deleteCustomDbEngineVersionRequest) throws CustomDbEngineVersionNotFoundException,
            InvalidCustomDbEngineVersionStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom engine version. To run this command, make sure you meet the following prerequisites:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The CEV must not be the default for RDS Custom. If it is, change the default before running this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * The CEV must not be associated with an RDS Custom DB instance, RDS Custom instance snapshot, or automated backup
     * of your RDS Custom instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Typically, deletion takes a few minutes.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>DeleteCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>DeleteCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.delete">Deleting a
     * CEV</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomDbEngineVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCustomDbEngineVersionRequest#builder()}
     * </p>
     *
     * @param deleteCustomDbEngineVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCustomDBEngineVersionMessage.Builder} to create
     *        a request.
     * @return Result of the DeleteCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionNotFoundException
     *         The specified CEV was not found.
     * @throws InvalidCustomDbEngineVersionStateException
     *         You can't delete the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCustomDbEngineVersionResponse deleteCustomDBEngineVersion(
            Consumer<DeleteCustomDbEngineVersionRequest.Builder> deleteCustomDbEngineVersionRequest)
            throws CustomDbEngineVersionNotFoundException, InvalidCustomDbEngineVersionStateException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteCustomDBEngineVersion(DeleteCustomDbEngineVersionRequest.builder()
                .applyMutation(deleteCustomDbEngineVersionRequest).build());
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas
     * are promoted to standalone instances.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterRequest
     * @return Result of the DeleteDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbClusterResponse deleteDBCluster(DeleteDbClusterRequest deleteDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a DB cluster, all
     * automated backups for that DB cluster are deleted and can't be recovered. Manual DB cluster snapshots of the
     * specified DB cluster are not deleted.
     * </p>
     * <p>
     * If you're deleting a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read replicas
     * are promoted to standalone instances.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbClusterRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterMessage.Builder} to create a request.
     * @return Result of the DeleteDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterSnapshotAlreadyExistsException
     *         The user already has a DB cluster snapshot with the given identifier.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbClusterResponse deleteDBCluster(Consumer<DeleteDbClusterRequest.Builder> deleteDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, DbClusterSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterSnapshotStateException, AwsServiceException, SdkClientException,
            RdsException {
        return deleteDBCluster(DeleteDbClusterRequest.builder().applyMutation(deleteDbClusterRequest).build());
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteDbClusterEndpointRequest
     * @return Result of the DeleteDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation can't be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbClusterEndpointResponse deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest deleteDbClusterEndpointRequest)
            throws InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterEndpointMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation can't be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbClusterEndpointResponse deleteDBClusterEndpoint(
            Consumer<DeleteDbClusterEndpointRequest.Builder> deleteDbClusterEndpointRequest)
            throws InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException, InvalidDbClusterStateException,
            AwsServiceException, SdkClientException, RdsException {
        return deleteDBClusterEndpoint(DeleteDbClusterEndpointRequest.builder().applyMutation(deleteDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     * @return Result of the DeleteDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(
            DeleteDbClusterParameterGroupRequest deleteDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DB cluster parameter group. The DB cluster parameter group to be deleted can't be associated
     * with any DB clusters.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterParameterGroupMessage.Builder} to
     *        create a request.
     * @return Result of the DeleteDBClusterParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbClusterParameterGroupResponse deleteDBClusterParameterGroup(
            Consumer<DeleteDbClusterParameterGroupRequest.Builder> deleteDbClusterParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteDBClusterParameterGroup(DeleteDbClusterParameterGroupRequest.builder()
                .applyMutation(deleteDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     * @return Result of the DeleteDBClusterSnapshot operation returned by the service.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest deleteDbClusterSnapshotRequest)
            throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB cluster snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbClusterSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDbClusterSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbClusterSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBClusterSnapshotMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteDBClusterSnapshot operation returned by the service.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBClusterSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBClusterSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbClusterSnapshotResponse deleteDBClusterSnapshot(
            Consumer<DeleteDbClusterSnapshotRequest.Builder> deleteDbClusterSnapshotRequest)
            throws InvalidDbClusterSnapshotStateException, DbClusterSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteDBClusterSnapshot(DeleteDbClusterSnapshotRequest.builder().applyMutation(deleteDbClusterSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon RDS DB instance is <code>deleting</code> until the DB
     * snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip
     * creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.
     * </p>
     * <p>
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of
     * the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first call the <code>PromoteReadReplicaDBCluster</code> API action to
     * promote the DB cluster so it's no longer a read replica. After the promotion completes, then call the
     * <code>DeleteDBInstance</code> API action to delete the final instance in the DB cluster.
     * </p>
     *
     * @param deleteDbInstanceRequest
     * @return Result of the DeleteDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbInstanceAutomatedBackupQuotaExceededException
     *         The quota for retained automated backups was exceeded. This prevents you from retaining any additional
     *         automated backups. The retained automated backups quota is the same as your DB Instance quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbInstanceResponse deleteDBInstance(DeleteDbInstanceRequest deleteDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterStateException, DbInstanceAutomatedBackupQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The DeleteDBInstance action deletes a previously provisioned DB instance. When you delete a DB instance, all
     * automated backups for that instance are deleted and can't be recovered. Manual DB snapshots of the DB instance to
     * be deleted by <code>DeleteDBInstance</code> are not deleted.
     * </p>
     * <p>
     * If you request a final DB snapshot the status of the Amazon RDS DB instance is <code>deleting</code> until the DB
     * snapshot is created. The API action <code>DescribeDBInstance</code> is used to monitor the status of this
     * operation. The action can't be canceled or reverted once submitted.
     * </p>
     * <p>
     * When a DB instance is in a failure state and has a status of <code>failed</code>,
     * <code>incompatible-restore</code>, or <code>incompatible-network</code>, you can only delete it when you skip
     * creation of the final snapshot with the <code>SkipFinalSnapshot</code> parameter.
     * </p>
     * <p>
     * If the specified DB instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both of
     * the following conditions are true:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The DB cluster is a read replica of another Amazon Aurora DB cluster.
     * </p>
     * </li>
     * <li>
     * <p>
     * The DB instance is the only instance in the DB cluster.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a DB instance in this case, first call the <code>PromoteReadReplicaDBCluster</code> API action to
     * promote the DB cluster so it's no longer a read replica. After the promotion completes, then call the
     * <code>DeleteDBInstance</code> API action to delete the final instance in the DB cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbInstanceRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBInstanceMessage.Builder} to create a request.
     * @return Result of the DeleteDBInstance operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbSnapshotAlreadyExistsException
     *         <code>DBSnapshotIdentifier</code> is already used by an existing snapshot.
     * @throws SnapshotQuotaExceededException
     *         The request would result in the user exceeding the allowed number of DB snapshots.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbInstanceAutomatedBackupQuotaExceededException
     *         The quota for retained automated backups was exceeded. This prevents you from retaining any additional
     *         automated backups. The retained automated backups quota is the same as your DB Instance quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbInstanceResponse deleteDBInstance(Consumer<DeleteDbInstanceRequest.Builder> deleteDbInstanceRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, DbSnapshotAlreadyExistsException,
            SnapshotQuotaExceededException, InvalidDbClusterStateException, DbInstanceAutomatedBackupQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {
        return deleteDBInstance(DeleteDbInstanceRequest.builder().applyMutation(deleteDbInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     *
     * @param deleteDbInstanceAutomatedBackupRequest
     *        Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
     * @return Result of the DeleteDBInstanceAutomatedBackup operation returned by the service.
     * @throws InvalidDbInstanceAutomatedBackupStateException
     *         The automated backup is in an invalid state. For example, this automated backup is associated with an
     *         active instance.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBInstanceAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbInstanceAutomatedBackupResponse deleteDBInstanceAutomatedBackup(
            DeleteDbInstanceAutomatedBackupRequest deleteDbInstanceAutomatedBackupRequest)
            throws InvalidDbInstanceAutomatedBackupStateException, DbInstanceAutomatedBackupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes automated backups using the <code>DbiResourceId</code> value of the source DB instance or the Amazon
     * Resource Name (ARN) of the automated backups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbInstanceAutomatedBackupRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteDbInstanceAutomatedBackupRequest#builder()}
     * </p>
     *
     * @param deleteDbInstanceAutomatedBackupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBInstanceAutomatedBackupMessage.Builder} to
     *        create a request. Parameter input for the <code>DeleteDBInstanceAutomatedBackup</code> operation.
     * @return Result of the DeleteDBInstanceAutomatedBackup operation returned by the service.
     * @throws InvalidDbInstanceAutomatedBackupStateException
     *         The automated backup is in an invalid state. For example, this automated backup is associated with an
     *         active instance.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBInstanceAutomatedBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBInstanceAutomatedBackup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDbInstanceAutomatedBackupResponse deleteDBInstanceAutomatedBackup(
            Consumer<DeleteDbInstanceAutomatedBackupRequest.Builder> deleteDbInstanceAutomatedBackupRequest)
            throws InvalidDbInstanceAutomatedBackupStateException, DbInstanceAutomatedBackupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return deleteDBInstanceAutomatedBackup(DeleteDbInstanceAutomatedBackupRequest.builder()
                .applyMutation(deleteDbInstanceAutomatedBackupRequest).build());
    }

    /**
     * <p>
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
     * instances.
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     * @return Result of the DeleteDBParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbParameterGroupResponse deleteDBParameterGroup(DeleteDbParameterGroupRequest deleteDbParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified DB parameter group. The DB parameter group to be deleted can't be associated with any DB
     * instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteDBParameterGroup operation returned by the service.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteDbParameterGroupResponse deleteDBParameterGroup(
            Consumer<DeleteDbParameterGroupRequest.Builder> deleteDbParameterGroupRequest)
            throws InvalidDbParameterGroupStateException, DbParameterGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteDBParameterGroup(DeleteDbParameterGroupRequest.builder().applyMutation(deleteDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an existing DB proxy.
     * </p>
     *
     * @param deleteDbProxyRequest
     * @return Result of the DeleteDBProxy operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbProxyResponse deleteDBProxy(DeleteDbProxyRequest deleteDbProxyRequest) throws DbProxyNotFoundException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing DB proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbProxyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDbProxyRequest#builder()}
     * </p>
     *
     * @param deleteDbProxyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBProxyRequest.Builder} to create a request.
     * @return Result of the DeleteDBProxy operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbProxyResponse deleteDBProxy(Consumer<DeleteDbProxyRequest.Builder> deleteDbProxyRequest)
            throws DbProxyNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        return deleteDBProxy(DeleteDbProxyRequest.builder().applyMutation(deleteDbProxyRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint
     * that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only
     * operations, or using a different VPC than the DB proxy's default VPC.
     * </p>
     *
     * @param deleteDbProxyEndpointRequest
     * @return Result of the DeleteDBProxyEndpoint operation returned by the service.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws InvalidDbProxyEndpointStateException
     *         You can't perform this operation while the DB proxy endpoint is in a particular state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbProxyEndpointResponse deleteDBProxyEndpoint(DeleteDbProxyEndpointRequest deleteDbProxyEndpointRequest)
            throws DbProxyEndpointNotFoundException, InvalidDbProxyEndpointStateException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>DBProxyEndpoint</code>. Doing so removes the ability to access the DB proxy using the endpoint
     * that you defined. The endpoint that you delete might have provided capabilities such as read/write or read-only
     * operations, or using a different VPC than the DB proxy's default VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbProxyEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbProxyEndpointRequest#builder()}
     * </p>
     *
     * @param deleteDbProxyEndpointRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBProxyEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDBProxyEndpoint operation returned by the service.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws InvalidDbProxyEndpointStateException
     *         You can't perform this operation while the DB proxy endpoint is in a particular state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbProxyEndpointResponse deleteDBProxyEndpoint(
            Consumer<DeleteDbProxyEndpointRequest.Builder> deleteDbProxyEndpointRequest) throws DbProxyEndpointNotFoundException,
            InvalidDbProxyEndpointStateException, AwsServiceException, SdkClientException, RdsException {
        return deleteDBProxyEndpoint(DeleteDbProxyEndpointRequest.builder().applyMutation(deleteDbProxyEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a DB security group.
     * </p>
     * <p>
     * The specified DB security group must not be associated with any DB instances.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param deleteDbSecurityGroupRequest
     * @return Result of the DeleteDBSecurityGroup operation returned by the service.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSecurityGroupResponse deleteDBSecurityGroup(DeleteDbSecurityGroupRequest deleteDbSecurityGroupRequest)
            throws InvalidDbSecurityGroupStateException, DbSecurityGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB security group.
     * </p>
     * <p>
     * The specified DB security group must not be associated with any DB instances.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSecurityGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSecurityGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSecurityGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBSecurityGroupMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteDBSecurityGroup operation returned by the service.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSecurityGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSecurityGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSecurityGroupResponse deleteDBSecurityGroup(
            Consumer<DeleteDbSecurityGroupRequest.Builder> deleteDbSecurityGroupRequest)
            throws InvalidDbSecurityGroupStateException, DbSecurityGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteDBSecurityGroup(DeleteDbSecurityGroupRequest.builder().applyMutation(deleteDbSecurityGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note>
     *
     * @param deleteDbSnapshotRequest
     * @return Result of the DeleteDBSnapshot operation returned by the service.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSnapshotResponse deleteDBSnapshot(DeleteDbSnapshotRequest deleteDbSnapshotRequest)
            throws InvalidDbSnapshotStateException, DbSnapshotNotFoundException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
     * </p>
     * <note>
     * <p>
     * The DB snapshot must be in the <code>available</code> state to be deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDbSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteDbSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBSnapshotMessage.Builder} to create a request.
     * @return Result of the DeleteDBSnapshot operation returned by the service.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSnapshotResponse deleteDBSnapshot(Consumer<DeleteDbSnapshotRequest.Builder> deleteDbSnapshotRequest)
            throws InvalidDbSnapshotStateException, DbSnapshotNotFoundException, AwsServiceException, SdkClientException,
            RdsException {
        return deleteDBSnapshot(DeleteDbSnapshotRequest.builder().applyMutation(deleteDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note>
     *
     * @param deleteDbSubnetGroupRequest
     * @return Result of the DeleteDBSubnetGroup operation returned by the service.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidDbSubnetStateException
     *         The DB subnet isn't in the <i>available</i> state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSubnetGroupResponse deleteDBSubnetGroup(DeleteDbSubnetGroupRequest deleteDbSubnetGroupRequest)
            throws InvalidDbSubnetGroupStateException, InvalidDbSubnetStateException, DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DB subnet group.
     * </p>
     * <note>
     * <p>
     * The specified database subnet group must not be associated with any DB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param deleteDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDBSubnetGroupMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteDBSubnetGroup operation returned by the service.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidDbSubnetStateException
     *         The DB subnet isn't in the <i>available</i> state.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDbSubnetGroupResponse deleteDBSubnetGroup(
            Consumer<DeleteDbSubnetGroupRequest.Builder> deleteDbSubnetGroupRequest) throws InvalidDbSubnetGroupStateException,
            InvalidDbSubnetStateException, DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return deleteDBSubnetGroup(DeleteDbSubnetGroupRequest.builder().applyMutation(deleteDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an RDS event notification subscription.
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws InvalidEventSubscriptionStateException
     *         This error can occur if someone else is modifying a subscription. You should retry the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest)
            throws SubscriptionNotFoundException, InvalidEventSubscriptionStateException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an RDS event notification subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventSubscriptionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteEventSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventSubscriptionMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteEventSubscription operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws InvalidEventSubscriptionStateException
     *         This error can occur if someone else is modifying a subscription. You should retry the action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEventSubscriptionResponse deleteEventSubscription(
            Consumer<DeleteEventSubscriptionRequest.Builder> deleteEventSubscriptionRequest)
            throws SubscriptionNotFoundException, InvalidEventSubscriptionStateException, AwsServiceException,
            SdkClientException, RdsException {
        return deleteEventSubscription(DeleteEventSubscriptionRequest.builder().applyMutation(deleteEventSubscriptionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed
     * first.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param deleteGlobalClusterRequest
     * @return Result of the DeleteGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGlobalClusterResponse deleteGlobalCluster(DeleteGlobalClusterRequest deleteGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a global database cluster. The primary and secondary clusters must already be detached or destroyed
     * first.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalClusterRequest#builder()}
     * </p>
     *
     * @param deleteGlobalClusterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGlobalClusterMessage.Builder} to create a
     *        request.
     * @return Result of the DeleteGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGlobalClusterResponse deleteGlobalCluster(
            Consumer<DeleteGlobalClusterRequest.Builder> deleteGlobalClusterRequest) throws GlobalClusterNotFoundException,
            InvalidGlobalClusterStateException, AwsServiceException, SdkClientException, RdsException {
        return deleteGlobalCluster(DeleteGlobalClusterRequest.builder().applyMutation(deleteGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Deletes an existing option group.
     * </p>
     *
     * @param deleteOptionGroupRequest
     * @return Result of the DeleteOptionGroup operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws InvalidOptionGroupStateException
     *         The option group isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOptionGroupResponse deleteOptionGroup(DeleteOptionGroupRequest deleteOptionGroupRequest)
            throws OptionGroupNotFoundException, InvalidOptionGroupStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing option group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOptionGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOptionGroupRequest#builder()}
     * </p>
     *
     * @param deleteOptionGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOptionGroupMessage.Builder} to create a request.
     * @return Result of the DeleteOptionGroup operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws InvalidOptionGroupStateException
     *         The option group isn't in the <i>available</i> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeleteOptionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeleteOptionGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOptionGroupResponse deleteOptionGroup(Consumer<DeleteOptionGroupRequest.Builder> deleteOptionGroupRequest)
            throws OptionGroupNotFoundException, InvalidOptionGroupStateException, AwsServiceException, SdkClientException,
            RdsException {
        return deleteOptionGroup(DeleteOptionGroupRequest.builder().applyMutation(deleteOptionGroupRequest).build());
    }

    /**
     * <p>
     * Remove the association between one or more <code>DBProxyTarget</code> data structures and a
     * <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param deregisterDbProxyTargetsRequest
     * @return Result of the DeregisterDBProxyTargets operation returned by the service.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeregisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterDbProxyTargetsResponse deregisterDBProxyTargets(
            DeregisterDbProxyTargetsRequest deregisterDbProxyTargetsRequest) throws DbProxyTargetNotFoundException,
            DbProxyTargetGroupNotFoundException, DbProxyNotFoundException, InvalidDbProxyStateException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove the association between one or more <code>DBProxyTarget</code> data structures and a
     * <code>DBProxyTargetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterDbProxyTargetsRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterDbProxyTargetsRequest#builder()}
     * </p>
     *
     * @param deregisterDbProxyTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterDBProxyTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterDBProxyTargets operation returned by the service.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DeregisterDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DeregisterDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterDbProxyTargetsResponse deregisterDBProxyTargets(
            Consumer<DeregisterDbProxyTargetsRequest.Builder> deregisterDbProxyTargetsRequest)
            throws DbProxyTargetNotFoundException, DbProxyTargetGroupNotFoundException, DbProxyNotFoundException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        return deregisterDBProxyTargets(DeregisterDbProxyTargetsRequest.builder().applyMutation(deregisterDbProxyTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     *
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeAccountAttributes
     * @see #describeAccountAttributes(DescribeAccountAttributesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes() throws AwsServiceException, SdkClientException,
            RdsException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     *
     * @param describeAccountAttributesRequest
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            DescribeAccountAttributesRequest describeAccountAttributesRequest) throws AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the attributes for a customer account. The attributes include Amazon RDS quotas for the account,
     * such as the number of DB instances allowed. The description for a quota includes the quota name, current usage
     * toward that quota, and the quota's maximum value.
     * </p>
     * <p>
     * This command doesn't take any parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAccountAttributesRequest#builder()}
     * </p>
     *
     * @param describeAccountAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAccountAttributesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeAccountAttributes operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeAccountAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeAccountAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAccountAttributesResponse describeAccountAttributes(
            Consumer<DescribeAccountAttributesRequest.Builder> describeAccountAttributesRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeAccountAttributes(DescribeAccountAttributesRequest.builder()
                .applyMutation(describeAccountAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     * @return Result of the DescribeBlueGreenDeployments operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBlueGreenDeploymentsResponse describeBlueGreenDeployments(
            DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) throws BlueGreenDeploymentNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBlueGreenDeploymentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBlueGreenDeploymentsRequest#builder()}
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBlueGreenDeploymentsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeBlueGreenDeployments operation returned by the service.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBlueGreenDeploymentsResponse describeBlueGreenDeployments(
            Consumer<DescribeBlueGreenDeploymentsRequest.Builder> describeBlueGreenDeploymentsRequest)
            throws BlueGreenDeploymentNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeBlueGreenDeployments(DescribeBlueGreenDeploymentsRequest.builder()
                .applyMutation(describeBlueGreenDeploymentsRequest).build());
    }

    /**
     * <p>
     * Returns information about blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable responses = client.describeBlueGreenDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable responses = client
     *             .describeBlueGreenDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable responses = client.describeBlueGreenDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBlueGreenDeploymentsIterable describeBlueGreenDeploymentsPaginator(
            DescribeBlueGreenDeploymentsRequest describeBlueGreenDeploymentsRequest) throws BlueGreenDeploymentNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about blue/green deployments.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html">Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/blue-green-deployments.html"> Using Amazon RDS
     * Blue/Green Deployments for database updates</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable responses = client.describeBlueGreenDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable responses = client
     *             .describeBlueGreenDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeBlueGreenDeploymentsIterable responses = client.describeBlueGreenDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeBlueGreenDeployments(software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBlueGreenDeploymentsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeBlueGreenDeploymentsRequest#builder()}
     * </p>
     *
     * @param describeBlueGreenDeploymentsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeBlueGreenDeploymentsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeBlueGreenDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeBlueGreenDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeBlueGreenDeploymentsIterable describeBlueGreenDeploymentsPaginator(
            Consumer<DescribeBlueGreenDeploymentsRequest.Builder> describeBlueGreenDeploymentsRequest)
            throws BlueGreenDeploymentNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeBlueGreenDeploymentsPaginator(DescribeBlueGreenDeploymentsRequest.builder()
                .applyMutation(describeBlueGreenDeploymentsRequest).build());
    }

    /**
     * <p>
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see #describeCertificates(DescribeCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates() throws CertificateNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeCertificates(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeCertificatesRequest
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(DescribeCertificatesRequest describeCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificatesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesResponse describeCertificates(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws CertificateNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeCertificates(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see #describeCertificatesPaginator(DescribeCertificatesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator() throws CertificateNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator(DescribeCertificatesRequest describeCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the set of CA certificates provided by Amazon RDS for this Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html">Using SSL/TLS to encrypt a
     * connection to a DB instance</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html"> Using SSL/TLS to
     * encrypt a connection to a DB cluster</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client
     *             .describeCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeCertificatesIterable responses = client.describeCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeCertificates(software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificatesRequest#builder()}
     * </p>
     *
     * @param describeCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeCertificatesMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeCertificatesIterable describeCertificatesPaginator(
            Consumer<DescribeCertificatesRequest.Builder> describeCertificatesRequest) throws CertificateNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeCertificatesPaginator(DescribeCertificatesRequest.builder().applyMutation(describeCertificatesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterBacktracksRequest
     * @return Result of the DescribeDBClusterBacktracks operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterBacktrackNotFoundException
     *         <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterBacktracksResponse describeDBClusterBacktracks(
            DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) throws DbClusterNotFoundException,
            DbClusterBacktrackNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterBacktracksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterBacktracksRequest#builder()}
     * </p>
     *
     * @param describeDbClusterBacktracksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterBacktracksMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeDBClusterBacktracks operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterBacktrackNotFoundException
     *         <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterBacktracksResponse describeDBClusterBacktracks(
            Consumer<DescribeDbClusterBacktracksRequest.Builder> describeDbClusterBacktracksRequest)
            throws DbClusterNotFoundException, DbClusterBacktrackNotFoundException, AwsServiceException, SdkClientException,
            RdsException {
        return describeDBClusterBacktracks(DescribeDbClusterBacktracksRequest.builder()
                .applyMutation(describeDbClusterBacktracksRequest).build());
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable responses = client.describeDBClusterBacktracksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable responses = client
     *             .describeDBClusterBacktracksPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable responses = client.describeDBClusterBacktracksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterBacktracksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterBacktrackNotFoundException
     *         <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterBacktracksIterable describeDBClusterBacktracksPaginator(
            DescribeDbClusterBacktracksRequest describeDbClusterBacktracksRequest) throws DbClusterNotFoundException,
            DbClusterBacktrackNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about backtracks for a DB cluster.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora MySQL DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable responses = client.describeDBClusterBacktracksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable responses = client
     *             .describeDBClusterBacktracksPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksIterable responses = client.describeDBClusterBacktracksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterBacktracks(software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterBacktracksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterBacktracksRequest#builder()}
     * </p>
     *
     * @param describeDbClusterBacktracksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterBacktracksMessage.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbClusterBacktrackNotFoundException
     *         <code>BacktrackIdentifier</code> doesn't refer to an existing backtrack.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterBacktracks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterBacktracks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterBacktracksIterable describeDBClusterBacktracksPaginator(
            Consumer<DescribeDbClusterBacktracksRequest.Builder> describeDbClusterBacktracksRequest)
            throws DbClusterNotFoundException, DbClusterBacktrackNotFoundException, AwsServiceException, SdkClientException,
            RdsException {
        return describeDBClusterBacktracksPaginator(DescribeDbClusterBacktracksRequest.builder()
                .applyMutation(describeDbClusterBacktracksRequest).build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @return Result of the DescribeDBClusterEndpoints operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see #describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterEndpointsResponse describeDBClusterEndpoints() throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeDbClusterEndpointsRequest
     * @return Result of the DescribeDBClusterEndpoints operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterEndpointsResponse describeDBClusterEndpoints(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterEndpointsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBClusterEndpoints operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterEndpointsResponse describeDBClusterEndpoints(
            Consumer<DescribeDbClusterEndpointsRequest.Builder> describeDbClusterEndpointsRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterEndpoints(DescribeDbClusterEndpointsRequest.builder()
                .applyMutation(describeDbClusterEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client.describeDBClusterEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client
     *             .describeDBClusterEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client.describeDBClusterEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see #describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsIterable describeDBClusterEndpointsPaginator() throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client.describeDBClusterEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client
     *             .describeDBClusterEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client.describeDBClusterEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsIterable describeDBClusterEndpointsPaginator(
            DescribeDbClusterEndpointsRequest describeDbClusterEndpointsRequest) throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about endpoints for an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client.describeDBClusterEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client
     *             .describeDBClusterEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsIterable responses = client.describeDBClusterEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterEndpointsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterEndpointsIterable describeDBClusterEndpointsPaginator(
            Consumer<DescribeDbClusterEndpointsRequest.Builder> describeDbClusterEndpointsRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterEndpointsPaginator(DescribeDbClusterEndpointsRequest.builder()
                .applyMutation(describeDbClusterEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see #describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups() throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeDBClusterParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParameterGroupsResponse describeDBClusterParameterGroups(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterParameterGroups(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client.describeDBClusterParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client
     *             .describeDBClusterParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client.describeDBClusterParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see #describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsIterable describeDBClusterParameterGroupsPaginator()
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client.describeDBClusterParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client
     *             .describeDBClusterParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client.describeDBClusterParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsIterable describeDBClusterParameterGroupsPaginator(
            DescribeDbClusterParameterGroupsRequest describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBClusterParameterGroup</code> descriptions. If a
     * <code>DBClusterParameterGroupName</code> parameter is specified, the list will contain only the description of
     * the specified DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client.describeDBClusterParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client
     *             .describeDBClusterParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsIterable responses = client.describeDBClusterParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParameterGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParameterGroupsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameterGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParameterGroupsIterable describeDBClusterParameterGroupsPaginator(
            Consumer<DescribeDbClusterParameterGroupsRequest.Builder> describeDbClusterParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterParameterGroupsPaginator(DescribeDbClusterParameterGroupsRequest.builder()
                .applyMutation(describeDbClusterParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return Result of the DescribeDBClusterParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParametersResponse describeDBClusterParameters(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParametersMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeDBClusterParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterParametersResponse describeDBClusterParameters(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterParameters(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable responses = client.describeDBClusterParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable responses = client
     *             .describeDBClusterParametersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable responses = client.describeDBClusterParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParametersIterable describeDBClusterParametersPaginator(
            DescribeDbClusterParametersRequest describeDbClusterParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB cluster parameter group.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable responses = client.describeDBClusterParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable responses = client
     *             .describeDBClusterParametersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersIterable responses = client.describeDBClusterParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterParameters(software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeDbClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterParametersMessage.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterParametersIterable describeDBClusterParametersPaginator(
            Consumer<DescribeDbClusterParametersRequest.Builder> describeDbClusterParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterParametersPaginator(DescribeDbClusterParametersRequest.builder()
                .applyMutation(describeDbClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
     * returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
     * values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or
     * restored by all Amazon Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to
     * make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API
     * action.
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     * @return Result of the DescribeDBClusterSnapshotAttributes operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(
            DescribeDbClusterSnapshotAttributesRequest describeDbClusterSnapshotAttributesRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBClusterSnapshotAttributes</code>
     * returns the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are
     * authorized to copy or restore the manual DB cluster snapshot. If <code>all</code> is included in the list of
     * values for the <code>restore</code> attribute, then the manual DB cluster snapshot is public and can be copied or
     * restored by all Amazon Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB cluster snapshot, or to
     * make the manual DB cluster snapshot public or private, use the <code>ModifyDBClusterSnapshotAttribute</code> API
     * action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbClusterSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotAttributesMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeDBClusterSnapshotAttributes operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotAttributesResponse describeDBClusterSnapshotAttributes(
            Consumer<DescribeDbClusterSnapshotAttributesRequest.Builder> describeDbClusterSnapshotAttributesRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterSnapshotAttributes(DescribeDbClusterSnapshotAttributesRequest.builder()
                .applyMutation(describeDbClusterSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see #describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots() throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBClusterSnapshots operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbClusterSnapshotsResponse describeDBClusterSnapshots(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterSnapshots(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client.describeDBClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client
     *             .describeDBClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client.describeDBClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see #describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsIterable describeDBClusterSnapshotsPaginator() throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client.describeDBClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client
     *             .describeDBClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client.describeDBClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsIterable describeDBClusterSnapshotsPaginator(
            DescribeDbClusterSnapshotsRequest describeDbClusterSnapshotsRequest) throws DbClusterSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB cluster snapshots. This API action supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client.describeDBClusterSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client
     *             .describeDBClusterSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsIterable responses = client.describeDBClusterSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusterSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClusterSnapshotsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbClusterSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbClusterSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClusterSnapshotsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusterSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusterSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBClusterSnapshotsIterable describeDBClusterSnapshotsPaginator(
            Consumer<DescribeDbClusterSnapshotsRequest.Builder> describeDbClusterSnapshotsRequest)
            throws DbClusterSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusterSnapshotsPaginator(DescribeDbClusterSnapshotsRequest.builder()
                .applyMutation(describeDbClusterSnapshotsRequest).build());
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     *
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see #describeDBClusters(DescribeDbClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbClustersResponse describeDBClusters() throws DbClusterNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBClusters(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     *
     * @param describeDbClustersRequest
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbClustersResponse describeDBClusters(DescribeDbClustersRequest describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClustersMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBClusters operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbClustersResponse describeDBClusters(Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBClusters(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client
     *             .describeDBClustersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see #describeDBClustersPaginator(DescribeDbClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersIterable describeDBClustersPaginator() throws DbClusterNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().build());
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client
     *             .describeDBClustersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     *
     * @param describeDbClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersIterable describeDBClustersPaginator(DescribeDbClustersRequest describeDbClustersRequest)
            throws DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client
     *             .describeDBClustersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBClustersIterable responses = client.describeDBClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBClusters(software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbClustersRequest#builder()}
     * </p>
     *
     * @param describeDbClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBClustersMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBClusters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBClustersIterable describeDBClustersPaginator(
            Consumer<DescribeDbClustersRequest.Builder> describeDbClustersRequest) throws DbClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBClustersPaginator(DescribeDbClustersRequest.builder().applyMutation(describeDbClustersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see #describeDBEngineVersions(DescribeDbEngineVersionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbEngineVersionsResponse describeDBEngineVersions() throws AwsServiceException, SdkClientException,
            RdsException {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbEngineVersionsResponse describeDBEngineVersions(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBEngineVersionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBEngineVersions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbEngineVersionsResponse describeDBEngineVersions(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeDBEngineVersions(DescribeDbEngineVersionsRequest.builder().applyMutation(describeDbEngineVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client
     *             .describeDBEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see #describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator() throws AwsServiceException, SdkClientException,
            RdsException {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client
     *             .describeDBEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(
            DescribeDbEngineVersionsRequest describeDbEngineVersionsRequest) throws AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available DB engines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client
     *             .describeDBEngineVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsIterable responses = client.describeDBEngineVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBEngineVersions(software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbEngineVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbEngineVersionsRequest#builder()}
     * </p>
     *
     * @param describeDbEngineVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBEngineVersionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBEngineVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBEngineVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBEngineVersionsIterable describeDBEngineVersionsPaginator(
            Consumer<DescribeDbEngineVersionsRequest.Builder> describeDbEngineVersionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeDBEngineVersionsPaginator(DescribeDbEngineVersionsRequest.builder()
                .applyMutation(describeDbEngineVersionsRequest).build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @return Result of the DescribeDBInstanceAutomatedBackups operation returned by the service.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see #describeDBInstanceAutomatedBackups(DescribeDbInstanceAutomatedBackupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbInstanceAutomatedBackupsResponse describeDBInstanceAutomatedBackups()
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBInstanceAutomatedBackups(DescribeDbInstanceAutomatedBackupsRequest.builder().build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return Result of the DescribeDBInstanceAutomatedBackups operation returned by the service.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbInstanceAutomatedBackupsResponse describeDBInstanceAutomatedBackups(
            DescribeDbInstanceAutomatedBackupsRequest describeDbInstanceAutomatedBackupsRequest)
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstanceAutomatedBackupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbInstanceAutomatedBackupsRequest#builder()}
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstanceAutomatedBackupsMessage.Builder} to
     *        create a request. Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return Result of the DescribeDBInstanceAutomatedBackups operation returned by the service.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbInstanceAutomatedBackupsResponse describeDBInstanceAutomatedBackups(
            Consumer<DescribeDbInstanceAutomatedBackupsRequest.Builder> describeDbInstanceAutomatedBackupsRequest)
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBInstanceAutomatedBackups(DescribeDbInstanceAutomatedBackupsRequest.builder()
                .applyMutation(describeDbInstanceAutomatedBackupsRequest).build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client
     *             .describeDBInstanceAutomatedBackupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see #describeDBInstanceAutomatedBackupsPaginator(DescribeDbInstanceAutomatedBackupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBInstanceAutomatedBackupsIterable describeDBInstanceAutomatedBackupsPaginator()
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBInstanceAutomatedBackupsPaginator(DescribeDbInstanceAutomatedBackupsRequest.builder().build());
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client
     *             .describeDBInstanceAutomatedBackupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBInstanceAutomatedBackupsIterable describeDBInstanceAutomatedBackupsPaginator(
            DescribeDbInstanceAutomatedBackupsRequest describeDbInstanceAutomatedBackupsRequest)
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays backups for both current and deleted instances. For example, use this operation to find details about
     * automated backups for previously deleted instances. Current instances with retention periods greater than zero
     * (0) are returned for both the <code>DescribeDBInstanceAutomatedBackups</code> and
     * <code>DescribeDBInstances</code> operations.
     * </p>
     * <p>
     * All parameters are optional.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client
     *             .describeDBInstanceAutomatedBackupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsIterable responses = client.describeDBInstanceAutomatedBackupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstanceAutomatedBackups(software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstanceAutomatedBackupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbInstanceAutomatedBackupsRequest#builder()}
     * </p>
     *
     * @param describeDbInstanceAutomatedBackupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstanceAutomatedBackupsMessage.Builder} to
     *        create a request. Parameter input for DescribeDBInstanceAutomatedBackups.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceAutomatedBackupNotFoundException
     *         No automated backup for this DB instance was found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstanceAutomatedBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstanceAutomatedBackups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBInstanceAutomatedBackupsIterable describeDBInstanceAutomatedBackupsPaginator(
            Consumer<DescribeDbInstanceAutomatedBackupsRequest.Builder> describeDbInstanceAutomatedBackupsRequest)
            throws DbInstanceAutomatedBackupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBInstanceAutomatedBackupsPaginator(DescribeDbInstanceAutomatedBackupsRequest.builder()
                .applyMutation(describeDbInstanceAutomatedBackupsRequest).build());
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note>
     *
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see #describeDBInstances(DescribeDbInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbInstancesResponse describeDBInstances() throws DbInstanceNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBInstances(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note>
     *
     * @param describeDbInstancesRequest
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbInstancesResponse describeDBInstances(DescribeDbInstancesRequest describeDbInstancesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstancesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBInstances operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbInstancesResponse describeDBInstances(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) throws DbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBInstances(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest).build());
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client
     *             .describeDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see #describeDBInstancesPaginator(DescribeDbInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesIterable describeDBInstancesPaginator() throws DbInstanceNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client
     *             .describeDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation.</b>
     * </p>
     *
     * @param describeDbInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesIterable describeDBInstancesPaginator(DescribeDbInstancesRequest describeDbInstancesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes provisioned RDS instances. This API supports pagination.
     * </p>
     * <note>
     * <p>
     * This operation can also return information for Amazon Neptune DB instances and Amazon DocumentDB instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client
     *             .describeDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesIterable responses = client.describeDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBInstances(software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBInstancesMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBInstances" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBInstancesIterable describeDBInstancesPaginator(
            Consumer<DescribeDbInstancesRequest.Builder> describeDbInstancesRequest) throws DbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBInstancesPaginator(DescribeDbInstancesRequest.builder().applyMutation(describeDbInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeDbLogFilesRequest
     * @return Result of the DescribeDBLogFiles operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbLogFilesResponse describeDBLogFiles(DescribeDbLogFilesRequest describeDbLogFilesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbLogFilesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbLogFilesRequest#builder()}
     * </p>
     *
     * @param describeDbLogFilesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBLogFilesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBLogFiles operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbLogFilesResponse describeDBLogFiles(Consumer<DescribeDbLogFilesRequest.Builder> describeDbLogFilesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBLogFiles(DescribeDbLogFilesRequest.builder().applyMutation(describeDbLogFilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable responses = client.describeDBLogFilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable responses = client
     *             .describeDBLogFilesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable responses = client.describeDBLogFilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation.</b>
     * </p>
     *
     * @param describeDbLogFilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBLogFilesIterable describeDBLogFilesPaginator(DescribeDbLogFilesRequest describeDbLogFilesRequest)
            throws DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB log files for the DB instance.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable responses = client.describeDBLogFilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable responses = client
     *             .describeDBLogFilesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesIterable responses = client.describeDBLogFilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBLogFiles(software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbLogFilesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbLogFilesRequest#builder()}
     * </p>
     *
     * @param describeDbLogFilesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBLogFilesMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBLogFiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBLogFiles" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBLogFilesIterable describeDBLogFilesPaginator(
            Consumer<DescribeDbLogFilesRequest.Builder> describeDbLogFilesRequest) throws DbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBLogFilesPaginator(DescribeDbLogFilesRequest.builder().applyMutation(describeDbLogFilesRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @return Result of the DescribeDBParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see #describeDBParameterGroups(DescribeDbParameterGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbParameterGroupsResponse describeDBParameterGroups() throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return Result of the DescribeDBParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbParameterGroupsResponse describeDBParameterGroups(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParameterGroupsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBParameterGroups operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbParameterGroupsResponse describeDBParameterGroups(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBParameterGroups(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client.describeDBParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client
     *             .describeDBParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client.describeDBParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see #describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParameterGroupsIterable describeDBParameterGroupsPaginator() throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client.describeDBParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client
     *             .describeDBParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client.describeDBParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParameterGroupsIterable describeDBParameterGroupsPaginator(
            DescribeDbParameterGroupsRequest describeDbParameterGroupsRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBParameterGroup</code> descriptions. If a <code>DBParameterGroupName</code> is
     * specified, the list will contain only the description of the specified DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client.describeDBParameterGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client
     *             .describeDBParameterGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsIterable responses = client.describeDBParameterGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameterGroups(software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParameterGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbParameterGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbParameterGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParameterGroupsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameterGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameterGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBParameterGroupsIterable describeDBParameterGroupsPaginator(
            Consumer<DescribeDbParameterGroupsRequest.Builder> describeDbParameterGroupsRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBParameterGroupsPaginator(DescribeDbParameterGroupsRequest.builder()
                .applyMutation(describeDbParameterGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     *
     * @param describeDbParametersRequest
     * @return Result of the DescribeDBParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbParametersResponse describeDBParameters(DescribeDbParametersRequest describeDbParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParametersMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBParameters operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbParametersResponse describeDBParameters(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBParameters(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest).build());
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable responses = client.describeDBParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable responses = client
     *             .describeDBParametersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable responses = client.describeDBParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBParametersIterable describeDBParametersPaginator(DescribeDbParametersRequest describeDbParametersRequest)
            throws DbParameterGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the detailed parameter list for a particular DB parameter group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable responses = client.describeDBParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable responses = client
     *             .describeDBParametersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBParametersIterable responses = client.describeDBParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBParameters(software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbParametersRequest#builder()}
     * </p>
     *
     * @param describeDbParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBParametersMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBParametersIterable describeDBParametersPaginator(
            Consumer<DescribeDbParametersRequest.Builder> describeDbParametersRequest) throws DbParameterGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBParametersPaginator(DescribeDbParametersRequest.builder().applyMutation(describeDbParametersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     *
     * @param describeDbProxiesRequest
     * @return Result of the DescribeDBProxies operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbProxiesResponse describeDBProxies(DescribeDbProxiesRequest describeDbProxiesRequest)
            throws DbProxyNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxiesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDbProxiesRequest#builder()}
     * </p>
     *
     * @param describeDbProxiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxiesRequest.Builder} to create a request.
     * @return Result of the DescribeDBProxies operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbProxiesResponse describeDBProxies(Consumer<DescribeDbProxiesRequest.Builder> describeDbProxiesRequest)
            throws DbProxyNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBProxies(DescribeDbProxiesRequest.builder().applyMutation(describeDbProxiesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable responses = client.describeDBProxiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable responses = client
     *             .describeDBProxiesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable responses = client.describeDBProxiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation.</b>
     * </p>
     *
     * @param describeDbProxiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBProxiesIterable describeDBProxiesPaginator(DescribeDbProxiesRequest describeDbProxiesRequest)
            throws DbProxyNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxies.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable responses = client.describeDBProxiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable responses = client
     *             .describeDBProxiesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesIterable responses = client.describeDBProxiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxies(software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxiesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDbProxiesRequest#builder()}
     * </p>
     *
     * @param describeDbProxiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxiesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxies" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBProxiesIterable describeDBProxiesPaginator(
            Consumer<DescribeDbProxiesRequest.Builder> describeDbProxiesRequest) throws DbProxyNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBProxiesPaginator(DescribeDbProxiesRequest.builder().applyMutation(describeDbProxiesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     * @return Result of the DescribeDBProxyEndpoints operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbProxyEndpointsResponse describeDBProxyEndpoints(
            DescribeDbProxyEndpointsRequest describeDbProxyEndpointsRequest) throws DbProxyNotFoundException,
            DbProxyEndpointNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbProxyEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxyEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDBProxyEndpoints operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbProxyEndpointsResponse describeDBProxyEndpoints(
            Consumer<DescribeDbProxyEndpointsRequest.Builder> describeDbProxyEndpointsRequest) throws DbProxyNotFoundException,
            DbProxyEndpointNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBProxyEndpoints(DescribeDbProxyEndpointsRequest.builder().applyMutation(describeDbProxyEndpointsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable responses = client.describeDBProxyEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable responses = client
     *             .describeDBProxyEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable responses = client.describeDBProxyEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyEndpointsIterable describeDBProxyEndpointsPaginator(
            DescribeDbProxyEndpointsRequest describeDbProxyEndpointsRequest) throws DbProxyNotFoundException,
            DbProxyEndpointNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxy endpoints.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable responses = client.describeDBProxyEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable responses = client
     *             .describeDBProxyEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsIterable responses = client.describeDBProxyEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyEndpoints(software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbProxyEndpointsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyEndpointsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxyEndpointsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyEndpointsIterable describeDBProxyEndpointsPaginator(
            Consumer<DescribeDbProxyEndpointsRequest.Builder> describeDbProxyEndpointsRequest) throws DbProxyNotFoundException,
            DbProxyEndpointNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBProxyEndpointsPaginator(DescribeDbProxyEndpointsRequest.builder()
                .applyMutation(describeDbProxyEndpointsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     * @return Result of the DescribeDBProxyTargetGroups operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbProxyTargetGroupsResponse describeDBProxyTargetGroups(
            DescribeDbProxyTargetGroupsRequest describeDbProxyTargetGroupsRequest) throws DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbProxyTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxyTargetGroupsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeDBProxyTargetGroups operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbProxyTargetGroupsResponse describeDBProxyTargetGroups(
            Consumer<DescribeDbProxyTargetGroupsRequest.Builder> describeDbProxyTargetGroupsRequest)
            throws DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBProxyTargetGroups(DescribeDbProxyTargetGroupsRequest.builder()
                .applyMutation(describeDbProxyTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable responses = client.describeDBProxyTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable responses = client
     *             .describeDBProxyTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable responses = client.describeDBProxyTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBProxyTargetGroupsIterable describeDBProxyTargetGroupsPaginator(
            DescribeDbProxyTargetGroupsRequest describeDbProxyTargetGroupsRequest) throws DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB proxy target groups, represented by <code>DBProxyTargetGroup</code> data structures.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable responses = client.describeDBProxyTargetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable responses = client
     *             .describeDBProxyTargetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsIterable responses = client.describeDBProxyTargetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargetGroups(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbProxyTargetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxyTargetGroupsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDBProxyTargetGroupsIterable describeDBProxyTargetGroupsPaginator(
            Consumer<DescribeDbProxyTargetGroupsRequest.Builder> describeDbProxyTargetGroupsRequest)
            throws DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBProxyTargetGroupsPaginator(DescribeDbProxyTargetGroupsRequest.builder()
                .applyMutation(describeDbProxyTargetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     * @return Result of the DescribeDBProxyTargets operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbProxyTargetsResponse describeDBProxyTargets(DescribeDbProxyTargetsRequest describeDbProxyTargetsRequest)
            throws DbProxyNotFoundException, DbProxyTargetNotFoundException, DbProxyTargetGroupNotFoundException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbProxyTargetsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxyTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDBProxyTargets operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbProxyTargetsResponse describeDBProxyTargets(
            Consumer<DescribeDbProxyTargetsRequest.Builder> describeDbProxyTargetsRequest) throws DbProxyNotFoundException,
            DbProxyTargetNotFoundException, DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBProxyTargets(DescribeDbProxyTargetsRequest.builder().applyMutation(describeDbProxyTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable responses = client.describeDBProxyTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable responses = client
     *             .describeDBProxyTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable responses = client.describeDBProxyTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyTargetsIterable describeDBProxyTargetsPaginator(
            DescribeDbProxyTargetsRequest describeDbProxyTargetsRequest) throws DbProxyNotFoundException,
            DbProxyTargetNotFoundException, DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about <code>DBProxyTarget</code> objects. This API supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable responses = client.describeDBProxyTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable responses = client
     *             .describeDBProxyTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsIterable responses = client.describeDBProxyTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBProxyTargets(software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbProxyTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbProxyTargetsRequest#builder()}
     * </p>
     *
     * @param describeDbProxyTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBProxyTargetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetNotFoundException
     *         The specified RDS DB instance or Aurora DB cluster isn't available for a proxy owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBProxyTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBProxyTargets" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBProxyTargetsIterable describeDBProxyTargetsPaginator(
            Consumer<DescribeDbProxyTargetsRequest.Builder> describeDbProxyTargetsRequest) throws DbProxyNotFoundException,
            DbProxyTargetNotFoundException, DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBProxyTargetsPaginator(DescribeDbProxyTargetsRequest.builder()
                .applyMutation(describeDbProxyTargetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @return Result of the DescribeDBSecurityGroups operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see #describeDBSecurityGroups(DescribeDbSecurityGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSecurityGroupsResponse describeDBSecurityGroups() throws DbSecurityGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSecurityGroups(DescribeDbSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note>
     *
     * @param describeDbSecurityGroupsRequest
     * @return Result of the DescribeDBSecurityGroups operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSecurityGroupsResponse describeDBSecurityGroups(
            DescribeDbSecurityGroupsRequest describeDbSecurityGroupsRequest) throws DbSecurityGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSecurityGroupsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBSecurityGroups operation returned by the service.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSecurityGroupsResponse describeDBSecurityGroups(
            Consumer<DescribeDbSecurityGroupsRequest.Builder> describeDbSecurityGroupsRequest)
            throws DbSecurityGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBSecurityGroups(DescribeDbSecurityGroupsRequest.builder().applyMutation(describeDbSecurityGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client.describeDBSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client
     *             .describeDBSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client.describeDBSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see #describeDBSecurityGroupsPaginator(DescribeDbSecurityGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSecurityGroupsIterable describeDBSecurityGroupsPaginator() throws DbSecurityGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSecurityGroupsPaginator(DescribeDbSecurityGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client.describeDBSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client
     *             .describeDBSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client.describeDBSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSecurityGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSecurityGroupsIterable describeDBSecurityGroupsPaginator(
            DescribeDbSecurityGroupsRequest describeDbSecurityGroupsRequest) throws DbSecurityGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of <code>DBSecurityGroup</code> descriptions. If a <code>DBSecurityGroupName</code> is specified,
     * the list will contain only the descriptions of the specified DB security group.
     * </p>
     * <note>
     * <p>
     * EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we recommend that
     * you migrate as soon as possible. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-migrate.html">Migrate from EC2-Classic to a VPC</a>
     * in the <i>Amazon EC2 User Guide</i>, the blog <a
     * href="http://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/">EC2-Classic Networking is
     * Retiring – Here’s How to Prepare</a>, and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.Non-VPC2VPC.html">Moving a DB instance not
     * in a VPC into a VPC</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client.describeDBSecurityGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client
     *             .describeDBSecurityGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsIterable responses = client.describeDBSecurityGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSecurityGroups(software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSecurityGroupsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDbSecurityGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSecurityGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSecurityGroupsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSecurityGroupsIterable describeDBSecurityGroupsPaginator(
            Consumer<DescribeDbSecurityGroupsRequest.Builder> describeDbSecurityGroupsRequest)
            throws DbSecurityGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBSecurityGroupsPaginator(DescribeDbSecurityGroupsRequest.builder()
                .applyMutation(describeDbSecurityGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns
     * the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to
     * copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon
     * Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make
     * the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     *
     * @param describeDbSnapshotAttributesRequest
     * @return Result of the DescribeDBSnapshotAttributes operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbSnapshotAttributesResponse describeDBSnapshotAttributes(
            DescribeDbSnapshotAttributesRequest describeDbSnapshotAttributesRequest) throws DbSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DB snapshot attribute names and values for a manual DB snapshot.
     * </p>
     * <p>
     * When sharing snapshots with other Amazon Web Services accounts, <code>DescribeDBSnapshotAttributes</code> returns
     * the <code>restore</code> attribute and a list of IDs for the Amazon Web Services accounts that are authorized to
     * copy or restore the manual DB snapshot. If <code>all</code> is included in the list of values for the
     * <code>restore</code> attribute, then the manual DB snapshot is public and can be copied or restored by all Amazon
     * Web Services accounts.
     * </p>
     * <p>
     * To add or remove access for an Amazon Web Services account to copy or restore a manual DB snapshot, or to make
     * the manual DB snapshot public or private, use the <code>ModifyDBSnapshotAttribute</code> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDbSnapshotAttributesRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotAttributesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSnapshotAttributesMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeDBSnapshotAttributes operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshotAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDbSnapshotAttributesResponse describeDBSnapshotAttributes(
            Consumer<DescribeDbSnapshotAttributesRequest.Builder> describeDbSnapshotAttributesRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeDBSnapshotAttributes(DescribeDbSnapshotAttributesRequest.builder()
                .applyMutation(describeDbSnapshotAttributesRequest).build());
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     *
     * @return Result of the DescribeDBSnapshots operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see #describeDBSnapshots(DescribeDbSnapshotsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbSnapshotsResponse describeDBSnapshots() throws DbSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBSnapshots(DescribeDbSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     *
     * @param describeDbSnapshotsRequest
     * @return Result of the DescribeDBSnapshots operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbSnapshotsResponse describeDBSnapshots(DescribeDbSnapshotsRequest describeDbSnapshotsRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSnapshotsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBSnapshots operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDbSnapshotsResponse describeDBSnapshots(
            Consumer<DescribeDbSnapshotsRequest.Builder> describeDbSnapshotsRequest) throws DbSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSnapshots(DescribeDbSnapshotsRequest.builder().applyMutation(describeDbSnapshotsRequest).build());
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client.describeDBSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client
     *             .describeDBSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client.describeDBSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see #describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBSnapshotsIterable describeDBSnapshotsPaginator() throws DbSnapshotNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client.describeDBSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client
     *             .describeDBSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client.describeDBSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param describeDbSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBSnapshotsIterable describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest describeDbSnapshotsRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about DB snapshots. This API action supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client.describeDBSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client
     *             .describeDBSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsIterable responses = client.describeDBSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSnapshots(software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSnapshotsRequest#builder()}
     * </p>
     *
     * @param describeDbSnapshotsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSnapshotsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDBSnapshotsIterable describeDBSnapshotsPaginator(
            Consumer<DescribeDbSnapshotsRequest.Builder> describeDbSnapshotsRequest) throws DbSnapshotNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSnapshotsPaginator(DescribeDbSnapshotsRequest.builder().applyMutation(describeDbSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see #describeDBSubnetGroups(DescribeDbSubnetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSubnetGroupsResponse describeDBSubnetGroups() throws DbSubnetGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSubnetGroupsResponse describeDBSubnetGroups(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest)
            throws DbSubnetGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSubnetGroupsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeDBSubnetGroups operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDbSubnetGroupsResponse describeDBSubnetGroups(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSubnetGroups(DescribeDbSubnetGroupsRequest.builder().applyMutation(describeDbSubnetGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client
     *             .describeDBSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see #describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator() throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client
     *             .describeDBSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(
            DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list will contain only the
     * descriptions of the specified DBSubnetGroup.
     * </p>
     * <p>
     * For an overview of CIDR ranges, go to the <a
     * href="http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing">Wikipedia Tutorial</a>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client
     *             .describeDBSubnetGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsIterable responses = client.describeDBSubnetGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeDBSubnetGroups(software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDbSubnetGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDbSubnetGroupsRequest#builder()}
     * </p>
     *
     * @param describeDbSubnetGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDBSubnetGroupsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeDBSubnetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSubnetGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeDBSubnetGroupsIterable describeDBSubnetGroupsPaginator(
            Consumer<DescribeDbSubnetGroupsRequest.Builder> describeDbSubnetGroupsRequest) throws DbSubnetGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeDBSubnetGroupsPaginator(DescribeDbSubnetGroupsRequest.builder()
                .applyMutation(describeDbSubnetGroupsRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     * @return Result of the DescribeEngineDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(
            DescribeEngineDefaultClusterParametersRequest describeEngineDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the cluster database engine.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEngineDefaultClusterParametersRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEngineDefaultClusterParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultClusterParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultClusterParametersMessage.Builder}
     *        to create a request.
     * @return Result of the DescribeEngineDefaultClusterParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultClusterParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultClusterParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultClusterParametersResponse describeEngineDefaultClusterParameters(
            Consumer<DescribeEngineDefaultClusterParametersRequest.Builder> describeEngineDefaultClusterParametersRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeEngineDefaultClusterParameters(DescribeEngineDefaultClusterParametersRequest.builder()
                .applyMutation(describeEngineDefaultClusterParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return Result of the DescribeEngineDefaultParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultParametersMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeEngineDefaultParameters operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersResponse describeEngineDefaultParameters(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable responses = client.describeEngineDefaultParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable responses = client
     *             .describeEngineDefaultParametersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable responses = client.describeEngineDefaultParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersIterable describeEngineDefaultParametersPaginator(
            DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the default engine and system parameter information for the specified database engine.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable responses = client.describeEngineDefaultParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable responses = client
     *             .describeEngineDefaultParametersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEngineDefaultParametersIterable responses = client.describeEngineDefaultParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEngineDefaultParameters(software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEngineDefaultParametersRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEngineDefaultParametersRequest#builder()}
     * </p>
     *
     * @param describeEngineDefaultParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEngineDefaultParametersMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEngineDefaultParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEngineDefaultParameters"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEngineDefaultParametersIterable describeEngineDefaultParametersPaginator(
            Consumer<DescribeEngineDefaultParametersRequest.Builder> describeEngineDefaultParametersRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeEngineDefaultParametersPaginator(DescribeEngineDefaultParametersRequest.builder()
                .applyMutation(describeEngineDefaultParametersRequest).build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     *
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventCategories
     * @see #describeEventCategories(DescribeEventCategoriesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories() throws AwsServiceException, SdkClientException,
            RdsException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().build());
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     *
     * @param describeEventCategoriesRequest
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays a list of categories for all event source types, or, if specified, for a specified source type. You can
     * also see this list in the "Amazon RDS event categories and event messages" section of the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.Messages.html"> <i>Amazon RDS User
     * Guide</i> </a> or the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_Events.Messages.html"> <i>Amazon Aurora
     * User Guide</i> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventCategoriesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventCategoriesRequest#builder()}
     * </p>
     *
     * @param describeEventCategoriesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventCategoriesMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEventCategories operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventCategories" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeEventCategoriesResponse describeEventCategories(
            Consumer<DescribeEventCategoriesRequest.Builder> describeEventCategoriesRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeEventCategories(DescribeEventCategoriesRequest.builder().applyMutation(describeEventCategoriesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     *
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptions(DescribeEventSubscriptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions() throws SubscriptionNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeEventSubscriptions operation returned by the service.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsResponse describeEventSubscriptions(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws SubscriptionNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeEventSubscriptions(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see #describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator() throws SubscriptionNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws SubscriptionNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the subscription descriptions for a customer account. The description for a subscription includes
     * <code>SubscriptionName</code>, <code>SNSTopicARN</code>, <code>CustomerID</code>, <code>SourceType</code>,
     * <code>SourceID</code>, <code>CreationTime</code>, and <code>Status</code>.
     * </p>
     * <p>
     * If you specify a <code>SubscriptionName</code>, lists the description for that subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client
     *             .describeEventSubscriptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsIterable responses = client.describeEventSubscriptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEventSubscriptions(software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventSubscriptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEventSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeEventSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventSubscriptionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEventSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEventSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEventSubscriptionsIterable describeEventSubscriptionsPaginator(
            Consumer<DescribeEventSubscriptionsRequest.Builder> describeEventSubscriptionsRequest)
            throws SubscriptionNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeEventSubscriptionsPaginator(DescribeEventSubscriptionsRequest.builder()
                .applyMutation(describeEventSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note>
     *
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see #describeEvents(DescribeEventsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents() throws AwsServiceException, SdkClientException, RdsException {
        return describeEvents(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note>
     *
     * @param describeEventsRequest
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(DescribeEventsRequest describeEventsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return Result of the DescribeEvents operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsResponse describeEvents(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeEvents(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see #describeEventsPaginator(DescribeEventsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator() throws AwsServiceException, SdkClientException, RdsException {
        return describeEventsPaginator(DescribeEventsRequest.builder().build());
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)} operation.</b>
     * </p>
     *
     * @param describeEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(DescribeEventsRequest describeEventsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB
     * cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster,
     * DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by
     * providing the name as a parameter.
     * </p>
     * <p>
     * For more information on working with events, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/working-with-events.html">Monitoring Amazon RDS
     * events</a> in the <i>Amazon RDS User Guide</i> and <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/working-with-events.html">Monitoring Amazon
     * Aurora events</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * By default, RDS returns events that were generated in the past hour.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeEventsIterable responses = client.describeEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEvents(software.amazon.awssdk.services.rds.model.DescribeEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeEventsRequest#builder()}
     * </p>
     *
     * @param describeEventsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEventsMessage.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeEventsIterable describeEventsPaginator(Consumer<DescribeEventsRequest.Builder> describeEventsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeEventsPaginator(DescribeEventsRequest.builder().applyMutation(describeEventsRequest).build());
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     *
     * @param describeExportTasksRequest
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExportTasksResponse describeExportTasks(DescribeExportTasksRequest describeExportTasksRequest)
            throws ExportTaskNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExportTasksMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeExportTasks operation returned by the service.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExportTasksResponse describeExportTasks(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) throws ExportTaskNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeExportTasks(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest).build());
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable responses = client.describeExportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable responses = client
     *             .describeExportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable responses = client.describeExportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation.</b>
     * </p>
     *
     * @param describeExportTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExportTasksIterable describeExportTasksPaginator(DescribeExportTasksRequest describeExportTasksRequest)
            throws ExportTaskNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a snapshot or cluster export to Amazon S3. This API operation supports pagination.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable responses = client.describeExportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable responses = client
     *             .describeExportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeExportTasksIterable responses = client.describeExportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeExportTasks(software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeExportTasksRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeExportTasksRequest#builder()}
     * </p>
     *
     * @param describeExportTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeExportTasksMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ExportTaskNotFoundException
     *         The export task doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeExportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeExportTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeExportTasksIterable describeExportTasksPaginator(
            Consumer<DescribeExportTasksRequest.Builder> describeExportTasksRequest) throws ExportTaskNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeExportTasksPaginator(DescribeExportTasksRequest.builder().applyMutation(describeExportTasksRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @return Result of the DescribeGlobalClusters operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see #describeGlobalClusters(DescribeGlobalClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersResponse describeGlobalClusters() throws GlobalClusterNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeGlobalClusters(DescribeGlobalClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param describeGlobalClustersRequest
     * @return Result of the DescribeGlobalClusters operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersResponse describeGlobalClusters(DescribeGlobalClustersRequest describeGlobalClustersRequest)
            throws GlobalClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalClustersRequest#builder()}
     * </p>
     *
     * @param describeGlobalClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalClustersMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeGlobalClusters operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersResponse describeGlobalClusters(
            Consumer<DescribeGlobalClustersRequest.Builder> describeGlobalClustersRequest) throws GlobalClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeGlobalClusters(DescribeGlobalClustersRequest.builder().applyMutation(describeGlobalClustersRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client.describeGlobalClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client
     *             .describeGlobalClustersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client.describeGlobalClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see #describeGlobalClustersPaginator(DescribeGlobalClustersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersIterable describeGlobalClustersPaginator() throws GlobalClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeGlobalClustersPaginator(DescribeGlobalClustersRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client.describeGlobalClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client
     *             .describeGlobalClustersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client.describeGlobalClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGlobalClustersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersIterable describeGlobalClustersPaginator(
            DescribeGlobalClustersRequest describeGlobalClustersRequest) throws GlobalClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about Aurora global database clusters. This API supports pagination.
     * </p>
     * <p>
     * For more information on Amazon Aurora, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client.describeGlobalClustersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client
     *             .describeGlobalClustersPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersIterable responses = client.describeGlobalClustersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGlobalClusters(software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGlobalClustersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGlobalClustersRequest#builder()}
     * </p>
     *
     * @param describeGlobalClustersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeGlobalClustersMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeGlobalClusters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeGlobalClusters" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGlobalClustersIterable describeGlobalClustersPaginator(
            Consumer<DescribeGlobalClustersRequest.Builder> describeGlobalClustersRequest) throws GlobalClusterNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeGlobalClustersPaginator(DescribeGlobalClustersRequest.builder()
                .applyMutation(describeGlobalClustersRequest).build());
    }

    /**
     * <p>
     * Describes all available options.
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     * @return Result of the DescribeOptionGroupOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptionGroupOptionsResponse describeOptionGroupOptions(
            DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) throws AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all available options.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptionGroupOptionsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOptionGroupOptionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeOptionGroupOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptionGroupOptionsResponse describeOptionGroupOptions(
            Consumer<DescribeOptionGroupOptionsRequest.Builder> describeOptionGroupOptionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeOptionGroupOptions(DescribeOptionGroupOptionsRequest.builder()
                .applyMutation(describeOptionGroupOptionsRequest).build());
    }

    /**
     * <p>
     * Describes all available options.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable responses = client.describeOptionGroupOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable responses = client
     *             .describeOptionGroupOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable responses = client.describeOptionGroupOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptionGroupOptionsIterable describeOptionGroupOptionsPaginator(
            DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) throws AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes all available options.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable responses = client.describeOptionGroupOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable responses = client
     *             .describeOptionGroupOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsIterable responses = client.describeOptionGroupOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroupOptions(software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupOptionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeOptionGroupOptionsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOptionGroupOptionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroupOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroupOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOptionGroupOptionsIterable describeOptionGroupOptionsPaginator(
            Consumer<DescribeOptionGroupOptionsRequest.Builder> describeOptionGroupOptionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeOptionGroupOptionsPaginator(DescribeOptionGroupOptionsRequest.builder()
                .applyMutation(describeOptionGroupOptionsRequest).build());
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     *
     * @return Result of the DescribeOptionGroups operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see #describeOptionGroups(DescribeOptionGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsResponse describeOptionGroups() throws OptionGroupNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return describeOptionGroups(DescribeOptionGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     *
     * @param describeOptionGroupsRequest
     * @return Result of the DescribeOptionGroups operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsResponse describeOptionGroups(DescribeOptionGroupsRequest describeOptionGroupsRequest)
            throws OptionGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptionGroupsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOptionGroupsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeOptionGroups operation returned by the service.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsResponse describeOptionGroups(
            Consumer<DescribeOptionGroupsRequest.Builder> describeOptionGroupsRequest) throws OptionGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeOptionGroups(DescribeOptionGroupsRequest.builder().applyMutation(describeOptionGroupsRequest).build());
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client.describeOptionGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client
     *             .describeOptionGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client.describeOptionGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see #describeOptionGroupsPaginator(DescribeOptionGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsIterable describeOptionGroupsPaginator() throws OptionGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeOptionGroupsPaginator(DescribeOptionGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client.describeOptionGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client
     *             .describeOptionGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client.describeOptionGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOptionGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsIterable describeOptionGroupsPaginator(DescribeOptionGroupsRequest describeOptionGroupsRequest)
            throws OptionGroupNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available option groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client.describeOptionGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client
     *             .describeOptionGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsIterable responses = client.describeOptionGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOptionGroups(software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOptionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeOptionGroupsRequest#builder()}
     * </p>
     *
     * @param describeOptionGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOptionGroupsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOptionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOptionGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOptionGroupsIterable describeOptionGroupsPaginator(
            Consumer<DescribeOptionGroupsRequest.Builder> describeOptionGroupsRequest) throws OptionGroupNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeOptionGroupsPaginator(DescribeOptionGroupsRequest.builder().applyMutation(describeOptionGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance
     * class.
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return Result of the DescribeOrderableDBInstanceOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance
     * class.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableDBInstanceOptionsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribeOrderableDBInstanceOptions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDbInstanceOptionsResponse describeOrderableDBInstanceOptions(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeOrderableDBInstanceOptions(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance
     * class.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client
     *             .describeOrderableDBInstanceOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(
            DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of orderable DB instance options for the specified DB engine, DB engine version, and DB instance
     * class.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client
     *             .describeOrderableDBInstanceOptionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsIterable responses = client.describeOrderableDBInstanceOptionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOrderableDBInstanceOptions(software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrderableDbInstanceOptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrderableDbInstanceOptionsRequest#builder()}
     * </p>
     *
     * @param describeOrderableDbInstanceOptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOrderableDBInstanceOptionsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeOrderableDBInstanceOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeOrderableDBInstanceOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrderableDBInstanceOptionsIterable describeOrderableDBInstanceOptionsPaginator(
            Consumer<DescribeOrderableDbInstanceOptionsRequest.Builder> describeOrderableDbInstanceOptionsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        return describeOrderableDBInstanceOptionsPaginator(DescribeOrderableDbInstanceOptionsRequest.builder()
                .applyMutation(describeOrderableDbInstanceOptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see #describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions() throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingMaintenanceActionsMessage.Builder} to
     *        create a request.
     * @return Result of the DescribePendingMaintenanceActions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsResponse describePendingMaintenanceActions(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describePendingMaintenanceActions(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see #describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator()
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            DescribePendingMaintenanceActionsRequest describePendingMaintenanceActionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources (for example, DB instances) that have at least one pending maintenance action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client
     *             .describePendingMaintenanceActionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsIterable responses = client.describePendingMaintenanceActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePendingMaintenanceActions(software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePendingMaintenanceActionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribePendingMaintenanceActionsRequest#builder()}
     * </p>
     *
     * @param describePendingMaintenanceActionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePendingMaintenanceActionsMessage.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribePendingMaintenanceActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribePendingMaintenanceActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePendingMaintenanceActionsIterable describePendingMaintenanceActionsPaginator(
            Consumer<DescribePendingMaintenanceActionsRequest.Builder> describePendingMaintenanceActionsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describePendingMaintenanceActionsPaginator(DescribePendingMaintenanceActionsRequest.builder()
                .applyMutation(describePendingMaintenanceActionsRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     *
     * @return Result of the DescribeReservedDBInstances operation returned by the service.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see #describeReservedDBInstances(DescribeReservedDbInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDbInstancesResponse describeReservedDBInstances() throws ReservedDbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstances(DescribeReservedDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     * @return Result of the DescribeReservedDBInstances operation returned by the service.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDbInstancesResponse describeReservedDBInstances(
            DescribeReservedDbInstancesRequest describeReservedDbInstancesRequest) throws ReservedDbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedDbInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedDBInstancesMessage.Builder} to create
     *        a request.
     * @return Result of the DescribeReservedDBInstances operation returned by the service.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDbInstancesResponse describeReservedDBInstances(
            Consumer<DescribeReservedDbInstancesRequest.Builder> describeReservedDbInstancesRequest)
            throws ReservedDbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstances(DescribeReservedDbInstancesRequest.builder()
                .applyMutation(describeReservedDbInstancesRequest).build());
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client.describeReservedDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client
     *             .describeReservedDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client.describeReservedDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see #describeReservedDBInstancesPaginator(DescribeReservedDbInstancesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesIterable describeReservedDBInstancesPaginator()
            throws ReservedDbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstancesPaginator(DescribeReservedDbInstancesRequest.builder().build());
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client.describeReservedDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client
     *             .describeReservedDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client.describeReservedDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesIterable describeReservedDBInstancesPaginator(
            DescribeReservedDbInstancesRequest describeReservedDbInstancesRequest) throws ReservedDbInstanceNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about reserved DB instances for this account, or about a specified reserved DB instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client.describeReservedDBInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client
     *             .describeReservedDBInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesIterable responses = client.describeReservedDBInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstances(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeReservedDbInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeReservedDbInstancesRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedDBInstancesMessage.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedDbInstanceNotFoundException
     *         The specified reserved DB Instance not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesIterable describeReservedDBInstancesPaginator(
            Consumer<DescribeReservedDbInstancesRequest.Builder> describeReservedDbInstancesRequest)
            throws ReservedDbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstancesPaginator(DescribeReservedDbInstancesRequest.builder()
                .applyMutation(describeReservedDbInstancesRequest).build());
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     *
     * @return Result of the DescribeReservedDBInstancesOfferings operation returned by the service.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see #describeReservedDBInstancesOfferings(DescribeReservedDbInstancesOfferingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDbInstancesOfferingsResponse describeReservedDBInstancesOfferings()
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstancesOfferings(DescribeReservedDbInstancesOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     * @return Result of the DescribeReservedDBInstancesOfferings operation returned by the service.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDbInstancesOfferingsResponse describeReservedDBInstancesOfferings(
            DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest)
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedDbInstancesOfferingsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedDbInstancesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedDBInstancesOfferingsMessage.Builder}
     *        to create a request.
     * @return Result of the DescribeReservedDBInstancesOfferings operation returned by the service.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDbInstancesOfferingsResponse describeReservedDBInstancesOfferings(
            Consumer<DescribeReservedDbInstancesOfferingsRequest.Builder> describeReservedDbInstancesOfferingsRequest)
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstancesOfferings(DescribeReservedDbInstancesOfferingsRequest.builder()
                .applyMutation(describeReservedDbInstancesOfferingsRequest).build());
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client.describeReservedDBInstancesOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client
     *             .describeReservedDBInstancesOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client.describeReservedDBInstancesOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see #describeReservedDBInstancesOfferingsPaginator(DescribeReservedDbInstancesOfferingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesOfferingsIterable describeReservedDBInstancesOfferingsPaginator()
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstancesOfferingsPaginator(DescribeReservedDbInstancesOfferingsRequest.builder().build());
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client.describeReservedDBInstancesOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client
     *             .describeReservedDBInstancesOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client.describeReservedDBInstancesOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesOfferingsIterable describeReservedDBInstancesOfferingsPaginator(
            DescribeReservedDbInstancesOfferingsRequest describeReservedDbInstancesOfferingsRequest)
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available reserved DB instance offerings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client.describeReservedDBInstancesOfferingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client
     *             .describeReservedDBInstancesOfferingsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsIterable responses = client.describeReservedDBInstancesOfferingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReservedDBInstancesOfferings(software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReservedDbInstancesOfferingsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReservedDbInstancesOfferingsRequest#builder()}
     * </p>
     *
     * @param describeReservedDbInstancesOfferingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeReservedDBInstancesOfferingsMessage.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ReservedDbInstancesOfferingNotFoundException
     *         Specified offering does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeReservedDBInstancesOfferings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeReservedDBInstancesOfferings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReservedDBInstancesOfferingsIterable describeReservedDBInstancesOfferingsPaginator(
            Consumer<DescribeReservedDbInstancesOfferingsRequest.Builder> describeReservedDbInstancesOfferingsRequest)
            throws ReservedDbInstancesOfferingNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return describeReservedDBInstancesOfferingsPaginator(DescribeReservedDbInstancesOfferingsRequest.builder()
                .applyMutation(describeReservedDbInstancesOfferingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     *
     * @return Result of the DescribeSourceRegions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see #describeSourceRegions(DescribeSourceRegionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceRegionsResponse describeSourceRegions() throws AwsServiceException, SdkClientException, RdsException {
        return describeSourceRegions(DescribeSourceRegionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     *
     * @param describeSourceRegionsRequest
     * @return Result of the DescribeSourceRegions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceRegionsResponse describeSourceRegions(DescribeSourceRegionsRequest describeSourceRegionsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceRegionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceRegionsRequest#builder()}
     * </p>
     *
     * @param describeSourceRegionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceRegionsMessage.Builder} to create a
     *        request.
     * @return Result of the DescribeSourceRegions operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceRegionsResponse describeSourceRegions(
            Consumer<DescribeSourceRegionsRequest.Builder> describeSourceRegionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeSourceRegions(DescribeSourceRegionsRequest.builder().applyMutation(describeSourceRegionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceRegions(software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client.describeSourceRegionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client
     *             .describeSourceRegionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client.describeSourceRegionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceRegions(software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see #describeSourceRegionsPaginator(DescribeSourceRegionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceRegionsIterable describeSourceRegionsPaginator() throws AwsServiceException, SdkClientException,
            RdsException {
        return describeSourceRegionsPaginator(DescribeSourceRegionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceRegions(software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client.describeSourceRegionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client
     *             .describeSourceRegionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client.describeSourceRegionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceRegions(software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSourceRegionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceRegionsIterable describeSourceRegionsPaginator(DescribeSourceRegionsRequest describeSourceRegionsRequest)
            throws AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the source Amazon Web Services Regions where the current Amazon Web Services Region can create
     * a read replica, copy a DB snapshot from, or replicate automated backups from.
     * </p>
     * <p>
     * Use this operation to determine whether cross-Region features are supported between other Regions and your
     * current Region. This operation supports pagination.
     * </p>
     * <p>
     * To return information about the Regions that are enabled for your account, or all Regions, use the EC2 operation
     * <code>DescribeRegions</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeRegions.html"> DescribeRegions</a> in
     * the <i>Amazon EC2 API Reference</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceRegions(software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client.describeSourceRegionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client
     *             .describeSourceRegionsPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsIterable responses = client.describeSourceRegionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxRecords won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceRegions(software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceRegionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceRegionsRequest#builder()}
     * </p>
     *
     * @param describeSourceRegionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceRegionsMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeSourceRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeSourceRegions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceRegionsIterable describeSourceRegionsPaginator(
            Consumer<DescribeSourceRegionsRequest.Builder> describeSourceRegionsRequest) throws AwsServiceException,
            SdkClientException, RdsException {
        return describeSourceRegionsPaginator(DescribeSourceRegionsRequest.builder().applyMutation(describeSourceRegionsRequest)
                .build());
    }

    /**
     * <p>
     * You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to your
     * DB instance. You can use this information when you call <code>ModifyDBInstance</code>.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     * @return Result of the DescribeValidDBInstanceModifications operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeValidDbInstanceModificationsResponse describeValidDBInstanceModifications(
            DescribeValidDbInstanceModificationsRequest describeValidDbInstanceModificationsRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * You can call <code>DescribeValidDBInstanceModifications</code> to learn what modifications you can make to your
     * DB instance. You can use this information when you call <code>ModifyDBInstance</code>.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeValidDbInstanceModificationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeValidDbInstanceModificationsRequest#builder()}
     * </p>
     *
     * @param describeValidDbInstanceModificationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeValidDBInstanceModificationsMessage.Builder}
     *        to create a request.
     * @return Result of the DescribeValidDBInstanceModifications operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DescribeValidDBInstanceModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeValidDBInstanceModifications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeValidDbInstanceModificationsResponse describeValidDBInstanceModifications(
            Consumer<DescribeValidDbInstanceModificationsRequest.Builder> describeValidDbInstanceModificationsRequest)
            throws DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException,
            RdsException {
        return describeValidDBInstanceModifications(DescribeValidDbInstanceModificationsRequest.builder()
                .applyMutation(describeValidDbInstanceModificationsRequest).build());
    }

    /**
     * <p>
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     *
     * @param downloadDbLogFilePortionRequest
     * @return Result of the DownloadDBLogFilePortion operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbLogFileNotFoundException
     *         <code>LogFileName</code> doesn't refer to an existing DB log file.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DownloadDBLogFilePortion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion" target="_top">AWS
     *      API Documentation</a>
     */
    default DownloadDbLogFilePortionResponse downloadDBLogFilePortion(
            DownloadDbLogFilePortionRequest downloadDbLogFilePortionRequest) throws DbInstanceNotFoundException,
            DbLogFileNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DownloadDbLogFilePortionRequest.Builder} avoiding
     * the need to create one manually via {@link DownloadDbLogFilePortionRequest#builder()}
     * </p>
     *
     * @param downloadDbLogFilePortionRequest
     *        A {@link Consumer} that will call methods on {@link DownloadDBLogFilePortionMessage.Builder} to create a
     *        request.
     * @return Result of the DownloadDBLogFilePortion operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbLogFileNotFoundException
     *         <code>LogFileName</code> doesn't refer to an existing DB log file.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DownloadDBLogFilePortion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion" target="_top">AWS
     *      API Documentation</a>
     */
    default DownloadDbLogFilePortionResponse downloadDBLogFilePortion(
            Consumer<DownloadDbLogFilePortionRequest.Builder> downloadDbLogFilePortionRequest)
            throws DbInstanceNotFoundException, DbLogFileNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return downloadDBLogFilePortion(DownloadDbLogFilePortionRequest.builder().applyMutation(downloadDbLogFilePortionRequest)
                .build());
    }

    /**
     * <p>
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #downloadDBLogFilePortion(software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable responses = client.downloadDBLogFilePortionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable responses = client
     *             .downloadDBLogFilePortionPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable responses = client.downloadDBLogFilePortionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of NumberOfLines won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #downloadDBLogFilePortion(software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest)}
     * operation.</b>
     * </p>
     *
     * @param downloadDbLogFilePortionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbLogFileNotFoundException
     *         <code>LogFileName</code> doesn't refer to an existing DB log file.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DownloadDBLogFilePortion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion" target="_top">AWS
     *      API Documentation</a>
     */
    default DownloadDBLogFilePortionIterable downloadDBLogFilePortionPaginator(
            DownloadDbLogFilePortionRequest downloadDbLogFilePortionRequest) throws DbInstanceNotFoundException,
            DbLogFileNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Downloads all or a portion of the specified log file, up to 1 MB in size.
     * </p>
     * <p>
     * This command doesn't apply to RDS Custom.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #downloadDBLogFilePortion(software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable responses = client.downloadDBLogFilePortionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable responses = client
     *             .downloadDBLogFilePortionPaginator(request);
     *     for (software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.rds.paginators.DownloadDBLogFilePortionIterable responses = client.downloadDBLogFilePortionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of NumberOfLines won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #downloadDBLogFilePortion(software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DownloadDbLogFilePortionRequest.Builder} avoiding
     * the need to create one manually via {@link DownloadDbLogFilePortionRequest#builder()}
     * </p>
     *
     * @param downloadDbLogFilePortionRequest
     *        A {@link Consumer} that will call methods on {@link DownloadDBLogFilePortionMessage.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbLogFileNotFoundException
     *         <code>LogFileName</code> doesn't refer to an existing DB log file.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.DownloadDBLogFilePortion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DownloadDBLogFilePortion" target="_top">AWS
     *      API Documentation</a>
     */
    default DownloadDBLogFilePortionIterable downloadDBLogFilePortionPaginator(
            Consumer<DownloadDbLogFilePortionRequest.Builder> downloadDbLogFilePortionRequest)
            throws DbInstanceNotFoundException, DbLogFileNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return downloadDBLogFilePortionPaginator(DownloadDbLogFilePortionRequest.builder()
                .applyMutation(downloadDbLogFilePortionRequest).build());
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in
     * the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * For a Multi-AZ DB cluster, failover for a DB cluster promotes one of the readable standby DB instances (read-only
     * instances) in the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists, when the primary DB
     * instance fails. A Multi-AZ DB cluster automatically fails over to a readable standby DB instance when the primary
     * DB instance fails.
     * </p>
     * <p>
     * To simulate a failure of a primary instance for testing, you can force a failover. Because each instance in a DB
     * cluster has its own endpoint address, make sure to clean up and re-establish any existing connections that use
     * those endpoint addresses when the failover is complete.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param failoverDbClusterRequest
     * @return Result of the FailoverDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverDbClusterResponse failoverDBCluster(FailoverDbClusterRequest failoverDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Forces a failover for a DB cluster.
     * </p>
     * <p>
     * For an Aurora DB cluster, failover for a DB cluster promotes one of the Aurora Replicas (read-only instances) in
     * the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * For a Multi-AZ DB cluster, failover for a DB cluster promotes one of the readable standby DB instances (read-only
     * instances) in the DB cluster to be the primary DB instance (the cluster writer).
     * </p>
     * <p>
     * An Amazon Aurora DB cluster automatically fails over to an Aurora Replica, if one exists, when the primary DB
     * instance fails. A Multi-AZ DB cluster automatically fails over to a readable standby DB instance when the primary
     * DB instance fails.
     * </p>
     * <p>
     * To simulate a failure of a primary instance for testing, you can force a failover. Because each instance in a DB
     * cluster has its own endpoint address, make sure to clean up and re-establish any existing connections that use
     * those endpoint addresses when the failover is complete.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link FailoverDbClusterRequest#builder()}
     * </p>
     *
     * @param failoverDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link FailoverDBClusterMessage.Builder} to create a request.
     * @return Result of the FailoverDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.FailoverDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverDbClusterResponse failoverDBCluster(Consumer<FailoverDbClusterRequest.Builder> failoverDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbInstanceStateException,
            AwsServiceException, SdkClientException, RdsException {
        return failoverDBCluster(FailoverDbClusterRequest.builder().applyMutation(failoverDbClusterRequest).build());
    }

    /**
     * <p>
     * Initiates the failover process for an Aurora global database (<a>GlobalCluster</a>).
     * </p>
     * <p>
     * A failover for an Aurora global database promotes one of secondary read-only DB clusters to be the primary DB
     * cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role
     * of the current primary DB cluster and the selected (target) DB cluster are switched. The selected secondary DB
     * cluster assumes full read/write capabilities for the Aurora global database.
     * </p>
     * <p>
     * For more information about failing over an Amazon Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover"
     * >Managed planned failover for Amazon Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies to <a>GlobalCluster</a> (Aurora global databases) only. Use this action only on healthy
     * Aurora global databases with running Aurora DB clusters and no Region-wide outages, to test disaster recovery
     * scenarios or to reconfigure your Aurora global database topology.
     * </p>
     * </note>
     *
     * @param failoverGlobalClusterRequest
     * @return Result of the FailoverGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverGlobalClusterResponse failoverGlobalCluster(FailoverGlobalClusterRequest failoverGlobalClusterRequest)
            throws GlobalClusterNotFoundException, InvalidGlobalClusterStateException, InvalidDbClusterStateException,
            DbClusterNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates the failover process for an Aurora global database (<a>GlobalCluster</a>).
     * </p>
     * <p>
     * A failover for an Aurora global database promotes one of secondary read-only DB clusters to be the primary DB
     * cluster and demotes the primary DB cluster to being a secondary (read-only) DB cluster. In other words, the role
     * of the current primary DB cluster and the selected (target) DB cluster are switched. The selected secondary DB
     * cluster assumes full read/write capabilities for the Aurora global database.
     * </p>
     * <p>
     * For more information about failing over an Amazon Aurora global database, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database-disaster-recovery.html#aurora-global-database-disaster-recovery.managed-failover"
     * >Managed planned failover for Amazon Aurora global databases</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <note>
     * <p>
     * This action applies to <a>GlobalCluster</a> (Aurora global databases) only. Use this action only on healthy
     * Aurora global databases with running Aurora DB clusters and no Region-wide outages, to test disaster recovery
     * scenarios or to reconfigure your Aurora global database topology.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FailoverGlobalClusterRequest.Builder} avoiding the
     * need to create one manually via {@link FailoverGlobalClusterRequest#builder()}
     * </p>
     *
     * @param failoverGlobalClusterRequest
     *        A {@link Consumer} that will call methods on {@link FailoverGlobalClusterMessage.Builder} to create a
     *        request.
     * @return Result of the FailoverGlobalCluster operation returned by the service.
     * @throws GlobalClusterNotFoundException
     *         The <code>GlobalClusterIdentifier</code> doesn't refer to an existing global database cluster.
     * @throws InvalidGlobalClusterStateException
     *         The global cluster is in an invalid state and can't perform the requested operation.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.FailoverGlobalCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/FailoverGlobalCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default FailoverGlobalClusterResponse failoverGlobalCluster(
            Consumer<FailoverGlobalClusterRequest.Builder> failoverGlobalClusterRequest) throws GlobalClusterNotFoundException,
            InvalidGlobalClusterStateException, InvalidDbClusterStateException, DbClusterNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        return failoverGlobalCluster(FailoverGlobalClusterRequest.builder().applyMutation(failoverGlobalClusterRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an Amazon RDS resource.
     * </p>
     * <p>
     * For an overview on tagging an Amazon RDS resource, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws DbInstanceNotFoundException, DbSnapshotNotFoundException, DbClusterNotFoundException,
            DbProxyNotFoundException, DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an Amazon RDS resource.
     * </p>
     * <p>
     * For an overview on tagging an Amazon RDS resource, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Tagging.html">Tagging Amazon RDS
     * Resources</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceMessage.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws BlueGreenDeploymentNotFoundException
     *         <code>BlueGreenDeploymentIdentifier</code> doesn't refer to an existing blue/green deployment.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws DbInstanceNotFoundException,
            DbSnapshotNotFoundException, DbClusterNotFoundException, DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, BlueGreenDeploymentNotFoundException, AwsServiceException, SdkClientException,
            RdsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked
     * policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you
     * can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream
     * isn't required. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html"> Modifying a
     * database activity stream</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation is supported for RDS for Oracle and Microsoft SQL Server.
     * </p>
     *
     * @param modifyActivityStreamRequest
     * @return Result of the ModifyActivityStream operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyActivityStreamResponse modifyActivityStream(ModifyActivityStreamRequest modifyActivityStreamRequest)
            throws InvalidDbInstanceStateException, ResourceNotFoundException, DbInstanceNotFoundException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the audit policy state of a database activity stream to either locked (default) or unlocked. A locked
     * policy is read-only, whereas an unlocked policy is read/write. If your activity stream is started and locked, you
     * can unlock it, customize your audit policy, and then lock your activity stream. Restarting the activity stream
     * isn't required. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/DBActivityStreams.Modifying.html"> Modifying a
     * database activity stream</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * This operation is supported for RDS for Oracle and Microsoft SQL Server.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyActivityStreamRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyActivityStreamRequest#builder()}
     * </p>
     *
     * @param modifyActivityStreamRequest
     *        A {@link Consumer} that will call methods on {@link ModifyActivityStreamRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyActivityStream operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws ResourceNotFoundException
     *         The specified resource ID was not found.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyActivityStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyActivityStream" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyActivityStreamResponse modifyActivityStream(
            Consumer<ModifyActivityStreamRequest.Builder> modifyActivityStreamRequest) throws InvalidDbInstanceStateException,
            ResourceNotFoundException, DbInstanceNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return modifyActivityStream(ModifyActivityStreamRequest.builder().applyMutation(modifyActivityStreamRequest).build());
    }

    /**
     * <p>
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS
     * for new DB instances, or remove the override.
     * </p>
     * <p>
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is
     * different from the default certificate provided by RDS. You can also use this operation to remove the override,
     * so that new DB instances use the default certificate provided by RDS.
     * </p>
     * <p>
     * You might need to override the default certificate in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You already migrated your applications to support the latest certificate authority (CA) certificate, but the new
     * CA certificate is not yet the RDS default CA certificate for the specified Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS has already moved to a new default CA certificate for the specified Amazon Web Services Region, but you are
     * still in the process of supporting the new CA certificate. In this case, you temporarily need additional time to
     * finish your application changes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     *
     * @param modifyCertificatesRequest
     * @return Result of the ModifyCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyCertificatesResponse modifyCertificates(ModifyCertificatesRequest modifyCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS) certificate for Amazon RDS
     * for new DB instances, or remove the override.
     * </p>
     * <p>
     * By using this operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is
     * different from the default certificate provided by RDS. You can also use this operation to remove the override,
     * so that new DB instances use the default certificate provided by RDS.
     * </p>
     * <p>
     * You might need to override the default certificate in the following situations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You already migrated your applications to support the latest certificate authority (CA) certificate, but the new
     * CA certificate is not yet the RDS default CA certificate for the specified Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * RDS has already moved to a new default CA certificate for the specified Amazon Web Services Region, but you are
     * still in the process of supporting the new CA certificate. In this case, you temporarily need additional time to
     * finish your application changes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about rotating your SSL/TLS certificate for RDS DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <p>
     * For more information about rotating your SSL/TLS certificate for Aurora DB engines, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL-certificate-rotation.html">
     * Rotating Your SSL/TLS Certificate</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyCertificatesRequest#builder()}
     * </p>
     *
     * @param modifyCertificatesRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCertificatesMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyCertificates operation returned by the service.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyCertificatesResponse modifyCertificates(Consumer<ModifyCertificatesRequest.Builder> modifyCertificatesRequest)
            throws CertificateNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return modifyCertificates(ModifyCertificatesRequest.builder().applyMutation(modifyCertificatesRequest).build());
    }

    /**
     * <p>
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     * </p>
     * <p>
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might
     * not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call
     * <code>ModifyCurrentDBClusterCapacity</code> to set the capacity explicitly.
     * </p>
     * <p>
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale the DB cluster based
     * on the cooldown period for scaling up and the cooldown period for scaling down.
     * </p>
     * <p>
     * For more information about Aurora Serverless v1, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
     * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you call <code>ModifyCurrentDBClusterCapacity</code> with the default <code>TimeoutAction</code>, connections
     * that prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about
     * scaling points, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     * > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * This action only applies to Aurora Serverless v1 DB clusters.
     * </p>
     * </note>
     *
     * @param modifyCurrentDbClusterCapacityRequest
     * @return Result of the ModifyCurrentDBClusterCapacity operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterCapacityException
     *         <code>Capacity</code> isn't a valid Aurora Serverless DB cluster capacity. Valid capacity values are
     *         <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>,
     *         <code>128</code>, and <code>256</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCurrentDBClusterCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyCurrentDbClusterCapacityResponse modifyCurrentDBClusterCapacity(
            ModifyCurrentDbClusterCapacityRequest modifyCurrentDbClusterCapacityRequest) throws DbClusterNotFoundException,
            InvalidDbClusterStateException, InvalidDbClusterCapacityException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Set the capacity of an Aurora Serverless v1 DB cluster to a specific value.
     * </p>
     * <p>
     * Aurora Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the capacity might
     * not scale fast enough to meet a sudden change in workload, such as a large number of new transactions. Call
     * <code>ModifyCurrentDBClusterCapacity</code> to set the capacity explicitly.
     * </p>
     * <p>
     * After this call sets the DB cluster capacity, Aurora Serverless v1 can automatically scale the DB cluster based
     * on the cooldown period for scaling up and the cooldown period for scaling down.
     * </p>
     * <p>
     * For more information about Aurora Serverless v1, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html">Using Amazon Aurora
     * Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you call <code>ModifyCurrentDBClusterCapacity</code> with the default <code>TimeoutAction</code>, connections
     * that prevent Aurora Serverless v1 from finding a scaling point might be dropped. For more information about
     * scaling points, see <a href=
     * "https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling"
     * > Autoscaling for Aurora Serverless v1</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * This action only applies to Aurora Serverless v1 DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCurrentDbClusterCapacityRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyCurrentDbClusterCapacityRequest#builder()}
     * </p>
     *
     * @param modifyCurrentDbClusterCapacityRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCurrentDBClusterCapacityMessage.Builder} to
     *        create a request.
     * @return Result of the ModifyCurrentDBClusterCapacity operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterCapacityException
     *         <code>Capacity</code> isn't a valid Aurora Serverless DB cluster capacity. Valid capacity values are
     *         <code>2</code>, <code>4</code>, <code>8</code>, <code>16</code>, <code>32</code>, <code>64</code>,
     *         <code>128</code>, and <code>256</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCurrentDBClusterCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCurrentDBClusterCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyCurrentDbClusterCapacityResponse modifyCurrentDBClusterCapacity(
            Consumer<ModifyCurrentDbClusterCapacityRequest.Builder> modifyCurrentDbClusterCapacityRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, InvalidDbClusterCapacityException,
            AwsServiceException, SdkClientException, RdsException {
        return modifyCurrentDBClusterCapacity(ModifyCurrentDbClusterCapacityRequest.builder()
                .applyMutation(modifyCurrentDbClusterCapacityRequest).build());
    }

    /**
     * <p>
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
     * <code>DescribeDBEngineVersions</code>.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>ModifyCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>ModifyCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV
     * status</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param modifyCustomDbEngineVersionRequest
     * @return Result of the ModifyCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionNotFoundException
     *         The specified CEV was not found.
     * @throws InvalidCustomDbEngineVersionStateException
     *         You can't delete the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyCustomDbEngineVersionResponse modifyCustomDBEngineVersion(
            ModifyCustomDbEngineVersionRequest modifyCustomDbEngineVersionRequest) throws CustomDbEngineVersionNotFoundException,
            InvalidCustomDbEngineVersionStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the status of a custom engine version (CEV). You can find CEVs to modify by calling
     * <code>DescribeDBEngineVersions</code>.
     * </p>
     * <note>
     * <p>
     * The MediaImport service that imports files from Amazon S3 to create CEVs isn't integrated with Amazon Web
     * Services CloudTrail. If you turn on data logging for Amazon RDS in CloudTrail, calls to the
     * <code>ModifyCustomDbEngineVersion</code> event aren't logged. However, you might see calls from the API gateway
     * that accesses your Amazon S3 bucket. These calls originate from the MediaImport service for the
     * <code>ModifyCustomDbEngineVersion</code> event.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.modify">Modifying CEV
     * status</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyCustomDbEngineVersionRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyCustomDbEngineVersionRequest#builder()}
     * </p>
     *
     * @param modifyCustomDbEngineVersionRequest
     *        A {@link Consumer} that will call methods on {@link ModifyCustomDBEngineVersionMessage.Builder} to create
     *        a request.
     * @return Result of the ModifyCustomDBEngineVersion operation returned by the service.
     * @throws CustomDbEngineVersionNotFoundException
     *         The specified CEV was not found.
     * @throws InvalidCustomDbEngineVersionStateException
     *         You can't delete the CEV.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyCustomDBEngineVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyCustomDBEngineVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyCustomDbEngineVersionResponse modifyCustomDBEngineVersion(
            Consumer<ModifyCustomDbEngineVersionRequest.Builder> modifyCustomDbEngineVersionRequest)
            throws CustomDbEngineVersionNotFoundException, InvalidCustomDbEngineVersionStateException, AwsServiceException,
            SdkClientException, RdsException {
        return modifyCustomDBEngineVersion(ModifyCustomDbEngineVersionRequest.builder()
                .applyMutation(modifyCustomDbEngineVersionRequest).build());
    }

    /**
     * <p>
     * Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more
     * settings by specifying these parameters and the new values in the request.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     *
     * @param modifyDbClusterRequest
     * @return Result of the ModifyDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws StorageTypeNotAvailableException
     *         The <code>aurora-iopt1</code> storage type isn't available, because you modified the DB cluster to use
     *         this storage type less than one month ago.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbClusterResponse modifyDBCluster(ModifyDbClusterRequest modifyDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException,
            InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException,
            InvalidDbInstanceStateException, DbClusterAlreadyExistsException, DbInstanceAlreadyExistsException,
            DomainNotFoundException, StorageTypeNotAvailableException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can change one or more
     * settings by specifying these parameters and the new values in the request.
     * </p>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbClusterRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterMessage.Builder} to create a request.
     * @return Result of the ModifyDBCluster operation returned by the service.
     * @throws DbClusterNotFoundException
     *         <code>DBClusterIdentifier</code> doesn't refer to an existing DB cluster.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws InvalidDbSubnetGroupStateException
     *         The DB subnet group cannot be deleted because it's in use.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws DbClusterParameterGroupNotFoundException
     *         <code>DBClusterParameterGroupName</code> doesn't refer to an existing DB cluster parameter group.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws DbClusterAlreadyExistsException
     *         The user already has a DB cluster with the given identifier.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws StorageTypeNotAvailableException
     *         The <code>aurora-iopt1</code> storage type isn't available, because you modified the DB cluster to use
     *         this storage type less than one month ago.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBCluster
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBCluster" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbClusterResponse modifyDBCluster(Consumer<ModifyDbClusterRequest.Builder> modifyDbClusterRequest)
            throws DbClusterNotFoundException, InvalidDbClusterStateException, StorageQuotaExceededException,
            DbSubnetGroupNotFoundException, InvalidVpcNetworkStateException, InvalidDbSubnetGroupStateException,
            InvalidSubnetException, DbClusterParameterGroupNotFoundException, InvalidDbSecurityGroupStateException,
            InvalidDbInstanceStateException, DbClusterAlreadyExistsException, DbInstanceAlreadyExistsException,
            DomainNotFoundException, StorageTypeNotAvailableException, AwsServiceException, SdkClientException, RdsException {
        return modifyDBCluster(ModifyDbClusterRequest.builder().applyMutation(modifyDbClusterRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note>
     *
     * @param modifyDbClusterEndpointRequest
     * @return Result of the ModifyDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation can't be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbClusterEndpointResponse modifyDBClusterEndpoint(ModifyDbClusterEndpointRequest modifyDbClusterEndpointRequest)
            throws InvalidDbClusterStateException, InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException,
            DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of an endpoint in an Amazon Aurora DB cluster.
     * </p>
     * <note>
     * <p>
     * This action only applies to Aurora DB clusters.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyDbClusterEndpointRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterEndpointRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterEndpointMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyDBClusterEndpoint operation returned by the service.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws InvalidDbClusterEndpointStateException
     *         The requested operation can't be performed on the endpoint while the endpoint is in this state.
     * @throws DbClusterEndpointNotFoundException
     *         The specified custom endpoint doesn't exist.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbClusterEndpointResponse modifyDBClusterEndpoint(
            Consumer<ModifyDbClusterEndpointRequest.Builder> modifyDbClusterEndpointRequest)
            throws InvalidDbClusterStateException, InvalidDbClusterEndpointStateException, DbClusterEndpointNotFoundException,
            DbInstanceNotFoundException, InvalidDbInstanceStateException, AwsServiceException, SdkClientException, RdsException {
        return modifyDBClusterEndpoint(ModifyDbClusterEndpointRequest.builder().applyMutation(modifyDbClusterEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS
     * console</a> or the <code>DescribeDBClusterParameters</code> operation to verify that your DB cluster parameter
     * group has been created or modified.
     * </p>
     * <p>
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the update
     * immediately. The cluster restart might interrupt your workload. In that case, your application must reopen any
     * connections and retry any transactions that were active when the parameter changes took effect.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     * @return Result of the ModifyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(
            ModifyDbClusterParameterGroupRequest modifyDbClusterParameterGroupRequest) throws DbParameterGroupNotFoundException,
            InvalidDbParameterGroupStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB cluster parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you create a DB cluster parameter group, you should wait at least 5 minutes before creating your first DB
     * cluster that uses that DB cluster parameter group as the default parameter group. This allows Amazon RDS to fully
     * complete the create action before the parameter group is used as the default for a new DB cluster. This is
     * especially important for parameters that are critical when creating the default database for a DB cluster, such
     * as the character set for the default database defined by the <code>character_set_database</code> parameter. You
     * can use the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS
     * console</a> or the <code>DescribeDBClusterParameters</code> operation to verify that your DB cluster parameter
     * group has been created or modified.
     * </p>
     * <p>
     * If the modified DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the update
     * immediately. The cluster restart might interrupt your workload. In that case, your application must reopen any
     * connections and retry any transactions that were active when the parameter changes took effect.
     * </p>
     * </important>
     * <p>
     * For more information on Amazon Aurora DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_AuroraOverview.html"> What is Amazon
     * Aurora?</a> in the <i>Amazon Aurora User Guide</i>.
     * </p>
     * <p>
     * For more information on Multi-AZ DB clusters, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/multi-az-db-clusters-concepts.html"> Multi-AZ DB
     * cluster deployments</a> in the <i>Amazon RDS User Guide.</i>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterParameterGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterParameterGroupMessage.Builder} to
     *        create a request.
     * @return Result of the ModifyDBClusterParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterParameterGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterParameterGroupResponse modifyDBClusterParameterGroup(
            Consumer<ModifyDbClusterParameterGroupRequest.Builder> modifyDbClusterParameterGroupRequest)
            throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException,
            SdkClientException, RdsException {
        return modifyDBClusterParameterGroup(ModifyDbClusterParameterGroupRequest.builder()
                .applyMutation(modifyDbClusterParameterGroupRequest).build());
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify <code>restore</code> as
     * the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * Web Services accounts that are authorized to restore the manual DB cluster snapshot. Use the value
     * <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by
     * all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB cluster snapshots that contain private information that
     * you don't want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized
     * Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a
     * value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster snapshot, or
     * whether a manual DB cluster snapshot is public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API
     * operation. The accounts are returned as values for the <code>restore</code> attribute.
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     * @return Result of the ModifyDBClusterSnapshotAttribute operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(
            ModifyDbClusterSnapshotAttributeRequest modifyDbClusterSnapshotAttributeRequest)
            throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException,
            SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot.
     * </p>
     * <p>
     * To share a manual DB cluster snapshot with other Amazon Web Services accounts, specify <code>restore</code> as
     * the <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon
     * Web Services accounts that are authorized to restore the manual DB cluster snapshot. Use the value
     * <code>all</code> to make the manual DB cluster snapshot public, which means that it can be copied or restored by
     * all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB cluster snapshots that contain private information that
     * you don't want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If a manual DB cluster snapshot is encrypted, it can be shared, but only by specifying a list of authorized
     * Amazon Web Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a
     * value for that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB cluster snapshot, or
     * whether a manual DB cluster snapshot is public or private, use the <a>DescribeDBClusterSnapshotAttributes</a> API
     * operation. The accounts are returned as values for the <code>restore</code> attribute.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbClusterSnapshotAttributeRequest.Builder}
     * avoiding the need to create one manually via {@link ModifyDbClusterSnapshotAttributeRequest#builder()}
     * </p>
     *
     * @param modifyDbClusterSnapshotAttributeRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBClusterSnapshotAttributeMessage.Builder} to
     *        create a request.
     * @return Result of the ModifyDBClusterSnapshotAttribute operation returned by the service.
     * @throws DbClusterSnapshotNotFoundException
     *         <code>DBClusterSnapshotIdentifier</code> doesn't refer to an existing DB cluster snapshot.
     * @throws InvalidDbClusterSnapshotStateException
     *         The supplied value isn't a valid DB cluster snapshot state.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBClusterSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBClusterSnapshotAttribute"
     *      target="_top">AWS API Documentation</a>
     */
    default ModifyDbClusterSnapshotAttributeResponse modifyDBClusterSnapshotAttribute(
            Consumer<ModifyDbClusterSnapshotAttributeRequest.Builder> modifyDbClusterSnapshotAttributeRequest)
            throws DbClusterSnapshotNotFoundException, InvalidDbClusterSnapshotStateException,
            SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException, RdsException {
        return modifyDBClusterSnapshotAttribute(ModifyDbClusterSnapshotAttributeRequest.builder()
                .applyMutation(modifyDbClusterSnapshotAttributeRequest).build());
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <code>DescribeValidDBInstanceModifications</code> before you call <code>ModifyDBInstance</code>.
     * </p>
     *
     * @param modifyDbInstanceRequest
     * @return Result of the ModifyDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbUpgradeDependencyFailureException
     *         The DB upgrade failed because a resource the DB depends on can't be modified.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbInstanceResponse modifyDBInstance(ModifyDbInstanceRequest modifyDbInstanceRequest)
            throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException,
            InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException,
            ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbUpgradeDependencyFailureException,
            StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException,
            DomainNotFoundException, KmsKeyNotAccessibleException, InvalidDbClusterStateException,
            NetworkTypeNotSupportedException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies settings for a DB instance. You can change one or more database configuration parameters by specifying
     * these parameters and the new values in the request. To learn what modifications you can make to your DB instance,
     * call <code>DescribeValidDBInstanceModifications</code> before you call <code>ModifyDBInstance</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbInstanceRequest#builder()}
     * </p>
     *
     * @param modifyDbInstanceRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBInstanceMessage.Builder} to create a request.
     * @return Result of the ModifyDBInstance operation returned by the service.
     * @throws InvalidDbInstanceStateException
     *         The DB instance isn't in a valid state.
     * @throws InvalidDbSecurityGroupStateException
     *         The state of the DB security group doesn't allow deletion.
     * @throws DbInstanceAlreadyExistsException
     *         The user already has a DB instance with the given identifier.
     * @throws DbInstanceNotFoundException
     *         <code>DBInstanceIdentifier</code> doesn't refer to an existing DB instance.
     * @throws DbSecurityGroupNotFoundException
     *         <code>DBSecurityGroupName</code> doesn't refer to an existing DB security group.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InsufficientDbInstanceCapacityException
     *         The specified DB instance class isn't available in the specified Availability Zone.
     * @throws StorageQuotaExceededException
     *         The request would result in the user exceeding the allowed amount of storage available across all DB
     *         instances.
     * @throws InvalidVpcNetworkStateException
     *         The DB subnet group doesn't cover all Availability Zones after it's created because of users' change.
     * @throws ProvisionedIopsNotAvailableInAzException
     *         Provisioned IOPS not available in the specified Availability Zone.
     * @throws OptionGroupNotFoundException
     *         The specified option group could not be found.
     * @throws DbUpgradeDependencyFailureException
     *         The DB upgrade failed because a resource the DB depends on can't be modified.
     * @throws StorageTypeNotSupportedException
     *         The specified <code>StorageType</code> can't be associated with the DB instance.
     * @throws AuthorizationNotFoundException
     *         The specified CIDR IP range or Amazon EC2 security group might not be authorized for the specified DB
     *         security group.</p>
     *         <p>
     *         Or, RDS might not be authorized to perform necessary actions using IAM on your behalf.
     * @throws CertificateNotFoundException
     *         <code>CertificateIdentifier</code> doesn't refer to an existing certificate.
     * @throws DomainNotFoundException
     *         <code>Domain</code> doesn't refer to an existing Active Directory domain.
     * @throws KmsKeyNotAccessibleException
     *         An error occurred accessing an Amazon Web Services KMS key.
     * @throws InvalidDbClusterStateException
     *         The requested operation can't be performed while the cluster is in this state.
     * @throws NetworkTypeNotSupportedException
     *         The network type is invalid for the DB instance. Valid nework type values are <code>IPV4</code> and
     *         <code>DUAL</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbInstanceResponse modifyDBInstance(Consumer<ModifyDbInstanceRequest.Builder> modifyDbInstanceRequest)
            throws InvalidDbInstanceStateException, InvalidDbSecurityGroupStateException, DbInstanceAlreadyExistsException,
            DbInstanceNotFoundException, DbSecurityGroupNotFoundException, DbParameterGroupNotFoundException,
            InsufficientDbInstanceCapacityException, StorageQuotaExceededException, InvalidVpcNetworkStateException,
            ProvisionedIopsNotAvailableInAzException, OptionGroupNotFoundException, DbUpgradeDependencyFailureException,
            StorageTypeNotSupportedException, AuthorizationNotFoundException, CertificateNotFoundException,
            DomainNotFoundException, KmsKeyNotAccessibleException, InvalidDbClusterStateException,
            NetworkTypeNotSupportedException, AwsServiceException, SdkClientException, RdsException {
        return modifyDBInstance(ModifyDbInstanceRequest.builder().applyMutation(modifyDbInstanceRequest).build());
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important>
     *
     * @param modifyDbParameterGroupRequest
     * @return Result of the ModifyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbParameterGroupResponse modifyDBParameterGroup(ModifyDbParameterGroupRequest modifyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException,
            SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the parameters of a DB parameter group. To modify more than one parameter, submit a list of the
     * following: <code>ParameterName</code>, <code>ParameterValue</code>, and <code>ApplyMethod</code>. A maximum of 20
     * parameters can be modified in a single request.
     * </p>
     * <important>
     * <p>
     * After you modify a DB parameter group, you should wait at least 5 minutes before creating your first DB instance
     * that uses that DB parameter group as the default parameter group. This allows Amazon RDS to fully complete the
     * modify action before the parameter group is used as the default for a new DB instance. This is especially
     * important for parameters that are critical when creating the default database for a DB instance, such as the
     * character set for the default database defined by the <code>character_set_database</code> parameter. You can use
     * the <i>Parameter Groups</i> option of the <a href="https://console.aws.amazon.com/rds/">Amazon RDS console</a> or
     * the <i>DescribeDBParameters</i> command to verify that your DB parameter group has been created or modified.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbParameterGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbParameterGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbParameterGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBParameterGroupMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyDBParameterGroup operation returned by the service.
     * @throws DbParameterGroupNotFoundException
     *         <code>DBParameterGroupName</code> doesn't refer to an existing DB parameter group.
     * @throws InvalidDbParameterGroupStateException
     *         The DB parameter group is in use or is in an invalid state. If you are attempting to delete the parameter
     *         group, you can't delete it when the parameter group is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBParameterGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBParameterGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbParameterGroupResponse modifyDBParameterGroup(
            Consumer<ModifyDbParameterGroupRequest.Builder> modifyDbParameterGroupRequest)
            throws DbParameterGroupNotFoundException, InvalidDbParameterGroupStateException, AwsServiceException,
            SdkClientException, RdsException {
        return modifyDBParameterGroup(ModifyDbParameterGroupRequest.builder().applyMutation(modifyDbParameterGroupRequest)
                .build());
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy.
     * </p>
     *
     * @param modifyDbProxyRequest
     * @return Result of the ModifyDBProxy operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyAlreadyExistsException
     *         The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbProxyResponse modifyDBProxy(ModifyDbProxyRequest modifyDbProxyRequest) throws DbProxyNotFoundException,
            DbProxyAlreadyExistsException, InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbProxyRequest.Builder} avoiding the need to
     * create one manually via {@link ModifyDbProxyRequest#builder()}
     * </p>
     *
     * @param modifyDbProxyRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBProxyRequest.Builder} to create a request.
     * @return Result of the ModifyDBProxy operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyAlreadyExistsException
     *         The specified proxy name must be unique for all proxies owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxy" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbProxyResponse modifyDBProxy(Consumer<ModifyDbProxyRequest.Builder> modifyDbProxyRequest)
            throws DbProxyNotFoundException, DbProxyAlreadyExistsException, InvalidDbProxyStateException, AwsServiceException,
            SdkClientException, RdsException {
        return modifyDBProxy(ModifyDbProxyRequest.builder().applyMutation(modifyDbProxyRequest).build());
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy endpoint.
     * </p>
     *
     * @param modifyDbProxyEndpointRequest
     * @return Result of the ModifyDBProxyEndpoint operation returned by the service.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws DbProxyEndpointAlreadyExistsException
     *         The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws InvalidDbProxyEndpointStateException
     *         You can't perform this operation while the DB proxy endpoint is in a particular state.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbProxyEndpointResponse modifyDBProxyEndpoint(ModifyDbProxyEndpointRequest modifyDbProxyEndpointRequest)
            throws DbProxyEndpointNotFoundException, DbProxyEndpointAlreadyExistsException, InvalidDbProxyEndpointStateException,
            InvalidDbProxyStateException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Changes the settings for an existing DB proxy endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbProxyEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbProxyEndpointRequest#builder()}
     * </p>
     *
     * @param modifyDbProxyEndpointRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBProxyEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyDBProxyEndpoint operation returned by the service.
     * @throws DbProxyEndpointNotFoundException
     *         The DB proxy endpoint doesn't exist.
     * @throws DbProxyEndpointAlreadyExistsException
     *         The specified DB proxy endpoint name must be unique for all DB proxy endpoints owned by your Amazon Web
     *         Services account in the specified Amazon Web Services Region.
     * @throws InvalidDbProxyEndpointStateException
     *         You can't perform this operation while the DB proxy endpoint is in a particular state.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxyEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbProxyEndpointResponse modifyDBProxyEndpoint(
            Consumer<ModifyDbProxyEndpointRequest.Builder> modifyDbProxyEndpointRequest) throws DbProxyEndpointNotFoundException,
            DbProxyEndpointAlreadyExistsException, InvalidDbProxyEndpointStateException, InvalidDbProxyStateException,
            AwsServiceException, SdkClientException, RdsException {
        return modifyDBProxyEndpoint(ModifyDbProxyEndpointRequest.builder().applyMutation(modifyDbProxyEndpointRequest).build());
    }

    /**
     * <p>
     * Modifies the properties of a <code>DBProxyTargetGroup</code>.
     * </p>
     *
     * @param modifyDbProxyTargetGroupRequest
     * @return Result of the ModifyDBProxyTargetGroup operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbProxyTargetGroupResponse modifyDBProxyTargetGroup(
            ModifyDbProxyTargetGroupRequest modifyDbProxyTargetGroupRequest) throws DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies the properties of a <code>DBProxyTargetGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbProxyTargetGroupRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyDbProxyTargetGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbProxyTargetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBProxyTargetGroupRequest.Builder} to create a
     *        request.
     * @return Result of the ModifyDBProxyTargetGroup operation returned by the service.
     * @throws DbProxyNotFoundException
     *         The specified proxy name doesn't correspond to a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws DbProxyTargetGroupNotFoundException
     *         The specified target group isn't available for a proxy owned by your Amazon Web Services account in the
     *         specified Amazon Web Services Region.
     * @throws InvalidDbProxyStateException
     *         The requested operation can't be performed while the proxy is in this state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBProxyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBProxyTargetGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbProxyTargetGroupResponse modifyDBProxyTargetGroup(
            Consumer<ModifyDbProxyTargetGroupRequest.Builder> modifyDbProxyTargetGroupRequest) throws DbProxyNotFoundException,
            DbProxyTargetGroupNotFoundException, InvalidDbProxyStateException, AwsServiceException, SdkClientException,
            RdsException {
        return modifyDBProxyTargetGroup(ModifyDbProxyTargetGroupRequest.builder().applyMutation(modifyDbProxyTargetGroupRequest)
                .build());
    }

    /**
     * <p>
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not
     * shared or public.
     * </p>
     * <p>
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This command doesn't apply to RDS
     * Custom.
     * </p>
     *
     * @param modifyDbSnapshotRequest
     * @return Result of the ModifyDBSnapshot operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbSnapshotResponse modifyDBSnapshot(ModifyDbSnapshotRequest modifyDbSnapshotRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or unencrypted, but not
     * shared or public.
     * </p>
     * <p>
     * Amazon RDS supports upgrading DB snapshots for MySQL, PostgreSQL, and Oracle. This command doesn't apply to RDS
     * Custom.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link ModifyDbSnapshotRequest#builder()}
     * </p>
     *
     * @param modifyDbSnapshotRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBSnapshotMessage.Builder} to create a request.
     * @return Result of the ModifyDBSnapshot operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbSnapshotResponse modifyDBSnapshot(Consumer<ModifyDbSnapshotRequest.Builder> modifyDbSnapshotRequest)
            throws DbSnapshotNotFoundException, AwsServiceException, SdkClientException, RdsException {
        return modifyDBSnapshot(ModifyDbSnapshotRequest.builder().applyMutation(modifyDbSnapshotRequest).build());
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     * </p>
     * <p>
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web
     * Services accounts that are authorized to restore the manual DB snapshot. Uses the value <code>all</code> to make
     * the manual DB snapshot public, which means it can be copied or restored by all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB snapshots that contain private information that you don't
     * want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web
     * Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for
     * that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or whether a
     * manual DB snapshot public or private, use the <a>DescribeDBSnapshotAttributes</a> API operation. The accounts are
     * returned as values for the <code>restore</code> attribute.
     * </p>
     *
     * @param modifyDbSnapshotAttributeRequest
     * @return Result of the ModifyDBSnapshotAttribute operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbSnapshotAttributeResponse modifyDBSnapshotAttribute(
            ModifyDbSnapshotAttributeRequest modifyDbSnapshotAttributeRequest) throws DbSnapshotNotFoundException,
            InvalidDbSnapshotStateException, SharedSnapshotQuotaExceededException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an attribute and values to, or removes an attribute and values from, a manual DB snapshot.
     * </p>
     * <p>
     * To share a manual DB snapshot with other Amazon Web Services accounts, specify <code>restore</code> as the
     * <code>AttributeName</code> and use the <code>ValuesToAdd</code> parameter to add a list of IDs of the Amazon Web
     * Services accounts that are authorized to restore the manual DB snapshot. Uses the value <code>all</code> to make
     * the manual DB snapshot public, which means it can be copied or restored by all Amazon Web Services accounts.
     * </p>
     * <note>
     * <p>
     * Don't add the <code>all</code> value for any manual DB snapshots that contain private information that you don't
     * want available to all Amazon Web Services accounts.
     * </p>
     * </note>
     * <p>
     * If the manual DB snapshot is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web
     * Services account IDs for the <code>ValuesToAdd</code> parameter. You can't use <code>all</code> as a value for
     * that parameter in this case.
     * </p>
     * <p>
     * To view which Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or whether a
     * manual DB snapshot public or private, use the <a>DescribeDBSnapshotAttributes</a> API operation. The accounts are
     * returned as values for the <code>restore</code> attribute.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbSnapshotAttributeRequest.Builder} avoiding
     * the need to create one manually via {@link ModifyDbSnapshotAttributeRequest#builder()}
     * </p>
     *
     * @param modifyDbSnapshotAttributeRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBSnapshotAttributeMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyDBSnapshotAttribute operation returned by the service.
     * @throws DbSnapshotNotFoundException
     *         <code>DBSnapshotIdentifier</code> doesn't refer to an existing DB snapshot.
     * @throws InvalidDbSnapshotStateException
     *         The state of the DB snapshot doesn't allow deletion.
     * @throws SharedSnapshotQuotaExceededException
     *         You have exceeded the maximum number of accounts that you can share a manual DB snapshot with.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSnapshotAttribute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSnapshotAttribute" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyDbSnapshotAttributeResponse modifyDBSnapshotAttribute(
            Consumer<ModifyDbSnapshotAttributeRequest.Builder> modifyDbSnapshotAttributeRequest)
            throws DbSnapshotNotFoundException, InvalidDbSnapshotStateException, SharedSnapshotQuotaExceededException,
            AwsServiceException, SdkClientException, RdsException {
        return modifyDBSnapshotAttribute(ModifyDbSnapshotAttributeRequest.builder()
                .applyMutation(modifyDbSnapshotAttributeRequest).build());
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Web Services Region.
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     * @return Result of the ModifyDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetQuotaExceededException
     *         The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws SubnetAlreadyInUseException
     *         The DB subnet is already in use in the Availability Zone.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbSubnetGroupResponse modifyDBSubnetGroup(ModifyDbSubnetGroupRequest modifyDbSubnetGroupRequest)
            throws DbSubnetGroupNotFoundException, DbSubnetQuotaExceededException, SubnetAlreadyInUseException,
            DbSubnetGroupDoesNotCoverEnoughAZsException, InvalidSubnetException, AwsServiceException, SdkClientException,
            RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in at least two AZs in
     * the Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ModifyDbSubnetGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ModifyDbSubnetGroupRequest#builder()}
     * </p>
     *
     * @param modifyDbSubnetGroupRequest
     *        A {@link Consumer} that will call methods on {@link ModifyDBSubnetGroupMessage.Builder} to create a
     *        request.
     * @return Result of the ModifyDBSubnetGroup operation returned by the service.
     * @throws DbSubnetGroupNotFoundException
     *         <code>DBSubnetGroupName</code> doesn't refer to an existing DB subnet group.
     * @throws DbSubnetQuotaExceededException
     *         The request would result in the user exceeding the allowed number of subnets in a DB subnet groups.
     * @throws SubnetAlreadyInUseException
     *         The DB subnet is already in use in the Availability Zone.
     * @throws DbSubnetGroupDoesNotCoverEnoughAZsException
     *         Subnets in the DB subnet group should cover at least two Availability Zones unless there is only one
     *         Availability Zone.
     * @throws InvalidSubnetException
     *         The requested subnet is invalid, or multiple subnets were requested that are not all in a common VPC.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyDBSubnetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyDBSubnetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default ModifyDbSubnetGroupResponse modifyDBSubnetGroup(
            Consumer<ModifyDbSubnetGroupRequest.Builder> modifyDbSubnetGroupRequest) throws DbSubnetGroupNotFoundException,
            DbSubnetQuotaExceededException, SubnetAlreadyInUseException, DbSubnetGroupDoesNotCoverEnoughAZsException,
            InvalidSubnetException, AwsServiceException, SdkClientException, RdsException {
        return modifyDBSubnetGroup(ModifyDbSubnetGroupRequest.builder().applyMutation(modifyDbSubnetGroupRequest).build());
    }

    /**
     * <p>
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this
     * call. To change source identifiers for a subscription, use the <code>AddSourceIdentifierToSubscription</code> and
     * <code>RemoveSourceIdentifierFromSubscription</code> calls.
     * </p>
     * <p>
     * You can see a list of the event categories for a given source type (<code>SourceType</code>) in <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> in the <i>Amazon RDS
     * User Guide</i> or by using the <code>DescribeEventCategories</code> operation.
     * </p>
     *
     * @param modifyEventSubscriptionRequest
     * @return Result of the ModifyEventSubscription operation returned by the service.
     * @throws EventSubscriptionQuotaExceededException
     *         You have reached the maximum number of event subscriptions.
     * @throws SubscriptionNotFoundException
     *         The subscription name does not exist.
     * @throws SnsInvalidTopicException
     *         SNS has responded that there is a problem with the SNS topic specified.
     * @throws SnsNoAuthorizationException
     *         You do not have permission to publish to the SNS topic ARN.
     * @throws SnsTopicArnNotFoundException
     *         The SNS topic ARN does not exist.
     * @throws SubscriptionCategoryNotFoundException
     *         The supplied category does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RdsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RdsClient.ModifyEventSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/ModifyEventSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default ModifyEventSubscriptionResponse modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest)
            throws EventSubscriptionQuotaExceededException, SubscriptionNotFoundException, SnsInvalidTopicException,
            SnsNoAuthorizationException, SnsTopicArnNotFoundException, SubscriptionCategoryNotFoundException,
            AwsServiceException, SdkClientException, RdsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Modifies an existing RDS event notification subscription. You can't modify the source identifiers using this
     * call. To change source identifiers for a subscription, use the <code>AddSourceIdentifierToSubscription</code> and
     * <co