/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailoverDbClusterResponse extends RdsResponse implements
        ToCopyableBuilder<FailoverDbClusterResponse.Builder, FailoverDbClusterResponse> {
    private static final SdkField<DBCluster> DB_CLUSTER_FIELD = SdkField.<DBCluster> builder(MarshallingType.SDK_POJO)
            .memberName("DBCluster").getter(getter(FailoverDbClusterResponse::dbCluster)).setter(setter(Builder::dbCluster))
            .constructor(DBCluster::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_FIELD));

    private final DBCluster dbCluster;

    private FailoverDbClusterResponse(BuilderImpl builder) {
        super(builder);
        this.dbCluster = builder.dbCluster;
    }

    /**
     * Returns the value of the DBCluster property for this object.
     * 
     * @return The value of the DBCluster property for this object.
     */
    public final DBCluster dbCluster() {
        return dbCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverDbClusterResponse)) {
            return false;
        }
        FailoverDbClusterResponse other = (FailoverDbClusterResponse) obj;
        return Objects.equals(dbCluster(), other.dbCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FailoverDbClusterResponse").add("DBCluster", dbCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBCluster":
            return Optional.ofNullable(clazz.cast(dbCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailoverDbClusterResponse, T> g) {
        return obj -> g.apply((FailoverDbClusterResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, FailoverDbClusterResponse> {
        /**
         * Sets the value of the DBCluster property for this object.
         *
         * @param dbCluster
         *        The new value for the DBCluster property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbCluster(DBCluster dbCluster);

        /**
         * Sets the value of the DBCluster property for this object.
         *
         * This is a convenience that creates an instance of the {@link DBCluster.Builder} avoiding the need to create
         * one manually via {@link DBCluster#builder()}.
         *
         * When the {@link Consumer} completes, {@link DBCluster.Builder#build()} is called immediately and its result
         * is passed to {@link #dbCluster(DBCluster)}.
         * 
         * @param dbCluster
         *        a consumer that will call methods on {@link DBCluster.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbCluster(DBCluster)
         */
        default Builder dbCluster(Consumer<DBCluster.Builder> dbCluster) {
            return dbCluster(DBCluster.builder().applyMutation(dbCluster).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private DBCluster dbCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverDbClusterResponse model) {
            super(model);
            dbCluster(model.dbCluster);
        }

        public final DBCluster.Builder getDbCluster() {
            return dbCluster != null ? dbCluster.toBuilder() : null;
        }

        public final void setDbCluster(DBCluster.BuilderImpl dbCluster) {
            this.dbCluster = dbCluster != null ? dbCluster.build() : null;
        }

        @Override
        @Transient
        public final Builder dbCluster(DBCluster dbCluster) {
            this.dbCluster = dbCluster;
            return this;
        }

        @Override
        public FailoverDbClusterResponse build() {
            return new FailoverDbClusterResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
