/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This data type is used as a response element to <code>DownloadDBLogFilePortion</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DownloadDbLogFilePortionResponse extends RdsResponse implements
        ToCopyableBuilder<DownloadDbLogFilePortionResponse.Builder, DownloadDbLogFilePortionResponse> {
    private static final SdkField<String> LOG_FILE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFileData").getter(getter(DownloadDbLogFilePortionResponse::logFileData))
            .setter(setter(Builder::logFileData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileData").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DownloadDbLogFilePortionResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Boolean> ADDITIONAL_DATA_PENDING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AdditionalDataPending").getter(getter(DownloadDbLogFilePortionResponse::additionalDataPending))
            .setter(setter(Builder::additionalDataPending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDataPending").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FILE_DATA_FIELD,
            MARKER_FIELD, ADDITIONAL_DATA_PENDING_FIELD));

    private final String logFileData;

    private final String marker;

    private final Boolean additionalDataPending;

    private DownloadDbLogFilePortionResponse(BuilderImpl builder) {
        super(builder);
        this.logFileData = builder.logFileData;
        this.marker = builder.marker;
        this.additionalDataPending = builder.additionalDataPending;
    }

    /**
     * <p>
     * Entries from the specified log file.
     * </p>
     * 
     * @return Entries from the specified log file.
     */
    public final String logFileData() {
        return logFileData;
    }

    /**
     * <p>
     * A pagination token that can be used in a later <code>DownloadDBLogFilePortion</code> request.
     * </p>
     * 
     * @return A pagination token that can be used in a later <code>DownloadDBLogFilePortion</code> request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Boolean value that if true, indicates there is more data to be downloaded.
     * </p>
     * 
     * @return Boolean value that if true, indicates there is more data to be downloaded.
     */
    public final Boolean additionalDataPending() {
        return additionalDataPending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(logFileData());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(additionalDataPending());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDbLogFilePortionResponse)) {
            return false;
        }
        DownloadDbLogFilePortionResponse other = (DownloadDbLogFilePortionResponse) obj;
        return Objects.equals(logFileData(), other.logFileData()) && Objects.equals(marker(), other.marker())
                && Objects.equals(additionalDataPending(), other.additionalDataPending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DownloadDbLogFilePortionResponse").add("LogFileData", logFileData()).add("Marker", marker())
                .add("AdditionalDataPending", additionalDataPending()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogFileData":
            return Optional.ofNullable(clazz.cast(logFileData()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "AdditionalDataPending":
            return Optional.ofNullable(clazz.cast(additionalDataPending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DownloadDbLogFilePortionResponse, T> g) {
        return obj -> g.apply((DownloadDbLogFilePortionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DownloadDbLogFilePortionResponse> {
        /**
         * <p>
         * Entries from the specified log file.
         * </p>
         * 
         * @param logFileData
         *        Entries from the specified log file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileData(String logFileData);

        /**
         * <p>
         * A pagination token that can be used in a later <code>DownloadDBLogFilePortion</code> request.
         * </p>
         * 
         * @param marker
         *        A pagination token that can be used in a later <code>DownloadDBLogFilePortion</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Boolean value that if true, indicates there is more data to be downloaded.
         * </p>
         * 
         * @param additionalDataPending
         *        Boolean value that if true, indicates there is more data to be downloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDataPending(Boolean additionalDataPending);
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String logFileData;

        private String marker;

        private Boolean additionalDataPending;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDbLogFilePortionResponse model) {
            super(model);
            logFileData(model.logFileData);
            marker(model.marker);
            additionalDataPending(model.additionalDataPending);
        }

        public final String getLogFileData() {
            return logFileData;
        }

        public final void setLogFileData(String logFileData) {
            this.logFileData = logFileData;
        }

        @Override
        @Transient
        public final Builder logFileData(String logFileData) {
            this.logFileData = logFileData;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getAdditionalDataPending() {
            return additionalDataPending;
        }

        public final void setAdditionalDataPending(Boolean additionalDataPending) {
            this.additionalDataPending = additionalDataPending;
        }

        @Override
        @Transient
        public final Builder additionalDataPending(Boolean additionalDataPending) {
            this.additionalDataPending = additionalDataPending;
            return this;
        }

        @Override
        public DownloadDbLogFilePortionResponse build() {
            return new DownloadDbLogFilePortionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
