/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DownloadDbLogFilePortionRequest extends RdsRequest implements
        ToCopyableBuilder<DownloadDbLogFilePortionRequest.Builder, DownloadDbLogFilePortionRequest> {
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(DownloadDbLogFilePortionRequest::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> LOG_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFileName").getter(getter(DownloadDbLogFilePortionRequest::logFileName))
            .setter(setter(Builder::logFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFileName").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DownloadDbLogFilePortionRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> NUMBER_OF_LINES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfLines").getter(getter(DownloadDbLogFilePortionRequest::numberOfLines))
            .setter(setter(Builder::numberOfLines))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfLines").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_INSTANCE_IDENTIFIER_FIELD,
            LOG_FILE_NAME_FIELD, MARKER_FIELD, NUMBER_OF_LINES_FIELD));

    private final String dbInstanceIdentifier;

    private final String logFileName;

    private final String marker;

    private final Integer numberOfLines;

    private DownloadDbLogFilePortionRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.logFileName = builder.logFileName;
        this.marker = builder.marker;
        this.numberOfLines = builder.numberOfLines;
    }

    /**
     * <p>
     * The customer-assigned name of the DB instance that contains the log files you want to list.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must match the identifier of an existing DBInstance.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The customer-assigned name of the DB instance that contains the log files you want to list.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must match the identifier of an existing DBInstance.
     *         </p>
     *         </li>
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * The name of the log file to be downloaded.
     * </p>
     * 
     * @return The name of the log file to be downloaded.
     */
    public final String logFileName() {
        return logFileName;
    }

    /**
     * <p>
     * The pagination token provided in the previous request or "0". If the Marker parameter is specified the response
     * includes only records beyond the marker until the end of the file or up to NumberOfLines.
     * </p>
     * 
     * @return The pagination token provided in the previous request or "0". If the Marker parameter is specified the
     *         response includes only records beyond the marker until the end of the file or up to NumberOfLines.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the file
     * is truncated at 1 MB in size.
     * </p>
     * <p>
     * If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or the
     * end of the log file, depending on the value of the Marker parameter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000 lines,
     * starting with the most recent log entries first.
     * </p>
     * </li>
     * <li>
     * <p>
     * If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of the log file
     * are returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If Marker is specified as "0", then the specified number of lines from the beginning of the log file are
     * returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines
     * parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the Marker
     * value returned in the response as the Marker value for the next request, continuing until the
     * AdditionalDataPending response element returns false.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The number of lines to download. If the number of lines specified results in a file over 1 MB in size,
     *         the file is truncated at 1 MB in size.</p>
     *         <p>
     *         If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning
     *         or the end of the log file, depending on the value of the Marker parameter.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of
     *         10000 lines, starting with the most recent log entries first.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of the
     *         log file are returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If Marker is specified as "0", then the specified number of lines from the beginning of the log file are
     *         returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You can download the log file in blocks of lines by specifying the size of the block using the
     *         NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first request.
     *         Include the Marker value returned in the response as the Marker value for the next request, continuing
     *         until the AdditionalDataPending response element returns false.
     *         </p>
     *         </li>
     */
    public final Integer numberOfLines() {
        return numberOfLines;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(logFileName());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfLines());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownloadDbLogFilePortionRequest)) {
            return false;
        }
        DownloadDbLogFilePortionRequest other = (DownloadDbLogFilePortionRequest) obj;
        return Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(logFileName(), other.logFileName()) && Objects.equals(marker(), other.marker())
                && Objects.equals(numberOfLines(), other.numberOfLines());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DownloadDbLogFilePortionRequest").add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("LogFileName", logFileName()).add("Marker", marker()).add("NumberOfLines", numberOfLines()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "LogFileName":
            return Optional.ofNullable(clazz.cast(logFileName()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "NumberOfLines":
            return Optional.ofNullable(clazz.cast(numberOfLines()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DownloadDbLogFilePortionRequest, T> g) {
        return obj -> g.apply((DownloadDbLogFilePortionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DownloadDbLogFilePortionRequest> {
        /**
         * <p>
         * The customer-assigned name of the DB instance that contains the log files you want to list.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must match the identifier of an existing DBInstance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dbInstanceIdentifier
         *        The customer-assigned name of the DB instance that contains the log files you want to list.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must match the identifier of an existing DBInstance.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * The name of the log file to be downloaded.
         * </p>
         * 
         * @param logFileName
         *        The name of the log file to be downloaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFileName(String logFileName);

        /**
         * <p>
         * The pagination token provided in the previous request or "0". If the Marker parameter is specified the
         * response includes only records beyond the marker until the end of the file or up to NumberOfLines.
         * </p>
         * 
         * @param marker
         *        The pagination token provided in the previous request or "0". If the Marker parameter is specified the
         *        response includes only records beyond the marker until the end of the file or up to NumberOfLines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The number of lines to download. If the number of lines specified results in a file over 1 MB in size, the
         * file is truncated at 1 MB in size.
         * </p>
         * <p>
         * If the NumberOfLines parameter is specified, then the block of lines returned can be from the beginning or
         * the end of the log file, depending on the value of the Marker parameter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of 10000
         * lines, starting with the most recent log entries first.
         * </p>
         * </li>
         * <li>
         * <p>
         * If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of the log
         * file are returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If Marker is specified as "0", then the specified number of lines from the beginning of the log file are
         * returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * You can download the log file in blocks of lines by specifying the size of the block using the NumberOfLines
         * parameter, and by specifying a value of "0" for the Marker parameter in your first request. Include the
         * Marker value returned in the response as the Marker value for the next request, continuing until the
         * AdditionalDataPending response element returns false.
         * </p>
         * </li>
         * </ul>
         * 
         * @param numberOfLines
         *        The number of lines to download. If the number of lines specified results in a file over 1 MB in size,
         *        the file is truncated at 1 MB in size.</p>
         *        <p>
         *        If the NumberOfLines parameter is specified, then the block of lines returned can be from the
         *        beginning or the end of the log file, depending on the value of the Marker parameter.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If neither Marker or NumberOfLines are specified, the entire log file is returned up to a maximum of
         *        10000 lines, starting with the most recent log entries first.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If NumberOfLines is specified and Marker isn't specified, then the most recent lines from the end of
         *        the log file are returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If Marker is specified as "0", then the specified number of lines from the beginning of the log file
         *        are returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You can download the log file in blocks of lines by specifying the size of the block using the
         *        NumberOfLines parameter, and by specifying a value of "0" for the Marker parameter in your first
         *        request. Include the Marker value returned in the response as the Marker value for the next request,
         *        continuing until the AdditionalDataPending response element returns false.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLines(Integer numberOfLines);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String dbInstanceIdentifier;

        private String logFileName;

        private String marker;

        private Integer numberOfLines;

        private BuilderImpl() {
        }

        private BuilderImpl(DownloadDbLogFilePortionRequest model) {
            super(model);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            logFileName(model.logFileName);
            marker(model.marker);
            numberOfLines(model.numberOfLines);
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getLogFileName() {
            return logFileName;
        }

        public final void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        @Override
        @Transient
        public final Builder logFileName(String logFileName) {
            this.logFileName = logFileName;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getNumberOfLines() {
            return numberOfLines;
        }

        public final void setNumberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
        }

        @Override
        @Transient
        public final Builder numberOfLines(Integer numberOfLines) {
            this.numberOfLines = numberOfLines;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DownloadDbLogFilePortionRequest build() {
            return new DownloadDbLogFilePortionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
