/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the installation media for a DB engine that requires an on-premises customer provided license, such as
 * Microsoft SQL Server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInstallationMediaResponse extends RdsResponse implements
        ToCopyableBuilder<DeleteInstallationMediaResponse.Builder, DeleteInstallationMediaResponse> {
    private static final SdkField<String> INSTALLATION_MEDIA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstallationMediaId").getter(getter(DeleteInstallationMediaResponse::installationMediaId))
            .setter(setter(Builder::installationMediaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallationMediaId").build())
            .build();

    private static final SdkField<String> CUSTOM_AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomAvailabilityZoneId").getter(getter(DeleteInstallationMediaResponse::customAvailabilityZoneId))
            .setter(setter(Builder::customAvailabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAvailabilityZoneId").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(DeleteInstallationMediaResponse::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(DeleteInstallationMediaResponse::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> ENGINE_INSTALLATION_MEDIA_PATH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EngineInstallationMediaPath")
            .getter(getter(DeleteInstallationMediaResponse::engineInstallationMediaPath))
            .setter(setter(Builder::engineInstallationMediaPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineInstallationMediaPath")
                    .build()).build();

    private static final SdkField<String> OS_INSTALLATION_MEDIA_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OSInstallationMediaPath").getter(getter(DeleteInstallationMediaResponse::osInstallationMediaPath))
            .setter(setter(Builder::osInstallationMediaPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSInstallationMediaPath").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DeleteInstallationMediaResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<InstallationMediaFailureCause> FAILURE_CAUSE_FIELD = SdkField
            .<InstallationMediaFailureCause> builder(MarshallingType.SDK_POJO).memberName("FailureCause")
            .getter(getter(DeleteInstallationMediaResponse::failureCause)).setter(setter(Builder::failureCause))
            .constructor(InstallationMediaFailureCause::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTALLATION_MEDIA_ID_FIELD,
            CUSTOM_AVAILABILITY_ZONE_ID_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_INSTALLATION_MEDIA_PATH_FIELD,
            OS_INSTALLATION_MEDIA_PATH_FIELD, STATUS_FIELD, FAILURE_CAUSE_FIELD));

    private final String installationMediaId;

    private final String customAvailabilityZoneId;

    private final String engine;

    private final String engineVersion;

    private final String engineInstallationMediaPath;

    private final String osInstallationMediaPath;

    private final String status;

    private final InstallationMediaFailureCause failureCause;

    private DeleteInstallationMediaResponse(BuilderImpl builder) {
        super(builder);
        this.installationMediaId = builder.installationMediaId;
        this.customAvailabilityZoneId = builder.customAvailabilityZoneId;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineInstallationMediaPath = builder.engineInstallationMediaPath;
        this.osInstallationMediaPath = builder.osInstallationMediaPath;
        this.status = builder.status;
        this.failureCause = builder.failureCause;
    }

    /**
     * <p>
     * The installation medium ID.
     * </p>
     * 
     * @return The installation medium ID.
     */
    public final String installationMediaId() {
        return installationMediaId;
    }

    /**
     * <p>
     * The custom Availability Zone (AZ) that contains the installation media.
     * </p>
     * 
     * @return The custom Availability Zone (AZ) that contains the installation media.
     */
    public final String customAvailabilityZoneId() {
        return customAvailabilityZoneId;
    }

    /**
     * <p>
     * The DB engine.
     * </p>
     * 
     * @return The DB engine.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The engine version of the DB engine.
     * </p>
     * 
     * @return The engine version of the DB engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The path to the installation medium for the DB engine.
     * </p>
     * 
     * @return The path to the installation medium for the DB engine.
     */
    public final String engineInstallationMediaPath() {
        return engineInstallationMediaPath;
    }

    /**
     * <p>
     * The path to the installation medium for the operating system associated with the DB engine.
     * </p>
     * 
     * @return The path to the installation medium for the operating system associated with the DB engine.
     */
    public final String osInstallationMediaPath() {
        return osInstallationMediaPath;
    }

    /**
     * <p>
     * The status of the installation medium.
     * </p>
     * 
     * @return The status of the installation medium.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an installation media failure occurred, the cause of the failure.
     * </p>
     * 
     * @return If an installation media failure occurred, the cause of the failure.
     */
    public final InstallationMediaFailureCause failureCause() {
        return failureCause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(installationMediaId());
        hashCode = 31 * hashCode + Objects.hashCode(customAvailabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(engineInstallationMediaPath());
        hashCode = 31 * hashCode + Objects.hashCode(osInstallationMediaPath());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(failureCause());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstallationMediaResponse)) {
            return false;
        }
        DeleteInstallationMediaResponse other = (DeleteInstallationMediaResponse) obj;
        return Objects.equals(installationMediaId(), other.installationMediaId())
                && Objects.equals(customAvailabilityZoneId(), other.customAvailabilityZoneId())
                && Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(engineInstallationMediaPath(), other.engineInstallationMediaPath())
                && Objects.equals(osInstallationMediaPath(), other.osInstallationMediaPath())
                && Objects.equals(status(), other.status()) && Objects.equals(failureCause(), other.failureCause());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteInstallationMediaResponse").add("InstallationMediaId", installationMediaId())
                .add("CustomAvailabilityZoneId", customAvailabilityZoneId()).add("Engine", engine())
                .add("EngineVersion", engineVersion()).add("EngineInstallationMediaPath", engineInstallationMediaPath())
                .add("OSInstallationMediaPath", osInstallationMediaPath()).add("Status", status())
                .add("FailureCause", failureCause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstallationMediaId":
            return Optional.ofNullable(clazz.cast(installationMediaId()));
        case "CustomAvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(customAvailabilityZoneId()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "EngineInstallationMediaPath":
            return Optional.ofNullable(clazz.cast(engineInstallationMediaPath()));
        case "OSInstallationMediaPath":
            return Optional.ofNullable(clazz.cast(osInstallationMediaPath()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "FailureCause":
            return Optional.ofNullable(clazz.cast(failureCause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstallationMediaResponse, T> g) {
        return obj -> g.apply((DeleteInstallationMediaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInstallationMediaResponse> {
        /**
         * <p>
         * The installation medium ID.
         * </p>
         * 
         * @param installationMediaId
         *        The installation medium ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installationMediaId(String installationMediaId);

        /**
         * <p>
         * The custom Availability Zone (AZ) that contains the installation media.
         * </p>
         * 
         * @param customAvailabilityZoneId
         *        The custom Availability Zone (AZ) that contains the installation media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAvailabilityZoneId(String customAvailabilityZoneId);

        /**
         * <p>
         * The DB engine.
         * </p>
         * 
         * @param engine
         *        The DB engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The engine version of the DB engine.
         * </p>
         * 
         * @param engineVersion
         *        The engine version of the DB engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The path to the installation medium for the DB engine.
         * </p>
         * 
         * @param engineInstallationMediaPath
         *        The path to the installation medium for the DB engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineInstallationMediaPath(String engineInstallationMediaPath);

        /**
         * <p>
         * The path to the installation medium for the operating system associated with the DB engine.
         * </p>
         * 
         * @param osInstallationMediaPath
         *        The path to the installation medium for the operating system associated with the DB engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osInstallationMediaPath(String osInstallationMediaPath);

        /**
         * <p>
         * The status of the installation medium.
         * </p>
         * 
         * @param status
         *        The status of the installation medium.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an installation media failure occurred, the cause of the failure.
         * </p>
         * 
         * @param failureCause
         *        If an installation media failure occurred, the cause of the failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCause(InstallationMediaFailureCause failureCause);

        /**
         * <p>
         * If an installation media failure occurred, the cause of the failure.
         * </p>
         * This is a convenience that creates an instance of the {@link InstallationMediaFailureCause.Builder} avoiding
         * the need to create one manually via {@link InstallationMediaFailureCause#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstallationMediaFailureCause.Builder#build()} is called
         * immediately and its result is passed to {@link #failureCause(InstallationMediaFailureCause)}.
         * 
         * @param failureCause
         *        a consumer that will call methods on {@link InstallationMediaFailureCause.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureCause(InstallationMediaFailureCause)
         */
        default Builder failureCause(Consumer<InstallationMediaFailureCause.Builder> failureCause) {
            return failureCause(InstallationMediaFailureCause.builder().applyMutation(failureCause).build());
        }
    }

    static final class BuilderImpl extends RdsResponse.BuilderImpl implements Builder {
        private String installationMediaId;

        private String customAvailabilityZoneId;

        private String engine;

        private String engineVersion;

        private String engineInstallationMediaPath;

        private String osInstallationMediaPath;

        private String status;

        private InstallationMediaFailureCause failureCause;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstallationMediaResponse model) {
            super(model);
            installationMediaId(model.installationMediaId);
            customAvailabilityZoneId(model.customAvailabilityZoneId);
            engine(model.engine);
            engineVersion(model.engineVersion);
            engineInstallationMediaPath(model.engineInstallationMediaPath);
            osInstallationMediaPath(model.osInstallationMediaPath);
            status(model.status);
            failureCause(model.failureCause);
        }

        public final String getInstallationMediaId() {
            return installationMediaId;
        }

        public final void setInstallationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
        }

        @Override
        @Transient
        public final Builder installationMediaId(String installationMediaId) {
            this.installationMediaId = installationMediaId;
            return this;
        }

        public final String getCustomAvailabilityZoneId() {
            return customAvailabilityZoneId;
        }

        public final void setCustomAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
        }

        @Override
        @Transient
        public final Builder customAvailabilityZoneId(String customAvailabilityZoneId) {
            this.customAvailabilityZoneId = customAvailabilityZoneId;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEngineInstallationMediaPath() {
            return engineInstallationMediaPath;
        }

        public final void setEngineInstallationMediaPath(String engineInstallationMediaPath) {
            this.engineInstallationMediaPath = engineInstallationMediaPath;
        }

        @Override
        @Transient
        public final Builder engineInstallationMediaPath(String engineInstallationMediaPath) {
            this.engineInstallationMediaPath = engineInstallationMediaPath;
            return this;
        }

        public final String getOsInstallationMediaPath() {
            return osInstallationMediaPath;
        }

        public final void setOsInstallationMediaPath(String osInstallationMediaPath) {
            this.osInstallationMediaPath = osInstallationMediaPath;
        }

        @Override
        @Transient
        public final Builder osInstallationMediaPath(String osInstallationMediaPath) {
            this.osInstallationMediaPath = osInstallationMediaPath;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final InstallationMediaFailureCause.Builder getFailureCause() {
            return failureCause != null ? failureCause.toBuilder() : null;
        }

        public final void setFailureCause(InstallationMediaFailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        @Override
        @Transient
        public final Builder failureCause(InstallationMediaFailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        @Override
        public DeleteInstallationMediaResponse build() {
            return new DeleteInstallationMediaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
