/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details for an Amazon RDS DB security group.
 * </p>
 * <p>
 * This data type is used as a response element in the <code>DescribeDBSecurityGroups</code> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DBSecurityGroup implements SdkPojo, Serializable, ToCopyableBuilder<DBSecurityGroup.Builder, DBSecurityGroup> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(DBSecurityGroup::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> DB_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSecurityGroupName").getter(getter(DBSecurityGroup::dbSecurityGroupName))
            .setter(setter(Builder::dbSecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build())
            .build();

    private static final SdkField<String> DB_SECURITY_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DBSecurityGroupDescription")
            .getter(getter(DBSecurityGroup::dbSecurityGroupDescription))
            .setter(setter(Builder::dbSecurityGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupDescription").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(DBSecurityGroup::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<EC2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField
            .<List<EC2SecurityGroup>> builder(MarshallingType.LIST)
            .memberName("EC2SecurityGroups")
            .getter(getter(DBSecurityGroup::ec2SecurityGroups))
            .setter(setter(Builder::ec2SecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2SecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("EC2SecurityGroup")
                            .memberFieldInfo(
                                    SdkField.<EC2SecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(EC2SecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("EC2SecurityGroup").build()).build()).build()).build();

    private static final SdkField<List<IPRange>> IP_RANGES_FIELD = SdkField
            .<List<IPRange>> builder(MarshallingType.LIST)
            .memberName("IPRanges")
            .getter(getter(DBSecurityGroup::ipRanges))
            .setter(setter(Builder::ipRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("IPRange")
                            .memberFieldInfo(
                                    SdkField.<IPRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(IPRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("IPRange").build()).build()).build()).build();

    private static final SdkField<String> DB_SECURITY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBSecurityGroupArn").getter(getter(DBSecurityGroup::dbSecurityGroupArn))
            .setter(setter(Builder::dbSecurityGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            DB_SECURITY_GROUP_NAME_FIELD, DB_SECURITY_GROUP_DESCRIPTION_FIELD, VPC_ID_FIELD, EC2_SECURITY_GROUPS_FIELD,
            IP_RANGES_FIELD, DB_SECURITY_GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String dbSecurityGroupName;

    private final String dbSecurityGroupDescription;

    private final String vpcId;

    private final List<EC2SecurityGroup> ec2SecurityGroups;

    private final List<IPRange> ipRanges;

    private final String dbSecurityGroupArn;

    private DBSecurityGroup(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.dbSecurityGroupDescription = builder.dbSecurityGroupDescription;
        this.vpcId = builder.vpcId;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.dbSecurityGroupArn = builder.dbSecurityGroupArn;
    }

    /**
     * <p>
     * Provides the Amazon Web Services ID of the owner of a specific DB security group.
     * </p>
     * 
     * @return Provides the Amazon Web Services ID of the owner of a specific DB security group.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * Specifies the name of the DB security group.
     * </p>
     * 
     * @return Specifies the name of the DB security group.
     */
    public final String dbSecurityGroupName() {
        return dbSecurityGroupName;
    }

    /**
     * <p>
     * Provides the description of the DB security group.
     * </p>
     * 
     * @return Provides the description of the DB security group.
     */
    public final String dbSecurityGroupDescription() {
        return dbSecurityGroupDescription;
    }

    /**
     * <p>
     * Provides the VpcId of the DB security group.
     * </p>
     * 
     * @return Provides the VpcId of the DB security group.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2SecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEc2SecurityGroups() {
        return ec2SecurityGroups != null && !(ec2SecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of <code>EC2SecurityGroup</code> elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2SecurityGroups} method.
     * </p>
     * 
     * @return Contains a list of <code>EC2SecurityGroup</code> elements.
     */
    public final List<EC2SecurityGroup> ec2SecurityGroups() {
        return ec2SecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the IPRanges property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpRanges() {
        return ipRanges != null && !(ipRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a list of <code>IPRange</code> elements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpRanges} method.
     * </p>
     * 
     * @return Contains a list of <code>IPRange</code> elements.
     */
    public final List<IPRange> ipRanges() {
        return ipRanges;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the DB security group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the DB security group.
     */
    public final String dbSecurityGroupArn() {
        return dbSecurityGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(dbSecurityGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2SecurityGroups() ? ec2SecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRanges() ? ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbSecurityGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSecurityGroup)) {
            return false;
        }
        DBSecurityGroup other = (DBSecurityGroup) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(dbSecurityGroupName(), other.dbSecurityGroupName())
                && Objects.equals(dbSecurityGroupDescription(), other.dbSecurityGroupDescription())
                && Objects.equals(vpcId(), other.vpcId()) && hasEc2SecurityGroups() == other.hasEc2SecurityGroups()
                && Objects.equals(ec2SecurityGroups(), other.ec2SecurityGroups()) && hasIpRanges() == other.hasIpRanges()
                && Objects.equals(ipRanges(), other.ipRanges())
                && Objects.equals(dbSecurityGroupArn(), other.dbSecurityGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DBSecurityGroup").add("OwnerId", ownerId()).add("DBSecurityGroupName", dbSecurityGroupName())
                .add("DBSecurityGroupDescription", dbSecurityGroupDescription()).add("VpcId", vpcId())
                .add("EC2SecurityGroups", hasEc2SecurityGroups() ? ec2SecurityGroups() : null)
                .add("IPRanges", hasIpRanges() ? ipRanges() : null).add("DBSecurityGroupArn", dbSecurityGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "DBSecurityGroupName":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupName()));
        case "DBSecurityGroupDescription":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupDescription()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "EC2SecurityGroups":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroups()));
        case "IPRanges":
            return Optional.ofNullable(clazz.cast(ipRanges()));
        case "DBSecurityGroupArn":
            return Optional.ofNullable(clazz.cast(dbSecurityGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBSecurityGroup, T> g) {
        return obj -> g.apply((DBSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DBSecurityGroup> {
        /**
         * <p>
         * Provides the Amazon Web Services ID of the owner of a specific DB security group.
         * </p>
         * 
         * @param ownerId
         *        Provides the Amazon Web Services ID of the owner of a specific DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Specifies the name of the DB security group.
         * </p>
         * 
         * @param dbSecurityGroupName
         *        Specifies the name of the DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupName(String dbSecurityGroupName);

        /**
         * <p>
         * Provides the description of the DB security group.
         * </p>
         * 
         * @param dbSecurityGroupDescription
         *        Provides the description of the DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupDescription(String dbSecurityGroupDescription);

        /**
         * <p>
         * Provides the VpcId of the DB security group.
         * </p>
         * 
         * @param vpcId
         *        Provides the VpcId of the DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Contains a list of <code>EC2SecurityGroup</code> elements.
         * </p>
         * 
         * @param ec2SecurityGroups
         *        Contains a list of <code>EC2SecurityGroup</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups);

        /**
         * <p>
         * Contains a list of <code>EC2SecurityGroup</code> elements.
         * </p>
         * 
         * @param ec2SecurityGroups
         *        Contains a list of <code>EC2SecurityGroup</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroups(EC2SecurityGroup... ec2SecurityGroups);

        /**
         * <p>
         * Contains a list of <code>EC2SecurityGroup</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EC2SecurityGroup>.Builder} avoiding the
         * need to create one manually via {@link List<EC2SecurityGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EC2SecurityGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2SecurityGroups(List<EC2SecurityGroup>)}.
         * 
         * @param ec2SecurityGroups
         *        a consumer that will call methods on {@link List<EC2SecurityGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2SecurityGroups(List<EC2SecurityGroup>)
         */
        Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder>... ec2SecurityGroups);

        /**
         * <p>
         * Contains a list of <code>IPRange</code> elements.
         * </p>
         * 
         * @param ipRanges
         *        Contains a list of <code>IPRange</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<IPRange> ipRanges);

        /**
         * <p>
         * Contains a list of <code>IPRange</code> elements.
         * </p>
         * 
         * @param ipRanges
         *        Contains a list of <code>IPRange</code> elements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(IPRange... ipRanges);

        /**
         * <p>
         * Contains a list of <code>IPRange</code> elements.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IPRange>.Builder} avoiding the need to
         * create one manually via {@link List<IPRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IPRange>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipRanges(List<IPRange>)}.
         * 
         * @param ipRanges
         *        a consumer that will call methods on {@link List<IPRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRanges(List<IPRange>)
         */
        Builder ipRanges(Consumer<IPRange.Builder>... ipRanges);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the DB security group.
         * </p>
         * 
         * @param dbSecurityGroupArn
         *        The Amazon Resource Name (ARN) for the DB security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroupArn(String dbSecurityGroupArn);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String dbSecurityGroupName;

        private String dbSecurityGroupDescription;

        private String vpcId;

        private List<EC2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<IPRange> ipRanges = DefaultSdkAutoConstructList.getInstance();

        private String dbSecurityGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSecurityGroup model) {
            ownerId(model.ownerId);
            dbSecurityGroupName(model.dbSecurityGroupName);
            dbSecurityGroupDescription(model.dbSecurityGroupDescription);
            vpcId(model.vpcId);
            ec2SecurityGroups(model.ec2SecurityGroups);
            ipRanges(model.ipRanges);
            dbSecurityGroupArn(model.dbSecurityGroupArn);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        @Transient
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getDbSecurityGroupName() {
            return dbSecurityGroupName;
        }

        public final void setDbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        @Override
        @Transient
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final String getDbSecurityGroupDescription() {
            return dbSecurityGroupDescription;
        }

        public final void setDbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
        }

        @Override
        @Transient
        public final Builder dbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<EC2SecurityGroup.Builder> getEc2SecurityGroups() {
            List<EC2SecurityGroup.Builder> result = EC2SecurityGroupListCopier.copyToBuilder(this.ec2SecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2SecurityGroups(Collection<EC2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copyFromBuilder(ec2SecurityGroups);
        }

        @Override
        @Transient
        public final Builder ec2SecurityGroups(Collection<EC2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = EC2SecurityGroupListCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2SecurityGroups(EC2SecurityGroup... ec2SecurityGroups) {
            ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<EC2SecurityGroup.Builder>... ec2SecurityGroups) {
            ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> EC2SecurityGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<IPRange.Builder> getIpRanges() {
            List<IPRange.Builder> result = IPRangeListCopier.copyToBuilder(this.ipRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpRanges(Collection<IPRange.BuilderImpl> ipRanges) {
            this.ipRanges = IPRangeListCopier.copyFromBuilder(ipRanges);
        }

        @Override
        @Transient
        public final Builder ipRanges(Collection<IPRange> ipRanges) {
            this.ipRanges = IPRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipRanges(IPRange... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ipRanges(Consumer<IPRange.Builder>... ipRanges) {
            ipRanges(Stream.of(ipRanges).map(c -> IPRange.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbSecurityGroupArn() {
            return dbSecurityGroupArn;
        }

        public final void setDbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
        }

        @Override
        @Transient
        public final Builder dbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
            return this;
        }

        @Override
        public DBSecurityGroup build() {
            return new DBSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
