/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyOptionGroupRequest extends RdsRequest implements
        ToCopyableBuilder<CopyOptionGroupRequest.Builder, CopyOptionGroupRequest> {
    private static final SdkField<String> SOURCE_OPTION_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceOptionGroupIdentifier")
            .getter(getter(CopyOptionGroupRequest::sourceOptionGroupIdentifier))
            .setter(setter(Builder::sourceOptionGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceOptionGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> TARGET_OPTION_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetOptionGroupIdentifier")
            .getter(getter(CopyOptionGroupRequest::targetOptionGroupIdentifier))
            .setter(setter(Builder::targetOptionGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOptionGroupIdentifier")
                    .build()).build();

    private static final SdkField<String> TARGET_OPTION_GROUP_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetOptionGroupDescription")
            .getter(getter(CopyOptionGroupRequest::targetOptionGroupDescription))
            .setter(setter(Builder::targetOptionGroupDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOptionGroupDescription")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CopyOptionGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SOURCE_OPTION_GROUP_IDENTIFIER_FIELD, TARGET_OPTION_GROUP_IDENTIFIER_FIELD, TARGET_OPTION_GROUP_DESCRIPTION_FIELD,
            TAGS_FIELD));

    private final String sourceOptionGroupIdentifier;

    private final String targetOptionGroupIdentifier;

    private final String targetOptionGroupDescription;

    private final List<Tag> tags;

    private CopyOptionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceOptionGroupIdentifier = builder.sourceOptionGroupIdentifier;
        this.targetOptionGroupIdentifier = builder.targetOptionGroupIdentifier;
        this.targetOptionGroupDescription = builder.targetOptionGroupDescription;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identifier for the source option group.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must specify a valid option group.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier for the source option group.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must specify a valid option group.
     *         </p>
     *         </li>
     */
    public final String sourceOptionGroupIdentifier() {
        return sourceOptionGroupIdentifier;
    }

    /**
     * <p>
     * The identifier for the copied option group.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Can't be null, empty, or blank
     * </p>
     * </li>
     * <li>
     * <p>
     * Must contain from 1 to 255 letters, numbers, or hyphens
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter
     * </p>
     * </li>
     * <li>
     * <p>
     * Can't end with a hyphen or contain two consecutive hyphens
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>my-option-group</code>
     * </p>
     * 
     * @return The identifier for the copied option group.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Can't be null, empty, or blank
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must contain from 1 to 255 letters, numbers, or hyphens
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Can't end with a hyphen or contain two consecutive hyphens
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>my-option-group</code>
     */
    public final String targetOptionGroupIdentifier() {
        return targetOptionGroupIdentifier;
    }

    /**
     * <p>
     * The description for the copied option group.
     * </p>
     * 
     * @return The description for the copied option group.
     */
    public final String targetOptionGroupDescription() {
        return targetOptionGroupDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceOptionGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetOptionGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(targetOptionGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyOptionGroupRequest)) {
            return false;
        }
        CopyOptionGroupRequest other = (CopyOptionGroupRequest) obj;
        return Objects.equals(sourceOptionGroupIdentifier(), other.sourceOptionGroupIdentifier())
                && Objects.equals(targetOptionGroupIdentifier(), other.targetOptionGroupIdentifier())
                && Objects.equals(targetOptionGroupDescription(), other.targetOptionGroupDescription())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyOptionGroupRequest").add("SourceOptionGroupIdentifier", sourceOptionGroupIdentifier())
                .add("TargetOptionGroupIdentifier", targetOptionGroupIdentifier())
                .add("TargetOptionGroupDescription", targetOptionGroupDescription()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceOptionGroupIdentifier":
            return Optional.ofNullable(clazz.cast(sourceOptionGroupIdentifier()));
        case "TargetOptionGroupIdentifier":
            return Optional.ofNullable(clazz.cast(targetOptionGroupIdentifier()));
        case "TargetOptionGroupDescription":
            return Optional.ofNullable(clazz.cast(targetOptionGroupDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyOptionGroupRequest, T> g) {
        return obj -> g.apply((CopyOptionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyOptionGroupRequest> {
        /**
         * <p>
         * The identifier for the source option group.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must specify a valid option group.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceOptionGroupIdentifier
         *        The identifier for the source option group.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must specify a valid option group.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceOptionGroupIdentifier(String sourceOptionGroupIdentifier);

        /**
         * <p>
         * The identifier for the copied option group.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Can't be null, empty, or blank
         * </p>
         * </li>
         * <li>
         * <p>
         * Must contain from 1 to 255 letters, numbers, or hyphens
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter
         * </p>
         * </li>
         * <li>
         * <p>
         * Can't end with a hyphen or contain two consecutive hyphens
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>my-option-group</code>
         * </p>
         * 
         * @param targetOptionGroupIdentifier
         *        The identifier for the copied option group.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Can't be null, empty, or blank
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must contain from 1 to 255 letters, numbers, or hyphens
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Can't end with a hyphen or contain two consecutive hyphens
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>my-option-group</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOptionGroupIdentifier(String targetOptionGroupIdentifier);

        /**
         * <p>
         * The description for the copied option group.
         * </p>
         * 
         * @param targetOptionGroupDescription
         *        The description for the copied option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOptionGroupDescription(String targetOptionGroupDescription);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String sourceOptionGroupIdentifier;

        private String targetOptionGroupIdentifier;

        private String targetOptionGroupDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyOptionGroupRequest model) {
            super(model);
            sourceOptionGroupIdentifier(model.sourceOptionGroupIdentifier);
            targetOptionGroupIdentifier(model.targetOptionGroupIdentifier);
            targetOptionGroupDescription(model.targetOptionGroupDescription);
            tags(model.tags);
        }

        public final String getSourceOptionGroupIdentifier() {
            return sourceOptionGroupIdentifier;
        }

        public final void setSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
            this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
        }

        @Override
        @Transient
        public final Builder sourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
            this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
            return this;
        }

        public final String getTargetOptionGroupIdentifier() {
            return targetOptionGroupIdentifier;
        }

        public final void setTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
            this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
        }

        @Override
        @Transient
        public final Builder targetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
            this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
            return this;
        }

        public final String getTargetOptionGroupDescription() {
            return targetOptionGroupDescription;
        }

        public final void setTargetOptionGroupDescription(String targetOptionGroupDescription) {
            this.targetOptionGroupDescription = targetOptionGroupDescription;
        }

        @Override
        @Transient
        public final Builder targetOptionGroupDescription(String targetOptionGroupDescription) {
            this.targetOptionGroupDescription = targetOptionGroupDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyOptionGroupRequest build() {
            return new CopyOptionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
