/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a quota for an Amazon Web Services account.
 * </p>
 * <p>
 * The following are account quotas:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>AllocatedStorage</code> - The total allocated storage per account, in GiB. The used value is the total
 * allocated storage in the account, in GiB.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>AuthorizationsPerDBSecurityGroup</code> - The number of ingress rules per DB security group. The used value is
 * the highest number of ingress rules in a DB security group in the account. Other DB security groups in the account
 * might have a lower number of ingress rules.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>CustomEndpointsPerDBCluster</code> - The number of custom endpoints per DB cluster. The used value is the
 * highest number of custom endpoints in a DB clusters in the account. Other DB clusters in the account might have a
 * lower number of custom endpoints.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBClusterParameterGroups</code> - The number of DB cluster parameter groups per account, excluding default
 * parameter groups. The used value is the count of nondefault DB cluster parameter groups in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBClusterRoles</code> - The number of associated Amazon Web Services Identity and Access Management (IAM) roles
 * per DB cluster. The used value is the highest number of associated IAM roles for a DB cluster in the account. Other
 * DB clusters in the account might have a lower number of associated IAM roles.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBClusters</code> - The number of DB clusters per account. The used value is the count of DB clusters in the
 * account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBInstanceRoles</code> - The number of associated IAM roles per DB instance. The used value is the highest
 * number of associated IAM roles for a DB instance in the account. Other DB instances in the account might have a lower
 * number of associated IAM roles.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBInstances</code> - The number of DB instances per account. The used value is the count of the DB instances in
 * the account.
 * </p>
 * <p>
 * Amazon RDS DB instances, Amazon Aurora DB instances, Amazon Neptune instances, and Amazon DocumentDB instances apply
 * to this quota.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBParameterGroups</code> - The number of DB parameter groups per account, excluding default parameter groups.
 * The used value is the count of nondefault DB parameter groups in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBSecurityGroups</code> - The number of DB security groups (not VPC security groups) per account, excluding the
 * default security group. The used value is the count of nondefault DB security groups in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>DBSubnetGroups</code> - The number of DB subnet groups per account. The used value is the count of the DB
 * subnet groups in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>EventSubscriptions</code> - The number of event subscriptions per account. The used value is the count of the
 * event subscriptions in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ManualClusterSnapshots</code> - The number of manual DB cluster snapshots per account. The used value is the
 * count of the manual DB cluster snapshots in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ManualSnapshots</code> - The number of manual DB instance snapshots per account. The used value is the count of
 * the manual DB instance snapshots in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>OptionGroups</code> - The number of DB option groups per account, excluding default option groups. The used
 * value is the count of nondefault DB option groups in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ReadReplicasPerMaster</code> - The number of read replicas per DB instance. The used value is the highest
 * number of read replicas for a DB instance in the account. Other DB instances in the account might have a lower number
 * of read replicas.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>ReservedDBInstances</code> - The number of reserved DB instances per account. The used value is the count of
 * the active reserved DB instances in the account.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>SubnetsPerDBSubnetGroup</code> - The number of subnets per DB subnet group. The used value is highest number of
 * subnets for a DB subnet group in the account. Other DB subnet groups in the account might have a lower number of
 * subnets.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html">Quotas
 * for Amazon RDS</a> in the <i>Amazon RDS User Guide</i> and <a
 * href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html">Quotas for Amazon Aurora</a> in
 * the <i>Amazon Aurora User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountQuota implements SdkPojo, Serializable, ToCopyableBuilder<AccountQuota.Builder, AccountQuota> {
    private static final SdkField<String> ACCOUNT_QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountQuotaName").getter(getter(AccountQuota::accountQuotaName))
            .setter(setter(Builder::accountQuotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountQuotaName").build()).build();

    private static final SdkField<Long> USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Used")
            .getter(getter(AccountQuota::used)).setter(setter(Builder::used))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()).build();

    private static final SdkField<Long> MAX_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Max")
            .getter(getter(AccountQuota::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_QUOTA_NAME_FIELD,
            USED_FIELD, MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountQuotaName;

    private final Long used;

    private final Long max;

    private AccountQuota(BuilderImpl builder) {
        this.accountQuotaName = builder.accountQuotaName;
        this.used = builder.used;
        this.max = builder.max;
    }

    /**
     * <p>
     * The name of the Amazon RDS quota for this Amazon Web Services account.
     * </p>
     * 
     * @return The name of the Amazon RDS quota for this Amazon Web Services account.
     */
    public final String accountQuotaName() {
        return accountQuotaName;
    }

    /**
     * <p>
     * The amount currently used toward the quota maximum.
     * </p>
     * 
     * @return The amount currently used toward the quota maximum.
     */
    public final Long used() {
        return used;
    }

    /**
     * <p>
     * The maximum allowed value for the quota.
     * </p>
     * 
     * @return The maximum allowed value for the quota.
     */
    public final Long max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountQuotaName());
        hashCode = 31 * hashCode + Objects.hashCode(used());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountQuota)) {
            return false;
        }
        AccountQuota other = (AccountQuota) obj;
        return Objects.equals(accountQuotaName(), other.accountQuotaName()) && Objects.equals(used(), other.used())
                && Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountQuota").add("AccountQuotaName", accountQuotaName()).add("Used", used()).add("Max", max())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountQuotaName":
            return Optional.ofNullable(clazz.cast(accountQuotaName()));
        case "Used":
            return Optional.ofNullable(clazz.cast(used()));
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountQuota, T> g) {
        return obj -> g.apply((AccountQuota) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountQuota> {
        /**
         * <p>
         * The name of the Amazon RDS quota for this Amazon Web Services account.
         * </p>
         * 
         * @param accountQuotaName
         *        The name of the Amazon RDS quota for this Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountQuotaName(String accountQuotaName);

        /**
         * <p>
         * The amount currently used toward the quota maximum.
         * </p>
         * 
         * @param used
         *        The amount currently used toward the quota maximum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder used(Long used);

        /**
         * <p>
         * The maximum allowed value for the quota.
         * </p>
         * 
         * @param max
         *        The maximum allowed value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Long max);
    }

    static final class BuilderImpl implements Builder {
        private String accountQuotaName;

        private Long used;

        private Long max;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountQuota model) {
            accountQuotaName(model.accountQuotaName);
            used(model.used);
            max(model.max);
        }

        public final String getAccountQuotaName() {
            return accountQuotaName;
        }

        public final void setAccountQuotaName(String accountQuotaName) {
            this.accountQuotaName = accountQuotaName;
        }

        @Override
        @Transient
        public final Builder accountQuotaName(String accountQuotaName) {
            this.accountQuotaName = accountQuotaName;
            return this;
        }

        public final Long getUsed() {
            return used;
        }

        public final void setUsed(Long used) {
            this.used = used;
        }

        @Override
        @Transient
        public final Builder used(Long used) {
            this.used = used;
            return this;
        }

        public final Long getMax() {
            return max;
        }

        public final void setMax(Long max) {
            this.max = max;
        }

        @Override
        @Transient
        public final Builder max(Long max) {
            this.max = max;
            return this;
        }

        @Override
        public AccountQuota build() {
            return new AccountQuota(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
