/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A control to display a text box that is used to enter multiple entries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterTextAreaControl implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterTextAreaControl.Builder, ParameterTextAreaControl> {
    private static final SdkField<String> PARAMETER_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterControlId").getter(getter(ParameterTextAreaControl::parameterControlId))
            .setter(setter(Builder::parameterControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterControlId").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(ParameterTextAreaControl::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> SOURCE_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceParameterName").getter(getter(ParameterTextAreaControl::sourceParameterName))
            .setter(setter(Builder::sourceParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceParameterName").build())
            .build();

    private static final SdkField<String> DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Delimiter").getter(getter(ParameterTextAreaControl::delimiter)).setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()).build();

    private static final SdkField<TextAreaControlDisplayOptions> DISPLAY_OPTIONS_FIELD = SdkField
            .<TextAreaControlDisplayOptions> builder(MarshallingType.SDK_POJO).memberName("DisplayOptions")
            .getter(getter(ParameterTextAreaControl::displayOptions)).setter(setter(Builder::displayOptions))
            .constructor(TextAreaControlDisplayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_CONTROL_ID_FIELD,
            TITLE_FIELD, SOURCE_PARAMETER_NAME_FIELD, DELIMITER_FIELD, DISPLAY_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterControlId;

    private final String title;

    private final String sourceParameterName;

    private final String delimiter;

    private final TextAreaControlDisplayOptions displayOptions;

    private ParameterTextAreaControl(BuilderImpl builder) {
        this.parameterControlId = builder.parameterControlId;
        this.title = builder.title;
        this.sourceParameterName = builder.sourceParameterName;
        this.delimiter = builder.delimiter;
        this.displayOptions = builder.displayOptions;
    }

    /**
     * <p>
     * The ID of the <code>ParameterTextAreaControl</code>.
     * </p>
     * 
     * @return The ID of the <code>ParameterTextAreaControl</code>.
     */
    public final String parameterControlId() {
        return parameterControlId;
    }

    /**
     * <p>
     * The title of the <code>ParameterTextAreaControl</code>.
     * </p>
     * 
     * @return The title of the <code>ParameterTextAreaControl</code>.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The source parameter name of the <code>ParameterTextAreaControl</code>.
     * </p>
     * 
     * @return The source parameter name of the <code>ParameterTextAreaControl</code>.
     */
    public final String sourceParameterName() {
        return sourceParameterName;
    }

    /**
     * <p>
     * The delimiter that is used to separate the lines in text.
     * </p>
     * 
     * @return The delimiter that is used to separate the lines in text.
     */
    public final String delimiter() {
        return delimiter;
    }

    /**
     * <p>
     * The display options of a control.
     * </p>
     * 
     * @return The display options of a control.
     */
    public final TextAreaControlDisplayOptions displayOptions() {
        return displayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(sourceParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(displayOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterTextAreaControl)) {
            return false;
        }
        ParameterTextAreaControl other = (ParameterTextAreaControl) obj;
        return Objects.equals(parameterControlId(), other.parameterControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(sourceParameterName(), other.sourceParameterName())
                && Objects.equals(delimiter(), other.delimiter()) && Objects.equals(displayOptions(), other.displayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParameterTextAreaControl").add("ParameterControlId", parameterControlId()).add("Title", title())
                .add("SourceParameterName", sourceParameterName()).add("Delimiter", delimiter())
                .add("DisplayOptions", displayOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterControlId":
            return Optional.ofNullable(clazz.cast(parameterControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "SourceParameterName":
            return Optional.ofNullable(clazz.cast(sourceParameterName()));
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "DisplayOptions":
            return Optional.ofNullable(clazz.cast(displayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterTextAreaControl, T> g) {
        return obj -> g.apply((ParameterTextAreaControl) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterTextAreaControl> {
        /**
         * <p>
         * The ID of the <code>ParameterTextAreaControl</code>.
         * </p>
         * 
         * @param parameterControlId
         *        The ID of the <code>ParameterTextAreaControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterControlId(String parameterControlId);

        /**
         * <p>
         * The title of the <code>ParameterTextAreaControl</code>.
         * </p>
         * 
         * @param title
         *        The title of the <code>ParameterTextAreaControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The source parameter name of the <code>ParameterTextAreaControl</code>.
         * </p>
         * 
         * @param sourceParameterName
         *        The source parameter name of the <code>ParameterTextAreaControl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceParameterName(String sourceParameterName);

        /**
         * <p>
         * The delimiter that is used to separate the lines in text.
         * </p>
         * 
         * @param delimiter
         *        The delimiter that is used to separate the lines in text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * 
         * @param displayOptions
         *        The display options of a control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayOptions(TextAreaControlDisplayOptions displayOptions);

        /**
         * <p>
         * The display options of a control.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextAreaControlDisplayOptions.Builder}
         * avoiding the need to create one manually via {@link TextAreaControlDisplayOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextAreaControlDisplayOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #displayOptions(TextAreaControlDisplayOptions)}.
         * 
         * @param displayOptions
         *        a consumer that will call methods on {@link TextAreaControlDisplayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #displayOptions(TextAreaControlDisplayOptions)
         */
        default Builder displayOptions(Consumer<TextAreaControlDisplayOptions.Builder> displayOptions) {
            return displayOptions(TextAreaControlDisplayOptions.builder().applyMutation(displayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterControlId;

        private String title;

        private String sourceParameterName;

        private String delimiter;

        private TextAreaControlDisplayOptions displayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterTextAreaControl model) {
            parameterControlId(model.parameterControlId);
            title(model.title);
            sourceParameterName(model.sourceParameterName);
            delimiter(model.delimiter);
            displayOptions(model.displayOptions);
        }

        public final String getParameterControlId() {
            return parameterControlId;
        }

        public final void setParameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
        }

        @Override
        public final Builder parameterControlId(String parameterControlId) {
            this.parameterControlId = parameterControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getSourceParameterName() {
            return sourceParameterName;
        }

        public final void setSourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
        }

        @Override
        public final Builder sourceParameterName(String sourceParameterName) {
            this.sourceParameterName = sourceParameterName;
            return this;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final TextAreaControlDisplayOptions.Builder getDisplayOptions() {
            return displayOptions != null ? displayOptions.toBuilder() : null;
        }

        public final void setDisplayOptions(TextAreaControlDisplayOptions.BuilderImpl displayOptions) {
            this.displayOptions = displayOptions != null ? displayOptions.build() : null;
        }

        @Override
        public final Builder displayOptions(TextAreaControlDisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
            return this;
        }

        @Override
        public ParameterTextAreaControl build() {
            return new ParameterTextAreaControl(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
