/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value input pf the numeric range filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericRangeFilterValue implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericRangeFilterValue.Builder, NumericRangeFilterValue> {
    private static final SdkField<Double> STATIC_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StaticValue").getter(getter(NumericRangeFilterValue::staticValue)).setter(setter(Builder::staticValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticValue").build()).build();

    private static final SdkField<String> PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameter").getter(getter(NumericRangeFilterValue::parameter)).setter(setter(Builder::parameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_VALUE_FIELD,
            PARAMETER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double staticValue;

    private final String parameter;

    private NumericRangeFilterValue(BuilderImpl builder) {
        this.staticValue = builder.staticValue;
        this.parameter = builder.parameter;
    }

    /**
     * <p>
     * The static value of the numeric range filter.
     * </p>
     * 
     * @return The static value of the numeric range filter.
     */
    public final Double staticValue() {
        return staticValue;
    }

    /**
     * <p>
     * The parameter that is used in the numeric range.
     * </p>
     * 
     * @return The parameter that is used in the numeric range.
     */
    public final String parameter() {
        return parameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticValue());
        hashCode = 31 * hashCode + Objects.hashCode(parameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericRangeFilterValue)) {
            return false;
        }
        NumericRangeFilterValue other = (NumericRangeFilterValue) obj;
        return Objects.equals(staticValue(), other.staticValue()) && Objects.equals(parameter(), other.parameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericRangeFilterValue").add("StaticValue", staticValue()).add("Parameter", parameter())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticValue":
            return Optional.ofNullable(clazz.cast(staticValue()));
        case "Parameter":
            return Optional.ofNullable(clazz.cast(parameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericRangeFilterValue, T> g) {
        return obj -> g.apply((NumericRangeFilterValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericRangeFilterValue> {
        /**
         * <p>
         * The static value of the numeric range filter.
         * </p>
         * 
         * @param staticValue
         *        The static value of the numeric range filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticValue(Double staticValue);

        /**
         * <p>
         * The parameter that is used in the numeric range.
         * </p>
         * 
         * @param parameter
         *        The parameter that is used in the numeric range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameter(String parameter);
    }

    static final class BuilderImpl implements Builder {
        private Double staticValue;

        private String parameter;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericRangeFilterValue model) {
            staticValue(model.staticValue);
            parameter(model.parameter);
        }

        public final Double getStaticValue() {
            return staticValue;
        }

        public final void setStaticValue(Double staticValue) {
            this.staticValue = staticValue;
        }

        @Override
        public final Builder staticValue(Double staticValue) {
            this.staticValue = staticValue;
            return this;
        }

        public final String getParameter() {
            return parameter;
        }

        public final void setParameter(String parameter) {
            this.parameter = parameter;
        }

        @Override
        public final Builder parameter(String parameter) {
            this.parameter = parameter;
            return this;
        }

        @Override
        public NumericRangeFilterValue build() {
            return new NumericRangeFilterValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
