/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A dataset parameter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetParameter.Builder, DatasetParameter> {
    private static final SdkField<StringDatasetParameter> STRING_DATASET_PARAMETER_FIELD = SdkField
            .<StringDatasetParameter> builder(MarshallingType.SDK_POJO).memberName("StringDatasetParameter")
            .getter(getter(DatasetParameter::stringDatasetParameter)).setter(setter(Builder::stringDatasetParameter))
            .constructor(StringDatasetParameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringDatasetParameter").build())
            .build();

    private static final SdkField<DecimalDatasetParameter> DECIMAL_DATASET_PARAMETER_FIELD = SdkField
            .<DecimalDatasetParameter> builder(MarshallingType.SDK_POJO).memberName("DecimalDatasetParameter")
            .getter(getter(DatasetParameter::decimalDatasetParameter)).setter(setter(Builder::decimalDatasetParameter))
            .constructor(DecimalDatasetParameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecimalDatasetParameter").build())
            .build();

    private static final SdkField<IntegerDatasetParameter> INTEGER_DATASET_PARAMETER_FIELD = SdkField
            .<IntegerDatasetParameter> builder(MarshallingType.SDK_POJO).memberName("IntegerDatasetParameter")
            .getter(getter(DatasetParameter::integerDatasetParameter)).setter(setter(Builder::integerDatasetParameter))
            .constructor(IntegerDatasetParameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerDatasetParameter").build())
            .build();

    private static final SdkField<DateTimeDatasetParameter> DATE_TIME_DATASET_PARAMETER_FIELD = SdkField
            .<DateTimeDatasetParameter> builder(MarshallingType.SDK_POJO).memberName("DateTimeDatasetParameter")
            .getter(getter(DatasetParameter::dateTimeDatasetParameter)).setter(setter(Builder::dateTimeDatasetParameter))
            .constructor(DateTimeDatasetParameter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateTimeDatasetParameter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STRING_DATASET_PARAMETER_FIELD, DECIMAL_DATASET_PARAMETER_FIELD, INTEGER_DATASET_PARAMETER_FIELD,
            DATE_TIME_DATASET_PARAMETER_FIELD));

    private static final long serialVersionUID = 1L;

    private final StringDatasetParameter stringDatasetParameter;

    private final DecimalDatasetParameter decimalDatasetParameter;

    private final IntegerDatasetParameter integerDatasetParameter;

    private final DateTimeDatasetParameter dateTimeDatasetParameter;

    private DatasetParameter(BuilderImpl builder) {
        this.stringDatasetParameter = builder.stringDatasetParameter;
        this.decimalDatasetParameter = builder.decimalDatasetParameter;
        this.integerDatasetParameter = builder.integerDatasetParameter;
        this.dateTimeDatasetParameter = builder.dateTimeDatasetParameter;
    }

    /**
     * <p>
     * A string parameter that is created in the dataset.
     * </p>
     * 
     * @return A string parameter that is created in the dataset.
     */
    public final StringDatasetParameter stringDatasetParameter() {
        return stringDatasetParameter;
    }

    /**
     * <p>
     * A decimal parameter that is created in the dataset.
     * </p>
     * 
     * @return A decimal parameter that is created in the dataset.
     */
    public final DecimalDatasetParameter decimalDatasetParameter() {
        return decimalDatasetParameter;
    }

    /**
     * <p>
     * An integer parameter that is created in the dataset.
     * </p>
     * 
     * @return An integer parameter that is created in the dataset.
     */
    public final IntegerDatasetParameter integerDatasetParameter() {
        return integerDatasetParameter;
    }

    /**
     * <p>
     * A date time parameter that is created in the dataset.
     * </p>
     * 
     * @return A date time parameter that is created in the dataset.
     */
    public final DateTimeDatasetParameter dateTimeDatasetParameter() {
        return dateTimeDatasetParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringDatasetParameter());
        hashCode = 31 * hashCode + Objects.hashCode(decimalDatasetParameter());
        hashCode = 31 * hashCode + Objects.hashCode(integerDatasetParameter());
        hashCode = 31 * hashCode + Objects.hashCode(dateTimeDatasetParameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetParameter)) {
            return false;
        }
        DatasetParameter other = (DatasetParameter) obj;
        return Objects.equals(stringDatasetParameter(), other.stringDatasetParameter())
                && Objects.equals(decimalDatasetParameter(), other.decimalDatasetParameter())
                && Objects.equals(integerDatasetParameter(), other.integerDatasetParameter())
                && Objects.equals(dateTimeDatasetParameter(), other.dateTimeDatasetParameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetParameter").add("StringDatasetParameter", stringDatasetParameter())
                .add("DecimalDatasetParameter", decimalDatasetParameter())
                .add("IntegerDatasetParameter", integerDatasetParameter())
                .add("DateTimeDatasetParameter", dateTimeDatasetParameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StringDatasetParameter":
            return Optional.ofNullable(clazz.cast(stringDatasetParameter()));
        case "DecimalDatasetParameter":
            return Optional.ofNullable(clazz.cast(decimalDatasetParameter()));
        case "IntegerDatasetParameter":
            return Optional.ofNullable(clazz.cast(integerDatasetParameter()));
        case "DateTimeDatasetParameter":
            return Optional.ofNullable(clazz.cast(dateTimeDatasetParameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetParameter, T> g) {
        return obj -> g.apply((DatasetParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetParameter> {
        /**
         * <p>
         * A string parameter that is created in the dataset.
         * </p>
         * 
         * @param stringDatasetParameter
         *        A string parameter that is created in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringDatasetParameter(StringDatasetParameter stringDatasetParameter);

        /**
         * <p>
         * A string parameter that is created in the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringDatasetParameter.Builder} avoiding
         * the need to create one manually via {@link StringDatasetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringDatasetParameter.Builder#build()} is called immediately and
         * its result is passed to {@link #stringDatasetParameter(StringDatasetParameter)}.
         * 
         * @param stringDatasetParameter
         *        a consumer that will call methods on {@link StringDatasetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stringDatasetParameter(StringDatasetParameter)
         */
        default Builder stringDatasetParameter(Consumer<StringDatasetParameter.Builder> stringDatasetParameter) {
            return stringDatasetParameter(StringDatasetParameter.builder().applyMutation(stringDatasetParameter).build());
        }

        /**
         * <p>
         * A decimal parameter that is created in the dataset.
         * </p>
         * 
         * @param decimalDatasetParameter
         *        A decimal parameter that is created in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decimalDatasetParameter(DecimalDatasetParameter decimalDatasetParameter);

        /**
         * <p>
         * A decimal parameter that is created in the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DecimalDatasetParameter.Builder} avoiding
         * the need to create one manually via {@link DecimalDatasetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DecimalDatasetParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #decimalDatasetParameter(DecimalDatasetParameter)}.
         * 
         * @param decimalDatasetParameter
         *        a consumer that will call methods on {@link DecimalDatasetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #decimalDatasetParameter(DecimalDatasetParameter)
         */
        default Builder decimalDatasetParameter(Consumer<DecimalDatasetParameter.Builder> decimalDatasetParameter) {
            return decimalDatasetParameter(DecimalDatasetParameter.builder().applyMutation(decimalDatasetParameter).build());
        }

        /**
         * <p>
         * An integer parameter that is created in the dataset.
         * </p>
         * 
         * @param integerDatasetParameter
         *        An integer parameter that is created in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerDatasetParameter(IntegerDatasetParameter integerDatasetParameter);

        /**
         * <p>
         * An integer parameter that is created in the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntegerDatasetParameter.Builder} avoiding
         * the need to create one manually via {@link IntegerDatasetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntegerDatasetParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #integerDatasetParameter(IntegerDatasetParameter)}.
         * 
         * @param integerDatasetParameter
         *        a consumer that will call methods on {@link IntegerDatasetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #integerDatasetParameter(IntegerDatasetParameter)
         */
        default Builder integerDatasetParameter(Consumer<IntegerDatasetParameter.Builder> integerDatasetParameter) {
            return integerDatasetParameter(IntegerDatasetParameter.builder().applyMutation(integerDatasetParameter).build());
        }

        /**
         * <p>
         * A date time parameter that is created in the dataset.
         * </p>
         * 
         * @param dateTimeDatasetParameter
         *        A date time parameter that is created in the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateTimeDatasetParameter(DateTimeDatasetParameter dateTimeDatasetParameter);

        /**
         * <p>
         * A date time parameter that is created in the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateTimeDatasetParameter.Builder}
         * avoiding the need to create one manually via {@link DateTimeDatasetParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateTimeDatasetParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #dateTimeDatasetParameter(DateTimeDatasetParameter)}.
         * 
         * @param dateTimeDatasetParameter
         *        a consumer that will call methods on {@link DateTimeDatasetParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateTimeDatasetParameter(DateTimeDatasetParameter)
         */
        default Builder dateTimeDatasetParameter(Consumer<DateTimeDatasetParameter.Builder> dateTimeDatasetParameter) {
            return dateTimeDatasetParameter(DateTimeDatasetParameter.builder().applyMutation(dateTimeDatasetParameter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StringDatasetParameter stringDatasetParameter;

        private DecimalDatasetParameter decimalDatasetParameter;

        private IntegerDatasetParameter integerDatasetParameter;

        private DateTimeDatasetParameter dateTimeDatasetParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetParameter model) {
            stringDatasetParameter(model.stringDatasetParameter);
            decimalDatasetParameter(model.decimalDatasetParameter);
            integerDatasetParameter(model.integerDatasetParameter);
            dateTimeDatasetParameter(model.dateTimeDatasetParameter);
        }

        public final StringDatasetParameter.Builder getStringDatasetParameter() {
            return stringDatasetParameter != null ? stringDatasetParameter.toBuilder() : null;
        }

        public final void setStringDatasetParameter(StringDatasetParameter.BuilderImpl stringDatasetParameter) {
            this.stringDatasetParameter = stringDatasetParameter != null ? stringDatasetParameter.build() : null;
        }

        @Override
        public final Builder stringDatasetParameter(StringDatasetParameter stringDatasetParameter) {
            this.stringDatasetParameter = stringDatasetParameter;
            return this;
        }

        public final DecimalDatasetParameter.Builder getDecimalDatasetParameter() {
            return decimalDatasetParameter != null ? decimalDatasetParameter.toBuilder() : null;
        }

        public final void setDecimalDatasetParameter(DecimalDatasetParameter.BuilderImpl decimalDatasetParameter) {
            this.decimalDatasetParameter = decimalDatasetParameter != null ? decimalDatasetParameter.build() : null;
        }

        @Override
        public final Builder decimalDatasetParameter(DecimalDatasetParameter decimalDatasetParameter) {
            this.decimalDatasetParameter = decimalDatasetParameter;
            return this;
        }

        public final IntegerDatasetParameter.Builder getIntegerDatasetParameter() {
            return integerDatasetParameter != null ? integerDatasetParameter.toBuilder() : null;
        }

        public final void setIntegerDatasetParameter(IntegerDatasetParameter.BuilderImpl integerDatasetParameter) {
            this.integerDatasetParameter = integerDatasetParameter != null ? integerDatasetParameter.build() : null;
        }

        @Override
        public final Builder integerDatasetParameter(IntegerDatasetParameter integerDatasetParameter) {
            this.integerDatasetParameter = integerDatasetParameter;
            return this;
        }

        public final DateTimeDatasetParameter.Builder getDateTimeDatasetParameter() {
            return dateTimeDatasetParameter != null ? dateTimeDatasetParameter.toBuilder() : null;
        }

        public final void setDateTimeDatasetParameter(DateTimeDatasetParameter.BuilderImpl dateTimeDatasetParameter) {
            this.dateTimeDatasetParameter = dateTimeDatasetParameter != null ? dateTimeDatasetParameter.build() : null;
        }

        @Override
        public final Builder dateTimeDatasetParameter(DateTimeDatasetParameter dateTimeDatasetParameter) {
            this.dateTimeDatasetParameter = dateTimeDatasetParameter;
            return this;
        }

        @Override
        public DatasetParameter build() {
            return new DatasetParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
