/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contents of a dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardVersionDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardVersionDefinition.Builder, DashboardVersionDefinition> {
    private static final SdkField<List<DataSetIdentifierDeclaration>> DATA_SET_IDENTIFIER_DECLARATIONS_FIELD = SdkField
            .<List<DataSetIdentifierDeclaration>> builder(MarshallingType.LIST)
            .memberName("DataSetIdentifierDeclarations")
            .getter(getter(DashboardVersionDefinition::dataSetIdentifierDeclarations))
            .setter(setter(Builder::dataSetIdentifierDeclarations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetIdentifierDeclarations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSetIdentifierDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSetIdentifierDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SheetDefinition>> SHEETS_FIELD = SdkField
            .<List<SheetDefinition>> builder(MarshallingType.LIST)
            .memberName("Sheets")
            .getter(getter(DashboardVersionDefinition::sheets))
            .setter(setter(Builder::sheets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SheetDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SheetDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CalculatedField>> CALCULATED_FIELDS_FIELD = SdkField
            .<List<CalculatedField>> builder(MarshallingType.LIST)
            .memberName("CalculatedFields")
            .getter(getter(DashboardVersionDefinition::calculatedFields))
            .setter(setter(Builder::calculatedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CalculatedField> builder(MarshallingType.SDK_POJO)
                                            .constructor(CalculatedField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterDeclaration>> PARAMETER_DECLARATIONS_FIELD = SdkField
            .<List<ParameterDeclaration>> builder(MarshallingType.LIST)
            .memberName("ParameterDeclarations")
            .getter(getter(DashboardVersionDefinition::parameterDeclarations))
            .setter(setter(Builder::parameterDeclarations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterDeclarations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterDeclaration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterDeclaration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FilterGroup>> FILTER_GROUPS_FIELD = SdkField
            .<List<FilterGroup>> builder(MarshallingType.LIST)
            .memberName("FilterGroups")
            .getter(getter(DashboardVersionDefinition::filterGroups))
            .setter(setter(Builder::filterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ColumnConfiguration>> COLUMN_CONFIGURATIONS_FIELD = SdkField
            .<List<ColumnConfiguration>> builder(MarshallingType.LIST)
            .memberName("ColumnConfigurations")
            .getter(getter(DashboardVersionDefinition::columnConfigurations))
            .setter(setter(Builder::columnConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AnalysisDefaults> ANALYSIS_DEFAULTS_FIELD = SdkField
            .<AnalysisDefaults> builder(MarshallingType.SDK_POJO).memberName("AnalysisDefaults")
            .getter(getter(DashboardVersionDefinition::analysisDefaults)).setter(setter(Builder::analysisDefaults))
            .constructor(AnalysisDefaults::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisDefaults").build()).build();

    private static final SdkField<AssetOptions> OPTIONS_FIELD = SdkField.<AssetOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Options").getter(getter(DashboardVersionDefinition::options)).setter(setter(Builder::options))
            .constructor(AssetOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_SET_IDENTIFIER_DECLARATIONS_FIELD, SHEETS_FIELD, CALCULATED_FIELDS_FIELD, PARAMETER_DECLARATIONS_FIELD,
            FILTER_GROUPS_FIELD, COLUMN_CONFIGURATIONS_FIELD, ANALYSIS_DEFAULTS_FIELD, OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations;

    private final List<SheetDefinition> sheets;

    private final List<CalculatedField> calculatedFields;

    private final List<ParameterDeclaration> parameterDeclarations;

    private final List<FilterGroup> filterGroups;

    private final List<ColumnConfiguration> columnConfigurations;

    private final AnalysisDefaults analysisDefaults;

    private final AssetOptions options;

    private DashboardVersionDefinition(BuilderImpl builder) {
        this.dataSetIdentifierDeclarations = builder.dataSetIdentifierDeclarations;
        this.sheets = builder.sheets;
        this.calculatedFields = builder.calculatedFields;
        this.parameterDeclarations = builder.parameterDeclarations;
        this.filterGroups = builder.filterGroups;
        this.columnConfigurations = builder.columnConfigurations;
        this.analysisDefaults = builder.analysisDefaults;
        this.options = builder.options;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSetIdentifierDeclarations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataSetIdentifierDeclarations() {
        return dataSetIdentifierDeclarations != null && !(dataSetIdentifierDeclarations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead of dataset
     * Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSetIdentifierDeclarations} method.
     * </p>
     * 
     * @return An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead of
     *         dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
     */
    public final List<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations() {
        return dataSetIdentifierDeclarations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sheets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSheets() {
        return sheets != null && !(sheets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of sheet definitions for a dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSheets} method.
     * </p>
     * 
     * @return An array of sheet definitions for a dashboard.
     */
    public final List<SheetDefinition> sheets() {
        return sheets;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalculatedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCalculatedFields() {
        return calculatedFields != null && !(calculatedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of calculated field definitions for the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalculatedFields} method.
     * </p>
     * 
     * @return An array of calculated field definitions for the dashboard.
     */
    public final List<CalculatedField> calculatedFields() {
        return calculatedFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterDeclarations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasParameterDeclarations() {
        return parameterDeclarations != null && !(parameterDeclarations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameter declarations for a dashboard. Parameters are named variables that can transfer a value for use by
     * an action or an object.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterDeclarations} method.
     * </p>
     * 
     * @return The parameter declarations for a dashboard. Parameters are named variables that can transfer a value for
     *         use by an action or an object.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in
     *         Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<ParameterDeclaration> parameterDeclarations() {
        return parameterDeclarations;
    }

    /**
     * For responses, this returns true if the service returned a value for the FilterGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFilterGroups() {
        return filterGroups != null && !(filterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter definitions for a dashboard.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilterGroups} method.
     * </p>
     * 
     * @return The filter definitions for a dashboard.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon
     *         QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<FilterGroup> filterGroups() {
        return filterGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnConfigurations() {
        return columnConfigurations != null && !(columnConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of dashboard-level column configurations. Column configurations are used to set the default formatting
     * for a column that is used throughout a dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnConfigurations} method.
     * </p>
     * 
     * @return An array of dashboard-level column configurations. Column configurations are used to set the default
     *         formatting for a column that is used throughout a dashboard.
     */
    public final List<ColumnConfiguration> columnConfigurations() {
        return columnConfigurations;
    }

    /**
     * Returns the value of the AnalysisDefaults property for this object.
     * 
     * @return The value of the AnalysisDefaults property for this object.
     */
    public final AnalysisDefaults analysisDefaults() {
        return analysisDefaults;
    }

    /**
     * <p>
     * An array of option definitions for a dashboard.
     * </p>
     * 
     * @return An array of option definitions for a dashboard.
     */
    public final AssetOptions options() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSetIdentifierDeclarations() ? dataSetIdentifierDeclarations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSheets() ? sheets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCalculatedFields() ? calculatedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterDeclarations() ? parameterDeclarations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilterGroups() ? filterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnConfigurations() ? columnConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analysisDefaults());
        hashCode = 31 * hashCode + Objects.hashCode(options());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVersionDefinition)) {
            return false;
        }
        DashboardVersionDefinition other = (DashboardVersionDefinition) obj;
        return hasDataSetIdentifierDeclarations() == other.hasDataSetIdentifierDeclarations()
                && Objects.equals(dataSetIdentifierDeclarations(), other.dataSetIdentifierDeclarations())
                && hasSheets() == other.hasSheets() && Objects.equals(sheets(), other.sheets())
                && hasCalculatedFields() == other.hasCalculatedFields()
                && Objects.equals(calculatedFields(), other.calculatedFields())
                && hasParameterDeclarations() == other.hasParameterDeclarations()
                && Objects.equals(parameterDeclarations(), other.parameterDeclarations())
                && hasFilterGroups() == other.hasFilterGroups() && Objects.equals(filterGroups(), other.filterGroups())
                && hasColumnConfigurations() == other.hasColumnConfigurations()
                && Objects.equals(columnConfigurations(), other.columnConfigurations())
                && Objects.equals(analysisDefaults(), other.analysisDefaults()) && Objects.equals(options(), other.options());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DashboardVersionDefinition")
                .add("DataSetIdentifierDeclarations", hasDataSetIdentifierDeclarations() ? dataSetIdentifierDeclarations() : null)
                .add("Sheets", hasSheets() ? sheets() : null)
                .add("CalculatedFields", hasCalculatedFields() ? calculatedFields() : null)
                .add("ParameterDeclarations", hasParameterDeclarations() ? parameterDeclarations() : null)
                .add("FilterGroups", hasFilterGroups() ? filterGroups() : null)
                .add("ColumnConfigurations", hasColumnConfigurations() ? columnConfigurations() : null)
                .add("AnalysisDefaults", analysisDefaults()).add("Options", options()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetIdentifierDeclarations":
            return Optional.ofNullable(clazz.cast(dataSetIdentifierDeclarations()));
        case "Sheets":
            return Optional.ofNullable(clazz.cast(sheets()));
        case "CalculatedFields":
            return Optional.ofNullable(clazz.cast(calculatedFields()));
        case "ParameterDeclarations":
            return Optional.ofNullable(clazz.cast(parameterDeclarations()));
        case "FilterGroups":
            return Optional.ofNullable(clazz.cast(filterGroups()));
        case "ColumnConfigurations":
            return Optional.ofNullable(clazz.cast(columnConfigurations()));
        case "AnalysisDefaults":
            return Optional.ofNullable(clazz.cast(analysisDefaults()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardVersionDefinition, T> g) {
        return obj -> g.apply((DashboardVersionDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardVersionDefinition> {
        /**
         * <p>
         * An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead of
         * dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
         * </p>
         * 
         * @param dataSetIdentifierDeclarations
         *        An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead
         *        of dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifierDeclarations(Collection<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations);

        /**
         * <p>
         * An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead of
         * dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
         * </p>
         * 
         * @param dataSetIdentifierDeclarations
         *        An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead
         *        of dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetIdentifierDeclarations(DataSetIdentifierDeclaration... dataSetIdentifierDeclarations);

        /**
         * <p>
         * An array of dataset identifier declarations. With this mapping,you can use dataset identifiers instead of
         * dataset Amazon Resource Names (ARNs) throughout the dashboard's sub-structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetIdentifierDeclaration.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetIdentifierDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.DataSetIdentifierDeclaration.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #dataSetIdentifierDeclarations(List<DataSetIdentifierDeclaration>)}.
         * 
         * @param dataSetIdentifierDeclarations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.DataSetIdentifierDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSetIdentifierDeclarations(java.util.Collection<DataSetIdentifierDeclaration>)
         */
        Builder dataSetIdentifierDeclarations(Consumer<DataSetIdentifierDeclaration.Builder>... dataSetIdentifierDeclarations);

        /**
         * <p>
         * An array of sheet definitions for a dashboard.
         * </p>
         * 
         * @param sheets
         *        An array of sheet definitions for a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheets(Collection<SheetDefinition> sheets);

        /**
         * <p>
         * An array of sheet definitions for a dashboard.
         * </p>
         * 
         * @param sheets
         *        An array of sheet definitions for a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheets(SheetDefinition... sheets);

        /**
         * <p>
         * An array of sheet definitions for a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.SheetDefinition.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.SheetDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.SheetDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #sheets(List<SheetDefinition>)}.
         * 
         * @param sheets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.SheetDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sheets(java.util.Collection<SheetDefinition>)
         */
        Builder sheets(Consumer<SheetDefinition.Builder>... sheets);

        /**
         * <p>
         * An array of calculated field definitions for the dashboard.
         * </p>
         * 
         * @param calculatedFields
         *        An array of calculated field definitions for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFields(Collection<CalculatedField> calculatedFields);

        /**
         * <p>
         * An array of calculated field definitions for the dashboard.
         * </p>
         * 
         * @param calculatedFields
         *        An array of calculated field definitions for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calculatedFields(CalculatedField... calculatedFields);

        /**
         * <p>
         * An array of calculated field definitions for the dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.CalculatedField.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.CalculatedField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.CalculatedField.Builder#build()} is called
         * immediately and its result is passed to {@link #calculatedFields(List<CalculatedField>)}.
         * 
         * @param calculatedFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.CalculatedField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #calculatedFields(java.util.Collection<CalculatedField>)
         */
        Builder calculatedFields(Consumer<CalculatedField.Builder>... calculatedFields);

        /**
         * <p>
         * The parameter declarations for a dashboard. Parameters are named variables that can transfer a value for use
         * by an action or an object.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon
         * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param parameterDeclarations
         *        The parameter declarations for a dashboard. Parameters are named variables that can transfer a value
         *        for use by an action or an object.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in
         *        Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterDeclarations(Collection<ParameterDeclaration> parameterDeclarations);

        /**
         * <p>
         * The parameter declarations for a dashboard. Parameters are named variables that can transfer a value for use
         * by an action or an object.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon
         * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param parameterDeclarations
         *        The parameter declarations for a dashboard. Parameters are named variables that can transfer a value
         *        for use by an action or an object.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in
         *        Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterDeclarations(ParameterDeclaration... parameterDeclarations);

        /**
         * <p>
         * The parameter declarations for a dashboard. Parameters are named variables that can transfer a value for use
         * by an action or an object.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html">Parameters in Amazon
         * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ParameterDeclaration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ParameterDeclaration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ParameterDeclaration.Builder#build()} is called
         * immediately and its result is passed to {@link #parameterDeclarations(List<ParameterDeclaration>)}.
         * 
         * @param parameterDeclarations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ParameterDeclaration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterDeclarations(java.util.Collection<ParameterDeclaration>)
         */
        Builder parameterDeclarations(Consumer<ParameterDeclaration.Builder>... parameterDeclarations);

        /**
         * <p>
         * The filter definitions for a dashboard.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon
         * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param filterGroups
         *        The filter definitions for a dashboard.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in
         *        Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterGroups(Collection<FilterGroup> filterGroups);

        /**
         * <p>
         * The filter definitions for a dashboard.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon
         * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param filterGroups
         *        The filter definitions for a dashboard.</p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in
         *        Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterGroups(FilterGroup... filterGroups);

        /**
         * <p>
         * The filter definitions for a dashboard.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html">Filtering Data in Amazon
         * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FilterGroup.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.FilterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FilterGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #filterGroups(List<FilterGroup>)}.
         * 
         * @param filterGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterGroups(java.util.Collection<FilterGroup>)
         */
        Builder filterGroups(Consumer<FilterGroup.Builder>... filterGroups);

        /**
         * <p>
         * An array of dashboard-level column configurations. Column configurations are used to set the default
         * formatting for a column that is used throughout a dashboard.
         * </p>
         * 
         * @param columnConfigurations
         *        An array of dashboard-level column configurations. Column configurations are used to set the default
         *        formatting for a column that is used throughout a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnConfigurations(Collection<ColumnConfiguration> columnConfigurations);

        /**
         * <p>
         * An array of dashboard-level column configurations. Column configurations are used to set the default
         * formatting for a column that is used throughout a dashboard.
         * </p>
         * 
         * @param columnConfigurations
         *        An array of dashboard-level column configurations. Column configurations are used to set the default
         *        formatting for a column that is used throughout a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnConfigurations(ColumnConfiguration... columnConfigurations);

        /**
         * <p>
         * An array of dashboard-level column configurations. Column configurations are used to set the default
         * formatting for a column that is used throughout a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.ColumnConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #columnConfigurations(List<ColumnConfiguration>)}.
         * 
         * @param columnConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.ColumnConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnConfigurations(java.util.Collection<ColumnConfiguration>)
         */
        Builder columnConfigurations(Consumer<ColumnConfiguration.Builder>... columnConfigurations);

        /**
         * Sets the value of the AnalysisDefaults property for this object.
         *
         * @param analysisDefaults
         *        The new value for the AnalysisDefaults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisDefaults(AnalysisDefaults analysisDefaults);

        /**
         * Sets the value of the AnalysisDefaults property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnalysisDefaults.Builder} avoiding the
         * need to create one manually via {@link AnalysisDefaults#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisDefaults.Builder#build()} is called immediately and its
         * result is passed to {@link #analysisDefaults(AnalysisDefaults)}.
         * 
         * @param analysisDefaults
         *        a consumer that will call methods on {@link AnalysisDefaults.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisDefaults(AnalysisDefaults)
         */
        default Builder analysisDefaults(Consumer<AnalysisDefaults.Builder> analysisDefaults) {
            return analysisDefaults(AnalysisDefaults.builder().applyMutation(analysisDefaults).build());
        }

        /**
         * <p>
         * An array of option definitions for a dashboard.
         * </p>
         * 
         * @param options
         *        An array of option definitions for a dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(AssetOptions options);

        /**
         * <p>
         * An array of option definitions for a dashboard.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssetOptions.Builder} avoiding the need
         * to create one manually via {@link AssetOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #options(AssetOptions)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link AssetOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(AssetOptions)
         */
        default Builder options(Consumer<AssetOptions.Builder> options) {
            return options(AssetOptions.builder().applyMutation(options).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations = DefaultSdkAutoConstructList.getInstance();

        private List<SheetDefinition> sheets = DefaultSdkAutoConstructList.getInstance();

        private List<CalculatedField> calculatedFields = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterDeclaration> parameterDeclarations = DefaultSdkAutoConstructList.getInstance();

        private List<FilterGroup> filterGroups = DefaultSdkAutoConstructList.getInstance();

        private List<ColumnConfiguration> columnConfigurations = DefaultSdkAutoConstructList.getInstance();

        private AnalysisDefaults analysisDefaults;

        private AssetOptions options;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVersionDefinition model) {
            dataSetIdentifierDeclarations(model.dataSetIdentifierDeclarations);
            sheets(model.sheets);
            calculatedFields(model.calculatedFields);
            parameterDeclarations(model.parameterDeclarations);
            filterGroups(model.filterGroups);
            columnConfigurations(model.columnConfigurations);
            analysisDefaults(model.analysisDefaults);
            options(model.options);
        }

        public final List<DataSetIdentifierDeclaration.Builder> getDataSetIdentifierDeclarations() {
            List<DataSetIdentifierDeclaration.Builder> result = DataSetIdentifierDeclarationListCopier
                    .copyToBuilder(this.dataSetIdentifierDeclarations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSetIdentifierDeclarations(
                Collection<DataSetIdentifierDeclaration.BuilderImpl> dataSetIdentifierDeclarations) {
            this.dataSetIdentifierDeclarations = DataSetIdentifierDeclarationListCopier
                    .copyFromBuilder(dataSetIdentifierDeclarations);
        }

        @Override
        public final Builder dataSetIdentifierDeclarations(Collection<DataSetIdentifierDeclaration> dataSetIdentifierDeclarations) {
            this.dataSetIdentifierDeclarations = DataSetIdentifierDeclarationListCopier.copy(dataSetIdentifierDeclarations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetIdentifierDeclarations(DataSetIdentifierDeclaration... dataSetIdentifierDeclarations) {
            dataSetIdentifierDeclarations(Arrays.asList(dataSetIdentifierDeclarations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetIdentifierDeclarations(
                Consumer<DataSetIdentifierDeclaration.Builder>... dataSetIdentifierDeclarations) {
            dataSetIdentifierDeclarations(Stream.of(dataSetIdentifierDeclarations)
                    .map(c -> DataSetIdentifierDeclaration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SheetDefinition.Builder> getSheets() {
            List<SheetDefinition.Builder> result = SheetDefinitionListCopier.copyToBuilder(this.sheets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheets(Collection<SheetDefinition.BuilderImpl> sheets) {
            this.sheets = SheetDefinitionListCopier.copyFromBuilder(sheets);
        }

        @Override
        public final Builder sheets(Collection<SheetDefinition> sheets) {
            this.sheets = SheetDefinitionListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(SheetDefinition... sheets) {
            sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<SheetDefinition.Builder>... sheets) {
            sheets(Stream.of(sheets).map(c -> SheetDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CalculatedField.Builder> getCalculatedFields() {
            List<CalculatedField.Builder> result = CalculatedFieldsCopier.copyToBuilder(this.calculatedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCalculatedFields(Collection<CalculatedField.BuilderImpl> calculatedFields) {
            this.calculatedFields = CalculatedFieldsCopier.copyFromBuilder(calculatedFields);
        }

        @Override
        public final Builder calculatedFields(Collection<CalculatedField> calculatedFields) {
            this.calculatedFields = CalculatedFieldsCopier.copy(calculatedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(CalculatedField... calculatedFields) {
            calculatedFields(Arrays.asList(calculatedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder calculatedFields(Consumer<CalculatedField.Builder>... calculatedFields) {
            calculatedFields(Stream.of(calculatedFields).map(c -> CalculatedField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterDeclaration.Builder> getParameterDeclarations() {
            List<ParameterDeclaration.Builder> result = ParameterDeclarationListCopier.copyToBuilder(this.parameterDeclarations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameterDeclarations(Collection<ParameterDeclaration.BuilderImpl> parameterDeclarations) {
            this.parameterDeclarations = ParameterDeclarationListCopier.copyFromBuilder(parameterDeclarations);
        }

        @Override
        public final Builder parameterDeclarations(Collection<ParameterDeclaration> parameterDeclarations) {
            this.parameterDeclarations = ParameterDeclarationListCopier.copy(parameterDeclarations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDeclarations(ParameterDeclaration... parameterDeclarations) {
            parameterDeclarations(Arrays.asList(parameterDeclarations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDeclarations(Consumer<ParameterDeclaration.Builder>... parameterDeclarations) {
            parameterDeclarations(Stream.of(parameterDeclarations)
                    .map(c -> ParameterDeclaration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FilterGroup.Builder> getFilterGroups() {
            List<FilterGroup.Builder> result = FilterGroupListCopier.copyToBuilder(this.filterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterGroups(Collection<FilterGroup.BuilderImpl> filterGroups) {
            this.filterGroups = FilterGroupListCopier.copyFromBuilder(filterGroups);
        }

        @Override
        public final Builder filterGroups(Collection<FilterGroup> filterGroups) {
            this.filterGroups = FilterGroupListCopier.copy(filterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(FilterGroup... filterGroups) {
            filterGroups(Arrays.asList(filterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(Consumer<FilterGroup.Builder>... filterGroups) {
            filterGroups(Stream.of(filterGroups).map(c -> FilterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ColumnConfiguration.Builder> getColumnConfigurations() {
            List<ColumnConfiguration.Builder> result = ColumnConfigurationListCopier.copyToBuilder(this.columnConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnConfigurations(Collection<ColumnConfiguration.BuilderImpl> columnConfigurations) {
            this.columnConfigurations = ColumnConfigurationListCopier.copyFromBuilder(columnConfigurations);
        }

        @Override
        public final Builder columnConfigurations(Collection<ColumnConfiguration> columnConfigurations) {
            this.columnConfigurations = ColumnConfigurationListCopier.copy(columnConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnConfigurations(ColumnConfiguration... columnConfigurations) {
            columnConfigurations(Arrays.asList(columnConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnConfigurations(Consumer<ColumnConfiguration.Builder>... columnConfigurations) {
            columnConfigurations(Stream.of(columnConfigurations).map(c -> ColumnConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AnalysisDefaults.Builder getAnalysisDefaults() {
            return analysisDefaults != null ? analysisDefaults.toBuilder() : null;
        }

        public final void setAnalysisDefaults(AnalysisDefaults.BuilderImpl analysisDefaults) {
            this.analysisDefaults = analysisDefaults != null ? analysisDefaults.build() : null;
        }

        @Override
        public final Builder analysisDefaults(AnalysisDefaults analysisDefaults) {
            this.analysisDefaults = analysisDefaults;
            return this;
        }

        public final AssetOptions.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        public final void setOptions(AssetOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        @Override
        public final Builder options(AssetOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public DashboardVersionDefinition build() {
            return new DashboardVersionDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
