/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the following account information elements:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Your Amazon QuickSight account name.
 * </p>
 * </li>
 * <li>
 * <p>
 * The edition of Amazon QuickSight that your account is using.
 * </p>
 * </li>
 * <li>
 * <p>
 * The notification email address that is associated with the Amazon QuickSight account.
 * </p>
 * </li>
 * <li>
 * <p>
 * The authentication type of the Amazon QuickSight account.
 * </p>
 * </li>
 * <li>
 * <p>
 * The status of the Amazon QuickSight account's subscription.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountInfo implements SdkPojo, Serializable, ToCopyableBuilder<AccountInfo.Builder, AccountInfo> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(AccountInfo::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(AccountInfo::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationEmail").getter(getter(AccountInfo::notificationEmail))
            .setter(setter(Builder::notificationEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(AccountInfo::authenticationType))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<String> ACCOUNT_SUBSCRIPTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountSubscriptionStatus").getter(getter(AccountInfo::accountSubscriptionStatus))
            .setter(setter(Builder::accountSubscriptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSubscriptionStatus").build())
            .build();

    private static final SdkField<String> IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IAMIdentityCenterInstanceArn")
            .getter(getter(AccountInfo::iamIdentityCenterInstanceArn))
            .setter(setter(Builder::iamIdentityCenterInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMIdentityCenterInstanceArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD,
            EDITION_FIELD, NOTIFICATION_EMAIL_FIELD, AUTHENTICATION_TYPE_FIELD, ACCOUNT_SUBSCRIPTION_STATUS_FIELD,
            IAM_IDENTITY_CENTER_INSTANCE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountName;

    private final String edition;

    private final String notificationEmail;

    private final String authenticationType;

    private final String accountSubscriptionStatus;

    private final String iamIdentityCenterInstanceArn;

    private AccountInfo(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.edition = builder.edition;
        this.notificationEmail = builder.notificationEmail;
        this.authenticationType = builder.authenticationType;
        this.accountSubscriptionStatus = builder.accountSubscriptionStatus;
        this.iamIdentityCenterInstanceArn = builder.iamIdentityCenterInstanceArn;
    }

    /**
     * <p>
     * The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services account.
     * You create this name when you sign up for Amazon QuickSight. It's unique over all of Amazon Web Services, and it
     * appears only when users sign in.
     * </p>
     * 
     * @return The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services
     *         account. You create this name when you sign up for Amazon QuickSight. It's unique over all of Amazon Web
     *         Services, and it appears only when users sign in.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The edition of your Amazon QuickSight account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of your Amazon QuickSight account.
     * @see Edition
     */
    public final Edition edition() {
        return Edition.fromValue(edition);
    }

    /**
     * <p>
     * The edition of your Amazon QuickSight account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of your Amazon QuickSight account.
     * @see Edition
     */
    public final String editionAsString() {
        return edition;
    }

    /**
     * <p>
     * The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon Web
     * Services account or Amazon QuickSight subscription.
     * </p>
     * 
     * @return The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon Web
     *         Services account or Amazon QuickSight subscription.
     */
    public final String notificationEmail() {
        return notificationEmail;
    }

    /**
     * <p>
     * The way that your Amazon QuickSight account is authenticated.
     * </p>
     * 
     * @return The way that your Amazon QuickSight account is authenticated.
     */
    public final String authenticationType() {
        return authenticationType;
    }

    /**
     * <p>
     * The status of your account subscription.
     * </p>
     * 
     * @return The status of your account subscription.
     */
    public final String accountSubscriptionStatus() {
        return accountSubscriptionStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM Identity Center instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM Identity Center instance.
     */
    public final String iamIdentityCenterInstanceArn() {
        return iamIdentityCenterInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEmail());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(accountSubscriptionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterInstanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountInfo)) {
            return false;
        }
        AccountInfo other = (AccountInfo) obj;
        return Objects.equals(accountName(), other.accountName()) && Objects.equals(editionAsString(), other.editionAsString())
                && Objects.equals(notificationEmail(), other.notificationEmail())
                && Objects.equals(authenticationType(), other.authenticationType())
                && Objects.equals(accountSubscriptionStatus(), other.accountSubscriptionStatus())
                && Objects.equals(iamIdentityCenterInstanceArn(), other.iamIdentityCenterInstanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountInfo").add("AccountName", accountName()).add("Edition", editionAsString())
                .add("NotificationEmail", notificationEmail()).add("AuthenticationType", authenticationType())
                .add("AccountSubscriptionStatus", accountSubscriptionStatus())
                .add("IAMIdentityCenterInstanceArn", iamIdentityCenterInstanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "NotificationEmail":
            return Optional.ofNullable(clazz.cast(notificationEmail()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationType()));
        case "AccountSubscriptionStatus":
            return Optional.ofNullable(clazz.cast(accountSubscriptionStatus()));
        case "IAMIdentityCenterInstanceArn":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountInfo, T> g) {
        return obj -> g.apply((AccountInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountInfo> {
        /**
         * <p>
         * The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services
         * account. You create this name when you sign up for Amazon QuickSight. It's unique over all of Amazon Web
         * Services, and it appears only when users sign in.
         * </p>
         * 
         * @param accountName
         *        The account name that you provided for the Amazon QuickSight subscription in your Amazon Web Services
         *        account. You create this name when you sign up for Amazon QuickSight. It's unique over all of Amazon
         *        Web Services, and it appears only when users sign in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The edition of your Amazon QuickSight account.
         * </p>
         * 
         * @param edition
         *        The edition of your Amazon QuickSight account.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The edition of your Amazon QuickSight account.
         * </p>
         * 
         * @param edition
         *        The edition of your Amazon QuickSight account.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(Edition edition);

        /**
         * <p>
         * The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon Web
         * Services account or Amazon QuickSight subscription.
         * </p>
         * 
         * @param notificationEmail
         *        The email address that will be used for Amazon QuickSight to send notifications regarding your Amazon
         *        Web Services account or Amazon QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEmail(String notificationEmail);

        /**
         * <p>
         * The way that your Amazon QuickSight account is authenticated.
         * </p>
         * 
         * @param authenticationType
         *        The way that your Amazon QuickSight account is authenticated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The status of your account subscription.
         * </p>
         * 
         * @param accountSubscriptionStatus
         *        The status of your account subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSubscriptionStatus(String accountSubscriptionStatus);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM Identity Center instance.
         * </p>
         * 
         * @param iamIdentityCenterInstanceArn
         *        The Amazon Resource Name (ARN) for the IAM Identity Center instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private String edition;

        private String notificationEmail;

        private String authenticationType;

        private String accountSubscriptionStatus;

        private String iamIdentityCenterInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountInfo model) {
            accountName(model.accountName);
            edition(model.edition);
            notificationEmail(model.notificationEmail);
            authenticationType(model.authenticationType);
            accountSubscriptionStatus(model.accountSubscriptionStatus);
            iamIdentityCenterInstanceArn(model.iamIdentityCenterInstanceArn);
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getNotificationEmail() {
            return notificationEmail;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public final String getAccountSubscriptionStatus() {
            return accountSubscriptionStatus;
        }

        public final void setAccountSubscriptionStatus(String accountSubscriptionStatus) {
            this.accountSubscriptionStatus = accountSubscriptionStatus;
        }

        @Override
        public final Builder accountSubscriptionStatus(String accountSubscriptionStatus) {
            this.accountSubscriptionStatus = accountSubscriptionStatus;
            return this;
        }

        public final String getIamIdentityCenterInstanceArn() {
            return iamIdentityCenterInstanceArn;
        }

        public final void setIamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
        }

        @Override
        public final Builder iamIdentityCenterInstanceArn(String iamIdentityCenterInstanceArn) {
            this.iamIdentityCenterInstanceArn = iamIdentityCenterInstanceArn;
            return this;
        }

        @Override
        public AccountInfo build() {
            return new AccountInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
