/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The sort configuration for a <code>TableVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableSortConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableSortConfiguration.Builder, TableSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> ROW_SORT_FIELD = SdkField
            .<List<FieldSortOptions>> builder(MarshallingType.LIST)
            .memberName("RowSort")
            .getter(getter(TableSortConfiguration::rowSort))
            .setter(setter(Builder::rowSort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSort").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldSortOptions> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldSortOptions::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<PaginationConfiguration> PAGINATION_CONFIGURATION_FIELD = SdkField
            .<PaginationConfiguration> builder(MarshallingType.SDK_POJO).memberName("PaginationConfiguration")
            .getter(getter(TableSortConfiguration::paginationConfiguration)).setter(setter(Builder::paginationConfiguration))
            .constructor(PaginationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaginationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_SORT_FIELD,
            PAGINATION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FieldSortOptions> rowSort;

    private final PaginationConfiguration paginationConfiguration;

    private TableSortConfiguration(BuilderImpl builder) {
        this.rowSort = builder.rowSort;
        this.paginationConfiguration = builder.paginationConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowSort property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRowSort() {
        return rowSort != null && !(rowSort instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field sort options for rows in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowSort} method.
     * </p>
     * 
     * @return The field sort options for rows in the table.
     */
    public final List<FieldSortOptions> rowSort() {
        return rowSort;
    }

    /**
     * <p>
     * The pagination configuration (page size, page number) for the table.
     * </p>
     * 
     * @return The pagination configuration (page size, page number) for the table.
     */
    public final PaginationConfiguration paginationConfiguration() {
        return paginationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRowSort() ? rowSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(paginationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableSortConfiguration)) {
            return false;
        }
        TableSortConfiguration other = (TableSortConfiguration) obj;
        return hasRowSort() == other.hasRowSort() && Objects.equals(rowSort(), other.rowSort())
                && Objects.equals(paginationConfiguration(), other.paginationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableSortConfiguration").add("RowSort", hasRowSort() ? rowSort() : null)
                .add("PaginationConfiguration", paginationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RowSort":
            return Optional.ofNullable(clazz.cast(rowSort()));
        case "PaginationConfiguration":
            return Optional.ofNullable(clazz.cast(paginationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableSortConfiguration, T> g) {
        return obj -> g.apply((TableSortConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableSortConfiguration> {
        /**
         * <p>
         * The field sort options for rows in the table.
         * </p>
         * 
         * @param rowSort
         *        The field sort options for rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowSort(Collection<FieldSortOptions> rowSort);

        /**
         * <p>
         * The field sort options for rows in the table.
         * </p>
         * 
         * @param rowSort
         *        The field sort options for rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowSort(FieldSortOptions... rowSort);

        /**
         * <p>
         * The field sort options for rows in the table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #rowSort(List<FieldSortOptions>)}.
         * 
         * @param rowSort
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.FieldSortOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowSort(java.util.Collection<FieldSortOptions>)
         */
        Builder rowSort(Consumer<FieldSortOptions.Builder>... rowSort);

        /**
         * <p>
         * The pagination configuration (page size, page number) for the table.
         * </p>
         * 
         * @param paginationConfiguration
         *        The pagination configuration (page size, page number) for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paginationConfiguration(PaginationConfiguration paginationConfiguration);

        /**
         * <p>
         * The pagination configuration (page size, page number) for the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaginationConfiguration.Builder} avoiding
         * the need to create one manually via {@link PaginationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaginationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #paginationConfiguration(PaginationConfiguration)}.
         * 
         * @param paginationConfiguration
         *        a consumer that will call methods on {@link PaginationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paginationConfiguration(PaginationConfiguration)
         */
        default Builder paginationConfiguration(Consumer<PaginationConfiguration.Builder> paginationConfiguration) {
            return paginationConfiguration(PaginationConfiguration.builder().applyMutation(paginationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<FieldSortOptions> rowSort = DefaultSdkAutoConstructList.getInstance();

        private PaginationConfiguration paginationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TableSortConfiguration model) {
            rowSort(model.rowSort);
            paginationConfiguration(model.paginationConfiguration);
        }

        public final List<FieldSortOptions.Builder> getRowSort() {
            List<FieldSortOptions.Builder> result = RowSortListCopier.copyToBuilder(this.rowSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowSort(Collection<FieldSortOptions.BuilderImpl> rowSort) {
            this.rowSort = RowSortListCopier.copyFromBuilder(rowSort);
        }

        @Override
        public final Builder rowSort(Collection<FieldSortOptions> rowSort) {
            this.rowSort = RowSortListCopier.copy(rowSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(FieldSortOptions... rowSort) {
            rowSort(Arrays.asList(rowSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowSort(Consumer<FieldSortOptions.Builder>... rowSort) {
            rowSort(Stream.of(rowSort).map(c -> FieldSortOptions.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final PaginationConfiguration.Builder getPaginationConfiguration() {
            return paginationConfiguration != null ? paginationConfiguration.toBuilder() : null;
        }

        public final void setPaginationConfiguration(PaginationConfiguration.BuilderImpl paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration != null ? paginationConfiguration.build() : null;
        }

        @Override
        public final Builder paginationConfiguration(PaginationConfiguration paginationConfiguration) {
            this.paginationConfiguration = paginationConfiguration;
            return this;
        }

        @Override
        public TableSortConfiguration build() {
            return new TableSortConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
