/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data configuration of the reference line.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReferenceLineDataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReferenceLineDataConfiguration.Builder, ReferenceLineDataConfiguration> {
    private static final SdkField<ReferenceLineStaticDataConfiguration> STATIC_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineStaticDataConfiguration> builder(MarshallingType.SDK_POJO).memberName("StaticConfiguration")
            .getter(getter(ReferenceLineDataConfiguration::staticConfiguration)).setter(setter(Builder::staticConfiguration))
            .constructor(ReferenceLineStaticDataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticConfiguration").build())
            .build();

    private static final SdkField<ReferenceLineDynamicDataConfiguration> DYNAMIC_CONFIGURATION_FIELD = SdkField
            .<ReferenceLineDynamicDataConfiguration> builder(MarshallingType.SDK_POJO).memberName("DynamicConfiguration")
            .getter(getter(ReferenceLineDataConfiguration::dynamicConfiguration)).setter(setter(Builder::dynamicConfiguration))
            .constructor(ReferenceLineDynamicDataConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DynamicConfiguration").build())
            .build();

    private static final SdkField<String> AXIS_BINDING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AxisBinding").getter(getter(ReferenceLineDataConfiguration::axisBindingAsString))
            .setter(setter(Builder::axisBinding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AxisBinding").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_CONFIGURATION_FIELD,
            DYNAMIC_CONFIGURATION_FIELD, AXIS_BINDING_FIELD));

    private static final long serialVersionUID = 1L;

    private final ReferenceLineStaticDataConfiguration staticConfiguration;

    private final ReferenceLineDynamicDataConfiguration dynamicConfiguration;

    private final String axisBinding;

    private ReferenceLineDataConfiguration(BuilderImpl builder) {
        this.staticConfiguration = builder.staticConfiguration;
        this.dynamicConfiguration = builder.dynamicConfiguration;
        this.axisBinding = builder.axisBinding;
    }

    /**
     * <p>
     * The static data configuration of the reference line data configuration.
     * </p>
     * 
     * @return The static data configuration of the reference line data configuration.
     */
    public final ReferenceLineStaticDataConfiguration staticConfiguration() {
        return staticConfiguration;
    }

    /**
     * <p>
     * The dynamic configuration of the reference line data configuration.
     * </p>
     * 
     * @return The dynamic configuration of the reference line data configuration.
     */
    public final ReferenceLineDynamicDataConfiguration dynamicConfiguration() {
        return dynamicConfiguration;
    }

    /**
     * <p>
     * The axis binding type of the reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PrimaryY
     * </p>
     * </li>
     * <li>
     * <p>
     * SecondaryY
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #axisBinding} will
     * return {@link AxisBinding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #axisBindingAsString}.
     * </p>
     * 
     * @return The axis binding type of the reference line. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PrimaryY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SecondaryY
     *         </p>
     *         </li>
     * @see AxisBinding
     */
    public final AxisBinding axisBinding() {
        return AxisBinding.fromValue(axisBinding);
    }

    /**
     * <p>
     * The axis binding type of the reference line. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PrimaryY
     * </p>
     * </li>
     * <li>
     * <p>
     * SecondaryY
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #axisBinding} will
     * return {@link AxisBinding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #axisBindingAsString}.
     * </p>
     * 
     * @return The axis binding type of the reference line. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         PrimaryY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SecondaryY
     *         </p>
     *         </li>
     * @see AxisBinding
     */
    public final String axisBindingAsString() {
        return axisBinding;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dynamicConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(axisBindingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceLineDataConfiguration)) {
            return false;
        }
        ReferenceLineDataConfiguration other = (ReferenceLineDataConfiguration) obj;
        return Objects.equals(staticConfiguration(), other.staticConfiguration())
                && Objects.equals(dynamicConfiguration(), other.dynamicConfiguration())
                && Objects.equals(axisBindingAsString(), other.axisBindingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReferenceLineDataConfiguration").add("StaticConfiguration", staticConfiguration())
                .add("DynamicConfiguration", dynamicConfiguration()).add("AxisBinding", axisBindingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticConfiguration":
            return Optional.ofNullable(clazz.cast(staticConfiguration()));
        case "DynamicConfiguration":
            return Optional.ofNullable(clazz.cast(dynamicConfiguration()));
        case "AxisBinding":
            return Optional.ofNullable(clazz.cast(axisBindingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceLineDataConfiguration, T> g) {
        return obj -> g.apply((ReferenceLineDataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReferenceLineDataConfiguration> {
        /**
         * <p>
         * The static data configuration of the reference line data configuration.
         * </p>
         * 
         * @param staticConfiguration
         *        The static data configuration of the reference line data configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticConfiguration(ReferenceLineStaticDataConfiguration staticConfiguration);

        /**
         * <p>
         * The static data configuration of the reference line data configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReferenceLineStaticDataConfiguration.Builder} avoiding the need to create one manually via
         * {@link ReferenceLineStaticDataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineStaticDataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #staticConfiguration(ReferenceLineStaticDataConfiguration)}.
         * 
         * @param staticConfiguration
         *        a consumer that will call methods on {@link ReferenceLineStaticDataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #staticConfiguration(ReferenceLineStaticDataConfiguration)
         */
        default Builder staticConfiguration(Consumer<ReferenceLineStaticDataConfiguration.Builder> staticConfiguration) {
            return staticConfiguration(ReferenceLineStaticDataConfiguration.builder().applyMutation(staticConfiguration).build());
        }

        /**
         * <p>
         * The dynamic configuration of the reference line data configuration.
         * </p>
         * 
         * @param dynamicConfiguration
         *        The dynamic configuration of the reference line data configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamicConfiguration(ReferenceLineDynamicDataConfiguration dynamicConfiguration);

        /**
         * <p>
         * The dynamic configuration of the reference line data configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ReferenceLineDynamicDataConfiguration.Builder} avoiding the need to create one manually via
         * {@link ReferenceLineDynamicDataConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferenceLineDynamicDataConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #dynamicConfiguration(ReferenceLineDynamicDataConfiguration)}.
         * 
         * @param dynamicConfiguration
         *        a consumer that will call methods on {@link ReferenceLineDynamicDataConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamicConfiguration(ReferenceLineDynamicDataConfiguration)
         */
        default Builder dynamicConfiguration(Consumer<ReferenceLineDynamicDataConfiguration.Builder> dynamicConfiguration) {
            return dynamicConfiguration(ReferenceLineDynamicDataConfiguration.builder().applyMutation(dynamicConfiguration)
                    .build());
        }

        /**
         * <p>
         * The axis binding type of the reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PrimaryY
         * </p>
         * </li>
         * <li>
         * <p>
         * SecondaryY
         * </p>
         * </li>
         * </ul>
         * 
         * @param axisBinding
         *        The axis binding type of the reference line. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PrimaryY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SecondaryY
         *        </p>
         *        </li>
         * @see AxisBinding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AxisBinding
         */
        Builder axisBinding(String axisBinding);

        /**
         * <p>
         * The axis binding type of the reference line. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PrimaryY
         * </p>
         * </li>
         * <li>
         * <p>
         * SecondaryY
         * </p>
         * </li>
         * </ul>
         * 
         * @param axisBinding
         *        The axis binding type of the reference line. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        PrimaryY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SecondaryY
         *        </p>
         *        </li>
         * @see AxisBinding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AxisBinding
         */
        Builder axisBinding(AxisBinding axisBinding);
    }

    static final class BuilderImpl implements Builder {
        private ReferenceLineStaticDataConfiguration staticConfiguration;

        private ReferenceLineDynamicDataConfiguration dynamicConfiguration;

        private String axisBinding;

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceLineDataConfiguration model) {
            staticConfiguration(model.staticConfiguration);
            dynamicConfiguration(model.dynamicConfiguration);
            axisBinding(model.axisBinding);
        }

        public final ReferenceLineStaticDataConfiguration.Builder getStaticConfiguration() {
            return staticConfiguration != null ? staticConfiguration.toBuilder() : null;
        }

        public final void setStaticConfiguration(ReferenceLineStaticDataConfiguration.BuilderImpl staticConfiguration) {
            this.staticConfiguration = staticConfiguration != null ? staticConfiguration.build() : null;
        }

        @Override
        public final Builder staticConfiguration(ReferenceLineStaticDataConfiguration staticConfiguration) {
            this.staticConfiguration = staticConfiguration;
            return this;
        }

        public final ReferenceLineDynamicDataConfiguration.Builder getDynamicConfiguration() {
            return dynamicConfiguration != null ? dynamicConfiguration.toBuilder() : null;
        }

        public final void setDynamicConfiguration(ReferenceLineDynamicDataConfiguration.BuilderImpl dynamicConfiguration) {
            this.dynamicConfiguration = dynamicConfiguration != null ? dynamicConfiguration.build() : null;
        }

        @Override
        public final Builder dynamicConfiguration(ReferenceLineDynamicDataConfiguration dynamicConfiguration) {
            this.dynamicConfiguration = dynamicConfiguration;
            return this;
        }

        public final String getAxisBinding() {
            return axisBinding;
        }

        public final void setAxisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
        }

        @Override
        public final Builder axisBinding(String axisBinding) {
            this.axisBinding = axisBinding;
            return this;
        }

        @Override
        public final Builder axisBinding(AxisBinding axisBinding) {
            this.axisBinding(axisBinding == null ? null : axisBinding.toString());
            return this;
        }

        @Override
        public ReferenceLineDataConfiguration build() {
            return new ReferenceLineDataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
