/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transform operation that overrides the dataset parameter values that are defined in another dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OverrideDatasetParameterOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<OverrideDatasetParameterOperation.Builder, OverrideDatasetParameterOperation> {
    private static final SdkField<String> PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterName").getter(getter(OverrideDatasetParameterOperation::parameterName))
            .setter(setter(Builder::parameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterName").build()).build();

    private static final SdkField<String> NEW_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewParameterName").getter(getter(OverrideDatasetParameterOperation::newParameterName))
            .setter(setter(Builder::newParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewParameterName").build()).build();

    private static final SdkField<NewDefaultValues> NEW_DEFAULT_VALUES_FIELD = SdkField
            .<NewDefaultValues> builder(MarshallingType.SDK_POJO).memberName("NewDefaultValues")
            .getter(getter(OverrideDatasetParameterOperation::newDefaultValues)).setter(setter(Builder::newDefaultValues))
            .constructor(NewDefaultValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewDefaultValues").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_NAME_FIELD,
            NEW_PARAMETER_NAME_FIELD, NEW_DEFAULT_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterName;

    private final String newParameterName;

    private final NewDefaultValues newDefaultValues;

    private OverrideDatasetParameterOperation(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.newParameterName = builder.newParameterName;
        this.newDefaultValues = builder.newDefaultValues;
    }

    /**
     * <p>
     * The name of the parameter to be overridden with different values.
     * </p>
     * 
     * @return The name of the parameter to be overridden with different values.
     */
    public final String parameterName() {
        return parameterName;
    }

    /**
     * <p>
     * The new name for the parameter.
     * </p>
     * 
     * @return The new name for the parameter.
     */
    public final String newParameterName() {
        return newParameterName;
    }

    /**
     * <p>
     * The new default values for the parameter.
     * </p>
     * 
     * @return The new default values for the parameter.
     */
    public final NewDefaultValues newDefaultValues() {
        return newDefaultValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterName());
        hashCode = 31 * hashCode + Objects.hashCode(newParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(newDefaultValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverrideDatasetParameterOperation)) {
            return false;
        }
        OverrideDatasetParameterOperation other = (OverrideDatasetParameterOperation) obj;
        return Objects.equals(parameterName(), other.parameterName())
                && Objects.equals(newParameterName(), other.newParameterName())
                && Objects.equals(newDefaultValues(), other.newDefaultValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OverrideDatasetParameterOperation").add("ParameterName", parameterName())
                .add("NewParameterName", newParameterName()).add("NewDefaultValues", newDefaultValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterName":
            return Optional.ofNullable(clazz.cast(parameterName()));
        case "NewParameterName":
            return Optional.ofNullable(clazz.cast(newParameterName()));
        case "NewDefaultValues":
            return Optional.ofNullable(clazz.cast(newDefaultValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OverrideDatasetParameterOperation, T> g) {
        return obj -> g.apply((OverrideDatasetParameterOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OverrideDatasetParameterOperation> {
        /**
         * <p>
         * The name of the parameter to be overridden with different values.
         * </p>
         * 
         * @param parameterName
         *        The name of the parameter to be overridden with different values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterName(String parameterName);

        /**
         * <p>
         * The new name for the parameter.
         * </p>
         * 
         * @param newParameterName
         *        The new name for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newParameterName(String newParameterName);

        /**
         * <p>
         * The new default values for the parameter.
         * </p>
         * 
         * @param newDefaultValues
         *        The new default values for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newDefaultValues(NewDefaultValues newDefaultValues);

        /**
         * <p>
         * The new default values for the parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link NewDefaultValues.Builder} avoiding the
         * need to create one manually via {@link NewDefaultValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NewDefaultValues.Builder#build()} is called immediately and its
         * result is passed to {@link #newDefaultValues(NewDefaultValues)}.
         * 
         * @param newDefaultValues
         *        a consumer that will call methods on {@link NewDefaultValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newDefaultValues(NewDefaultValues)
         */
        default Builder newDefaultValues(Consumer<NewDefaultValues.Builder> newDefaultValues) {
            return newDefaultValues(NewDefaultValues.builder().applyMutation(newDefaultValues).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterName;

        private String newParameterName;

        private NewDefaultValues newDefaultValues;

        private BuilderImpl() {
        }

        private BuilderImpl(OverrideDatasetParameterOperation model) {
            parameterName(model.parameterName);
            newParameterName(model.newParameterName);
            newDefaultValues(model.newDefaultValues);
        }

        public final String getParameterName() {
            return parameterName;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final String getNewParameterName() {
            return newParameterName;
        }

        public final void setNewParameterName(String newParameterName) {
            this.newParameterName = newParameterName;
        }

        @Override
        public final Builder newParameterName(String newParameterName) {
            this.newParameterName = newParameterName;
            return this;
        }

        public final NewDefaultValues.Builder getNewDefaultValues() {
            return newDefaultValues != null ? newDefaultValues.toBuilder() : null;
        }

        public final void setNewDefaultValues(NewDefaultValues.BuilderImpl newDefaultValues) {
            this.newDefaultValues = newDefaultValues != null ? newDefaultValues.build() : null;
        }

        @Override
        public final Builder newDefaultValues(NewDefaultValues newDefaultValues) {
            this.newDefaultValues = newDefaultValues;
            return this;
        }

        @Override
        public OverrideDatasetParameterOperation build() {
            return new OverrideDatasetParameterOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
