/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The dimension type field.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionField implements SdkPojo, Serializable, ToCopyableBuilder<DimensionField.Builder, DimensionField> {
    private static final SdkField<NumericalDimensionField> NUMERICAL_DIMENSION_FIELD_FIELD = SdkField
            .<NumericalDimensionField> builder(MarshallingType.SDK_POJO).memberName("NumericalDimensionField")
            .getter(getter(DimensionField::numericalDimensionField)).setter(setter(Builder::numericalDimensionField))
            .constructor(NumericalDimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumericalDimensionField").build())
            .build();

    private static final SdkField<CategoricalDimensionField> CATEGORICAL_DIMENSION_FIELD_FIELD = SdkField
            .<CategoricalDimensionField> builder(MarshallingType.SDK_POJO).memberName("CategoricalDimensionField")
            .getter(getter(DimensionField::categoricalDimensionField)).setter(setter(Builder::categoricalDimensionField))
            .constructor(CategoricalDimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoricalDimensionField").build())
            .build();

    private static final SdkField<DateDimensionField> DATE_DIMENSION_FIELD_FIELD = SdkField
            .<DateDimensionField> builder(MarshallingType.SDK_POJO).memberName("DateDimensionField")
            .getter(getter(DimensionField::dateDimensionField)).setter(setter(Builder::dateDimensionField))
            .constructor(DateDimensionField::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateDimensionField").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMERICAL_DIMENSION_FIELD_FIELD, CATEGORICAL_DIMENSION_FIELD_FIELD, DATE_DIMENSION_FIELD_FIELD));

    private static final long serialVersionUID = 1L;

    private final NumericalDimensionField numericalDimensionField;

    private final CategoricalDimensionField categoricalDimensionField;

    private final DateDimensionField dateDimensionField;

    private DimensionField(BuilderImpl builder) {
        this.numericalDimensionField = builder.numericalDimensionField;
        this.categoricalDimensionField = builder.categoricalDimensionField;
        this.dateDimensionField = builder.dateDimensionField;
    }

    /**
     * <p>
     * The dimension type field with numerical type columns.
     * </p>
     * 
     * @return The dimension type field with numerical type columns.
     */
    public final NumericalDimensionField numericalDimensionField() {
        return numericalDimensionField;
    }

    /**
     * <p>
     * The dimension type field with categorical type columns.
     * </p>
     * 
     * @return The dimension type field with categorical type columns.
     */
    public final CategoricalDimensionField categoricalDimensionField() {
        return categoricalDimensionField;
    }

    /**
     * <p>
     * The dimension type field with date type columns.
     * </p>
     * 
     * @return The dimension type field with date type columns.
     */
    public final DateDimensionField dateDimensionField() {
        return dateDimensionField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numericalDimensionField());
        hashCode = 31 * hashCode + Objects.hashCode(categoricalDimensionField());
        hashCode = 31 * hashCode + Objects.hashCode(dateDimensionField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionField)) {
            return false;
        }
        DimensionField other = (DimensionField) obj;
        return Objects.equals(numericalDimensionField(), other.numericalDimensionField())
                && Objects.equals(categoricalDimensionField(), other.categoricalDimensionField())
                && Objects.equals(dateDimensionField(), other.dateDimensionField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionField").add("NumericalDimensionField", numericalDimensionField())
                .add("CategoricalDimensionField", categoricalDimensionField()).add("DateDimensionField", dateDimensionField())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumericalDimensionField":
            return Optional.ofNullable(clazz.cast(numericalDimensionField()));
        case "CategoricalDimensionField":
            return Optional.ofNullable(clazz.cast(categoricalDimensionField()));
        case "DateDimensionField":
            return Optional.ofNullable(clazz.cast(dateDimensionField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionField, T> g) {
        return obj -> g.apply((DimensionField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionField> {
        /**
         * <p>
         * The dimension type field with numerical type columns.
         * </p>
         * 
         * @param numericalDimensionField
         *        The dimension type field with numerical type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numericalDimensionField(NumericalDimensionField numericalDimensionField);

        /**
         * <p>
         * The dimension type field with numerical type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link NumericalDimensionField.Builder} avoiding
         * the need to create one manually via {@link NumericalDimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NumericalDimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #numericalDimensionField(NumericalDimensionField)}.
         * 
         * @param numericalDimensionField
         *        a consumer that will call methods on {@link NumericalDimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #numericalDimensionField(NumericalDimensionField)
         */
        default Builder numericalDimensionField(Consumer<NumericalDimensionField.Builder> numericalDimensionField) {
            return numericalDimensionField(NumericalDimensionField.builder().applyMutation(numericalDimensionField).build());
        }

        /**
         * <p>
         * The dimension type field with categorical type columns.
         * </p>
         * 
         * @param categoricalDimensionField
         *        The dimension type field with categorical type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder categoricalDimensionField(CategoricalDimensionField categoricalDimensionField);

        /**
         * <p>
         * The dimension type field with categorical type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link CategoricalDimensionField.Builder}
         * avoiding the need to create one manually via {@link CategoricalDimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CategoricalDimensionField.Builder#build()} is called immediately
         * and its result is passed to {@link #categoricalDimensionField(CategoricalDimensionField)}.
         * 
         * @param categoricalDimensionField
         *        a consumer that will call methods on {@link CategoricalDimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #categoricalDimensionField(CategoricalDimensionField)
         */
        default Builder categoricalDimensionField(Consumer<CategoricalDimensionField.Builder> categoricalDimensionField) {
            return categoricalDimensionField(CategoricalDimensionField.builder().applyMutation(categoricalDimensionField).build());
        }

        /**
         * <p>
         * The dimension type field with date type columns.
         * </p>
         * 
         * @param dateDimensionField
         *        The dimension type field with date type columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateDimensionField(DateDimensionField dateDimensionField);

        /**
         * <p>
         * The dimension type field with date type columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link DateDimensionField.Builder} avoiding the
         * need to create one manually via {@link DateDimensionField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateDimensionField.Builder#build()} is called immediately and its
         * result is passed to {@link #dateDimensionField(DateDimensionField)}.
         * 
         * @param dateDimensionField
         *        a consumer that will call methods on {@link DateDimensionField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateDimensionField(DateDimensionField)
         */
        default Builder dateDimensionField(Consumer<DateDimensionField.Builder> dateDimensionField) {
            return dateDimensionField(DateDimensionField.builder().applyMutation(dateDimensionField).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NumericalDimensionField numericalDimensionField;

        private CategoricalDimensionField categoricalDimensionField;

        private DateDimensionField dateDimensionField;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionField model) {
            numericalDimensionField(model.numericalDimensionField);
            categoricalDimensionField(model.categoricalDimensionField);
            dateDimensionField(model.dateDimensionField);
        }

        public final NumericalDimensionField.Builder getNumericalDimensionField() {
            return numericalDimensionField != null ? numericalDimensionField.toBuilder() : null;
        }

        public final void setNumericalDimensionField(NumericalDimensionField.BuilderImpl numericalDimensionField) {
            this.numericalDimensionField = numericalDimensionField != null ? numericalDimensionField.build() : null;
        }

        @Override
        public final Builder numericalDimensionField(NumericalDimensionField numericalDimensionField) {
            this.numericalDimensionField = numericalDimensionField;
            return this;
        }

        public final CategoricalDimensionField.Builder getCategoricalDimensionField() {
            return categoricalDimensionField != null ? categoricalDimensionField.toBuilder() : null;
        }

        public final void setCategoricalDimensionField(CategoricalDimensionField.BuilderImpl categoricalDimensionField) {
            this.categoricalDimensionField = categoricalDimensionField != null ? categoricalDimensionField.build() : null;
        }

        @Override
        public final Builder categoricalDimensionField(CategoricalDimensionField categoricalDimensionField) {
            this.categoricalDimensionField = categoricalDimensionField;
            return this;
        }

        public final DateDimensionField.Builder getDateDimensionField() {
            return dateDimensionField != null ? dateDimensionField.toBuilder() : null;
        }

        public final void setDateDimensionField(DateDimensionField.BuilderImpl dateDimensionField) {
            this.dateDimensionField = dateDimensionField != null ? dateDimensionField.build() : null;
        }

        @Override
        public final Builder dateDimensionField(DateDimensionField dateDimensionField) {
            this.dateDimensionField = dateDimensionField;
            return this;
        }

        @Override
        public DimensionField build() {
            return new DimensionField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
