/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ChartAxisLabelOptions;
import software.amazon.awssdk.services.quicksight.model.WordCloudFieldWells;
import software.amazon.awssdk.services.quicksight.model.WordCloudOptions;
import software.amazon.awssdk.services.quicksight.model.WordCloudSortConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WordCloudChartConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WordCloudChartConfiguration> {
    private static final SdkField<WordCloudFieldWells> FIELD_WELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FieldWells").getter(WordCloudChartConfiguration.getter(WordCloudChartConfiguration::fieldWells)).setter(WordCloudChartConfiguration.setter(Builder::fieldWells)).constructor(WordCloudFieldWells::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldWells").build()}).build();
    private static final SdkField<WordCloudSortConfiguration> SORT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortConfiguration").getter(WordCloudChartConfiguration.getter(WordCloudChartConfiguration::sortConfiguration)).setter(WordCloudChartConfiguration.setter(Builder::sortConfiguration)).constructor(WordCloudSortConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortConfiguration").build()}).build();
    private static final SdkField<ChartAxisLabelOptions> CATEGORY_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CategoryLabelOptions").getter(WordCloudChartConfiguration.getter(WordCloudChartConfiguration::categoryLabelOptions)).setter(WordCloudChartConfiguration.setter(Builder::categoryLabelOptions)).constructor(ChartAxisLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryLabelOptions").build()}).build();
    private static final SdkField<WordCloudOptions> WORD_CLOUD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WordCloudOptions").getter(WordCloudChartConfiguration.getter(WordCloudChartConfiguration::wordCloudOptions)).setter(WordCloudChartConfiguration.setter(Builder::wordCloudOptions)).constructor(WordCloudOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WordCloudOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_WELLS_FIELD, SORT_CONFIGURATION_FIELD, CATEGORY_LABEL_OPTIONS_FIELD, WORD_CLOUD_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final WordCloudFieldWells fieldWells;
    private final WordCloudSortConfiguration sortConfiguration;
    private final ChartAxisLabelOptions categoryLabelOptions;
    private final WordCloudOptions wordCloudOptions;

    private WordCloudChartConfiguration(BuilderImpl builder) {
        this.fieldWells = builder.fieldWells;
        this.sortConfiguration = builder.sortConfiguration;
        this.categoryLabelOptions = builder.categoryLabelOptions;
        this.wordCloudOptions = builder.wordCloudOptions;
    }

    public final WordCloudFieldWells fieldWells() {
        return this.fieldWells;
    }

    public final WordCloudSortConfiguration sortConfiguration() {
        return this.sortConfiguration;
    }

    public final ChartAxisLabelOptions categoryLabelOptions() {
        return this.categoryLabelOptions;
    }

    public final WordCloudOptions wordCloudOptions() {
        return this.wordCloudOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryLabelOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordCloudOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WordCloudChartConfiguration)) {
            return false;
        }
        WordCloudChartConfiguration other = (WordCloudChartConfiguration)obj;
        return Objects.equals(this.fieldWells(), other.fieldWells()) && Objects.equals(this.sortConfiguration(), other.sortConfiguration()) && Objects.equals(this.categoryLabelOptions(), other.categoryLabelOptions()) && Objects.equals(this.wordCloudOptions(), other.wordCloudOptions());
    }

    public final String toString() {
        return ToString.builder((String)"WordCloudChartConfiguration").add("FieldWells", (Object)this.fieldWells()).add("SortConfiguration", (Object)this.sortConfiguration()).add("CategoryLabelOptions", (Object)this.categoryLabelOptions()).add("WordCloudOptions", (Object)this.wordCloudOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldWells": {
                return Optional.ofNullable(clazz.cast(this.fieldWells()));
            }
            case "SortConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sortConfiguration()));
            }
            case "CategoryLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.categoryLabelOptions()));
            }
            case "WordCloudOptions": {
                return Optional.ofNullable(clazz.cast(this.wordCloudOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WordCloudChartConfiguration, T> g) {
        return obj -> g.apply((WordCloudChartConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private WordCloudFieldWells fieldWells;
        private WordCloudSortConfiguration sortConfiguration;
        private ChartAxisLabelOptions categoryLabelOptions;
        private WordCloudOptions wordCloudOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(WordCloudChartConfiguration model) {
            this.fieldWells(model.fieldWells);
            this.sortConfiguration(model.sortConfiguration);
            this.categoryLabelOptions(model.categoryLabelOptions);
            this.wordCloudOptions(model.wordCloudOptions);
        }

        public final WordCloudFieldWells.Builder getFieldWells() {
            return this.fieldWells != null ? this.fieldWells.toBuilder() : null;
        }

        public final void setFieldWells(WordCloudFieldWells.BuilderImpl fieldWells) {
            this.fieldWells = fieldWells != null ? fieldWells.build() : null;
        }

        @Override
        public final Builder fieldWells(WordCloudFieldWells fieldWells) {
            this.fieldWells = fieldWells;
            return this;
        }

        public final WordCloudSortConfiguration.Builder getSortConfiguration() {
            return this.sortConfiguration != null ? this.sortConfiguration.toBuilder() : null;
        }

        public final void setSortConfiguration(WordCloudSortConfiguration.BuilderImpl sortConfiguration) {
            this.sortConfiguration = sortConfiguration != null ? sortConfiguration.build() : null;
        }

        @Override
        public final Builder sortConfiguration(WordCloudSortConfiguration sortConfiguration) {
            this.sortConfiguration = sortConfiguration;
            return this;
        }

        public final ChartAxisLabelOptions.Builder getCategoryLabelOptions() {
            return this.categoryLabelOptions != null ? this.categoryLabelOptions.toBuilder() : null;
        }

        public final void setCategoryLabelOptions(ChartAxisLabelOptions.BuilderImpl categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions != null ? categoryLabelOptions.build() : null;
        }

        @Override
        public final Builder categoryLabelOptions(ChartAxisLabelOptions categoryLabelOptions) {
            this.categoryLabelOptions = categoryLabelOptions;
            return this;
        }

        public final WordCloudOptions.Builder getWordCloudOptions() {
            return this.wordCloudOptions != null ? this.wordCloudOptions.toBuilder() : null;
        }

        public final void setWordCloudOptions(WordCloudOptions.BuilderImpl wordCloudOptions) {
            this.wordCloudOptions = wordCloudOptions != null ? wordCloudOptions.build() : null;
        }

        @Override
        public final Builder wordCloudOptions(WordCloudOptions wordCloudOptions) {
            this.wordCloudOptions = wordCloudOptions;
            return this;
        }

        public WordCloudChartConfiguration build() {
            return new WordCloudChartConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WordCloudChartConfiguration> {
        public Builder fieldWells(WordCloudFieldWells var1);

        default public Builder fieldWells(Consumer<WordCloudFieldWells.Builder> fieldWells) {
            return this.fieldWells((WordCloudFieldWells)((WordCloudFieldWells.Builder)WordCloudFieldWells.builder().applyMutation(fieldWells)).build());
        }

        public Builder sortConfiguration(WordCloudSortConfiguration var1);

        default public Builder sortConfiguration(Consumer<WordCloudSortConfiguration.Builder> sortConfiguration) {
            return this.sortConfiguration((WordCloudSortConfiguration)((WordCloudSortConfiguration.Builder)WordCloudSortConfiguration.builder().applyMutation(sortConfiguration)).build());
        }

        public Builder categoryLabelOptions(ChartAxisLabelOptions var1);

        default public Builder categoryLabelOptions(Consumer<ChartAxisLabelOptions.Builder> categoryLabelOptions) {
            return this.categoryLabelOptions((ChartAxisLabelOptions)((ChartAxisLabelOptions.Builder)ChartAxisLabelOptions.builder().applyMutation(categoryLabelOptions)).build());
        }

        public Builder wordCloudOptions(WordCloudOptions var1);

        default public Builder wordCloudOptions(Consumer<WordCloudOptions.Builder> wordCloudOptions) {
            return this.wordCloudOptions((WordCloudOptions)((WordCloudOptions.Builder)WordCloudOptions.builder().applyMutation(wordCloudOptions)).build());
        }
    }
}

