/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum URLTargetConfiguration {
    NEW_TAB("NEW_TAB"),
    NEW_WINDOW("NEW_WINDOW"),
    SAME_TAB("SAME_TAB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, URLTargetConfiguration> VALUE_MAP;
    private final String value;

    private URLTargetConfiguration(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static URLTargetConfiguration fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<URLTargetConfiguration> knownValues() {
        EnumSet<URLTargetConfiguration> knownValues = EnumSet.allOf(URLTargetConfiguration.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(URLTargetConfiguration.class, URLTargetConfiguration::toString);
    }
}

