/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ColumnIdentifier;
import software.amazon.awssdk.services.quicksight.model.ExcludePeriodConfiguration;
import software.amazon.awssdk.services.quicksight.model.FilterNullOption;
import software.amazon.awssdk.services.quicksight.model.TimeGranularity;
import software.amazon.awssdk.services.quicksight.model.TimeRangeFilterValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeRangeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeRangeFilter> {
    private static final SdkField<String> FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterId").getter(TimeRangeFilter.getter(TimeRangeFilter::filterId)).setter(TimeRangeFilter.setter(Builder::filterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterId").build()}).build();
    private static final SdkField<ColumnIdentifier> COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Column").getter(TimeRangeFilter.getter(TimeRangeFilter::column)).setter(TimeRangeFilter.setter(Builder::column)).constructor(ColumnIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Column").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MINIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeMinimum").getter(TimeRangeFilter.getter(TimeRangeFilter::includeMinimum)).setter(TimeRangeFilter.setter(Builder::includeMinimum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMinimum").build()}).build();
    private static final SdkField<Boolean> INCLUDE_MAXIMUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeMaximum").getter(TimeRangeFilter.getter(TimeRangeFilter::includeMaximum)).setter(TimeRangeFilter.setter(Builder::includeMaximum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMaximum").build()}).build();
    private static final SdkField<TimeRangeFilterValue> RANGE_MINIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RangeMinimumValue").getter(TimeRangeFilter.getter(TimeRangeFilter::rangeMinimumValue)).setter(TimeRangeFilter.setter(Builder::rangeMinimumValue)).constructor(TimeRangeFilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMinimumValue").build()}).build();
    private static final SdkField<TimeRangeFilterValue> RANGE_MAXIMUM_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RangeMaximumValue").getter(TimeRangeFilter.getter(TimeRangeFilter::rangeMaximumValue)).setter(TimeRangeFilter.setter(Builder::rangeMaximumValue)).constructor(TimeRangeFilterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangeMaximumValue").build()}).build();
    private static final SdkField<String> NULL_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NullOption").getter(TimeRangeFilter.getter(TimeRangeFilter::nullOptionAsString)).setter(TimeRangeFilter.setter(Builder::nullOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullOption").build()}).build();
    private static final SdkField<ExcludePeriodConfiguration> EXCLUDE_PERIOD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExcludePeriodConfiguration").getter(TimeRangeFilter.getter(TimeRangeFilter::excludePeriodConfiguration)).setter(TimeRangeFilter.setter(Builder::excludePeriodConfiguration)).constructor(ExcludePeriodConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludePeriodConfiguration").build()}).build();
    private static final SdkField<String> TIME_GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeGranularity").getter(TimeRangeFilter.getter(TimeRangeFilter::timeGranularityAsString)).setter(TimeRangeFilter.setter(Builder::timeGranularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeGranularity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_ID_FIELD, COLUMN_FIELD, INCLUDE_MINIMUM_FIELD, INCLUDE_MAXIMUM_FIELD, RANGE_MINIMUM_VALUE_FIELD, RANGE_MAXIMUM_VALUE_FIELD, NULL_OPTION_FIELD, EXCLUDE_PERIOD_CONFIGURATION_FIELD, TIME_GRANULARITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filterId;
    private final ColumnIdentifier column;
    private final Boolean includeMinimum;
    private final Boolean includeMaximum;
    private final TimeRangeFilterValue rangeMinimumValue;
    private final TimeRangeFilterValue rangeMaximumValue;
    private final String nullOption;
    private final ExcludePeriodConfiguration excludePeriodConfiguration;
    private final String timeGranularity;

    private TimeRangeFilter(BuilderImpl builder) {
        this.filterId = builder.filterId;
        this.column = builder.column;
        this.includeMinimum = builder.includeMinimum;
        this.includeMaximum = builder.includeMaximum;
        this.rangeMinimumValue = builder.rangeMinimumValue;
        this.rangeMaximumValue = builder.rangeMaximumValue;
        this.nullOption = builder.nullOption;
        this.excludePeriodConfiguration = builder.excludePeriodConfiguration;
        this.timeGranularity = builder.timeGranularity;
    }

    public final String filterId() {
        return this.filterId;
    }

    public final ColumnIdentifier column() {
        return this.column;
    }

    public final Boolean includeMinimum() {
        return this.includeMinimum;
    }

    public final Boolean includeMaximum() {
        return this.includeMaximum;
    }

    public final TimeRangeFilterValue rangeMinimumValue() {
        return this.rangeMinimumValue;
    }

    public final TimeRangeFilterValue rangeMaximumValue() {
        return this.rangeMaximumValue;
    }

    public final FilterNullOption nullOption() {
        return FilterNullOption.fromValue(this.nullOption);
    }

    public final String nullOptionAsString() {
        return this.nullOption;
    }

    public final ExcludePeriodConfiguration excludePeriodConfiguration() {
        return this.excludePeriodConfiguration;
    }

    public final TimeGranularity timeGranularity() {
        return TimeGranularity.fromValue(this.timeGranularity);
    }

    public final String timeGranularityAsString() {
        return this.timeGranularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.column());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMinimum());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMaximum());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeMinimumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.rangeMaximumValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.nullOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.excludePeriodConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeGranularityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeRangeFilter)) {
            return false;
        }
        TimeRangeFilter other = (TimeRangeFilter)obj;
        return Objects.equals(this.filterId(), other.filterId()) && Objects.equals(this.column(), other.column()) && Objects.equals(this.includeMinimum(), other.includeMinimum()) && Objects.equals(this.includeMaximum(), other.includeMaximum()) && Objects.equals(this.rangeMinimumValue(), other.rangeMinimumValue()) && Objects.equals(this.rangeMaximumValue(), other.rangeMaximumValue()) && Objects.equals(this.nullOptionAsString(), other.nullOptionAsString()) && Objects.equals(this.excludePeriodConfiguration(), other.excludePeriodConfiguration()) && Objects.equals(this.timeGranularityAsString(), other.timeGranularityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TimeRangeFilter").add("FilterId", (Object)this.filterId()).add("Column", (Object)this.column()).add("IncludeMinimum", (Object)this.includeMinimum()).add("IncludeMaximum", (Object)this.includeMaximum()).add("RangeMinimumValue", (Object)this.rangeMinimumValue()).add("RangeMaximumValue", (Object)this.rangeMaximumValue()).add("NullOption", (Object)this.nullOptionAsString()).add("ExcludePeriodConfiguration", (Object)this.excludePeriodConfiguration()).add("TimeGranularity", (Object)this.timeGranularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FilterId": {
                return Optional.ofNullable(clazz.cast(this.filterId()));
            }
            case "Column": {
                return Optional.ofNullable(clazz.cast(this.column()));
            }
            case "IncludeMinimum": {
                return Optional.ofNullable(clazz.cast(this.includeMinimum()));
            }
            case "IncludeMaximum": {
                return Optional.ofNullable(clazz.cast(this.includeMaximum()));
            }
            case "RangeMinimumValue": {
                return Optional.ofNullable(clazz.cast(this.rangeMinimumValue()));
            }
            case "RangeMaximumValue": {
                return Optional.ofNullable(clazz.cast(this.rangeMaximumValue()));
            }
            case "NullOption": {
                return Optional.ofNullable(clazz.cast(this.nullOptionAsString()));
            }
            case "ExcludePeriodConfiguration": {
                return Optional.ofNullable(clazz.cast(this.excludePeriodConfiguration()));
            }
            case "TimeGranularity": {
                return Optional.ofNullable(clazz.cast(this.timeGranularityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeRangeFilter, T> g) {
        return obj -> g.apply((TimeRangeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterId;
        private ColumnIdentifier column;
        private Boolean includeMinimum;
        private Boolean includeMaximum;
        private TimeRangeFilterValue rangeMinimumValue;
        private TimeRangeFilterValue rangeMaximumValue;
        private String nullOption;
        private ExcludePeriodConfiguration excludePeriodConfiguration;
        private String timeGranularity;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeRangeFilter model) {
            this.filterId(model.filterId);
            this.column(model.column);
            this.includeMinimum(model.includeMinimum);
            this.includeMaximum(model.includeMaximum);
            this.rangeMinimumValue(model.rangeMinimumValue);
            this.rangeMaximumValue(model.rangeMaximumValue);
            this.nullOption(model.nullOption);
            this.excludePeriodConfiguration(model.excludePeriodConfiguration);
            this.timeGranularity(model.timeGranularity);
        }

        public final String getFilterId() {
            return this.filterId;
        }

        public final void setFilterId(String filterId) {
            this.filterId = filterId;
        }

        @Override
        public final Builder filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        public final ColumnIdentifier.Builder getColumn() {
            return this.column != null ? this.column.toBuilder() : null;
        }

        public final void setColumn(ColumnIdentifier.BuilderImpl column) {
            this.column = column != null ? column.build() : null;
        }

        @Override
        public final Builder column(ColumnIdentifier column) {
            this.column = column;
            return this;
        }

        public final Boolean getIncludeMinimum() {
            return this.includeMinimum;
        }

        public final void setIncludeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
        }

        @Override
        public final Builder includeMinimum(Boolean includeMinimum) {
            this.includeMinimum = includeMinimum;
            return this;
        }

        public final Boolean getIncludeMaximum() {
            return this.includeMaximum;
        }

        public final void setIncludeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
        }

        @Override
        public final Builder includeMaximum(Boolean includeMaximum) {
            this.includeMaximum = includeMaximum;
            return this;
        }

        public final TimeRangeFilterValue.Builder getRangeMinimumValue() {
            return this.rangeMinimumValue != null ? this.rangeMinimumValue.toBuilder() : null;
        }

        public final void setRangeMinimumValue(TimeRangeFilterValue.BuilderImpl rangeMinimumValue) {
            this.rangeMinimumValue = rangeMinimumValue != null ? rangeMinimumValue.build() : null;
        }

        @Override
        public final Builder rangeMinimumValue(TimeRangeFilterValue rangeMinimumValue) {
            this.rangeMinimumValue = rangeMinimumValue;
            return this;
        }

        public final TimeRangeFilterValue.Builder getRangeMaximumValue() {
            return this.rangeMaximumValue != null ? this.rangeMaximumValue.toBuilder() : null;
        }

        public final void setRangeMaximumValue(TimeRangeFilterValue.BuilderImpl rangeMaximumValue) {
            this.rangeMaximumValue = rangeMaximumValue != null ? rangeMaximumValue.build() : null;
        }

        @Override
        public final Builder rangeMaximumValue(TimeRangeFilterValue rangeMaximumValue) {
            this.rangeMaximumValue = rangeMaximumValue;
            return this;
        }

        public final String getNullOption() {
            return this.nullOption;
        }

        public final void setNullOption(String nullOption) {
            this.nullOption = nullOption;
        }

        @Override
        public final Builder nullOption(String nullOption) {
            this.nullOption = nullOption;
            return this;
        }

        @Override
        public final Builder nullOption(FilterNullOption nullOption) {
            this.nullOption(nullOption == null ? null : nullOption.toString());
            return this;
        }

        public final ExcludePeriodConfiguration.Builder getExcludePeriodConfiguration() {
            return this.excludePeriodConfiguration != null ? this.excludePeriodConfiguration.toBuilder() : null;
        }

        public final void setExcludePeriodConfiguration(ExcludePeriodConfiguration.BuilderImpl excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration != null ? excludePeriodConfiguration.build() : null;
        }

        @Override
        public final Builder excludePeriodConfiguration(ExcludePeriodConfiguration excludePeriodConfiguration) {
            this.excludePeriodConfiguration = excludePeriodConfiguration;
            return this;
        }

        public final String getTimeGranularity() {
            return this.timeGranularity;
        }

        public final void setTimeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
        }

        @Override
        public final Builder timeGranularity(String timeGranularity) {
            this.timeGranularity = timeGranularity;
            return this;
        }

        @Override
        public final Builder timeGranularity(TimeGranularity timeGranularity) {
            this.timeGranularity(timeGranularity == null ? null : timeGranularity.toString());
            return this;
        }

        public TimeRangeFilter build() {
            return new TimeRangeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeRangeFilter> {
        public Builder filterId(String var1);

        public Builder column(ColumnIdentifier var1);

        default public Builder column(Consumer<ColumnIdentifier.Builder> column) {
            return this.column((ColumnIdentifier)((ColumnIdentifier.Builder)ColumnIdentifier.builder().applyMutation(column)).build());
        }

        public Builder includeMinimum(Boolean var1);

        public Builder includeMaximum(Boolean var1);

        public Builder rangeMinimumValue(TimeRangeFilterValue var1);

        default public Builder rangeMinimumValue(Consumer<TimeRangeFilterValue.Builder> rangeMinimumValue) {
            return this.rangeMinimumValue((TimeRangeFilterValue)((TimeRangeFilterValue.Builder)TimeRangeFilterValue.builder().applyMutation(rangeMinimumValue)).build());
        }

        public Builder rangeMaximumValue(TimeRangeFilterValue var1);

        default public Builder rangeMaximumValue(Consumer<TimeRangeFilterValue.Builder> rangeMaximumValue) {
            return this.rangeMaximumValue((TimeRangeFilterValue)((TimeRangeFilterValue.Builder)TimeRangeFilterValue.builder().applyMutation(rangeMaximumValue)).build());
        }

        public Builder nullOption(String var1);

        public Builder nullOption(FilterNullOption var1);

        public Builder excludePeriodConfiguration(ExcludePeriodConfiguration var1);

        default public Builder excludePeriodConfiguration(Consumer<ExcludePeriodConfiguration.Builder> excludePeriodConfiguration) {
            return this.excludePeriodConfiguration((ExcludePeriodConfiguration)((ExcludePeriodConfiguration.Builder)ExcludePeriodConfiguration.builder().applyMutation(excludePeriodConfiguration)).build());
        }

        public Builder timeGranularity(String var1);

        public Builder timeGranularity(TimeGranularity var1);
    }
}

