/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceType {
    ADOBE_ANALYTICS("ADOBE_ANALYTICS"),
    AMAZON_ELASTICSEARCH("AMAZON_ELASTICSEARCH"),
    ATHENA("ATHENA"),
    AURORA("AURORA"),
    AURORA_POSTGRESQL("AURORA_POSTGRESQL"),
    AWS_IOT_ANALYTICS("AWS_IOT_ANALYTICS"),
    GITHUB("GITHUB"),
    JIRA("JIRA"),
    MARIADB("MARIADB"),
    MYSQL("MYSQL"),
    ORACLE("ORACLE"),
    POSTGRESQL("POSTGRESQL"),
    PRESTO("PRESTO"),
    REDSHIFT("REDSHIFT"),
    S3("S3"),
    SALESFORCE("SALESFORCE"),
    SERVICENOW("SERVICENOW"),
    SNOWFLAKE("SNOWFLAKE"),
    SPARK("SPARK"),
    SQLSERVER("SQLSERVER"),
    TERADATA("TERADATA"),
    TWITTER("TWITTER"),
    TIMESTREAM("TIMESTREAM"),
    AMAZON_OPENSEARCH("AMAZON_OPENSEARCH"),
    EXASOL("EXASOL"),
    DATABRICKS("DATABRICKS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceType> VALUE_MAP;
    private final String value;

    private DataSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceType> knownValues() {
        EnumSet<DataSourceType> knownValues = EnumSet.allOf(DataSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceType.class, DataSourceType::toString);
    }
}

