/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataLabelPosition {
    INSIDE("INSIDE"),
    OUTSIDE("OUTSIDE"),
    LEFT("LEFT"),
    TOP("TOP"),
    BOTTOM("BOTTOM"),
    RIGHT("RIGHT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataLabelPosition> VALUE_MAP;
    private final String value;

    private DataLabelPosition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataLabelPosition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataLabelPosition> knownValues() {
        EnumSet<DataLabelPosition> knownValues = EnumSet.allOf(DataLabelPosition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataLabelPosition.class, DataLabelPosition::toString);
    }
}

