/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TableOrientation {
    VERTICAL("VERTICAL"),
    HORIZONTAL("HORIZONTAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TableOrientation> VALUE_MAP;
    private final String value;

    private TableOrientation(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TableOrientation fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TableOrientation> knownValues() {
        EnumSet<TableOrientation> knownValues = EnumSet.allOf(TableOrientation.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TableOrientation.class, TableOrientation::toString);
    }
}

