/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.DashboardSummary;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;

public class SearchDashboardsIterable
implements SdkIterable<SearchDashboardsResponse> {
    private final QuickSightClient client;
    private final SearchDashboardsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchDashboardsIterable(QuickSightClient client, SearchDashboardsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchDashboardsResponseFetcher();
    }

    public Iterator<SearchDashboardsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DashboardSummary> dashboardSummaryList() {
        Function<SearchDashboardsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dashboardSummaryList() != null) {
                return response.dashboardSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchDashboardsResponseFetcher
    implements SyncPageFetcher<SearchDashboardsResponse> {
        private SearchDashboardsResponseFetcher() {
        }

        public boolean hasNextPage(SearchDashboardsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchDashboardsResponse nextPage(SearchDashboardsResponse previousPage) {
            if (previousPage == null) {
                return SearchDashboardsIterable.this.client.searchDashboards(SearchDashboardsIterable.this.firstRequest);
            }
            return SearchDashboardsIterable.this.client.searchDashboards((SearchDashboardsRequest)((Object)SearchDashboardsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

