/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSourceCredentials;
import software.amazon.awssdk.services.quicksight.model.DataSourceParameters;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.SslProperties;
import software.amazon.awssdk.services.quicksight.model.VpcConnectionProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataSourceRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateDataSourceRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::awsAccountId)).setter(UpdateDataSourceRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSourceId").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::dataSourceId)).setter(UpdateDataSourceRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSourceId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::name)).setter(UpdateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSourceParameters").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::dataSourceParameters)).setter(UpdateDataSourceRequest.setter(Builder::dataSourceParameters)).constructor(DataSourceParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build()}).build();
    private static final SdkField<DataSourceCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Credentials").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::credentials)).setter(UpdateDataSourceRequest.setter(Builder::credentials)).constructor(DataSourceCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()}).build();
    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConnectionProperties").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::vpcConnectionProperties)).setter(UpdateDataSourceRequest.setter(Builder::vpcConnectionProperties)).constructor(VpcConnectionProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build()}).build();
    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SslProperties").getter(UpdateDataSourceRequest.getter(UpdateDataSourceRequest::sslProperties)).setter(UpdateDataSourceRequest.setter(Builder::sslProperties)).constructor(SslProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, DATA_SOURCE_ID_FIELD, NAME_FIELD, DATA_SOURCE_PARAMETERS_FIELD, CREDENTIALS_FIELD, VPC_CONNECTION_PROPERTIES_FIELD, SSL_PROPERTIES_FIELD));
    private final String awsAccountId;
    private final String dataSourceId;
    private final String name;
    private final DataSourceParameters dataSourceParameters;
    private final DataSourceCredentials credentials;
    private final VpcConnectionProperties vpcConnectionProperties;
    private final SslProperties sslProperties;

    private UpdateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.credentials = builder.credentials;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String name() {
        return this.name;
    }

    public final DataSourceParameters dataSourceParameters() {
        return this.dataSourceParameters;
    }

    public final DataSourceCredentials credentials() {
        return this.credentials;
    }

    public final VpcConnectionProperties vpcConnectionProperties() {
        return this.vpcConnectionProperties;
    }

    public final SslProperties sslProperties() {
        return this.sslProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sslProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dataSourceParameters(), other.dataSourceParameters()) && Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.vpcConnectionProperties(), other.vpcConnectionProperties()) && Objects.equals(this.sslProperties(), other.sslProperties());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataSourceRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("DataSourceId", (Object)this.dataSourceId()).add("Name", (Object)this.name()).add("DataSourceParameters", (Object)this.dataSourceParameters()).add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("VpcConnectionProperties", (Object)this.vpcConnectionProperties()).add("SslProperties", (Object)this.sslProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "DataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DataSourceParameters": {
                return Optional.ofNullable(clazz.cast(this.dataSourceParameters()));
            }
            case "Credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "VpcConnectionProperties": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionProperties()));
            }
            case "SslProperties": {
                return Optional.ofNullable(clazz.cast(this.sslProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataSourceRequest, T> g) {
        return obj -> g.apply((UpdateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String dataSourceId;
        private String name;
        private DataSourceParameters dataSourceParameters;
        private DataSourceCredentials credentials;
        private VpcConnectionProperties vpcConnectionProperties;
        private SslProperties sslProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataSourceRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.dataSourceId(model.dataSourceId);
            this.name(model.name);
            this.dataSourceParameters(model.dataSourceParameters);
            this.credentials(model.credentials);
            this.vpcConnectionProperties(model.vpcConnectionProperties);
            this.sslProperties(model.sslProperties);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return this.dataSourceParameters != null ? this.dataSourceParameters.toBuilder() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        public final DataSourceCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(DataSourceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(DataSourceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return this.vpcConnectionProperties != null ? this.vpcConnectionProperties.toBuilder() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        public final SslProperties.Builder getSslProperties() {
            return this.sslProperties != null ? this.sslProperties.toBuilder() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataSourceRequest build() {
            return new UpdateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataSourceRequest> {
        public Builder awsAccountId(String var1);

        public Builder dataSourceId(String var1);

        public Builder name(String var1);

        public Builder dataSourceParameters(DataSourceParameters var1);

        default public Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return this.dataSourceParameters((DataSourceParameters)((DataSourceParameters.Builder)DataSourceParameters.builder().applyMutation(dataSourceParameters)).build());
        }

        public Builder credentials(DataSourceCredentials var1);

        default public Builder credentials(Consumer<DataSourceCredentials.Builder> credentials) {
            return this.credentials((DataSourceCredentials)((DataSourceCredentials.Builder)DataSourceCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder vpcConnectionProperties(VpcConnectionProperties var1);

        default public Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return this.vpcConnectionProperties((VpcConnectionProperties)((VpcConnectionProperties.Builder)VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties)).build());
        }

        public Builder sslProperties(SslProperties var1);

        default public Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return this.sslProperties((SslProperties)((SslProperties.Builder)SslProperties.builder().applyMutation(sslProperties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

