/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSet;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataSetResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeDataSetResponse> {
    private static final SdkField<DataSet> DATA_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSet").getter(DescribeDataSetResponse.getter(DescribeDataSetResponse::dataSet)).setter(DescribeDataSetResponse.setter(Builder::dataSet)).constructor(DataSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSet").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeDataSetResponse.getter(DescribeDataSetResponse::requestId)).setter(DescribeDataSetResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeDataSetResponse.getter(DescribeDataSetResponse::status)).setter(DescribeDataSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final DataSet dataSet;
    private final String requestId;
    private final Integer status;

    private DescribeDataSetResponse(BuilderImpl builder) {
        super(builder);
        this.dataSet = builder.dataSet;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final DataSet dataSet() {
        return this.dataSet;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSetResponse)) {
            return false;
        }
        DescribeDataSetResponse other = (DescribeDataSetResponse)((Object)obj);
        return Objects.equals(this.dataSet(), other.dataSet()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataSetResponse").add("DataSet", (Object)this.dataSet()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSet": {
                return Optional.ofNullable(clazz.cast(this.dataSet()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSetResponse, T> g) {
        return obj -> g.apply((DescribeDataSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private DataSet dataSet;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSetResponse model) {
            super(model);
            this.dataSet(model.dataSet);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final DataSet.Builder getDataSet() {
            return this.dataSet != null ? this.dataSet.toBuilder() : null;
        }

        @Override
        public final Builder dataSet(DataSet dataSet) {
            this.dataSet = dataSet;
            return this;
        }

        public final void setDataSet(DataSet.BuilderImpl dataSet) {
            this.dataSet = dataSet != null ? dataSet.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public DescribeDataSetResponse build() {
            return new DescribeDataSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataSetResponse> {
        public Builder dataSet(DataSet var1);

        default public Builder dataSet(Consumer<DataSet.Builder> dataSet) {
            return this.dataSet((DataSet)((DataSet.Builder)DataSet.builder().applyMutation(dataSet)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

