/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qldbsession;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.qldbsession.DefaultQldbSessionBaseClientBuilder;
import software.amazon.awssdk.services.qldbsession.DefaultQldbSessionClient;
import software.amazon.awssdk.services.qldbsession.QldbSessionClient;
import software.amazon.awssdk.services.qldbsession.QldbSessionClientBuilder;
import software.amazon.awssdk.services.qldbsession.QldbSessionServiceClientConfiguration;
import software.amazon.awssdk.services.qldbsession.endpoints.QldbSessionEndpointProvider;

@SdkInternalApi
final class DefaultQldbSessionClientBuilder
extends DefaultQldbSessionBaseClientBuilder<QldbSessionClientBuilder, QldbSessionClient>
implements QldbSessionClientBuilder {
    DefaultQldbSessionClientBuilder() {
    }

    @Override
    public DefaultQldbSessionClientBuilder endpointProvider(QldbSessionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final QldbSessionClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultQldbSessionClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        QldbSessionServiceClientConfiguration serviceClientConfiguration = QldbSessionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultQldbSessionClient(serviceClientConfiguration, clientConfiguration);
    }
}

