/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEnvironmentAccountConnectionsRequest extends ProtonRequest implements
        ToCopyableBuilder<ListEnvironmentAccountConnectionsRequest.Builder, ListEnvironmentAccountConnectionsRequest> {
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(ListEnvironmentAccountConnectionsRequest::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListEnvironmentAccountConnectionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListEnvironmentAccountConnectionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> REQUESTED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestedBy").getter(getter(ListEnvironmentAccountConnectionsRequest::requestedByAsString))
            .setter(setter(Builder::requestedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedBy").build()).build();

    private static final SdkField<List<String>> STATUSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statuses")
            .getter(getter(ListEnvironmentAccountConnectionsRequest::statusesAsStrings))
            .setter(setter(Builder::statusesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_NAME_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, REQUESTED_BY_FIELD, STATUSES_FIELD));

    private final String environmentName;

    private final Integer maxResults;

    private final String nextToken;

    private final String requestedBy;

    private final List<String> statuses;

    private ListEnvironmentAccountConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.environmentName = builder.environmentName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.requestedBy = builder.requestedBy;
        this.statuses = builder.statuses;
    }

    /**
     * <p>
     * The environment name that's associated with each listed environment account connection.
     * </p>
     * 
     * @return The environment name that's associated with each listed environment account connection.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The maximum number of environment account connections to list.
     * </p>
     * 
     * @return The maximum number of environment account connections to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that indicates the location of the next environment account connection in the array of environment
     * account connections, after the list of environment account connections that was previously requested.
     * </p>
     * 
     * @return A token that indicates the location of the next environment account connection in the array of
     *         environment account connections, after the list of environment account connections that was previously
     *         requested.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The type of account making the <code>ListEnvironmentAccountConnections</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestedBy} will
     * return {@link EnvironmentAccountConnectionRequesterAccountType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #requestedByAsString}.
     * </p>
     * 
     * @return The type of account making the <code>ListEnvironmentAccountConnections</code> request.
     * @see EnvironmentAccountConnectionRequesterAccountType
     */
    public final EnvironmentAccountConnectionRequesterAccountType requestedBy() {
        return EnvironmentAccountConnectionRequesterAccountType.fromValue(requestedBy);
    }

    /**
     * <p>
     * The type of account making the <code>ListEnvironmentAccountConnections</code> request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestedBy} will
     * return {@link EnvironmentAccountConnectionRequesterAccountType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #requestedByAsString}.
     * </p>
     * 
     * @return The type of account making the <code>ListEnvironmentAccountConnections</code> request.
     * @see EnvironmentAccountConnectionRequesterAccountType
     */
    public final String requestedByAsString() {
        return requestedBy;
    }

    /**
     * <p>
     * The status details for each listed environment account connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The status details for each listed environment account connection.
     */
    public final List<EnvironmentAccountConnectionStatus> statuses() {
        return EnvironmentAccountConnectionStatusListCopier.copyStringToEnum(statuses);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statuses property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatuses() {
        return statuses != null && !(statuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status details for each listed environment account connection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatuses} method.
     * </p>
     * 
     * @return The status details for each listed environment account connection.
     */
    public final List<String> statusesAsStrings() {
        return statuses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatuses() ? statusesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnvironmentAccountConnectionsRequest)) {
            return false;
        }
        ListEnvironmentAccountConnectionsRequest other = (ListEnvironmentAccountConnectionsRequest) obj;
        return Objects.equals(environmentName(), other.environmentName()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(requestedByAsString(), other.requestedByAsString()) && hasStatuses() == other.hasStatuses()
                && Objects.equals(statusesAsStrings(), other.statusesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEnvironmentAccountConnectionsRequest").add("EnvironmentName", environmentName())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("RequestedBy", requestedByAsString())
                .add("Statuses", hasStatuses() ? statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "requestedBy":
            return Optional.ofNullable(clazz.cast(requestedByAsString()));
        case "statuses":
            return Optional.ofNullable(clazz.cast(statusesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEnvironmentAccountConnectionsRequest, T> g) {
        return obj -> g.apply((ListEnvironmentAccountConnectionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ProtonRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEnvironmentAccountConnectionsRequest> {
        /**
         * <p>
         * The environment name that's associated with each listed environment account connection.
         * </p>
         * 
         * @param environmentName
         *        The environment name that's associated with each listed environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The maximum number of environment account connections to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of environment account connections to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that indicates the location of the next environment account connection in the array of environment
         * account connections, after the list of environment account connections that was previously requested.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates the location of the next environment account connection in the array of
         *        environment account connections, after the list of environment account connections that was previously
         *        requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The type of account making the <code>ListEnvironmentAccountConnections</code> request.
         * </p>
         * 
         * @param requestedBy
         *        The type of account making the <code>ListEnvironmentAccountConnections</code> request.
         * @see EnvironmentAccountConnectionRequesterAccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentAccountConnectionRequesterAccountType
         */
        Builder requestedBy(String requestedBy);

        /**
         * <p>
         * The type of account making the <code>ListEnvironmentAccountConnections</code> request.
         * </p>
         * 
         * @param requestedBy
         *        The type of account making the <code>ListEnvironmentAccountConnections</code> request.
         * @see EnvironmentAccountConnectionRequesterAccountType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentAccountConnectionRequesterAccountType
         */
        Builder requestedBy(EnvironmentAccountConnectionRequesterAccountType requestedBy);

        /**
         * <p>
         * The status details for each listed environment account connection.
         * </p>
         * 
         * @param statuses
         *        The status details for each listed environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(Collection<String> statuses);

        /**
         * <p>
         * The status details for each listed environment account connection.
         * </p>
         * 
         * @param statuses
         *        The status details for each listed environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusesWithStrings(String... statuses);

        /**
         * <p>
         * The status details for each listed environment account connection.
         * </p>
         * 
         * @param statuses
         *        The status details for each listed environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(Collection<EnvironmentAccountConnectionStatus> statuses);

        /**
         * <p>
         * The status details for each listed environment account connection.
         * </p>
         * 
         * @param statuses
         *        The status details for each listed environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statuses(EnvironmentAccountConnectionStatus... statuses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ProtonRequest.BuilderImpl implements Builder {
        private String environmentName;

        private Integer maxResults;

        private String nextToken;

        private String requestedBy;

        private List<String> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnvironmentAccountConnectionsRequest model) {
            super(model);
            environmentName(model.environmentName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            requestedBy(model.requestedBy);
            statusesWithStrings(model.statuses);
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestedBy() {
            return requestedBy;
        }

        public final void setRequestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
        }

        @Override
        public final Builder requestedBy(String requestedBy) {
            this.requestedBy = requestedBy;
            return this;
        }

        @Override
        public final Builder requestedBy(EnvironmentAccountConnectionRequesterAccountType requestedBy) {
            this.requestedBy(requestedBy == null ? null : requestedBy.toString());
            return this;
        }

        public final Collection<String> getStatuses() {
            if (statuses instanceof SdkAutoConstructList) {
                return null;
            }
            return statuses;
        }

        public final void setStatuses(Collection<String> statuses) {
            this.statuses = EnvironmentAccountConnectionStatusListCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Collection<String> statuses) {
            this.statuses = EnvironmentAccountConnectionStatusListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusesWithStrings(String... statuses) {
            statusesWithStrings(Arrays.asList(statuses));
            return this;
        }

        @Override
        public final Builder statuses(Collection<EnvironmentAccountConnectionStatus> statuses) {
            this.statuses = EnvironmentAccountConnectionStatusListCopier.copyEnumToString(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(EnvironmentAccountConnectionStatus... statuses) {
            statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEnvironmentAccountConnectionsRequest build() {
            return new ListEnvironmentAccountConnectionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
