/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplateVersionsResponse;

public class ListEnvironmentTemplateVersionsIterable
implements SdkIterable<ListEnvironmentTemplateVersionsResponse> {
    private final ProtonClient client;
    private final ListEnvironmentTemplateVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentTemplateVersionsIterable(ProtonClient client, ListEnvironmentTemplateVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentTemplateVersionsResponseFetcher();
    }

    public Iterator<ListEnvironmentTemplateVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentTemplateVersionSummary> templateVersions() {
        Function<ListEnvironmentTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateVersions() != null) {
                return response.templateVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentTemplateVersionsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentTemplateVersionsResponse> {
        private ListEnvironmentTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentTemplateVersionsResponse nextPage(ListEnvironmentTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentTemplateVersionsIterable.this.client.listEnvironmentTemplateVersions(ListEnvironmentTemplateVersionsIterable.this.firstRequest);
            }
            return ListEnvironmentTemplateVersionsIterable.this.client.listEnvironmentTemplateVersions((ListEnvironmentTemplateVersionsRequest)((Object)ListEnvironmentTemplateVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

