/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.proton.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary data of an Proton environment account connection resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentAccountConnectionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentAccountConnectionSummary.Builder, EnvironmentAccountConnectionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnvironmentAccountConnectionSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> COMPONENT_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("componentRoleArn").getter(getter(EnvironmentAccountConnectionSummary::componentRoleArn))
            .setter(setter(Builder::componentRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentRoleArn").build()).build();

    private static final SdkField<String> ENVIRONMENT_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentAccountId").getter(getter(EnvironmentAccountConnectionSummary::environmentAccountId))
            .setter(setter(Builder::environmentAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentAccountId").build())
            .build();

    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentName").getter(getter(EnvironmentAccountConnectionSummary::environmentName))
            .setter(setter(Builder::environmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EnvironmentAccountConnectionSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedAt").getter(getter(EnvironmentAccountConnectionSummary::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedAt").build()).build();

    private static final SdkField<String> MANAGEMENT_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managementAccountId").getter(getter(EnvironmentAccountConnectionSummary::managementAccountId))
            .setter(setter(Builder::managementAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementAccountId").build())
            .build();

    private static final SdkField<Instant> REQUESTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("requestedAt").getter(getter(EnvironmentAccountConnectionSummary::requestedAt))
            .setter(setter(Builder::requestedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestedAt").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(EnvironmentAccountConnectionSummary::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(EnvironmentAccountConnectionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            COMPONENT_ROLE_ARN_FIELD, ENVIRONMENT_ACCOUNT_ID_FIELD, ENVIRONMENT_NAME_FIELD, ID_FIELD, LAST_MODIFIED_AT_FIELD,
            MANAGEMENT_ACCOUNT_ID_FIELD, REQUESTED_AT_FIELD, ROLE_ARN_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String componentRoleArn;

    private final String environmentAccountId;

    private final String environmentName;

    private final String id;

    private final Instant lastModifiedAt;

    private final String managementAccountId;

    private final Instant requestedAt;

    private final String roleArn;

    private final String status;

    private EnvironmentAccountConnectionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.componentRoleArn = builder.componentRoleArn;
        this.environmentAccountId = builder.environmentAccountId;
        this.environmentName = builder.environmentName;
        this.id = builder.id;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.managementAccountId = builder.managementAccountId;
        this.requestedAt = builder.requestedAt;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment account connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment account connection.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
     * components in the associated environment account. It determines the scope of infrastructure that a component can
     * provision in the account.
     * </p>
     * <p>
     * The environment account connection must have a <code>componentRoleArn</code> to allow directly defined components
     * to be associated with any environments running in the account.
     * </p>
     * <p>
     * For more information about components, see <a
     * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
     * <i>Proton User Guide</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
     *         defined components in the associated environment account. It determines the scope of infrastructure that
     *         a component can provision in the account.</p>
     *         <p>
     *         The environment account connection must have a <code>componentRoleArn</code> to allow directly defined
     *         components to be associated with any environments running in the account.
     *         </p>
     *         <p>
     *         For more information about components, see <a
     *         href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
     *         the <i>Proton User Guide</i>.
     */
    public final String componentRoleArn() {
        return componentRoleArn;
    }

    /**
     * <p>
     * The ID of the environment account that's connected to the environment account connection.
     * </p>
     * 
     * @return The ID of the environment account that's connected to the environment account connection.
     */
    public final String environmentAccountId() {
        return environmentAccountId;
    }

    /**
     * <p>
     * The name of the environment that's associated with the environment account connection.
     * </p>
     * 
     * @return The name of the environment that's associated with the environment account connection.
     */
    public final String environmentName() {
        return environmentName;
    }

    /**
     * <p>
     * The ID of the environment account connection.
     * </p>
     * 
     * @return The ID of the environment account connection.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The time when the environment account connection was last modified.
     * </p>
     * 
     * @return The time when the environment account connection was last modified.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The ID of the management account that's connected to the environment account connection.
     * </p>
     * 
     * @return The ID of the management account that's connected to the environment account connection.
     */
    public final String managementAccountId() {
        return managementAccountId;
    }

    /**
     * <p>
     * The time when the environment account connection request was made.
     * </p>
     * 
     * @return The time when the environment account connection request was made.
     */
    public final Instant requestedAt() {
        return requestedAt;
    }

    /**
     * <p>
     * The IAM service role that's associated with the environment account connection.
     * </p>
     * 
     * @return The IAM service role that's associated with the environment account connection.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the environment account connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentAccountConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment account connection.
     * @see EnvironmentAccountConnectionStatus
     */
    public final EnvironmentAccountConnectionStatus status() {
        return EnvironmentAccountConnectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the environment account connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EnvironmentAccountConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the environment account connection.
     * @see EnvironmentAccountConnectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(componentRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(environmentAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(managementAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(requestedAt());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentAccountConnectionSummary)) {
            return false;
        }
        EnvironmentAccountConnectionSummary other = (EnvironmentAccountConnectionSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(componentRoleArn(), other.componentRoleArn())
                && Objects.equals(environmentAccountId(), other.environmentAccountId())
                && Objects.equals(environmentName(), other.environmentName()) && Objects.equals(id(), other.id())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt())
                && Objects.equals(managementAccountId(), other.managementAccountId())
                && Objects.equals(requestedAt(), other.requestedAt()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentAccountConnectionSummary").add("Arn", arn())
                .add("ComponentRoleArn", componentRoleArn()).add("EnvironmentAccountId", environmentAccountId())
                .add("EnvironmentName", environmentName()).add("Id", id()).add("LastModifiedAt", lastModifiedAt())
                .add("ManagementAccountId", managementAccountId()).add("RequestedAt", requestedAt()).add("RoleArn", roleArn())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "componentRoleArn":
            return Optional.ofNullable(clazz.cast(componentRoleArn()));
        case "environmentAccountId":
            return Optional.ofNullable(clazz.cast(environmentAccountId()));
        case "environmentName":
            return Optional.ofNullable(clazz.cast(environmentName()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "managementAccountId":
            return Optional.ofNullable(clazz.cast(managementAccountId()));
        case "requestedAt":
            return Optional.ofNullable(clazz.cast(requestedAt()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentAccountConnectionSummary, T> g) {
        return obj -> g.apply((EnvironmentAccountConnectionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentAccountConnectionSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment account connection.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly defined
         * components in the associated environment account. It determines the scope of infrastructure that a component
         * can provision in the account.
         * </p>
         * <p>
         * The environment account connection must have a <code>componentRoleArn</code> to allow directly defined
         * components to be associated with any environments running in the account.
         * </p>
         * <p>
         * For more information about components, see <a
         * href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in the
         * <i>Proton User Guide</i>.
         * </p>
         * 
         * @param componentRoleArn
         *        The Amazon Resource Name (ARN) of the IAM service role that Proton uses when provisioning directly
         *        defined components in the associated environment account. It determines the scope of infrastructure
         *        that a component can provision in the account.</p>
         *        <p>
         *        The environment account connection must have a <code>componentRoleArn</code> to allow directly defined
         *        components to be associated with any environments running in the account.
         *        </p>
         *        <p>
         *        For more information about components, see <a
         *        href="https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html">Proton components</a> in
         *        the <i>Proton User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentRoleArn(String componentRoleArn);

        /**
         * <p>
         * The ID of the environment account that's connected to the environment account connection.
         * </p>
         * 
         * @param environmentAccountId
         *        The ID of the environment account that's connected to the environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentAccountId(String environmentAccountId);

        /**
         * <p>
         * The name of the environment that's associated with the environment account connection.
         * </p>
         * 
         * @param environmentName
         *        The name of the environment that's associated with the environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentName(String environmentName);

        /**
         * <p>
         * The ID of the environment account connection.
         * </p>
         * 
         * @param id
         *        The ID of the environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The time when the environment account connection was last modified.
         * </p>
         * 
         * @param lastModifiedAt
         *        The time when the environment account connection was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The ID of the management account that's connected to the environment account connection.
         * </p>
         * 
         * @param managementAccountId
         *        The ID of the management account that's connected to the environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managementAccountId(String managementAccountId);

        /**
         * <p>
         * The time when the environment account connection request was made.
         * </p>
         * 
         * @param requestedAt
         *        The time when the environment account connection request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedAt(Instant requestedAt);

        /**
         * <p>
         * The IAM service role that's associated with the environment account connection.
         * </p>
         * 
         * @param roleArn
         *        The IAM service role that's associated with the environment account connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the environment account connection.
         * </p>
         * 
         * @param status
         *        The status of the environment account connection.
         * @see EnvironmentAccountConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentAccountConnectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the environment account connection.
         * </p>
         * 
         * @param status
         *        The status of the environment account connection.
         * @see EnvironmentAccountConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentAccountConnectionStatus
         */
        Builder status(EnvironmentAccountConnectionStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String componentRoleArn;

        private String environmentAccountId;

        private String environmentName;

        private String id;

        private Instant lastModifiedAt;

        private String managementAccountId;

        private Instant requestedAt;

        private String roleArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentAccountConnectionSummary model) {
            arn(model.arn);
            componentRoleArn(model.componentRoleArn);
            environmentAccountId(model.environmentAccountId);
            environmentName(model.environmentName);
            id(model.id);
            lastModifiedAt(model.lastModifiedAt);
            managementAccountId(model.managementAccountId);
            requestedAt(model.requestedAt);
            roleArn(model.roleArn);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getComponentRoleArn() {
            return componentRoleArn;
        }

        public final void setComponentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
        }

        @Override
        public final Builder componentRoleArn(String componentRoleArn) {
            this.componentRoleArn = componentRoleArn;
            return this;
        }

        public final String getEnvironmentAccountId() {
            return environmentAccountId;
        }

        public final void setEnvironmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
        }

        @Override
        public final Builder environmentAccountId(String environmentAccountId) {
            this.environmentAccountId = environmentAccountId;
            return this;
        }

        public final String getEnvironmentName() {
            return environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getManagementAccountId() {
            return managementAccountId;
        }

        public final void setManagementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
        }

        @Override
        public final Builder managementAccountId(String managementAccountId) {
            this.managementAccountId = managementAccountId;
            return this;
        }

        public final Instant getRequestedAt() {
            return requestedAt;
        }

        public final void setRequestedAt(Instant requestedAt) {
            this.requestedAt = requestedAt;
        }

        @Override
        public final Builder requestedAt(Instant requestedAt) {
            this.requestedAt = requestedAt;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EnvironmentAccountConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EnvironmentAccountConnectionSummary build() {
            return new EnvironmentAccountConnectionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
