/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.DeadLetterConfig;
import software.amazon.awssdk.services.pipes.model.OnPartialBatchItemFailureStreams;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePipeSourceDynamoDBStreamParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdatePipeSourceDynamoDBStreamParameters> {
    private static final SdkField<Integer> BATCH_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BatchSize").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::batchSize)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::batchSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchSize").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::deadLetterConfig)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<Integer> MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumBatchingWindowInSeconds").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::maximumBatchingWindowInSeconds)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::maximumBatchingWindowInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumBatchingWindowInSeconds").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRecordAgeInSeconds").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::maximumRecordAgeInSeconds)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::maximumRecordAgeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRecordAgeInSeconds").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryAttempts").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::maximumRetryAttempts)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::maximumRetryAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryAttempts").build()}).build();
    private static final SdkField<String> ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnPartialBatchItemFailure").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::onPartialBatchItemFailureAsString)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::onPartialBatchItemFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPartialBatchItemFailure").build()}).build();
    private static final SdkField<Integer> PARALLELIZATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParallelizationFactor").getter(UpdatePipeSourceDynamoDBStreamParameters.getter(UpdatePipeSourceDynamoDBStreamParameters::parallelizationFactor)).setter(UpdatePipeSourceDynamoDBStreamParameters.setter(Builder::parallelizationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelizationFactor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_SIZE_FIELD, DEAD_LETTER_CONFIG_FIELD, MAXIMUM_BATCHING_WINDOW_IN_SECONDS_FIELD, MAXIMUM_RECORD_AGE_IN_SECONDS_FIELD, MAXIMUM_RETRY_ATTEMPTS_FIELD, ON_PARTIAL_BATCH_ITEM_FAILURE_FIELD, PARALLELIZATION_FACTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer batchSize;
    private final DeadLetterConfig deadLetterConfig;
    private final Integer maximumBatchingWindowInSeconds;
    private final Integer maximumRecordAgeInSeconds;
    private final Integer maximumRetryAttempts;
    private final String onPartialBatchItemFailure;
    private final Integer parallelizationFactor;

    private UpdatePipeSourceDynamoDBStreamParameters(BuilderImpl builder) {
        this.batchSize = builder.batchSize;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
        this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
        this.maximumRetryAttempts = builder.maximumRetryAttempts;
        this.onPartialBatchItemFailure = builder.onPartialBatchItemFailure;
        this.parallelizationFactor = builder.parallelizationFactor;
    }

    public final Integer batchSize() {
        return this.batchSize;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final Integer maximumBatchingWindowInSeconds() {
        return this.maximumBatchingWindowInSeconds;
    }

    public final Integer maximumRecordAgeInSeconds() {
        return this.maximumRecordAgeInSeconds;
    }

    public final Integer maximumRetryAttempts() {
        return this.maximumRetryAttempts;
    }

    public final OnPartialBatchItemFailureStreams onPartialBatchItemFailure() {
        return OnPartialBatchItemFailureStreams.fromValue(this.onPartialBatchItemFailure);
    }

    public final String onPartialBatchItemFailureAsString() {
        return this.onPartialBatchItemFailure;
    }

    public final Integer parallelizationFactor() {
        return this.parallelizationFactor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.batchSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumBatchingWindowInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRecordAgeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPartialBatchItemFailureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelizationFactor());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipeSourceDynamoDBStreamParameters)) {
            return false;
        }
        UpdatePipeSourceDynamoDBStreamParameters other = (UpdatePipeSourceDynamoDBStreamParameters)obj;
        return Objects.equals(this.batchSize(), other.batchSize()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.maximumBatchingWindowInSeconds(), other.maximumBatchingWindowInSeconds()) && Objects.equals(this.maximumRecordAgeInSeconds(), other.maximumRecordAgeInSeconds()) && Objects.equals(this.maximumRetryAttempts(), other.maximumRetryAttempts()) && Objects.equals(this.onPartialBatchItemFailureAsString(), other.onPartialBatchItemFailureAsString()) && Objects.equals(this.parallelizationFactor(), other.parallelizationFactor());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePipeSourceDynamoDBStreamParameters").add("BatchSize", (Object)this.batchSize()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("MaximumBatchingWindowInSeconds", (Object)this.maximumBatchingWindowInSeconds()).add("MaximumRecordAgeInSeconds", (Object)this.maximumRecordAgeInSeconds()).add("MaximumRetryAttempts", (Object)this.maximumRetryAttempts()).add("OnPartialBatchItemFailure", (Object)this.onPartialBatchItemFailureAsString()).add("ParallelizationFactor", (Object)this.parallelizationFactor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BatchSize": {
                return Optional.ofNullable(clazz.cast(this.batchSize()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "MaximumBatchingWindowInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumBatchingWindowInSeconds()));
            }
            case "MaximumRecordAgeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maximumRecordAgeInSeconds()));
            }
            case "MaximumRetryAttempts": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryAttempts()));
            }
            case "OnPartialBatchItemFailure": {
                return Optional.ofNullable(clazz.cast(this.onPartialBatchItemFailureAsString()));
            }
            case "ParallelizationFactor": {
                return Optional.ofNullable(clazz.cast(this.parallelizationFactor()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipeSourceDynamoDBStreamParameters, T> g) {
        return obj -> g.apply((UpdatePipeSourceDynamoDBStreamParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer batchSize;
        private DeadLetterConfig deadLetterConfig;
        private Integer maximumBatchingWindowInSeconds;
        private Integer maximumRecordAgeInSeconds;
        private Integer maximumRetryAttempts;
        private String onPartialBatchItemFailure;
        private Integer parallelizationFactor;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipeSourceDynamoDBStreamParameters model) {
            this.batchSize(model.batchSize);
            this.deadLetterConfig(model.deadLetterConfig);
            this.maximumBatchingWindowInSeconds(model.maximumBatchingWindowInSeconds);
            this.maximumRecordAgeInSeconds(model.maximumRecordAgeInSeconds);
            this.maximumRetryAttempts(model.maximumRetryAttempts);
            this.onPartialBatchItemFailure(model.onPartialBatchItemFailure);
            this.parallelizationFactor(model.parallelizationFactor);
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final Integer getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        public final void setMaximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
        }

        @Override
        public final Builder maximumBatchingWindowInSeconds(Integer maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        public final Integer getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        public final void setMaximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
        }

        @Override
        public final Builder maximumRecordAgeInSeconds(Integer maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        public final Integer getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        public final void setMaximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
        }

        @Override
        public final Builder maximumRetryAttempts(Integer maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        public final String getOnPartialBatchItemFailure() {
            return this.onPartialBatchItemFailure;
        }

        public final void setOnPartialBatchItemFailure(String onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure = onPartialBatchItemFailure;
        }

        @Override
        public final Builder onPartialBatchItemFailure(String onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure = onPartialBatchItemFailure;
            return this;
        }

        @Override
        public final Builder onPartialBatchItemFailure(OnPartialBatchItemFailureStreams onPartialBatchItemFailure) {
            this.onPartialBatchItemFailure(onPartialBatchItemFailure == null ? null : onPartialBatchItemFailure.toString());
            return this;
        }

        public final Integer getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        public final void setParallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
        }

        @Override
        public final Builder parallelizationFactor(Integer parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        public UpdatePipeSourceDynamoDBStreamParameters build() {
            return new UpdatePipeSourceDynamoDBStreamParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdatePipeSourceDynamoDBStreamParameters> {
        public Builder batchSize(Integer var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder maximumBatchingWindowInSeconds(Integer var1);

        public Builder maximumRecordAgeInSeconds(Integer var1);

        public Builder maximumRetryAttempts(Integer var1);

        public Builder onPartialBatchItemFailure(String var1);

        public Builder onPartialBatchItemFailure(OnPartialBatchItemFailureStreams var1);

        public Builder parallelizationFactor(Integer var1);
    }
}

