/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.EventsRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventsRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, PutEventsRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(PutEventsRequest.getter(PutEventsRequest::applicationId)).setter(PutEventsRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<EventsRequest> EVENTS_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventsRequest").getter(PutEventsRequest.getter(PutEventsRequest::eventsRequest)).setter(PutEventsRequest.setter(Builder::eventsRequest)).constructor(EventsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventsRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, EVENTS_REQUEST_FIELD));
    private final String applicationId;
    private final EventsRequest eventsRequest;

    private PutEventsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.eventsRequest = builder.eventsRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final EventsRequest eventsRequest() {
        return this.eventsRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventsRequest)) {
            return false;
        }
        PutEventsRequest other = (PutEventsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.eventsRequest(), other.eventsRequest());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventsRequest").add("ApplicationId", (Object)this.applicationId()).add("EventsRequest", (Object)this.eventsRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "EventsRequest": {
                return Optional.ofNullable(clazz.cast(this.eventsRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutEventsRequest, T> g) {
        return obj -> g.apply((PutEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private EventsRequest eventsRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventsRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.eventsRequest(model.eventsRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final EventsRequest.Builder getEventsRequest() {
            return this.eventsRequest != null ? this.eventsRequest.toBuilder() : null;
        }

        public final void setEventsRequest(EventsRequest.BuilderImpl eventsRequest) {
            this.eventsRequest = eventsRequest != null ? eventsRequest.build() : null;
        }

        @Override
        public final Builder eventsRequest(EventsRequest eventsRequest) {
            this.eventsRequest = eventsRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventsRequest build() {
            return new PutEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventsRequest> {
        public Builder applicationId(String var1);

        public Builder eventsRequest(EventsRequest var1);

        default public Builder eventsRequest(Consumer<EventsRequest.Builder> eventsRequest) {
            return this.eventsRequest((EventsRequest)((EventsRequest.Builder)EventsRequest.builder().applyMutation(eventsRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

