/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointTypesElement {
    PUSH("PUSH"),
    GCM("GCM"),
    APNS("APNS"),
    APNS_SANDBOX("APNS_SANDBOX"),
    APNS_VOIP("APNS_VOIP"),
    APNS_VOIP_SANDBOX("APNS_VOIP_SANDBOX"),
    ADM("ADM"),
    SMS("SMS"),
    VOICE("VOICE"),
    EMAIL("EMAIL"),
    BAIDU("BAIDU"),
    CUSTOM("CUSTOM"),
    IN_APP("IN_APP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointTypesElement> VALUE_MAP;
    private final String value;

    private EndpointTypesElement(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointTypesElement fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointTypesElement> knownValues() {
        EnumSet<EndpointTypesElement> knownValues = EnumSet.allOf(EndpointTypesElement.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointTypesElement.class, EndpointTypesElement::toString);
    }
}

