/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeClient;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsRequest;
import software.amazon.awssdk.services.personalize.model.ListBatchInferenceJobsResponse;

public class ListBatchInferenceJobsIterable
implements SdkIterable<ListBatchInferenceJobsResponse> {
    private final PersonalizeClient client;
    private final ListBatchInferenceJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBatchInferenceJobsIterable(PersonalizeClient client, ListBatchInferenceJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBatchInferenceJobsResponseFetcher();
    }

    public Iterator<ListBatchInferenceJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BatchInferenceJobSummary> batchInferenceJobs() {
        Function<ListBatchInferenceJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.batchInferenceJobs() != null) {
                return response.batchInferenceJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBatchInferenceJobsResponseFetcher
    implements SyncPageFetcher<ListBatchInferenceJobsResponse> {
        private ListBatchInferenceJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListBatchInferenceJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBatchInferenceJobsResponse nextPage(ListBatchInferenceJobsResponse previousPage) {
            if (previousPage == null) {
                return ListBatchInferenceJobsIterable.this.client.listBatchInferenceJobs(ListBatchInferenceJobsIterable.this.firstRequest);
            }
            return ListBatchInferenceJobsIterable.this.client.listBatchInferenceJobs((ListBatchInferenceJobsRequest)((Object)ListBatchInferenceJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

