/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeviceResponse extends PanoramaResponse implements
        ToCopyableBuilder<DescribeDeviceResponse.Builder, DescribeDeviceResponse> {
    private static final SdkField<List<AlternateSoftwareMetadata>> ALTERNATE_SOFTWARES_FIELD = SdkField
            .<List<AlternateSoftwareMetadata>> builder(MarshallingType.LIST)
            .memberName("AlternateSoftwares")
            .getter(getter(DescribeDeviceResponse::alternateSoftwares))
            .setter(setter(Builder::alternateSoftwares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlternateSoftwares").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AlternateSoftwareMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(AlternateSoftwareMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeDeviceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> BRAND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Brand")
            .getter(getter(DescribeDeviceResponse::brandAsString)).setter(setter(Builder::brand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Brand").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DescribeDeviceResponse::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<NetworkStatus> CURRENT_NETWORKING_STATUS_FIELD = SdkField
            .<NetworkStatus> builder(MarshallingType.SDK_POJO).memberName("CurrentNetworkingStatus")
            .getter(getter(DescribeDeviceResponse::currentNetworkingStatus)).setter(setter(Builder::currentNetworkingStatus))
            .constructor(NetworkStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentNetworkingStatus").build())
            .build();

    private static final SdkField<String> CURRENT_SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentSoftware").getter(getter(DescribeDeviceResponse::currentSoftware))
            .setter(setter(Builder::currentSoftware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentSoftware").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DescribeDeviceResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEVICE_AGGREGATED_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceAggregatedStatus").getter(getter(DescribeDeviceResponse::deviceAggregatedStatusAsString))
            .setter(setter(Builder::deviceAggregatedStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceAggregatedStatus").build())
            .build();

    private static final SdkField<String> DEVICE_CONNECTION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceConnectionStatus").getter(getter(DescribeDeviceResponse::deviceConnectionStatusAsString))
            .setter(setter(Builder::deviceConnectionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceConnectionStatus").build())
            .build();

    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceId").getter(getter(DescribeDeviceResponse::deviceId)).setter(setter(Builder::deviceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()).build();

    private static final SdkField<String> LATEST_ALTERNATE_SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestAlternateSoftware").getter(getter(DescribeDeviceResponse::latestAlternateSoftware))
            .setter(setter(Builder::latestAlternateSoftware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestAlternateSoftware").build())
            .build();

    private static final SdkField<LatestDeviceJob> LATEST_DEVICE_JOB_FIELD = SdkField
            .<LatestDeviceJob> builder(MarshallingType.SDK_POJO).memberName("LatestDeviceJob")
            .getter(getter(DescribeDeviceResponse::latestDeviceJob)).setter(setter(Builder::latestDeviceJob))
            .constructor(LatestDeviceJob::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeviceJob").build()).build();

    private static final SdkField<String> LATEST_SOFTWARE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestSoftware").getter(getter(DescribeDeviceResponse::latestSoftware))
            .setter(setter(Builder::latestSoftware))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestSoftware").build()).build();

    private static final SdkField<Instant> LEASE_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LeaseExpirationTime").getter(getter(DescribeDeviceResponse::leaseExpirationTime))
            .setter(setter(Builder::leaseExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeaseExpirationTime").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeDeviceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<NetworkPayload> NETWORKING_CONFIGURATION_FIELD = SdkField
            .<NetworkPayload> builder(MarshallingType.SDK_POJO).memberName("NetworkingConfiguration")
            .getter(getter(DescribeDeviceResponse::networkingConfiguration)).setter(setter(Builder::networkingConfiguration))
            .constructor(NetworkPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkingConfiguration").build())
            .build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus").getter(getter(DescribeDeviceResponse::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus").build())
            .build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SerialNumber").getter(getter(DescribeDeviceResponse::serialNumber))
            .setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SerialNumber").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(DescribeDeviceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeDeviceResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALTERNATE_SOFTWARES_FIELD,
            ARN_FIELD, BRAND_FIELD, CREATED_TIME_FIELD, CURRENT_NETWORKING_STATUS_FIELD, CURRENT_SOFTWARE_FIELD,
            DESCRIPTION_FIELD, DEVICE_AGGREGATED_STATUS_FIELD, DEVICE_CONNECTION_STATUS_FIELD, DEVICE_ID_FIELD,
            LATEST_ALTERNATE_SOFTWARE_FIELD, LATEST_DEVICE_JOB_FIELD, LATEST_SOFTWARE_FIELD, LEASE_EXPIRATION_TIME_FIELD,
            NAME_FIELD, NETWORKING_CONFIGURATION_FIELD, PROVISIONING_STATUS_FIELD, SERIAL_NUMBER_FIELD, TAGS_FIELD, TYPE_FIELD));

    private final List<AlternateSoftwareMetadata> alternateSoftwares;

    private final String arn;

    private final String brand;

    private final Instant createdTime;

    private final NetworkStatus currentNetworkingStatus;

    private final String currentSoftware;

    private final String description;

    private final String deviceAggregatedStatus;

    private final String deviceConnectionStatus;

    private final String deviceId;

    private final String latestAlternateSoftware;

    private final LatestDeviceJob latestDeviceJob;

    private final String latestSoftware;

    private final Instant leaseExpirationTime;

    private final String name;

    private final NetworkPayload networkingConfiguration;

    private final String provisioningStatus;

    private final String serialNumber;

    private final Map<String, String> tags;

    private final String type;

    private DescribeDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.alternateSoftwares = builder.alternateSoftwares;
        this.arn = builder.arn;
        this.brand = builder.brand;
        this.createdTime = builder.createdTime;
        this.currentNetworkingStatus = builder.currentNetworkingStatus;
        this.currentSoftware = builder.currentSoftware;
        this.description = builder.description;
        this.deviceAggregatedStatus = builder.deviceAggregatedStatus;
        this.deviceConnectionStatus = builder.deviceConnectionStatus;
        this.deviceId = builder.deviceId;
        this.latestAlternateSoftware = builder.latestAlternateSoftware;
        this.latestDeviceJob = builder.latestDeviceJob;
        this.latestSoftware = builder.latestSoftware;
        this.leaseExpirationTime = builder.leaseExpirationTime;
        this.name = builder.name;
        this.networkingConfiguration = builder.networkingConfiguration;
        this.provisioningStatus = builder.provisioningStatus;
        this.serialNumber = builder.serialNumber;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlternateSoftwares property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAlternateSoftwares() {
        return alternateSoftwares != null && !(alternateSoftwares instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Beta software releases available for the device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlternateSoftwares} method.
     * </p>
     * 
     * @return Beta software releases available for the device.
     */
    public final List<AlternateSoftwareMetadata> alternateSoftwares() {
        return alternateSoftwares;
    }

    /**
     * <p>
     * The device's ARN.
     * </p>
     * 
     * @return The device's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The device's maker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brand} will return
     * {@link DeviceBrand#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandAsString}.
     * </p>
     * 
     * @return The device's maker.
     * @see DeviceBrand
     */
    public final DeviceBrand brand() {
        return DeviceBrand.fromValue(brand);
    }

    /**
     * <p>
     * The device's maker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #brand} will return
     * {@link DeviceBrand#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #brandAsString}.
     * </p>
     * 
     * @return The device's maker.
     * @see DeviceBrand
     */
    public final String brandAsString() {
        return brand;
    }

    /**
     * <p>
     * When the device was created.
     * </p>
     * 
     * @return When the device was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The device's networking status.
     * </p>
     * 
     * @return The device's networking status.
     */
    public final NetworkStatus currentNetworkingStatus() {
        return currentNetworkingStatus;
    }

    /**
     * <p>
     * The device's current software version.
     * </p>
     * 
     * @return The device's current software version.
     */
    public final String currentSoftware() {
        return currentSoftware;
    }

    /**
     * <p>
     * The device's description.
     * </p>
     * 
     * @return The device's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A device's aggregated status. Including the device's connection status, provisioning status, and lease status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceAggregatedStatus} will return {@link DeviceAggregatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceAggregatedStatusAsString}.
     * </p>
     * 
     * @return A device's aggregated status. Including the device's connection status, provisioning status, and lease
     *         status.
     * @see DeviceAggregatedStatus
     */
    public final DeviceAggregatedStatus deviceAggregatedStatus() {
        return DeviceAggregatedStatus.fromValue(deviceAggregatedStatus);
    }

    /**
     * <p>
     * A device's aggregated status. Including the device's connection status, provisioning status, and lease status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceAggregatedStatus} will return {@link DeviceAggregatedStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceAggregatedStatusAsString}.
     * </p>
     * 
     * @return A device's aggregated status. Including the device's connection status, provisioning status, and lease
     *         status.
     * @see DeviceAggregatedStatus
     */
    public final String deviceAggregatedStatusAsString() {
        return deviceAggregatedStatus;
    }

    /**
     * <p>
     * The device's connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceConnectionStatus} will return {@link DeviceConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceConnectionStatusAsString}.
     * </p>
     * 
     * @return The device's connection status.
     * @see DeviceConnectionStatus
     */
    public final DeviceConnectionStatus deviceConnectionStatus() {
        return DeviceConnectionStatus.fromValue(deviceConnectionStatus);
    }

    /**
     * <p>
     * The device's connection status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceConnectionStatus} will return {@link DeviceConnectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceConnectionStatusAsString}.
     * </p>
     * 
     * @return The device's connection status.
     * @see DeviceConnectionStatus
     */
    public final String deviceConnectionStatusAsString() {
        return deviceConnectionStatus;
    }

    /**
     * <p>
     * The device's ID.
     * </p>
     * 
     * @return The device's ID.
     */
    public final String deviceId() {
        return deviceId;
    }

    /**
     * <p>
     * The most recent beta software release.
     * </p>
     * 
     * @return The most recent beta software release.
     */
    public final String latestAlternateSoftware() {
        return latestAlternateSoftware;
    }

    /**
     * <p>
     * A device's latest job. Includes the target image version, and the job status.
     * </p>
     * 
     * @return A device's latest job. Includes the target image version, and the job status.
     */
    public final LatestDeviceJob latestDeviceJob() {
        return latestDeviceJob;
    }

    /**
     * <p>
     * The latest software version available for the device.
     * </p>
     * 
     * @return The latest software version available for the device.
     */
    public final String latestSoftware() {
        return latestSoftware;
    }

    /**
     * <p>
     * The device's lease expiration time.
     * </p>
     * 
     * @return The device's lease expiration time.
     */
    public final Instant leaseExpirationTime() {
        return leaseExpirationTime;
    }

    /**
     * <p>
     * The device's name.
     * </p>
     * 
     * @return The device's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The device's networking configuration.
     * </p>
     * 
     * @return The device's networking configuration.
     */
    public final NetworkPayload networkingConfiguration() {
        return networkingConfiguration;
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final DeviceStatus provisioningStatus() {
        return DeviceStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The device's provisioning status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The device's provisioning status.
     * @see DeviceStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * <p>
     * The device's serial number.
     * </p>
     * 
     * @return The device's serial number.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The device's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The device's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final DeviceType type() {
        return DeviceType.fromValue(type);
    }

    /**
     * <p>
     * The device's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The device's type.
     * @see DeviceType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAlternateSoftwares() ? alternateSoftwares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(brandAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(currentNetworkingStatus());
        hashCode = 31 * hashCode + Objects.hashCode(currentSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceAggregatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceConnectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(latestAlternateSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeviceJob());
        hashCode = 31 * hashCode + Objects.hashCode(latestSoftware());
        hashCode = 31 * hashCode + Objects.hashCode(leaseExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeviceResponse)) {
            return false;
        }
        DescribeDeviceResponse other = (DescribeDeviceResponse) obj;
        return hasAlternateSoftwares() == other.hasAlternateSoftwares()
                && Objects.equals(alternateSoftwares(), other.alternateSoftwares()) && Objects.equals(arn(), other.arn())
                && Objects.equals(brandAsString(), other.brandAsString()) && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(currentNetworkingStatus(), other.currentNetworkingStatus())
                && Objects.equals(currentSoftware(), other.currentSoftware())
                && Objects.equals(description(), other.description())
                && Objects.equals(deviceAggregatedStatusAsString(), other.deviceAggregatedStatusAsString())
                && Objects.equals(deviceConnectionStatusAsString(), other.deviceConnectionStatusAsString())
                && Objects.equals(deviceId(), other.deviceId())
                && Objects.equals(latestAlternateSoftware(), other.latestAlternateSoftware())
                && Objects.equals(latestDeviceJob(), other.latestDeviceJob())
                && Objects.equals(latestSoftware(), other.latestSoftware())
                && Objects.equals(leaseExpirationTime(), other.leaseExpirationTime()) && Objects.equals(name(), other.name())
                && Objects.equals(networkingConfiguration(), other.networkingConfiguration())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && Objects.equals(serialNumber(), other.serialNumber()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeviceResponse")
                .add("AlternateSoftwares", hasAlternateSoftwares() ? alternateSoftwares() : null).add("Arn", arn())
                .add("Brand", brandAsString()).add("CreatedTime", createdTime())
                .add("CurrentNetworkingStatus", currentNetworkingStatus()).add("CurrentSoftware", currentSoftware())
                .add("Description", description()).add("DeviceAggregatedStatus", deviceAggregatedStatusAsString())
                .add("DeviceConnectionStatus", deviceConnectionStatusAsString()).add("DeviceId", deviceId())
                .add("LatestAlternateSoftware", latestAlternateSoftware()).add("LatestDeviceJob", latestDeviceJob())
                .add("LatestSoftware", latestSoftware()).add("LeaseExpirationTime", leaseExpirationTime()).add("Name", name())
                .add("NetworkingConfiguration", networkingConfiguration())
                .add("ProvisioningStatus", provisioningStatusAsString()).add("SerialNumber", serialNumber())
                .add("Tags", hasTags() ? tags() : null).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlternateSoftwares":
            return Optional.ofNullable(clazz.cast(alternateSoftwares()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Brand":
            return Optional.ofNullable(clazz.cast(brandAsString()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "CurrentNetworkingStatus":
            return Optional.ofNullable(clazz.cast(currentNetworkingStatus()));
        case "CurrentSoftware":
            return Optional.ofNullable(clazz.cast(currentSoftware()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceAggregatedStatus":
            return Optional.ofNullable(clazz.cast(deviceAggregatedStatusAsString()));
        case "DeviceConnectionStatus":
            return Optional.ofNullable(clazz.cast(deviceConnectionStatusAsString()));
        case "DeviceId":
            return Optional.ofNullable(clazz.cast(deviceId()));
        case "LatestAlternateSoftware":
            return Optional.ofNullable(clazz.cast(latestAlternateSoftware()));
        case "LatestDeviceJob":
            return Optional.ofNullable(clazz.cast(latestDeviceJob()));
        case "LatestSoftware":
            return Optional.ofNullable(clazz.cast(latestSoftware()));
        case "LeaseExpirationTime":
            return Optional.ofNullable(clazz.cast(leaseExpirationTime()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkingConfiguration":
            return Optional.ofNullable(clazz.cast(networkingConfiguration()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "SerialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeviceResponse, T> g) {
        return obj -> g.apply((DescribeDeviceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeviceResponse> {
        /**
         * <p>
         * Beta software releases available for the device.
         * </p>
         * 
         * @param alternateSoftwares
         *        Beta software releases available for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateSoftwares(Collection<AlternateSoftwareMetadata> alternateSoftwares);

        /**
         * <p>
         * Beta software releases available for the device.
         * </p>
         * 
         * @param alternateSoftwares
         *        Beta software releases available for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alternateSoftwares(AlternateSoftwareMetadata... alternateSoftwares);

        /**
         * <p>
         * Beta software releases available for the device.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #alternateSoftwares(List<AlternateSoftwareMetadata>)}.
         * 
         * @param alternateSoftwares
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.panorama.model.AlternateSoftwareMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alternateSoftwares(java.util.Collection<AlternateSoftwareMetadata>)
         */
        Builder alternateSoftwares(Consumer<AlternateSoftwareMetadata.Builder>... alternateSoftwares);

        /**
         * <p>
         * The device's ARN.
         * </p>
         * 
         * @param arn
         *        The device's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The device's maker.
         * </p>
         * 
         * @param brand
         *        The device's maker.
         * @see DeviceBrand
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceBrand
         */
        Builder brand(String brand);

        /**
         * <p>
         * The device's maker.
         * </p>
         * 
         * @param brand
         *        The device's maker.
         * @see DeviceBrand
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceBrand
         */
        Builder brand(DeviceBrand brand);

        /**
         * <p>
         * When the device was created.
         * </p>
         * 
         * @param createdTime
         *        When the device was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The device's networking status.
         * </p>
         * 
         * @param currentNetworkingStatus
         *        The device's networking status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentNetworkingStatus(NetworkStatus currentNetworkingStatus);

        /**
         * <p>
         * The device's networking status.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkStatus.Builder} avoiding the need
         * to create one manually via {@link NetworkStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #currentNetworkingStatus(NetworkStatus)}.
         * 
         * @param currentNetworkingStatus
         *        a consumer that will call methods on {@link NetworkStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #currentNetworkingStatus(NetworkStatus)
         */
        default Builder currentNetworkingStatus(Consumer<NetworkStatus.Builder> currentNetworkingStatus) {
            return currentNetworkingStatus(NetworkStatus.builder().applyMutation(currentNetworkingStatus).build());
        }

        /**
         * <p>
         * The device's current software version.
         * </p>
         * 
         * @param currentSoftware
         *        The device's current software version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSoftware(String currentSoftware);

        /**
         * <p>
         * The device's description.
         * </p>
         * 
         * @param description
         *        The device's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A device's aggregated status. Including the device's connection status, provisioning status, and lease
         * status.
         * </p>
         * 
         * @param deviceAggregatedStatus
         *        A device's aggregated status. Including the device's connection status, provisioning status, and lease
         *        status.
         * @see DeviceAggregatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAggregatedStatus
         */
        Builder deviceAggregatedStatus(String deviceAggregatedStatus);

        /**
         * <p>
         * A device's aggregated status. Including the device's connection status, provisioning status, and lease
         * status.
         * </p>
         * 
         * @param deviceAggregatedStatus
         *        A device's aggregated status. Including the device's connection status, provisioning status, and lease
         *        status.
         * @see DeviceAggregatedStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAggregatedStatus
         */
        Builder deviceAggregatedStatus(DeviceAggregatedStatus deviceAggregatedStatus);

        /**
         * <p>
         * The device's connection status.
         * </p>
         * 
         * @param deviceConnectionStatus
         *        The device's connection status.
         * @see DeviceConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceConnectionStatus
         */
        Builder deviceConnectionStatus(String deviceConnectionStatus);

        /**
         * <p>
         * The device's connection status.
         * </p>
         * 
         * @param deviceConnectionStatus
         *        The device's connection status.
         * @see DeviceConnectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceConnectionStatus
         */
        Builder deviceConnectionStatus(DeviceConnectionStatus deviceConnectionStatus);

        /**
         * <p>
         * The device's ID.
         * </p>
         * 
         * @param deviceId
         *        The device's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceId(String deviceId);

        /**
         * <p>
         * The most recent beta software release.
         * </p>
         * 
         * @param latestAlternateSoftware
         *        The most recent beta software release.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAlternateSoftware(String latestAlternateSoftware);

        /**
         * <p>
         * A device's latest job. Includes the target image version, and the job status.
         * </p>
         * 
         * @param latestDeviceJob
         *        A device's latest job. Includes the target image version, and the job status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeviceJob(LatestDeviceJob latestDeviceJob);

        /**
         * <p>
         * A device's latest job. Includes the target image version, and the job status.
         * </p>
         * This is a convenience method that creates an instance of the {@link LatestDeviceJob.Builder} avoiding the
         * need to create one manually via {@link LatestDeviceJob#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LatestDeviceJob.Builder#build()} is called immediately and its
         * result is passed to {@link #latestDeviceJob(LatestDeviceJob)}.
         * 
         * @param latestDeviceJob
         *        a consumer that will call methods on {@link LatestDeviceJob.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestDeviceJob(LatestDeviceJob)
         */
        default Builder latestDeviceJob(Consumer<LatestDeviceJob.Builder> latestDeviceJob) {
            return latestDeviceJob(LatestDeviceJob.builder().applyMutation(latestDeviceJob).build());
        }

        /**
         * <p>
         * The latest software version available for the device.
         * </p>
         * 
         * @param latestSoftware
         *        The latest software version available for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestSoftware(String latestSoftware);

        /**
         * <p>
         * The device's lease expiration time.
         * </p>
         * 
         * @param leaseExpirationTime
         *        The device's lease expiration time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leaseExpirationTime(Instant leaseExpirationTime);

        /**
         * <p>
         * The device's name.
         * </p>
         * 
         * @param name
         *        The device's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The device's networking configuration.
         * </p>
         * 
         * @param networkingConfiguration
         *        The device's networking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkingConfiguration(NetworkPayload networkingConfiguration);

        /**
         * <p>
         * The device's networking configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkPayload.Builder} avoiding the need
         * to create one manually via {@link NetworkPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #networkingConfiguration(NetworkPayload)}.
         * 
         * @param networkingConfiguration
         *        a consumer that will call methods on {@link NetworkPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkingConfiguration(NetworkPayload)
         */
        default Builder networkingConfiguration(Consumer<NetworkPayload.Builder> networkingConfiguration) {
            return networkingConfiguration(NetworkPayload.builder().applyMutation(networkingConfiguration).build());
        }

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The device's provisioning status.
         * </p>
         * 
         * @param provisioningStatus
         *        The device's provisioning status.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder provisioningStatus(DeviceStatus provisioningStatus);

        /**
         * <p>
         * The device's serial number.
         * </p>
         * 
         * @param serialNumber
         *        The device's serial number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The device's tags.
         * </p>
         * 
         * @param tags
         *        The device's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param type
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder type(String type);

        /**
         * <p>
         * The device's type.
         * </p>
         * 
         * @param type
         *        The device's type.
         * @see DeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceType
         */
        Builder type(DeviceType type);
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private List<AlternateSoftwareMetadata> alternateSoftwares = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String brand;

        private Instant createdTime;

        private NetworkStatus currentNetworkingStatus;

        private String currentSoftware;

        private String description;

        private String deviceAggregatedStatus;

        private String deviceConnectionStatus;

        private String deviceId;

        private String latestAlternateSoftware;

        private LatestDeviceJob latestDeviceJob;

        private String latestSoftware;

        private Instant leaseExpirationTime;

        private String name;

        private NetworkPayload networkingConfiguration;

        private String provisioningStatus;

        private String serialNumber;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeviceResponse model) {
            super(model);
            alternateSoftwares(model.alternateSoftwares);
            arn(model.arn);
            brand(model.brand);
            createdTime(model.createdTime);
            currentNetworkingStatus(model.currentNetworkingStatus);
            currentSoftware(model.currentSoftware);
            description(model.description);
            deviceAggregatedStatus(model.deviceAggregatedStatus);
            deviceConnectionStatus(model.deviceConnectionStatus);
            deviceId(model.deviceId);
            latestAlternateSoftware(model.latestAlternateSoftware);
            latestDeviceJob(model.latestDeviceJob);
            latestSoftware(model.latestSoftware);
            leaseExpirationTime(model.leaseExpirationTime);
            name(model.name);
            networkingConfiguration(model.networkingConfiguration);
            provisioningStatus(model.provisioningStatus);
            serialNumber(model.serialNumber);
            tags(model.tags);
            type(model.type);
        }

        public final List<AlternateSoftwareMetadata.Builder> getAlternateSoftwares() {
            List<AlternateSoftwareMetadata.Builder> result = AlternateSoftwaresCopier.copyToBuilder(this.alternateSoftwares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternateSoftwares(Collection<AlternateSoftwareMetadata.BuilderImpl> alternateSoftwares) {
            this.alternateSoftwares = AlternateSoftwaresCopier.copyFromBuilder(alternateSoftwares);
        }

        @Override
        public final Builder alternateSoftwares(Collection<AlternateSoftwareMetadata> alternateSoftwares) {
            this.alternateSoftwares = AlternateSoftwaresCopier.copy(alternateSoftwares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateSoftwares(AlternateSoftwareMetadata... alternateSoftwares) {
            alternateSoftwares(Arrays.asList(alternateSoftwares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternateSoftwares(Consumer<AlternateSoftwareMetadata.Builder>... alternateSoftwares) {
            alternateSoftwares(Stream.of(alternateSoftwares)
                    .map(c -> AlternateSoftwareMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getBrand() {
            return brand;
        }

        public final void setBrand(String brand) {
            this.brand = brand;
        }

        @Override
        public final Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        @Override
        public final Builder brand(DeviceBrand brand) {
            this.brand(brand == null ? null : brand.toString());
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final NetworkStatus.Builder getCurrentNetworkingStatus() {
            return currentNetworkingStatus != null ? currentNetworkingStatus.toBuilder() : null;
        }

        public final void setCurrentNetworkingStatus(NetworkStatus.BuilderImpl currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus != null ? currentNetworkingStatus.build() : null;
        }

        @Override
        public final Builder currentNetworkingStatus(NetworkStatus currentNetworkingStatus) {
            this.currentNetworkingStatus = currentNetworkingStatus;
            return this;
        }

        public final String getCurrentSoftware() {
            return currentSoftware;
        }

        public final void setCurrentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
        }

        @Override
        public final Builder currentSoftware(String currentSoftware) {
            this.currentSoftware = currentSoftware;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeviceAggregatedStatus() {
            return deviceAggregatedStatus;
        }

        public final void setDeviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
        }

        @Override
        public final Builder deviceAggregatedStatus(String deviceAggregatedStatus) {
            this.deviceAggregatedStatus = deviceAggregatedStatus;
            return this;
        }

        @Override
        public final Builder deviceAggregatedStatus(DeviceAggregatedStatus deviceAggregatedStatus) {
            this.deviceAggregatedStatus(deviceAggregatedStatus == null ? null : deviceAggregatedStatus.toString());
            return this;
        }

        public final String getDeviceConnectionStatus() {
            return deviceConnectionStatus;
        }

        public final void setDeviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
        }

        @Override
        public final Builder deviceConnectionStatus(String deviceConnectionStatus) {
            this.deviceConnectionStatus = deviceConnectionStatus;
            return this;
        }

        @Override
        public final Builder deviceConnectionStatus(DeviceConnectionStatus deviceConnectionStatus) {
            this.deviceConnectionStatus(deviceConnectionStatus == null ? null : deviceConnectionStatus.toString());
            return this;
        }

        public final String getDeviceId() {
            return deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final String getLatestAlternateSoftware() {
            return latestAlternateSoftware;
        }

        public final void setLatestAlternateSoftware(String latestAlternateSoftware) {
            this.latestAlternateSoftware = latestAlternateSoftware;
        }

        @Override
        public final Builder latestAlternateSoftware(String latestAlternateSoftware) {
            this.latestAlternateSoftware = latestAlternateSoftware;
            return this;
        }

        public final LatestDeviceJob.Builder getLatestDeviceJob() {
            return latestDeviceJob != null ? latestDeviceJob.toBuilder() : null;
        }

        public final void setLatestDeviceJob(LatestDeviceJob.BuilderImpl latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob != null ? latestDeviceJob.build() : null;
        }

        @Override
        public final Builder latestDeviceJob(LatestDeviceJob latestDeviceJob) {
            this.latestDeviceJob = latestDeviceJob;
            return this;
        }

        public final String getLatestSoftware() {
            return latestSoftware;
        }

        public final void setLatestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
        }

        @Override
        public final Builder latestSoftware(String latestSoftware) {
            this.latestSoftware = latestSoftware;
            return this;
        }

        public final Instant getLeaseExpirationTime() {
            return leaseExpirationTime;
        }

        public final void setLeaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
        }

        @Override
        public final Builder leaseExpirationTime(Instant leaseExpirationTime) {
            this.leaseExpirationTime = leaseExpirationTime;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final NetworkPayload.Builder getNetworkingConfiguration() {
            return networkingConfiguration != null ? networkingConfiguration.toBuilder() : null;
        }

        public final void setNetworkingConfiguration(NetworkPayload.BuilderImpl networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration != null ? networkingConfiguration.build() : null;
        }

        @Override
        public final Builder networkingConfiguration(NetworkPayload networkingConfiguration) {
            this.networkingConfiguration = networkingConfiguration;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(DeviceStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public DescribeDeviceResponse build() {
            return new DescribeDeviceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
