/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePackageRequest extends PanoramaRequest implements
        ToCopyableBuilder<DeletePackageRequest.Builder, DeletePackageRequest> {
    private static final SdkField<Boolean> FORCE_DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ForceDelete").getter(getter(DeletePackageRequest::forceDelete)).setter(setter(Builder::forceDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ForceDelete").build()).build();

    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(DeletePackageRequest::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PackageId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORCE_DELETE_FIELD,
            PACKAGE_ID_FIELD));

    private final Boolean forceDelete;

    private final String packageId;

    private DeletePackageRequest(BuilderImpl builder) {
        super(builder);
        this.forceDelete = builder.forceDelete;
        this.packageId = builder.packageId;
    }

    /**
     * <p>
     * Delete the package even if it has artifacts stored in its access point. Deletes the package's artifacts from
     * Amazon S3.
     * </p>
     * 
     * @return Delete the package even if it has artifacts stored in its access point. Deletes the package's artifacts
     *         from Amazon S3.
     */
    public final Boolean forceDelete() {
        return forceDelete;
    }

    /**
     * <p>
     * The package's ID.
     * </p>
     * 
     * @return The package's ID.
     */
    public final String packageId() {
        return packageId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(forceDelete());
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageRequest)) {
            return false;
        }
        DeletePackageRequest other = (DeletePackageRequest) obj;
        return Objects.equals(forceDelete(), other.forceDelete()) && Objects.equals(packageId(), other.packageId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePackageRequest").add("ForceDelete", forceDelete()).add("PackageId", packageId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ForceDelete":
            return Optional.ofNullable(clazz.cast(forceDelete()));
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageRequest, T> g) {
        return obj -> g.apply((DeletePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeletePackageRequest> {
        /**
         * <p>
         * Delete the package even if it has artifacts stored in its access point. Deletes the package's artifacts from
         * Amazon S3.
         * </p>
         * 
         * @param forceDelete
         *        Delete the package even if it has artifacts stored in its access point. Deletes the package's
         *        artifacts from Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceDelete(Boolean forceDelete);

        /**
         * <p>
         * The package's ID.
         * </p>
         * 
         * @param packageId
         *        The package's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private Boolean forceDelete;

        private String packageId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageRequest model) {
            super(model);
            forceDelete(model.forceDelete);
            packageId(model.packageId);
        }

        public final Boolean getForceDelete() {
            return forceDelete;
        }

        public final void setForceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
        }

        @Override
        public final Builder forceDelete(Boolean forceDelete) {
            this.forceDelete = forceDelete;
            return this;
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePackageRequest build() {
            return new DeletePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
