/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePackageResponse extends PanoramaResponse implements
        ToCopyableBuilder<CreatePackageResponse.Builder, CreatePackageResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreatePackageResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageId").getter(getter(CreatePackageResponse::packageId)).setter(setter(Builder::packageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageId").build()).build();

    private static final SdkField<StorageLocation> STORAGE_LOCATION_FIELD = SdkField
            .<StorageLocation> builder(MarshallingType.SDK_POJO).memberName("StorageLocation")
            .getter(getter(CreatePackageResponse::storageLocation)).setter(setter(Builder::storageLocation))
            .constructor(StorageLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, PACKAGE_ID_FIELD,
            STORAGE_LOCATION_FIELD));

    private final String arn;

    private final String packageId;

    private final StorageLocation storageLocation;

    private CreatePackageResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.packageId = builder.packageId;
        this.storageLocation = builder.storageLocation;
    }

    /**
     * <p>
     * The package's ARN.
     * </p>
     * 
     * @return The package's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The package's ID.
     * </p>
     * 
     * @return The package's ID.
     */
    public final String packageId() {
        return packageId;
    }

    /**
     * <p>
     * The package's storage location.
     * </p>
     * 
     * @return The package's storage location.
     */
    public final StorageLocation storageLocation() {
        return storageLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(packageId());
        hashCode = 31 * hashCode + Objects.hashCode(storageLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageResponse)) {
            return false;
        }
        CreatePackageResponse other = (CreatePackageResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(packageId(), other.packageId())
                && Objects.equals(storageLocation(), other.storageLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePackageResponse").add("Arn", arn()).add("PackageId", packageId())
                .add("StorageLocation", storageLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "PackageId":
            return Optional.ofNullable(clazz.cast(packageId()));
        case "StorageLocation":
            return Optional.ofNullable(clazz.cast(storageLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePackageResponse, T> g) {
        return obj -> g.apply((CreatePackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePackageResponse> {
        /**
         * <p>
         * The package's ARN.
         * </p>
         * 
         * @param arn
         *        The package's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The package's ID.
         * </p>
         * 
         * @param packageId
         *        The package's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageId(String packageId);

        /**
         * <p>
         * The package's storage location.
         * </p>
         * 
         * @param storageLocation
         *        The package's storage location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageLocation(StorageLocation storageLocation);

        /**
         * <p>
         * The package's storage location.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageLocation.Builder} avoiding the
         * need to create one manually via {@link StorageLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #storageLocation(StorageLocation)}.
         * 
         * @param storageLocation
         *        a consumer that will call methods on {@link StorageLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageLocation(StorageLocation)
         */
        default Builder storageLocation(Consumer<StorageLocation.Builder> storageLocation) {
            return storageLocation(StorageLocation.builder().applyMutation(storageLocation).build());
        }
    }

    static final class BuilderImpl extends PanoramaResponse.BuilderImpl implements Builder {
        private String arn;

        private String packageId;

        private StorageLocation storageLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePackageResponse model) {
            super(model);
            arn(model.arn);
            packageId(model.packageId);
            storageLocation(model.storageLocation);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getPackageId() {
            return packageId;
        }

        public final void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        @Override
        public final Builder packageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        public final StorageLocation.Builder getStorageLocation() {
            return storageLocation != null ? storageLocation.toBuilder() : null;
        }

        public final void setStorageLocation(StorageLocation.BuilderImpl storageLocation) {
            this.storageLocation = storageLocation != null ? storageLocation.build() : null;
        }

        @Override
        public final Builder storageLocation(StorageLocation storageLocation) {
            this.storageLocation = storageLocation;
            return this;
        }

        @Override
        public CreatePackageResponse build() {
            return new CreatePackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
