/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobForDevicesRequest extends PanoramaRequest implements
        ToCopyableBuilder<CreateJobForDevicesRequest.Builder, CreateJobForDevicesRequest> {
    private static final SdkField<List<String>> DEVICE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DeviceIds")
            .getter(getter(CreateJobForDevicesRequest::deviceIds))
            .setter(setter(Builder::deviceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeviceJobConfig> DEVICE_JOB_CONFIG_FIELD = SdkField
            .<DeviceJobConfig> builder(MarshallingType.SDK_POJO).memberName("DeviceJobConfig")
            .getter(getter(CreateJobForDevicesRequest::deviceJobConfig)).setter(setter(Builder::deviceJobConfig))
            .constructor(DeviceJobConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceJobConfig").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(CreateJobForDevicesRequest::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_IDS_FIELD,
            DEVICE_JOB_CONFIG_FIELD, JOB_TYPE_FIELD));

    private final List<String> deviceIds;

    private final DeviceJobConfig deviceJobConfig;

    private final String jobType;

    private CreateJobForDevicesRequest(BuilderImpl builder) {
        super(builder);
        this.deviceIds = builder.deviceIds;
        this.deviceJobConfig = builder.deviceJobConfig;
        this.jobType = builder.jobType;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDeviceIds() {
        return deviceIds != null && !(deviceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * ID of target device.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceIds} method.
     * </p>
     * 
     * @return ID of target device.
     */
    public final List<String> deviceIds() {
        return deviceIds;
    }

    /**
     * <p>
     * Configuration settings for a software update job.
     * </p>
     * 
     * @return Configuration settings for a software update job.
     */
    public final DeviceJobConfig deviceJobConfig() {
        return deviceJobConfig;
    }

    /**
     * <p>
     * The type of job to run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of job to run.
     * @see JobType
     */
    public final JobType jobType() {
        return JobType.fromValue(jobType);
    }

    /**
     * <p>
     * The type of job to run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link JobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The type of job to run.
     * @see JobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceIds() ? deviceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobForDevicesRequest)) {
            return false;
        }
        CreateJobForDevicesRequest other = (CreateJobForDevicesRequest) obj;
        return hasDeviceIds() == other.hasDeviceIds() && Objects.equals(deviceIds(), other.deviceIds())
                && Objects.equals(deviceJobConfig(), other.deviceJobConfig())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobForDevicesRequest").add("DeviceIds", hasDeviceIds() ? deviceIds() : null)
                .add("DeviceJobConfig", deviceJobConfig()).add("JobType", jobTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceIds":
            return Optional.ofNullable(clazz.cast(deviceIds()));
        case "DeviceJobConfig":
            return Optional.ofNullable(clazz.cast(deviceJobConfig()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobForDevicesRequest, T> g) {
        return obj -> g.apply((CreateJobForDevicesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PanoramaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobForDevicesRequest> {
        /**
         * <p>
         * ID of target device.
         * </p>
         * 
         * @param deviceIds
         *        ID of target device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIds(Collection<String> deviceIds);

        /**
         * <p>
         * ID of target device.
         * </p>
         * 
         * @param deviceIds
         *        ID of target device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIds(String... deviceIds);

        /**
         * <p>
         * Configuration settings for a software update job.
         * </p>
         * 
         * @param deviceJobConfig
         *        Configuration settings for a software update job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceJobConfig(DeviceJobConfig deviceJobConfig);

        /**
         * <p>
         * Configuration settings for a software update job.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceJobConfig.Builder} avoiding the
         * need to create one manually via {@link DeviceJobConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceJobConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deviceJobConfig(DeviceJobConfig)}.
         * 
         * @param deviceJobConfig
         *        a consumer that will call methods on {@link DeviceJobConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceJobConfig(DeviceJobConfig)
         */
        default Builder deviceJobConfig(Consumer<DeviceJobConfig.Builder> deviceJobConfig) {
            return deviceJobConfig(DeviceJobConfig.builder().applyMutation(deviceJobConfig).build());
        }

        /**
         * <p>
         * The type of job to run.
         * </p>
         * 
         * @param jobType
         *        The type of job to run.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The type of job to run.
         * </p>
         * 
         * @param jobType
         *        The type of job to run.
         * @see JobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobType
         */
        Builder jobType(JobType jobType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PanoramaRequest.BuilderImpl implements Builder {
        private List<String> deviceIds = DefaultSdkAutoConstructList.getInstance();

        private DeviceJobConfig deviceJobConfig;

        private String jobType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobForDevicesRequest model) {
            super(model);
            deviceIds(model.deviceIds);
            deviceJobConfig(model.deviceJobConfig);
            jobType(model.jobType);
        }

        public final Collection<String> getDeviceIds() {
            if (deviceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return deviceIds;
        }

        public final void setDeviceIds(Collection<String> deviceIds) {
            this.deviceIds = DeviceIdListCopier.copy(deviceIds);
        }

        @Override
        public final Builder deviceIds(Collection<String> deviceIds) {
            this.deviceIds = DeviceIdListCopier.copy(deviceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceIds(String... deviceIds) {
            deviceIds(Arrays.asList(deviceIds));
            return this;
        }

        public final DeviceJobConfig.Builder getDeviceJobConfig() {
            return deviceJobConfig != null ? deviceJobConfig.toBuilder() : null;
        }

        public final void setDeviceJobConfig(DeviceJobConfig.BuilderImpl deviceJobConfig) {
            this.deviceJobConfig = deviceJobConfig != null ? deviceJobConfig.build() : null;
        }

        @Override
        public final Builder deviceJobConfig(DeviceJobConfig deviceJobConfig) {
            this.deviceJobConfig = deviceJobConfig;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(JobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobForDevicesRequest build() {
            return new CreateJobForDevicesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
